/*
 * Decompiled with CFR 0.152.
 */
package com.fr.js;

import com.fr.base.BaseXMLUtils;
import com.fr.base.Parameter;
import com.fr.general.ComparatorUtils;
import com.fr.js.JavaScript;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.FormulaProvider;
import com.fr.stable.ParameterProvider;
import com.fr.stable.script.CalculatorKey;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.ExTool;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.StableXMLUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractJavaScript
implements JavaScript {
    private static final long serialVersionUID = -3629245217096045333L;
    public static CalculatorKey RECALCULATE_TAG = CalculatorKey.createKey("shouldRecalculate");
    public static final String CALLBACK = "callback";
    public static final String FEEDBACKMAP = "feedbackMap";
    protected ParameterProvider[] parameters;
    protected Map<Object, Object> paraMap = new HashMap<Object, Object>();
    private boolean recalculate;
    private String itemName = "";

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String string) {
        this.itemName = string;
    }

    public ParameterProvider[] getParameters() {
        return this.parameters == null ? new ParameterProvider[]{} : this.parameters;
    }

    public void setParameters(ParameterProvider[] parameterProviderArray) {
        this.parameters = parameterProviderArray;
    }

    public boolean shouldRecalculate() {
        return this.recalculate;
    }

    public void setShouldRecalculate(boolean bl) {
        this.recalculate = bl;
    }

    public String createJS(Repository repository) {
        return "var as=arguments; return FR.tc(function(){" + this.actionJS(repository) + "}, this, as)";
    }

    public JSONObject createJSONObject(Repository repository) throws JSONException {
        return new JSONObject().put("data", this.createJS(repository));
    }

    protected abstract String actionJS(Repository var1);

    public void addParameterMap(Map map) {
        this.paraMap.putAll(map);
    }

    public void analyzeCorrelative(CalculatorProvider calculatorProvider, ExTool exTool, ColumnRow columnRow) {
        for (ParameterProvider parameterProvider : this.getParameters()) {
            Object object = parameterProvider.getValue();
            if (!(object instanceof FormulaProvider)) continue;
            exTool.setCreateRelation(true);
            calculatorProvider.exStatement(columnRow, ((FormulaProvider)object).getPureContent());
            exTool.setCreateRelation(false);
        }
    }

    public void setLinkTitle(String string) {
    }

    public void renderParameters(Calculator calculator) {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractJavaScript)) {
            return false;
        }
        return ComparatorUtils.equals(this.parameters, ((AbstractJavaScript)object).parameters);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && "Parameters".equals(xMLableReader.getTagName())) {
            ParameterProvider[] parameterProviderArray = BaseXMLUtils.readParameters(xMLableReader);
            this.setParameters(parameterProviderArray);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        StableXMLUtils.writeParameters(xMLPrintWriter, this.getParameters());
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractJavaScript abstractJavaScript = (AbstractJavaScript)super.clone();
        if (this.parameters != null) {
            abstractJavaScript.parameters = new Parameter[this.parameters.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                abstractJavaScript.parameters[i] = (Parameter)this.parameters[i].clone();
            }
        }
        return abstractJavaScript;
    }
}

