/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general.http;

import com.fr.general.FRLogger;
import com.fr.general.IOUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.CodeUtils;
import com.fr.stable.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClient {
    public static final String CLOSED = "__STREAMCLOSED__";
    private static final String CONTENT = "__CONTENT__";
    public static final String CHARSET = "__CHARSET__";
    private static final int TIME_OUT = 300000;
    private static final byte[] EMPTY_CONTENT = new byte[0];
    private String url;
    private int timeout = -1;
    private String header;
    private String charSet;
    private HashMap<String, String> para;
    private byte[] content;
    private boolean encode = false;
    private boolean isAppenPara = false;
    private HttpURLConnection conn;

    public HttpClient(String string) {
        this.url = string;
        this.para = new HashMap();
    }

    public HttpClient(String string, HashMap<String, String> hashMap) {
        this.url = string;
        this.para = hashMap;
    }

    public HttpClient(String string, HashMap<String, String> hashMap, boolean bl) {
        this.url = string;
        this.para = hashMap;
        this.encode = bl;
    }

    private void appendPara() {
        if (this.para == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.url);
        stringBuilder.append(this.url.indexOf(63) != -1 ? (char)'&' : '?');
        for (Map.Entry<String, String> entry : this.para.entrySet()) {
            stringBuilder.append('&');
            stringBuilder.append(this.encodeString(entry.getKey(), this.encode));
            stringBuilder.append('=');
            stringBuilder.append(this.encodeString(entry.getValue(), this.encode));
        }
        this.url = stringBuilder.toString();
    }

    public void asGet() {
        this.isAppenPara = true;
    }

    public void setContent(byte[] byArray) {
        this.content = byArray;
    }

    public void setHeader(String string) {
        this.header = string;
    }

    private String encodeString(String string, boolean bl) {
        String string2 = CodeUtils.cjkEncode(string);
        if (!bl) {
            return string2;
        }
        try {
            return URLEncoder.encode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string2;
        }
    }

    private void applyHeader() {
        if (StringUtils.isEmpty(this.header)) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(this.header);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = jSONObject.getString(string);
                this.conn.setRequestProperty(string, string2);
            }
        }
        catch (JSONException jSONException) {
            FRLogger.getLogger().error(jSONException.getMessage());
        }
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public void setCharSet(String string) {
        this.charSet = string;
    }

    private void pushParaIntoContent() {
        if (this.isAppenPara) {
            this.appendPara();
            return;
        }
        try {
            if (this.content != null) {
                this.para.put(CONTENT, new String(this.content, this.getCharSet()));
                this.appendCharSet();
            }
            JSONObject jSONObject = new JSONObject(this.para);
            this.content = jSONObject.toString().getBytes(this.getCharSet());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void appendCharSet() {
        this.para.put(CHARSET, this.getCharSet());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.url);
        stringBuilder.append(this.url.indexOf(63) != -1 ? (char)'&' : '?');
        stringBuilder.append(CHARSET).append("=").append(this.getCharSet());
        this.url = stringBuilder.toString();
    }

    private String getCharSet() {
        return StringUtils.isEmpty(this.charSet) ? "UTF-8" : this.charSet;
    }

    private int getTimeout() {
        return this.timeout == -1 ? 300000 : this.timeout;
    }

    private void connect() {
        if (this.conn != null) {
            return;
        }
        try {
            this.pushParaIntoContent();
            URL uRL = new URL(this.url);
            this.conn = (HttpURLConnection)uRL.openConnection();
            this.conn.setUseCaches(false);
            this.conn.setRequestProperty("Content-Type", "text/xml;charset=" + this.getCharSet());
            this.conn.setRequestMethod(this.isAppenPara ? "GET" : "POST");
            this.conn.setDoOutput(true);
            this.conn.setDoInput(true);
            int n = this.getTimeout();
            this.conn.setReadTimeout(n);
            this.conn.setConnectTimeout(n);
            this.applyHeader();
            if (this.content != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.content);
                OutputStream outputStream = this.conn.getOutputStream();
                IOUtils.copyBinaryTo(byteArrayInputStream, outputStream);
                byteArrayInputStream.close();
                outputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isServerAlive() {
        return this.getResponseCodeNoException() != -1;
    }

    public int getResponseCodeNoException() {
        return this.getResponseCode(true);
    }

    public int getResponseCode(boolean bl) {
        this.connect();
        try {
            return this.conn.getResponseCode();
        }
        catch (Throwable throwable) {
            if (!bl) {
                FRLogger.getLogger().error(throwable.getMessage());
            }
            return -1;
        }
    }

    public int getResponseCode() {
        return this.getResponseCode(false);
    }

    public String getResponseText() {
        return this.getResponseText(this.getCharSet());
    }

    public byte[] getResponseBytes() {
        InputStream inputStream = this.getResponseStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            IOUtils.copyBinaryTo(inputStream, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String getResponseText(String string) {
        InputStream inputStream = this.getResponseStream();
        if (inputStream == null) {
            return this.getResponseCode() + "";
        }
        try {
            return IOUtils.inputStream2String(inputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return this.getResponseCode() + "";
        }
    }

    public InputStream getResponseStream() {
        this.connect();
        try {
            return this.conn.getInputStream();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
            return null;
        }
    }

    public int getContentLength() {
        this.connect();
        try {
            return this.conn.getContentLength();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
            return 0;
        }
    }

    public String getHeaderField(String string) {
        this.connect();
        return this.conn.getHeaderField(string);
    }

    public Iterator<String> getHeaderFieldIterator(String string) {
        Map<String, List<String>> map = this.getAllHeader();
        return map.get(string).iterator();
    }

    public Map<String, List<String>> getAllHeader() {
        this.connect();
        return this.conn.getHeaderFields();
    }

    public void release() {
        if (this.conn != null) {
            this.conn.disconnect();
            this.conn = null;
            this.content = null;
            this.para = null;
        }
    }

    public static InputStream getInputStream(HttpServletRequest httpServletRequest) {
        String string;
        ByteArrayInputStream byteArrayInputStream = null;
        String string2 = (String)httpServletRequest.getAttribute(CONTENT);
        Object object = httpServletRequest.getAttribute(CHARSET);
        String string3 = string = object == null ? "UTF-8" : object.toString();
        if (StringUtils.isNotEmpty(string2)) {
            byte[] byArray;
            try {
                byArray = string2.getBytes(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FRLogger.getLogger().error("Error Encoding");
                byArray = EMPTY_CONTENT;
            }
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        return byteArrayInputStream;
    }
}

