/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.general.DefaultValues;
import com.fr.general.EnvProvider;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.EnvSignOutListener;
import com.fr.stable.RegStatusChangedListener;
import com.fr.stable.plugin.PluginReadListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class GeneralContext {
    private static ArrayList<EnvChangedListener> envChangeListenerList = new ArrayList();
    private static List<EnvChangedListener> envChangedListenersLast = new ArrayList<EnvChangedListener>();
    private static Map<String, EnvChangedListener> envWillChangeListenerList = new HashMap<String, EnvChangedListener>();
    private static ArrayList<EnvSignOutListener> envExitListenerList = new ArrayList();
    private static List<PluginReadListener> pluginReadListeners = new ArrayList<PluginReadListener>();
    private static List<RegStatusChangedListener> regStatusChangeListenerList = new ArrayList<RegStatusChangedListener>();
    private static Locale locale = Locale.CHINA;
    private static DefaultValues defaultValues = null;
    private static EnvProvider envProvider = null;

    private GeneralContext() {
    }

    public static EnvProvider getEnvProvider() {
        return envProvider;
    }

    public static void setEnvProvider(EnvProvider envProvider) {
        GeneralContext.envProvider = envProvider;
    }

    public static void addEnvChangedListener(EnvChangedListener envChangedListener) {
        envChangeListenerList.add(envChangedListener);
    }

    public static void addEnvChangedListenerToLast(EnvChangedListener envChangedListener) {
        envChangedListenersLast.add(envChangedListener);
    }

    public static void addEnvSignOutListener(EnvSignOutListener envSignOutListener) {
        envExitListenerList.add(envSignOutListener);
    }

    public static void addEnvWillChangedListener(String string, EnvChangedListener envChangedListener) {
        envWillChangeListenerList.put(string, envChangedListener);
    }

    public static void removeEnvWillChangedListener(String string) {
        envWillChangeListenerList.remove(string);
    }

    public static void addPluginReadListener(PluginReadListener pluginReadListener) {
        pluginReadListeners.add(pluginReadListener);
    }

    public static void addRegStatusChangedListener(RegStatusChangedListener regStatusChangedListener) {
        regStatusChangeListenerList.add(regStatusChangedListener);
    }

    public static void fireRegStatusChangeListener(boolean bl) {
        for (RegStatusChangedListener regStatusChangedListener : regStatusChangeListenerList) {
            regStatusChangedListener.regStatusChanged(bl);
        }
    }

    public static void firePluginReadListener(PluginReadListener.Status status) {
        for (PluginReadListener pluginReadListener : pluginReadListeners) {
            pluginReadListener.success(status);
        }
    }

    public static boolean isChineseEnv() {
        return locale == Locale.CHINA || locale == Locale.TAIWAN;
    }

    public static void fireEnvChangeListener() {
        for (int i = 0; i < envChangeListenerList.size(); ++i) {
            envChangeListenerList.get(i).envChanged();
        }
        for (EnvChangedListener envChangedListener : envChangedListenersLast) {
            envChangedListener.envChanged();
        }
    }

    public static void fireEnvSignOutListener() {
        for (int i = 0; i < envExitListenerList.size(); ++i) {
            envExitListenerList.get(i).envExited();
        }
    }

    public static void fireEnvWillChangeListener() {
        for (Map.Entry<String, EnvChangedListener> entry : envWillChangeListenerList.entrySet()) {
            if (entry == null || entry.getValue() == null) continue;
            entry.getValue().envChanged();
        }
    }

    public static Locale getLocale() {
        return locale;
    }

    public static void setLanguage(int n) {
        switch (n) {
            case 2: {
                locale = Locale.US;
                break;
            }
            case 3: {
                locale = Locale.JAPAN;
                break;
            }
            case 1: {
                locale = Locale.CHINA;
                break;
            }
            case 4: {
                locale = Locale.TAIWAN;
                break;
            }
            case 5: {
                locale = Locale.KOREA;
                break;
            }
            default: {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("com/fr/base/core/locale", Locale.getDefault());
                String string = resourceBundle.getString("language");
                if ("zh".equals(string)) {
                    GeneralContext.processChina(resourceBundle);
                    break;
                }
                locale = "en".equals(string) ? Locale.US : ("jp".equals(string) ? Locale.JAPAN : ("ko".equals(string) ? Locale.KOREA : Locale.ENGLISH));
            }
        }
    }

    private static void processChina(ResourceBundle resourceBundle) {
        String string = resourceBundle.getString("country");
        locale = "TW".equals(string) ? Locale.TRADITIONAL_CHINESE : Locale.CHINA;
    }

    public static DefaultValues getDefaultValues() {
        if (defaultValues == null) {
            defaultValues = new DefaultValues();
        }
        return defaultValues;
    }

    public static void resetDefaultValues() {
        defaultValues = null;
    }

    public static InputStream getResourceStream(String string) {
        return GeneralContext.getResourceStream(string, true);
    }

    public static InputStream getResourceStream(String string, boolean bl) {
        EnvProvider envProvider = GeneralContext.getEnvProvider();
        if (envProvider != null) {
            try {
                InputStream inputStream = envProvider.readResource(string);
                if (bl && inputStream != null) {
                    FRLogger.getLogger().info(Inter.getLocText("FR-Base-Load_Resource_File") + ":\"" + string + "\".");
                }
                return inputStream;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getCurrentAppNameOfEnv() {
        return GeneralContext.getEnvProvider().getAppName();
    }
}

