/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.general.ComparatorUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONArray;
import com.fr.stable.ArrayProvider;
import com.fr.stable.CodeUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLWriter;
import com.fr.stable.xml.XMLableReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FArray<T>
implements ArrayProvider<T>,
XMLWriter,
XMLReadable,
Serializable,
Iterable {
    private List<T> list = new ArrayList<T>();
    private static final String SEPARATOR = ",";

    public FArray() {
    }

    public FArray(T[] TArray) {
        this(Arrays.asList(TArray));
    }

    public FArray(Collection<T> collection) {
        this.list.addAll(collection);
    }

    @Override
    public Object[] asObjects() {
        return this.list.toArray();
    }

    @Override
    public T elementAt(int n) {
        return this.list.get(n);
    }

    @Override
    public int length() {
        return this.list.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public void removeElement(int n) {
        if (n > -1 && n < this.length()) {
            this.list.remove(n);
        }
    }

    public void setElement(int n, T t) {
        if (n > -1 && n < this.length()) {
            this.list.set(n, t);
        }
    }

    @Override
    public ArrayProvider<T> add(T t) {
        if (t instanceof FArray) {
            this.list.addAll(((FArray)t).list);
        } else {
            this.list.add(t);
        }
        return this;
    }

    public ArrayProvider<T> simpleAdd(T t) {
        this.list.add(t);
        return this;
    }

    @Override
    public List<T> toList() {
        return Collections.unmodifiableList(this.list);
    }

    public String toString() {
        return StableUtils.join(this.list, SEPARATOR);
    }

    public FArray cjkEncode() {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (int i = 0; i < this.length(); ++i) {
            T t = this.list.get(i);
            if (t instanceof String) {
                arrayList.add(i, CodeUtils.cjkEncode((String)t));
                continue;
            }
            if (t instanceof JSONArray) {
                arrayList.add(((JSONArray)t).cjkEncode());
                continue;
            }
            arrayList.add(t);
        }
        this.list = arrayList;
        return this;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FArray)) {
            return false;
        }
        FArray fArray = (FArray)object;
        if (this.length() != fArray.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (ComparatorUtils.equals(this.elementAt(i), fArray.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("FARRAY");
        int n = this.length();
        for (int i = 0; i < n; ++i) {
            xMLPrintWriter.startTAG("FARRAYVALUE");
            GeneralXMLTools.writeObject(xMLPrintWriter, this.elementAt(i));
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && "FARRAYVALUE".equals(string = xMLableReader.getTagName())) {
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode() && "O".equals(xMLableReader.getTagName())) {
                        Object object = GeneralXMLTools.readObject(xMLableReader);
                        FArray.this.add(object);
                    }
                }
            });
        }
    }
}

