/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.GeneralContext;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

public final class DefaultValues
implements Serializable,
Cloneable {
    private ThreadLocal<SimpleDateFormat> dateTimeLocal = new ThreadLocal();
    private ThreadLocal<SimpleDateFormat> timeLocal = new ThreadLocal();
    private FRFont frFont = null;

    DefaultValues() {
    }

    public DateFormat getTimeFormat() {
        SimpleDateFormat simpleDateFormat = this.timeLocal.get();
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
            this.timeLocal.set(simpleDateFormat);
        }
        return simpleDateFormat;
    }

    public DateFormat getDateTimeFormat() {
        SimpleDateFormat simpleDateFormat = this.dateTimeLocal.get();
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.dateTimeLocal.set(simpleDateFormat);
        }
        return simpleDateFormat;
    }

    public FRFont getFRFont() {
        if (this.frFont == null) {
            Locale locale = GeneralContext.getLocale();
            this.frFont = ComparatorUtils.equals(Locale.SIMPLIFIED_CHINESE, locale) ? FRFont.getInstance("SimSun", 0, 9.0f) : (ComparatorUtils.equals(Locale.TRADITIONAL_CHINESE, locale) || ComparatorUtils.equals(Locale.KOREAN, locale) || ComparatorUtils.equals(Locale.KOREA, locale) ? FRFont.getInstance("Dialog", 0, 9.0f) : (ComparatorUtils.equals(Locale.JAPANESE, locale) || ComparatorUtils.equals(Locale.JAPAN, locale) ? FRFont.getInstance("MS Mincho", 0, 9.0f) : FRFont.getInstance("Times New Roman", 0, 9.0f)));
        }
        try {
            return (FRFont)this.frFont.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this.frFont;
        }
    }

    public void setFRFont(FRFont fRFont) {
        this.frFont = fRFont;
    }
}

