/*
 * Decompiled with CFR 0.152.
 */
package com.fr.function;

import com.fr.general.DateUtils;
import com.fr.script.AbstractFunction;
import com.fr.stable.script.Function;
import java.util.Calendar;
import java.util.Date;

public class DAYSOFQUARTER
extends AbstractFunction {
    private static final int FIRST_QUARTER_MONTH = 3;
    private static final int SECOND_QUARTER_MONTH = 6;
    private static final int SECOND_QUARTER_DAYS = 91;
    private static final int OTHER_QUARTER_DAYS = 92;

    public Object run(Object[] objectArray) {
        if (objectArray.length == 0) {
            return 0;
        }
        Date date = DateUtils.object2Date(objectArray[0], false);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(2);
        if (n <= 3) {
            return this.processFirstQuarter(date);
        }
        if (n <= 6) {
            return 91;
        }
        return 92;
    }

    private int processFirstQuarter(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, 0);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        calendar2.set(2, 3);
        return (int)DateUtils.subtractDate(calendar2.getTime(), calendar.getTime(), "d");
    }

    public Function.Type getType() {
        return DATETIME;
    }

    public String getCN() {
        return "DAYSOFQUARTER(date): \u8fd4\u56de\u4ece1900\u5e741\u6708\u540e\u67d0\u5e74\u67d0\u5b63\u5ea6\u7684\u5929\u6570\u3002\n\u793a\u4f8b\uff1a\nDAYSOFQUARTER(\"2009-02-01\")\u7b49\u4e8e90\u3002\nDAYSOFQUARTER(\"2009/05/05\")\u7b49\u4e8e91\u3002";
    }

    public String getEN() {
        return "DAYSOFQUARTER(date):return the days of one day in a quarter.\nExample:\nDAYSOFQUARTER(\"2009-02-01\") = 90.\nDAYSOFQUARTER(\"2009/05/05\") = 91.";
    }
}

