/*
 * Decompiled with CFR 0.152.
 */
package com.fr.function;

import com.fr.general.script.FunctionHelper;
import com.fr.script.AbstractFunction;
import com.fr.stable.Primitive;
import com.fr.stable.script.Function;

public class ATAN
extends AbstractFunction {
    public Object run(Object[] objectArray) {
        if (objectArray.length < 1) {
            return Primitive.ERROR_NAME;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof Number)) continue;
            return FunctionHelper.asNumber(Math.atan(((Number)objectArray[i]).doubleValue()));
        }
        return Primitive.ERROR_NAME;
    }

    public Function.Type getType() {
        return Function.MATH;
    }

    public String getCN() {
        return "ATAN(number): \u8ba1\u7b97\u6307\u5b9a\u6570\u503c\u7684\u53cd\u6b63\u5207\u503c\u3002\u6307\u5b9a\u6570\u503c\u662f\u8fd4\u56de\u89d2\u5ea6\u7684\u6b63\u5207\u503c\uff0c\u8fd4\u56de\u89d2\u5ea6\u4ee5\u5f27\u5ea6\u5f62\u5f0f\u8868\u793a\u3002\nNumber:\u8fd4\u56de\u89d2\u5ea6\u7684\u6b63\u5207\u3002\n\u5907\u6ce8:\n    \u8fd4\u56de\u89d2\u5ea6\u5728-pi/2\u5230pi/2\u4e4b\u95f4\u3002\n    \u5982\u679c\u8fd4\u56de\u89d2\u5ea6\u7b49\u4e8e-pi/2\u6216pi/2\uff0cATAN\u5c06\u8fd4\u56de\u9519\u8bef\u4fe1\u606f*NUM!\u3002\n    \u7528\u89d2\u5ea6\u5f62\u5f0f\u8fd4\u56de\u6570\u503c\u65f6\uff0c\u8fd4\u56de\u6570\u503c\u4e58\u4ee5180/PI()\u3002\n\u793a\u4f8b:\nATAN(-1)\u7b49\u4e8e-0.785398163\uff08-pi/4\u5f27\u5ea6\uff09\u3002\nATAN(0)\u7b49\u4e8e0\uff08\u5f27\u5ea6\uff09\u3002\nATAN(2)*180/PI()\u7b49\u4e8e63.43494882\uff08\u5ea6\uff09\u3002";
    }

    public String getEN() {
        return "ATAN(number): Returns the arctangent, or inverse tangent, of a number. The arctangent is the angle whose tangent is number, the returned angle is given in radians. \nNumber is the tangent of the angle you want.\n\nRemarks:\n    The returned angle is in the range -pi/2 to pi/2.\n    If returned angle equals -pi/2 or pi/2, ATAN returns error *NUM!.\n    To express the arctangent in degrees, multiply the result by 180/PI( ) or use the DEGREES function.\n\nExample:\n   ATAN(-1)=-0.785398163 (-pi/4 in radians)\n   ATAN(0)=0 (in radians)\n   ATAN(2)*180/PI()=63.43494882 (in degrees)";
    }
}

