/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui.tree;

import com.fr.base.TableData;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.impl.TableDataDictionary;
import com.fr.form.ui.tree.LayerDependence;
import com.fr.general.ComparatorUtils;
import com.fr.script.Calculator;
import com.fr.stable.ParameterProvider;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerConfig
implements XMLable {
    public static final String XML_TAG = "LayerConfig";
    private int layerIndex;
    private TableDataDictionary dictionary;
    private TableData tableData;
    private int modelColumn;
    private int viewColumn;
    private List<LayerDependence> dependenceList = new ArrayList<LayerDependence>();

    public LayerConfig(int n) {
        this.layerIndex = n;
    }

    public LayerConfig() {
    }

    public void setTableData(TableData tableData) {
        this.tableData = tableData;
    }

    public void setModelColumn(int n) {
        this.modelColumn = n;
    }

    public void setViewColumn(int n) {
        this.viewColumn = n;
    }

    public int getModelColumn() {
        return this.modelColumn;
    }

    public int getViewColumn() {
        return this.viewColumn;
    }

    public TableData getTableData() {
        return this.tableData;
    }

    public TableDataDictionary getDictionary() {
        return this.dictionary;
    }

    public void setDictionary(TableDataDictionary tableDataDictionary) {
        this.dictionary = tableDataDictionary;
    }

    public int getIndex() {
        return this.layerIndex;
    }

    public List<LayerDependence> getDependenceList() {
        return this.dependenceList;
    }

    public void addAll(List<LayerDependence> list) {
        this.dependenceList.addAll(list);
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            String string = xMLableReader.getTagName();
            if (string.equals(XML_TAG)) {
                this.layerIndex = xMLableReader.getAttrAsInt("layerIndex", 1);
                this.modelColumn = xMLableReader.getAttrAsInt("modelColumn", 0);
                this.viewColumn = xMLableReader.getAttrAsInt("viewColumn", 0);
            }
        } else if (xMLableReader.isChildNode()) {
            if (xMLableReader.getTagName().equals("TableData")) {
                this.tableData = DataCoreXmlUtils.readXMLTableData(xMLableReader);
            } else if (xMLableReader.getTagName().equals("Dictionary")) {
                this.dictionary = (TableDataDictionary)DataCoreXmlUtils.readXMLDictionary(xMLableReader);
            } else if (xMLableReader.getTagName().equals("LayerDependence")) {
                LayerDependence layerDependence = new LayerDependence();
                xMLableReader.readXMLObject(layerDependence);
                this.dependenceList.add(layerDependence);
            }
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.attr("layerIndex", this.layerIndex).attr("modelColumn", this.modelColumn).attr("viewColumn", this.viewColumn);
        DataCoreXmlUtils.writeXMLTableData(xMLPrintWriter, this.tableData);
        DataCoreXmlUtils.writeXMLDictionary(xMLPrintWriter, this.dictionary);
        for (LayerDependence layerDependence : this.dependenceList) {
            xMLPrintWriter.startTAG("LayerDependence");
            layerDependence.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    public boolean equals(Object object) {
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        LayerConfig layerConfig = (LayerConfig)object;
        boolean bl = this.layerIndex == layerConfig.layerIndex && this.modelColumn == layerConfig.modelColumn && this.viewColumn == layerConfig.viewColumn;
        return bl && ComparatorUtils.equals(this.dictionary, layerConfig.dictionary) && ComparatorUtils.equals(this.tableData, layerConfig.tableData);
    }

    @Override
    public Object clone() {
        try {
            LayerConfig layerConfig = (LayerConfig)super.clone();
            layerConfig.layerIndex = this.layerIndex;
            layerConfig.tableData = this.tableData;
            layerConfig.modelColumn = this.modelColumn;
            layerConfig.viewColumn = this.viewColumn;
            layerConfig.tableData = (TableData)this.tableData.clone();
            layerConfig.dependenceList = new ArrayList<LayerDependence>();
            for (LayerDependence layerDependence : this.dependenceList) {
                layerConfig.dependenceList.add((LayerDependence)layerDependence.clone());
            }
            return layerConfig;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public List<String> getDataModelParam(CalculatorProvider calculatorProvider) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ParameterProvider[] parameterProviderArray = this.tableData.getParameters((Calculator)calculatorProvider);
        if (parameterProviderArray != null && parameterProviderArray.length != 0) {
            for (int i = 0; i < parameterProviderArray.length; ++i) {
                ParameterProvider parameterProvider = parameterProviderArray[i];
                if (parameterProvider == null || parameterProvider.getName() == null) continue;
                arrayList.add(parameterProvider.getName());
            }
        }
        return arrayList;
    }
}

