/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.BaseUtils;
import com.fr.base.BaseXMLUtils;
import com.fr.base.GraphHelper;
import com.fr.form.ui.WidgetTitle;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;

public class LayoutBorderStyle
implements Cloneable,
Serializable,
XMLable {
    public static final int STANDARD = 0;
    public static final int TITLE = 1;
    public static final int NORMAL = 0;
    public static final int SHADOWS = 1;
    private static final float DEFAULT_ALPHA = 1.0f;
    private static final int DEFAULT_RADIUS = 0;
    private static final long serialVersionUID = 2677466857456162929L;
    private int type = 0;
    private Color color = new Color(244, 244, 244);
    private int border = 0;
    private int borderRadius = 0;
    private int borderStyle;
    protected Background background;
    protected float alpha = 1.0f;
    private WidgetTitle title = new WidgetTitle();
    private int border_hShadow = 0;
    private int border_vShadow = 0;
    private int border_blur = 3;
    private int border_spread = 2;

    public LayoutBorderStyle() {
    }

    public LayoutBorderStyle(int n, Color color, int n2) {
        this.setStyle(n, color, n2);
    }

    public LayoutBorderStyle(int n, Color color, int n2, int n3, int n4) {
        this.setStyle(n, color, n2, n3, n4);
    }

    public void reset() {
        this.setColor(Color.BLACK);
        this.setBorder(0);
        this.setBorderRadius(0);
        this.setType(0);
        this.setBorderStyle(0);
    }

    private void setStyle(int n, Color color, int n2) {
        this.setColor(color);
        this.setBorder(n);
        this.setBorderRadius(n2);
    }

    private void setStyle(int n, Color color, int n2, int n3, int n4) {
        this.setColor(color);
        this.setBorder(n);
        this.setBorderRadius(n2);
        this.setType(n3);
        this.setBorderStyle(n4);
    }

    public void setStyle(LayoutBorderStyle layoutBorderStyle) {
        if (layoutBorderStyle == null) {
            this.reset();
        } else {
            this.border = layoutBorderStyle.border;
            this.color = layoutBorderStyle.color;
            this.borderRadius = layoutBorderStyle.borderRadius;
            this.borderStyle = layoutBorderStyle.borderStyle;
            this.type = layoutBorderStyle.type;
            this.background = layoutBorderStyle.background;
            this.alpha = layoutBorderStyle.alpha;
            this.title = layoutBorderStyle.title;
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getBorderRadius() {
        return this.borderRadius;
    }

    public void setBorderRadius(int n) {
        this.borderRadius = n;
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int n) {
        this.border = n;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(int n) {
        this.borderStyle = n;
    }

    public Background getBackground() {
        return this.background;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float f) {
        this.alpha = f;
    }

    public void setTitle(WidgetTitle widgetTitle) {
        this.title = widgetTitle;
    }

    public WidgetTitle getTitle() {
        return this.title;
    }

    public String getBorderShadow() {
        String string = StableUtils.javaColorToCSSColor(this.color);
        return LayoutBorderStyle.border2Shadow(this.borderStyle, this.border_hShadow, this.border_vShadow, this.border_blur, this.border_spread, string);
    }

    private static String border2Shadow(int n, int n2, int n3, int n4, int n5, String string) {
        switch (n) {
            case 0: {
                return "none";
            }
            case 1: {
                return n2 + "px " + n3 + "px " + n4 + "px " + n5 + "px " + string;
            }
        }
        return "none";
    }

    public void createJSONConfig(Repository repository, JSONObject jSONObject) throws JSONException {
        if (this.border != 0) {
            JSONObject jSONObject2 = new JSONObject();
            String string = StableUtils.javaColorToCSSColor(this.color);
            jSONObject2.put("width", BaseUtils.getBorderWidth(this.border)).put("type", BaseUtils.border2Style(this.border)).put("color", string).put("borderRadius", this.getBorderRadius()).put("borderStyle", this.getBorderShadow());
            jSONObject.put("border", jSONObject2);
        }
        if (this.alpha != 1.0f) {
            jSONObject.put("widgetOpacity", this.alpha);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof LayoutBorderStyle)) {
            return false;
        }
        LayoutBorderStyle layoutBorderStyle = (LayoutBorderStyle)object;
        return this.getBorder() == layoutBorderStyle.getBorder() && ComparatorUtils.equals(this.getColor(), layoutBorderStyle.getColor()) && ComparatorUtils.equals(this.getBorderRadius(), layoutBorderStyle.getBorderRadius()) && ComparatorUtils.equals(this.getBorderStyle(), layoutBorderStyle.borderStyle) && ComparatorUtils.equals(this.getBackground(), layoutBorderStyle.background) && ComparatorUtils.equals(Float.valueOf(this.getAlpha()), Float.valueOf(layoutBorderStyle.alpha)) && ComparatorUtils.equals(this.getType(), layoutBorderStyle.type) && ComparatorUtils.equals(this.getTitle(), layoutBorderStyle.title);
    }

    public Object clone() throws CloneNotSupportedException {
        LayoutBorderStyle layoutBorderStyle = (LayoutBorderStyle)super.clone();
        layoutBorderStyle.background = this.background != null ? (Background)this.background.clone() : null;
        layoutBorderStyle.color = this.color;
        layoutBorderStyle.title = (WidgetTitle)this.title.clone();
        return layoutBorderStyle;
    }

    private void setStyleFromReader(XMLableReader xMLableReader) {
        this.setStyle(xMLableReader.getAttrAsInt("style", 0), xMLableReader.getAttrAsColor("color", Color.BLACK), xMLableReader.getAttrAsInt("borderRadius", 0), xMLableReader.getAttrAsInt("type", 0), xMLableReader.getAttrAsInt("borderStyle", 0));
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("border")) {
                this.setStyleFromReader(xMLableReader);
            } else if ("WidgetTitle".equals(string)) {
                final WidgetTitle widgetTitle = new WidgetTitle();
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        xMLableReader.readXMLObject(widgetTitle);
                    }
                });
                this.title = widgetTitle;
            } else if ("Background".equals(string)) {
                this.background = BaseXMLUtils.readBackground(xMLableReader);
            } else if ("Alpha".equals(string)) {
                this.setAlpha(xMLableReader.getAttrAsFloat("alpha", 1.0f));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Border");
        xMLPrintWriter.startTAG("border").attr("style", this.border);
        if (this.color != Color.black) {
            xMLPrintWriter.attr("color", this.color.getRGB());
        }
        xMLPrintWriter.attr("borderRadius", this.getBorderRadius());
        xMLPrintWriter.attr("type", this.type);
        xMLPrintWriter.attr("borderStyle", this.borderStyle);
        xMLPrintWriter.end();
        if (this.title != null) {
            this.title.writeXML(xMLPrintWriter);
        }
        if (this.background != null) {
            BaseXMLUtils.writeBackground(xMLPrintWriter, this.background);
        }
        xMLPrintWriter.startTAG("Alpha").attr("alpha", this.alpha).end();
        xMLPrintWriter.end();
    }

    public void paint(Graphics graphics, Rectangle2D.Double double_) {
        if (this.getBorder() != 0) {
            graphics.setColor(this.color);
            int n = GraphHelper.getLineStyleSize(this.border);
            double d = double_.getX() + (double)(n == 1 ? 1 : 2) - (double)n - 1.0;
            double d2 = double_.getY() + (double)(n == 1 ? 1 : 2) - (double)n - 1.0;
            GraphHelper.draw(graphics, new RoundRectangle2D.Double(d, d2, double_.getWidth() + (double)n, double_.getHeight() + (double)n, this.getBorderRadius(), this.getBorderRadius()), this.border);
            if (this.borderStyle == 1) {
                graphics.setColor(this.color.brighter());
                int n2 = 2;
                RoundRectangle2D.Double double_2 = new RoundRectangle2D.Double(d -= (double)(n == 1 ? 1 : 2), d2 -= (double)(n == 1 ? 1 : 2), double_.getWidth() + (double)(n * 2) + (double)n2, double_.getHeight() + (double)(n * 2) + (double)n2, 0.0, 0.0);
                GraphHelper.draw(graphics, double_2, n2);
            }
        }
    }
}

