/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.event;

import com.fr.general.ComparatorUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.js.AbstractJavaScript;
import com.fr.js.JavaScript;
import com.fr.js.JavaScriptImpl;
import com.fr.js.JavaScriptXMLUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONFunction;
import com.fr.json.JSONObject;
import com.fr.json.JSONVariable;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.io.Serializable;

public class Listener
implements XMLReadable,
Serializable,
Cloneable {
    public static final String XML_TAG = "Listener";
    private String targetWidget;
    private String eventName;
    private boolean invokeOnce = false;
    private JavaScript action;

    public Listener() {
    }

    public boolean isDefault() {
        return false;
    }

    public Listener(String string) {
        this(string, null);
    }

    public Listener(String string, JavaScript javaScript) {
        this(string, javaScript, false);
    }

    public Listener(String string, JavaScript javaScript, boolean bl) {
        this(null, string, javaScript, bl);
    }

    public Listener(String string, String string2, JavaScript javaScript) {
        this(string, string2, javaScript, false);
    }

    public Listener(String string, String string2, JavaScript javaScript, boolean bl) {
        this.setTargetWidget(string);
        this.setEventName(string2);
        this.setAction(javaScript);
        this.setInvokeOnce(bl);
    }

    public String getTargetWidget() {
        return this.targetWidget;
    }

    public void setTargetWidget(String string) {
        this.targetWidget = string;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String string) {
        this.eventName = string;
    }

    public boolean isInvokeOnce() {
        return this.invokeOnce;
    }

    public void setInvokeOnce(boolean bl) {
        this.invokeOnce = bl;
    }

    public JavaScript getAction() {
        return this.action;
    }

    public void setAction(JavaScript javaScript) {
        this.action = javaScript;
    }

    public JSONObject createJSONConfig(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        String string = this.getTargetWidget();
        if (StringUtils.isNotBlank(string)) {
            jSONObject.put("target", new JSONVariable(string));
        }
        jSONObject.put("eventName", this.getEventName());
        jSONObject.put("once", this.isInvokeOnce());
        JavaScript javaScript = this.getAction() == null ? new JavaScriptImpl() : this.getAction();
        Object object = repository.getCalculator().getAttribute(AbstractJavaScript.RECALCULATE_TAG);
        if (object != null && ((Boolean)object).booleanValue()) {
            javaScript.setShouldRecalculate(true);
        }
        jSONObject.put("action", new JSONFunction(new String[]{"e"}, javaScript.createJS(repository), repository.getDevice()));
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            String string = xMLableReader.getAttrAsString("target", null);
            if (string != null) {
                this.setTargetWidget(string);
            }
            if ((string = xMLableReader.getAttrAsString("event", null)) != null) {
                this.setEventName(string);
            }
            this.setInvokeOnce(xMLableReader.getAttrAsBoolean("once", false));
        }
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("JavaScript")) {
            this.setAction(JavaScriptXMLUtils.readJavaScript(xMLableReader));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (StringUtils.isNotBlank(this.getTargetWidget())) {
            xMLPrintWriter.attr("target", this.getTargetWidget());
        }
        if (StringUtils.isNotBlank(this.getEventName())) {
            xMLPrintWriter.attr("event", this.getEventName());
        }
        if (this.isInvokeOnce()) {
            xMLPrintWriter.attr("once", this.isInvokeOnce());
        }
        if (this.getAction() != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.getAction(), "JavaScript");
        }
        xMLPrintWriter.end();
    }

    public String toString() {
        return this.action == null ? "" : this.eventName + ":" + this.action.getClass().getName();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Listener)) {
            return false;
        }
        return ComparatorUtils.equals(this.getTargetWidget(), ((Listener)object).getTargetWidget()) && ComparatorUtils.equals(this.getEventName(), ((Listener)object).getEventName()) && ComparatorUtils.equals(this.getAction(), ((Listener)object).getAction()) && this.isInvokeOnce() == ((Listener)object).isInvokeOnce();
    }

    public Object clone() throws CloneNotSupportedException {
        Listener listener = (Listener)super.clone();
        if (this.action != null) {
            listener.action = (JavaScript)this.action.clone();
        }
        return listener;
    }
}

