/*
 * Decompiled with CFR 0.152.
 */
package com.fr.file;

import com.fr.cluster.stable.ClusterState;
import com.fr.file.ClusterConfigManager;
import com.fr.file.ClusterReinitListener;
import com.fr.file.ClusterService;
import com.fr.file.DefaultClusterServerProcessor;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.fun.ClusterServerProcessor;
import com.fr.stable.plugin.ExtraClassManagerProvider;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class BaseClusterHelper {
    public static final int CLUSTER_CLOSED = -1;
    public static final int CLUSTER_MEMBER = 0;
    public static final int CLUSTER_LEADER = 1;
    private static List<ClusterReinitListener> clusterReinitListeners = new ArrayList<ClusterReinitListener>();

    public static void addManagerReinitListener(ClusterReinitListener clusterReinitListener) {
        if (BaseClusterHelper.getClusterState() == ClusterState.CLOSED) {
            return;
        }
        clusterReinitListeners.add(clusterReinitListener);
    }

    public static void fireManagerReinitListener() {
        for (ClusterReinitListener clusterReinitListener : clusterReinitListeners) {
            clusterReinitListener.reinit();
        }
    }

    public static ClusterState getClusterState() {
        ExtraClassManagerProvider extraClassManagerProvider = StableFactory.getMarkedObject("ExtraClassManager", ExtraClassManagerProvider.class);
        if (extraClassManagerProvider == null) {
            if (StringUtils.isNotEmpty(BaseClusterHelper.getMainServiceIP())) {
                return BaseClusterHelper.resolveStateWithoutPlugin();
            }
            return ClusterState.CLOSED;
        }
        ClusterServerProcessor clusterServerProcessor = (ClusterServerProcessor)((Object)extraClassManagerProvider.getSingle("ClusterServerProcessor", DefaultClusterServerProcessor.class));
        return (ClusterState)clusterServerProcessor.getClusterState();
    }

    private static ClusterState resolveStateWithoutPlugin() {
        ClusterConfigManager clusterConfigManager = ClusterConfigManager.getInstance();
        if (!clusterConfigManager.isUseCluster()) {
            return ClusterState.CLOSED;
        }
        ClusterService clusterService = clusterConfigManager.resolveSelfServices();
        ClusterService clusterService2 = clusterConfigManager.resolveMainServices();
        if (clusterService == null || clusterService2 == null) {
            return ClusterState.CLOSED;
        }
        return clusterService.isMain() ? ClusterState.LEADER : ClusterState.MEMBER;
    }

    public static String getMainServiceIP() {
        ClusterConfigManager clusterConfigManager = ClusterConfigManager.getInstance();
        ClusterService clusterService = clusterConfigManager.resolveMainServices();
        return clusterService != null && clusterService.isMain() ? clusterService.getIp() : "";
    }

    public static String getLocalIP() throws Exception {
        Object object;
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        InetAddress inetAddress = null;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            Enumeration<InetAddress> enumeration2 = ((NetworkInterface)object).getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                inetAddress = enumeration2.nextElement();
                if (!BaseClusterHelper.isLocalIP(inetAddress, ((NetworkInterface)object).getName())) continue;
                return inetAddress.getHostAddress();
            }
        }
        object = InetAddress.getLocalHost();
        return object == null ? null : ((InetAddress)object).getHostAddress();
    }

    private static boolean isLocalIP(InetAddress inetAddress, String string) {
        return inetAddress.isSiteLocalAddress() && !inetAddress.isLoopbackAddress() && inetAddress.getHostAddress().indexOf(":") == -1 && BaseClusterHelper.isNotVirbr(string);
    }

    private static boolean isNotVirbr(String string) {
        if (StringUtils.isEmpty(string)) {
            return true;
        }
        return string.toLowerCase().indexOf("virbr0") == -1;
    }
}

