/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl.excelplus;

import com.fr.data.impl.excelplus.ExcelUtil;
import com.fr.general.FRLogger;
import com.fr.stable.ColumnRow;
import com.fr.stable.Primitive;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFDateUtil;
import com.fr.third.v2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.OPCPackage;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.PackageAccess;
import com.fr.third.v2.org.apache.poi.ss.usermodel.BuiltinFormats;
import com.fr.third.v2.org.apache.poi.ss.usermodel.DataFormatter;
import com.fr.third.v2.org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import com.fr.third.v2.org.apache.poi.xssf.eventusermodel.XSSFReader;
import com.fr.third.v2.org.apache.poi.xssf.model.StylesTable;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFCellStyle;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFRichTextString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Excel2007Util
extends ExcelUtil {
    private static final int A_CHAR = 65;
    private static final int CHAR_LEN = 26;
    public boolean isEmpty = false;
    private int columnCount = 0;
    private List<Object> currentRowData = new ArrayList<Object>();
    private List<Object[]> rowDataList = new ArrayList<Object[]>();
    private List<Object[]> tempRowDataList = new ArrayList<Object[]>();
    private Map<ColumnRow, ColumnRow> mergeCells = new HashMap<ColumnRow, ColumnRow>();
    private boolean preview = false;
    private OPCPackage xlsxPackage;
    private List<Object> tempData = new ArrayList<Object>();

    protected Excel2007Util(StylesTable stylesTable, ReadOnlySharedStringsTable readOnlySharedStringsTable, InputStream inputStream) throws IOException, ParserConfigurationException, SAXException {
        this.processSheet(stylesTable, readOnlySharedStringsTable, inputStream);
        inputStream.close();
        this.mergeCell();
        this.dealWithSomething();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Excel2007Util(String string, boolean bl) throws Exception {
        this.preview = bl;
        if (!string.startsWith("http")) {
            Object object;
            Object object2 = object = ExcelUtil.ExcelFileLock.getFileLock(string);
            synchronized (object2) {
                File file = new File(string);
                if (!file.exists()) {
                    System.err.println("Not found or not a file: " + file.getPath());
                    return;
                }
                this.xlsxPackage = OPCPackage.open((String)file.getPath(), (PackageAccess)PackageAccess.READ);
            }
        } else {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            this.xlsxPackage = OPCPackage.open((InputStream)uRLConnection.getInputStream());
        }
        this.processFirstSheet();
        if (this.tempRowDataList.size() == 0) {
            this.processFirstSheetFromBI();
        }
        this.mergeCell();
        this.dealWithSomething();
        this.xlsxPackage.close();
    }

    public Excel2007Util(InputStream inputStream, boolean bl) throws Exception {
        this.preview = bl;
        this.xlsxPackage = OPCPackage.open((InputStream)inputStream);
        this.processFirstSheet();
        if (this.tempRowDataList.size() == 0) {
            this.processFirstSheetFromBI();
        }
        this.mergeCell();
        this.dealWithSomething();
    }

    public static List<Excel2007Util> createMutiSheetExcel(InputStream inputStream) throws Exception {
        ArrayList<Excel2007Util> arrayList = new ArrayList<Excel2007Util>();
        OPCPackage oPCPackage = OPCPackage.open((InputStream)inputStream);
        ReadOnlySharedStringsTable readOnlySharedStringsTable = new ReadOnlySharedStringsTable(oPCPackage);
        XSSFReader xSSFReader = new XSSFReader(oPCPackage);
        StylesTable stylesTable = xSSFReader.getStylesTable();
        XSSFReader.SheetIterator sheetIterator = (XSSFReader.SheetIterator)xSSFReader.getSheetsData();
        while (sheetIterator.hasNext()) {
            InputStream inputStream2 = sheetIterator.next();
            Excel2007Util excel2007Util = new Excel2007Util(stylesTable, readOnlySharedStringsTable, inputStream2);
            arrayList.add(excel2007Util);
        }
        return arrayList;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public List<Object[]> getRowDataList() {
        return this.rowDataList;
    }

    public void mergeCell() {
        this.mergeCells(this.mergeCells, this.tempRowDataList);
    }

    private void dealWithSomething() {
        for (int i = 0; i < this.tempRowDataList.size(); ++i) {
            Object[] objectArray = this.tempRowDataList.get(i);
            this.currentRowData = new ArrayList<Object>();
            for (int j = 0; j < this.columnCount; ++j) {
                Object object = Primitive.NULL;
                if (objectArray.length > j && objectArray[j] != null) {
                    object = objectArray[j];
                }
                this.currentRowData.add(object);
            }
            this.rowDataList.add(this.currentRowData.toArray());
        }
    }

    public void processSheet(StylesTable stylesTable, ReadOnlySharedStringsTable readOnlySharedStringsTable, InputStream inputStream) throws IOException, ParserConfigurationException, SAXException {
        InputSource inputSource = new InputSource(inputStream);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        XMLReader xMLReader = sAXParser.getXMLReader();
        MyXSSFSheetHandler myXSSFSheetHandler = new MyXSSFSheetHandler(stylesTable, readOnlySharedStringsTable);
        xMLReader.setContentHandler(myXSSFSheetHandler);
        xMLReader.parse(inputSource);
    }

    public void processFirstSheet() throws Exception {
        ReadOnlySharedStringsTable readOnlySharedStringsTable = new ReadOnlySharedStringsTable(this.xlsxPackage);
        XSSFReader xSSFReader = new XSSFReader(this.xlsxPackage);
        StylesTable stylesTable = xSSFReader.getStylesTable();
        InputStream inputStream = xSSFReader.getSheet("rId1");
        InputSource inputSource = new InputSource(inputStream);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        XMLReader xMLReader = sAXParser.getXMLReader();
        MyXSSFSheetHandler myXSSFSheetHandler = new MyXSSFSheetHandler(stylesTable, readOnlySharedStringsTable);
        xMLReader.setContentHandler(myXSSFSheetHandler);
        xMLReader.parse(inputSource);
        inputStream.close();
    }

    public void processFirstSheetFromBI() throws Exception {
        ReadOnlySharedStringsTable readOnlySharedStringsTable = new ReadOnlySharedStringsTable(this.xlsxPackage);
        XSSFReader xSSFReader = new XSSFReader(this.xlsxPackage);
        StylesTable stylesTable = xSSFReader.getStylesTable();
        InputStream inputStream = xSSFReader.getSheet("rId3");
        InputSource inputSource = new InputSource(inputStream);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        XMLReader xMLReader = sAXParser.getXMLReader();
        MyXSSFSheetHandler myXSSFSheetHandler = new MyXSSFSheetHandler(stylesTable, readOnlySharedStringsTable);
        xMLReader.setContentHandler(myXSSFSheetHandler);
        xMLReader.parse(inputSource);
        inputStream.close();
    }

    public void process() throws IOException, OpenXML4JException, ParserConfigurationException, SAXException {
        ReadOnlySharedStringsTable readOnlySharedStringsTable = new ReadOnlySharedStringsTable(this.xlsxPackage);
        XSSFReader xSSFReader = new XSSFReader(this.xlsxPackage);
        StylesTable stylesTable = xSSFReader.getStylesTable();
        XSSFReader.SheetIterator sheetIterator = (XSSFReader.SheetIterator)xSSFReader.getSheetsData();
        while (sheetIterator.hasNext()) {
            InputStream inputStream = sheetIterator.next();
            this.processSheet(stylesTable, readOnlySharedStringsTable, inputStream);
            inputStream.close();
        }
    }

    class MyXSSFSheetHandler
    extends DefaultHandler {
        private StylesTable stylesTable;
        private ReadOnlySharedStringsTable sharedStringsTable;
        private boolean vIsOpen;
        private boolean fIsOpen;
        private boolean isIsOpen;
        private boolean hfIsOpen;
        private xssfDataType nextDataType;
        private short formatIndex;
        private String formatString;
        private final DataFormatter formatter;
        private StringBuffer value = new StringBuffer();
        private StringBuffer formula = new StringBuffer();
        private StringBuffer headerFooter = new StringBuffer();
        private boolean formulasNotResults;
        private Object cellValue;
        private int thisColumn = -1;
        private int lastColumnNumber = -1;
        private int thisRowIndex = 0;

        public MyXSSFSheetHandler(StylesTable stylesTable, ReadOnlySharedStringsTable readOnlySharedStringsTable, DataFormatter dataFormatter) {
            this.stylesTable = stylesTable;
            this.sharedStringsTable = readOnlySharedStringsTable;
            this.nextDataType = xssfDataType.NUMBER;
            this.formatter = dataFormatter;
            this.formulasNotResults = false;
        }

        public MyXSSFSheetHandler(StylesTable stylesTable, ReadOnlySharedStringsTable readOnlySharedStringsTable) {
            this(stylesTable, readOnlySharedStringsTable, new DataFormatter());
        }

        private boolean isTextTag(String string) {
            return "v".equals(string) ? true : ("inlineStr".equals(string) ? true : "t".equals(string) && this.isIsOpen);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.isTextTag(string3)) {
                this.vIsOpen = true;
                this.value.setLength(0);
            } else if ("is".equals(string3)) {
                this.isIsOpen = true;
            } else if ("f".equals(string3)) {
                String string4;
                this.formula.setLength(0);
                if (this.nextDataType == xssfDataType.NUMBER) {
                    this.nextDataType = xssfDataType.FORMULA;
                }
                if ((string4 = attributes.getValue("t")) != null && string4.equals("shared")) {
                    String string5 = attributes.getValue("ref");
                    if (string5 != null) {
                        this.fIsOpen = true;
                    } else if (this.formulasNotResults) {
                        System.err.println("Warning - shared formulas not yet supported!");
                    }
                } else {
                    this.fIsOpen = true;
                }
            } else if (!("oddHeader".equals(string3) || "evenHeader".equals(string3) || "firstHeader".equals(string3) || "firstFooter".equals(string3) || "oddFooter".equals(string3) || "evenFooter".equals(string3))) {
                if ("row".equals(string3)) {
                    this.thisRowIndex = Integer.parseInt(attributes.getValue("r")) - 1;
                } else if ("c".equals(string3)) {
                    int n;
                    String string6 = attributes.getValue("r");
                    int n2 = -1;
                    for (n = 0; n < string6.length(); ++n) {
                        if (!Character.isDigit(string6.charAt(n))) continue;
                        n2 = n;
                        break;
                    }
                    this.thisColumn = this.nameToColumn(string6.substring(0, n2));
                    this.nextDataType = xssfDataType.NUMBER;
                    this.formatIndex = (short)-1;
                    this.formatString = null;
                    String string7 = attributes.getValue("t");
                    String string8 = attributes.getValue("s");
                    if ("b".equals(string7)) {
                        this.nextDataType = xssfDataType.BOOL;
                    } else if ("e".equals(string7)) {
                        this.nextDataType = xssfDataType.ERROR;
                    } else if ("inlineStr".equals(string7)) {
                        this.nextDataType = xssfDataType.INLINESTR;
                    } else if ("s".equals(string7)) {
                        this.nextDataType = xssfDataType.SSTINDEX;
                    } else if ("str".equals(string7)) {
                        this.nextDataType = xssfDataType.FORMULA;
                    } else if (string8 != null) {
                        n = Integer.parseInt(string8);
                        XSSFCellStyle xSSFCellStyle = this.stylesTable.getStyleAt(n);
                        this.formatIndex = xSSFCellStyle.getDataFormat();
                        this.formatString = xSSFCellStyle.getDataFormatString();
                        if (this.formatString == null) {
                            this.formatString = BuiltinFormats.getBuiltinFormat((int)this.formatIndex);
                        }
                    }
                } else if ("mergeCell".equals(string3)) {
                    String string9 = attributes.getValue("ref");
                    String[] stringArray = string9.split(":");
                    String string10 = stringArray[0];
                    String string11 = stringArray[1];
                    ColumnRow columnRow = ColumnRow.valueOf(string10);
                    ColumnRow columnRow2 = ColumnRow.valueOf(string11);
                    Excel2007Util.this.mergeCells.put(columnRow, columnRow2);
                }
            } else {
                this.hfIsOpen = true;
                this.headerFooter.setLength(0);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.isTextTag(string3)) {
                int n;
                this.vIsOpen = false;
                switch (this.nextDataType) {
                    case BOOL: {
                        n = this.value.charAt(0);
                        this.cellValue = n == 48 ? "FALSE" : "TRUE";
                        break;
                    }
                    case ERROR: {
                        this.cellValue = "ERROR:" + this.value.toString();
                        break;
                    }
                    case FORMULA: {
                        if (this.formulasNotResults) {
                            this.cellValue = this.formula.toString();
                            break;
                        }
                        String string4 = this.value.toString();
                        if (this.formatString != null) {
                            try {
                                double d = Double.parseDouble(string4);
                                this.cellValue = this.formatter.formatRawCellContents(d, (int)this.formatIndex, this.formatString);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.cellValue = string4;
                            }
                            break;
                        }
                        this.cellValue = string4;
                        break;
                    }
                    case INLINESTR: {
                        String string4 = new XSSFRichTextString(this.value.toString());
                        this.cellValue = string4.toString();
                        break;
                    }
                    case SSTINDEX: {
                        this.processSSTIndex();
                        break;
                    }
                    case NUMBER: {
                        this.processNumber();
                        break;
                    }
                    default: {
                        this.cellValue = Primitive.NULL;
                    }
                }
                if (this.lastColumnNumber == -1) {
                    this.lastColumnNumber = 0;
                }
                for (n = this.lastColumnNumber; n < this.thisColumn; ++n) {
                    if (Excel2007Util.this.tempData.size() >= this.thisColumn) continue;
                    Excel2007Util.this.tempData.add(Primitive.NULL);
                }
                Excel2007Util.this.tempData.add(this.cellValue);
                if (this.thisColumn > -1) {
                    this.lastColumnNumber = this.thisColumn;
                }
            } else if ("f".equals(string3)) {
                this.fIsOpen = false;
            } else if ("is".equals(string3)) {
                this.isIsOpen = false;
            } else if ("row".equals(string3)) {
                Excel2007Util.this.columnCount = Math.max(Excel2007Util.this.columnCount, Excel2007Util.this.tempData.size());
                while (this.thisRowIndex > Excel2007Util.this.tempRowDataList.size()) {
                    ArrayList<Primitive> arrayList = new ArrayList<Primitive>();
                    for (int i = 0; i < Excel2007Util.this.columnCount; ++i) {
                        arrayList.add(Primitive.NULL);
                    }
                    Excel2007Util.this.tempRowDataList.add(arrayList.toArray());
                }
                Excel2007Util.this.tempRowDataList.add(Excel2007Util.this.tempData.toArray());
                Excel2007Util.this.tempData = new ArrayList();
                this.lastColumnNumber = 0;
            } else if (this.checkIsNotHeader(string3)) {
                if (this.checkIsOneOfFooter(string3)) {
                    this.hfIsOpen = false;
                }
            } else {
                this.hfIsOpen = false;
            }
        }

        private boolean checkIsNotHeader(String string) {
            return !"oddHeader".equals(string) && !"evenHeader".equals(string) && !"firstHeader".equals(string);
        }

        private boolean checkIsOneOfFooter(String string) {
            return "oddFooter".equals(string) || "evenFooter".equals(string) || "firstFooter".equals(string);
        }

        public void processSSTIndex() {
            String string = this.value.toString();
            try {
                int n = Integer.parseInt(string);
                XSSFRichTextString xSSFRichTextString = new XSSFRichTextString(this.sharedStringsTable.getEntryAt(n));
                this.cellValue = xSSFRichTextString.toString();
            }
            catch (NumberFormatException numberFormatException) {
                FRLogger.getLogger().error(numberFormatException.getMessage(), numberFormatException);
            }
        }

        public void processNumber() {
            String string = this.value.toString();
            boolean bl = this.formatString != null && (this.formatString.contains("yy") || this.formatString.contains("dd") || this.formatString.contains("mm"));
            try {
                if (bl) {
                    Date date = HSSFDateUtil.getJavaDate((double)Double.parseDouble(string));
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:MM:ss");
                    this.cellValue = simpleDateFormat.format(date);
                } else {
                    String string2;
                    this.cellValue = this.formatIndex != -1 || this.formatString != null ? (this.hasSpecialChar(string2 = this.formatter.formatRawCellContents(Double.parseDouble(this.value.toString()), (int)this.formatIndex, this.formatString == null ? "" : this.formatString)) ? string : string2) : string;
                }
            }
            catch (Exception exception) {
                this.cellValue = string;
            }
        }

        private boolean hasSpecialChar(String string) {
            Pattern pattern = Pattern.compile("[,()]");
            Matcher matcher = pattern.matcher(string);
            return matcher.find();
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.vIsOpen) {
                this.value.append(cArray, n, n2);
            }
            if (this.fIsOpen) {
                this.formula.append(cArray, n, n2);
            }
            if (this.hfIsOpen) {
                this.headerFooter.append(cArray, n, n2);
            }
        }

        private int nameToColumn(String string) {
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                n = (n + 1) * 26 + c - 65;
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum xssfDataType {
        BOOL,
        ERROR,
        FORMULA,
        INLINESTR,
        SSTINDEX,
        NUMBER;

    }
}

