/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.cache.list.IntList;
import com.fr.data.AbstractDataModel;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.stable.Primitive;
import java.util.ArrayList;
import java.util.List;

public class UnionDataModel
extends AbstractDataModel {
    private transient int[][] columnInfo = null;
    private transient int[] rowCountInfo = null;
    private transient List columnNameList = null;
    private List resultSetList;
    private final Object columnLock = new Object();
    private final Object rowLock = new Object();

    public UnionDataModel(List list) {
        this.resultSetList = list;
    }

    public int getColumnCount() throws TableDataException {
        this.initColumn();
        return this.columnNameList.size();
    }

    public String getColumnName(int n) throws TableDataException {
        this.initColumn();
        return (String)this.columnNameList.get(n);
    }

    public int getRowCount() throws TableDataException {
        this.initRowCount();
        this.initColumn();
        return this.rowCountInfo[this.rowCountInfo.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initColumn() throws TableDataException {
        Object object = this.columnLock;
        synchronized (object) {
            if (this.columnNameList == null) {
                int n;
                IntList intList;
                int n2;
                if (this.resultSetList == null || this.resultSetList.isEmpty()) {
                    this.columnNameList = new ArrayList(0);
                    this.columnInfo = new int[0][0];
                    return;
                }
                int n3 = this.resultSetList.size();
                this.columnNameList = new ArrayList();
                IntList[] intListArray = new IntList[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    DataModel dataModel = (DataModel)this.resultSetList.get(n2);
                    int n4 = dataModel.getColumnCount();
                    intList = new IntList();
                    for (n = 0; n < n4; ++n) {
                        String string = dataModel.getColumnName(n);
                        if (this.columnNameList.contains(string)) {
                            intList.add(this.columnNameList.indexOf(string));
                            continue;
                        }
                        this.columnNameList.add(string);
                        intList.add(this.columnNameList.size() - 1);
                    }
                    intListArray[n2] = intList;
                }
                this.columnInfo = new int[n3][this.columnNameList.size()];
                for (n2 = 0; n2 < n3; ++n2) {
                    intList = intListArray[n2];
                    int[] nArray = this.columnInfo[n2];
                    for (n = 0; n < nArray.length; ++n) {
                        nArray[n] = -1;
                    }
                    for (n = intList.size() - 1; n >= 0; --n) {
                        nArray[intList.get((int)n)] = n;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRowCount() throws TableDataException {
        Object object = this.rowLock;
        synchronized (object) {
            if (this.rowCountInfo == null) {
                if (this.resultSetList == null || this.resultSetList.isEmpty()) {
                    this.rowCountInfo = new int[1];
                    return;
                }
                int n = this.resultSetList.size();
                this.rowCountInfo = new int[n + 1];
                for (int i = 0; i < n; ++i) {
                    DataModel dataModel = (DataModel)this.resultSetList.get(i);
                    this.rowCountInfo[i + 1] = dataModel.getRowCount() + this.rowCountInfo[i];
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int n, int n2) throws TableDataException {
        if (n < 0 || n2 < 0) {
            return Primitive.NULL;
        }
        Object object = this.rowLock;
        synchronized (object) {
            for (int i = this.rowCountInfo.length - 1; i >= 0; --i) {
                if (n < this.rowCountInfo[i]) continue;
                if (i == this.rowCountInfo.length) {
                    return Primitive.NULL;
                }
                int[] nArray = this.columnInfo[i];
                if (n2 >= nArray.length) {
                    return Primitive.NULL;
                }
                int n3 = nArray[n2];
                if (n3 < 0) {
                    return Primitive.NULL;
                }
                Object object2 = ((DataModel)this.resultSetList.get(i)).getValueAt(n - this.rowCountInfo[i], n3);
                if (object2 == null) {
                    return Primitive.NULL;
                }
                return object2;
            }
            return Primitive.NULL;
        }
    }

    public void release() throws Exception {
        if (this.resultSetList != null) {
            int n = this.resultSetList.size();
            for (int i = 0; i < n; ++i) {
                DataModel dataModel = (DataModel)this.resultSetList.get(i);
                dataModel.release();
            }
        }
    }
}

