/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.AbstractTableData;
import com.fr.base.SynchronizedLiveDataModelUtils;
import com.fr.base.TableData;
import com.fr.data.TableDataSource;
import com.fr.data.core.DataCoreUtils;
import com.fr.data.impl.storeproc.StoreProcedure;
import com.fr.file.DatasourceManager;
import com.fr.file.DatasourceManagerProvider;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.data.DataModel;
import com.fr.script.Calculator;
import com.fr.stable.ParameterProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;

public class NameTableData
extends AbstractTableData
implements XMLable {
    private String name;
    private transient TableData _tableData;

    public NameTableData() {
    }

    public NameTableData(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public TableData getTableData() {
        return this._tableData;
    }

    public DataModel createDataModel(Calculator calculator) {
        TableData tableData;
        DataModel dataModel = null;
        if (calculator != null) {
            dataModel = SynchronizedLiveDataModelUtils.getSELiveDataModel4Share(calculator, this.name);
        }
        if (dataModel == null && (tableData = this.createTableData(calculator)) != null) {
            dataModel = tableData.createDataModel(calculator, this.name);
        }
        if (dataModel == null) {
            dataModel = DataCoreUtils.getLiveDataModel(calculator, this.name);
        }
        return dataModel;
    }

    public DataModel createDataModel(Calculator calculator, String string) {
        return this.createDataModel(calculator);
    }

    public DataModel createDataModel(Calculator calculator, int n) {
        return this.createDataModel(calculator);
    }

    public TableData createTableData(Calculator calculator) {
        if (this._tableData == null) {
            this.createTableDataFromSource(calculator);
        }
        if (this._tableData == null) {
            this.createTableFromGlobal(calculator);
        }
        return this._tableData;
    }

    private void createTableDataFromSource(Calculator calculator) {
        TableDataSource tableDataSource;
        if (calculator != null && (tableDataSource = (TableDataSource)calculator.getAttribute(TableDataSource.KEY)) != null) {
            this._tableData = tableDataSource.getTableData(this.name);
        }
    }

    private void createTableFromGlobal(Calculator calculator) {
        DatasourceManagerProvider datasourceManagerProvider = DatasourceManager.getProviderInstance();
        try {
            this._tableData = DataCoreUtils.getClonedTableData(datasourceManagerProvider, this.name);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    public ParameterProvider[] getParameters(Calculator calculator) {
        TableData tableData = this.createTableData(calculator);
        if (tableData == null) {
            StoreProcedure storeProcedure = DatasourceManager.getProviderInstance().getProcedure(this.name);
            return storeProcedure == null ? new ParameterProvider[]{} : storeProcedure.get_IN_Parameters();
        }
        return tableData.getParameters(calculator);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        return object instanceof NameTableData && ComparatorUtils.equals(this.name, ((NameTableData)object).name);
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && "Name".equals(xMLableReader.getTagName()) && (string = xMLableReader.getElementValue()) != null) {
            this.name = string;
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Name").textNode(this.getName()).end();
    }

    public String toString() {
        return "TableData[" + this.name + "]";
    }
}

