/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.TableData;
import com.fr.data.Dictionary;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.data.Condition;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ColumnRow;
import com.fr.stable.FormulaProvider;
import com.fr.stable.ParameterProvider;
import com.fr.stable.Primitive;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.collections.map.ObjectIntMap;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.ExTool;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class FormulaDisplayDictionary
implements Dictionary {
    protected Condition condition;
    protected int keyColumnIndex;
    protected String keyColumnName;
    protected String valueColumnName;
    protected int valueColumnIndex;
    protected FormulaProvider formula;
    protected transient List kvs;
    private Map<DataModel, ObjectIntMap> dmColumnIndexMap = new HashMap<DataModel, ObjectIntMap>();

    public int getKeyColumnIndex() {
        return this.keyColumnIndex;
    }

    public void setKeyColumnIndex(int n) {
        this.keyColumnIndex = n;
    }

    public int getValueColumnIndex() {
        return this.valueColumnIndex;
    }

    public void setValueColumnIndex(int n) {
        this.valueColumnIndex = n;
    }

    public String getKeyColumnName() {
        return this.keyColumnName;
    }

    public void setKeyColumnName(String string) {
        this.keyColumnName = string;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public void setValueColumnName(String string) {
        this.valueColumnName = string;
    }

    public FormulaProvider getFormula() {
        return this.formula;
    }

    public void setFormula(FormulaProvider formulaProvider) {
        this.formula = formulaProvider;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public String[] dependence(CalculatorProvider calculatorProvider) {
        if (this.condition != null) {
            return this.condition.dependence(calculatorProvider);
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object, Calculator calculator) {
        FormulaDisplayDictionary formulaDisplayDictionary = this;
        synchronized (formulaDisplayDictionary) {
            this.createKVS(calculator);
            int n = this.kvs.size();
            for (int i = 0; i < n; ++i) {
                Dictionary.MV mV = (Dictionary.MV)this.kvs.get(i);
                if (!ComparatorUtils.equals(mV.getModel(), object)) continue;
                return mV.getView();
            }
            return null;
        }
    }

    public Iterator entrys(Calculator calculator) {
        this.createKVS(calculator);
        return new EntryIterator();
    }

    public Iterator entrys(Calculator calculator, int n, int n2) {
        this.createKVS(calculator, n, n2);
        return new EntryIterator();
    }

    private void createKVS(Calculator calculator) {
        if (!this.isShareAvailable(calculator)) {
            TableData tableData = this.asTableData(calculator);
            if (tableData == null) {
                this.kvs = Collections.EMPTY_LIST;
                return;
            }
            this.kvs = new ArrayList();
            Map map = this.getParameterMap4Preview(calculator, tableData);
            try {
                tableData = (TableData)GeneralContext.getEnvProvider().previewTableData(tableData, map, -1);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
                tableData = TableData.EMPTY_TABLEDATA;
            }
            DataModel dataModel = tableData.createDataModel(null);
            try {
                int n = dataModel.getRowCount();
                for (int i = 0; i < n; ++i) {
                    this.kvs.add(this.createMV(dataModel, i, calculator));
                }
            }
            catch (TableDataException tableDataException) {
                FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
            }
            try {
                dataModel.release();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
    }

    private void createKVS(Calculator calculator, int n, int n2) {
        if (!this.isShareAvailable(calculator)) {
            TableData tableData = this.asTableData(calculator);
            if (tableData == null) {
                this.kvs = Collections.EMPTY_LIST;
                return;
            }
            this.kvs = new ArrayList();
            Map map = this.getParameterMap4Preview(calculator, tableData);
            try {
                tableData = (TableData)GeneralContext.getEnvProvider().previewTableData(tableData, map, n, n2, new String[]{this.keyColumnName, this.valueColumnName}, new int[]{this.keyColumnIndex, this.valueColumnIndex});
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
                tableData = TableData.EMPTY_TABLEDATA;
            }
            DataModel dataModel = tableData.createDataModel(null);
            try {
                int n3 = dataModel.getRowCount();
                for (int i = 0; i < n3; ++i) {
                    this.kvs.add(this.createMV(dataModel, i, calculator));
                }
            }
            catch (TableDataException tableDataException) {
                FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
            }
            try {
                dataModel.release();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
    }

    private Map getParameterMap4Preview(Calculator calculator, TableData tableData) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (calculator == null) {
            return hashMap;
        }
        ParameterProvider[] parameterProviderArray = tableData.getParameters(calculator);
        int n = ArrayUtils.getLength(parameterProviderArray);
        for (int i = 0; i < n; ++i) {
            ParameterProvider parameterProvider = parameterProviderArray[i];
            Object object = this.evalParaValue(calculator, hashMap, parameterProvider);
            hashMap.put(parameterProvider.getName(), object);
        }
        return hashMap;
    }

    private Object evalParaValue(Calculator calculator, Map map, ParameterProvider parameterProvider) {
        try {
            Object object = calculator.evalValue(parameterProvider.getName());
            if (object != null && object != Primitive.NULL) {
                return object;
            }
            object = parameterProvider.getValue();
            if (object instanceof FormulaProvider) {
                return calculator.eval((FormulaProvider)object);
            }
            return object;
        }
        catch (UtilEvalError utilEvalError) {
            return parameterProvider.getValue();
        }
    }

    protected abstract TableData asTableData(Calculator var1);

    protected boolean isShareAvailable(Calculator calculator) {
        return this.kvs != null;
    }

    protected Dictionary.MV createMV(DataModel dataModel, int n, Calculator calculator) throws TableDataException {
        int n2 = dataModel.getColumnCount();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < n2; ++i) {
            hashMap.put(dataModel.getColumnName(i), new Integer(i));
        }
        Object object = dataModel.getValueAt(n, this.getKeyColumnIndex(dataModel));
        Object object2 = dataModel.getValueAt(n, this.getValueColumnIndex(dataModel));
        if (this.getFormula() != null) {
            if (calculator == null) {
                calculator = Calculator.createCalculator();
            }
            calculator.set("$$$", object);
            try {
                object2 = calculator.evalValue(this.getFormula());
            }
            catch (UtilEvalError utilEvalError) {
                FRLogger.getLogger().error(utilEvalError.getMessage(), utilEvalError);
            }
        }
        return new Dictionary.MV(object, object2);
    }

    public int getDataModelColumnIndex(DataModel dataModel, String string) {
        try {
            if (dataModel == null) {
                return -1;
            }
            ObjectIntMap<String> objectIntMap = new ObjectIntMap<String>();
            if (this.dmColumnIndexMap.containsKey(dataModel)) {
                return this.dmColumnIndexMap.get(dataModel).get(string, -1);
            }
            int n = dataModel.getColumnCount();
            for (int i = 0; i < n; ++i) {
                objectIntMap.put(dataModel.getColumnName(i), i);
            }
            this.dmColumnIndexMap.put(dataModel, objectIntMap);
            return objectIntMap.get(string, -1);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getKeyColumnIndex(DataModel dataModel) {
        int n = this.getKeyColumnIndex();
        if (n == -1) {
            n = this.getDataModelColumnIndex(dataModel, this.getKeyColumnName());
        }
        return n;
    }

    public int getValueColumnIndex(DataModel dataModel) {
        int n = this.getValueColumnIndex();
        if (n == -1) {
            n = this.getDataModelColumnIndex(dataModel, this.getValueColumnName());
        }
        return n;
    }

    public void analyzeCorrelative(CalculatorProvider calculatorProvider, ExTool exTool, ColumnRow columnRow) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        FormulaDisplayDictionary formulaDisplayDictionary = this;
        synchronized (formulaDisplayDictionary) {
            this.kvs = null;
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && "FormulaDictAttr".equals(string = xMLableReader.getTagName())) {
            this.setKeyColumnIndex(xMLableReader.getAttrAsInt("ki", -1));
            this.setValueColumnIndex(xMLableReader.getAttrAsInt("vi", -1));
            this.setKeyColumnName(xMLableReader.getAttrAsString("kiName", ""));
            this.setValueColumnName(xMLableReader.getAttrAsString("viName", ""));
            String string2 = xMLableReader.getAttrAsString("formula", null);
            if (string2 != null) {
                FormulaProvider formulaProvider = (FormulaProvider)((Object)StableFactory.createXmlObject("Formula"));
                formulaProvider.setContent(string2);
                this.setFormula(formulaProvider);
            }
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode() && "Condition".equals(xMLableReader.getTagName())) {
                        FormulaDisplayDictionary.this.condition = DataCoreXmlUtils.readCondition(xMLableReader);
                    }
                }
            });
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n = this.getKeyColumnIndex();
        String string = this.getKeyColumnName();
        int n2 = this.getValueColumnIndex();
        String string2 = this.getValueColumnName();
        if (StringUtils.isNotEmpty(string)) {
            xMLPrintWriter.startTAG("FormulaDictAttr").attr("kiName", string);
        } else {
            xMLPrintWriter.startTAG("FormulaDictAttr").attr("ki", n);
        }
        if (this.formula != null) {
            xMLPrintWriter.attr("formula", this.getFormula().getContent());
        } else if (StringUtils.isNotEmpty(string2)) {
            xMLPrintWriter.attr("viName", string2);
        } else {
            xMLPrintWriter.attr("vi", n2);
        }
        if (this.condition != null) {
            DataCoreXmlUtils.writeXMLCondition(xMLPrintWriter, this.condition);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FormulaDisplayDictionary)) {
            return false;
        }
        return this.getKeyColumnIndex() == ((FormulaDisplayDictionary)object).getKeyColumnIndex() && this.getValueColumnIndex() == ((FormulaDisplayDictionary)object).getValueColumnIndex() && ComparatorUtils.equals(this.formula, ((FormulaDisplayDictionary)object).getFormula()) && this.keyColumnIndex == ((FormulaDisplayDictionary)object).keyColumnIndex && this.valueColumnIndex == ((FormulaDisplayDictionary)object).valueColumnIndex && this.keyColumnName == ((FormulaDisplayDictionary)object).keyColumnName && this.valueColumnName == ((FormulaDisplayDictionary)object).valueColumnName && ComparatorUtils.equals(this.condition, ((FormulaDisplayDictionary)object).condition);
    }

    public String toString() {
        if (this.formula == null) {
            return "";
        }
        return "formula:" + this.formula.getContent();
    }

    public Object clone() throws CloneNotSupportedException {
        FormulaDisplayDictionary formulaDisplayDictionary = (FormulaDisplayDictionary)super.clone();
        if (this.condition != null) {
            formulaDisplayDictionary.condition = (Condition)this.condition.clone();
        }
        return formulaDisplayDictionary;
    }

    private class EntryIterator
    implements Iterator {
        private int next = 0;

        private EntryIterator() {
        }

        public boolean hasNext() {
            return this.next < FormulaDisplayDictionary.this.kvs.size();
        }

        public Object next() {
            Object e = FormulaDisplayDictionary.this.kvs.get(this.next);
            ++this.next;
            return e;
        }

        public void remove() {
        }
    }
}

