/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.cache.list.IntList;
import com.fr.data.impl.Node;
import com.fr.data.impl.Tree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class Forest {
    private ArrayList trees = new ArrayList();
    private int newAddTreeCount = 0;
    private Map nodeMap = new HashMap();
    private Object[] bufferedRow;

    Forest() {
    }

    void mergeTrees() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.trees);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            boolean bl = this.mergeTree((Tree)arrayList.get(i));
            if (!bl) continue;
            this.trees.remove(arrayList.get(i));
            this.removeSame(((Tree)arrayList.get(i)).getRoot());
        }
    }

    private void removeSame(Node node) {
        List list = this.getNodeList(node);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (list.get(i) != node) continue;
            list.remove(i);
            return;
        }
    }

    public void addNewTree(Tree tree) {
        this.trees.add(tree);
        this.putTreeNode(tree);
        ++this.newAddTreeCount;
        if (this.newAddTreeCount > Integer.MAX_VALUE) {
            this.mergeTrees();
            this.newAddTreeCount = 0;
        }
    }

    private void putTreeNode(Tree tree) {
        Node node = tree.getRoot();
        this.putTreeNode(node);
    }

    private void putTreeNode(Node node) {
        this.putNode(node);
        int n = node.getChildSize();
        for (int i = 0; i < n; ++i) {
            this.putTreeNode(node.getChild(i));
        }
    }

    private boolean mergeTree(Tree tree) {
        Node node = tree.getRoot();
        Node node2 = this.findMountNode(tree);
        if (node2 != Node.NULL) {
            node2.addGivedChildren(node);
            return true;
        }
        return false;
    }

    public void addNodePair(Node node, Node node2) {
        boolean bl = this.addToExist(node, node2);
        if (bl) {
            return;
        }
        this.addNewTree(node, node2);
    }

    private void addNewTree(Node node, Node node2) {
        if (Node.isNULL(node2)) {
            return;
        }
        if (Node.isNULL(node)) {
            this.addNewTree(node2);
            return;
        }
        Tree tree = new Tree(node);
        tree.addNode(node, node2);
        this.addNewTree(tree);
    }

    private void putNode(Node node) {
        ArrayList<Node> arrayList = (ArrayList<Node>)this.nodeMap.get(node.getId());
        if (arrayList == null) {
            arrayList = new ArrayList<Node>(1);
            arrayList.add(node);
            this.nodeMap.put(node.getId(), arrayList);
        } else {
            arrayList.add(node);
        }
    }

    private boolean addToExist(Node node, Node node2) {
        if (Node.isNULL(node)) {
            return false;
        }
        Node node3 = this.getNode(node);
        if (Node.isNULL(node3)) {
            return false;
        }
        node3.addChild(node2);
        this.putNode(node2);
        return true;
    }

    private void addNewTree(Node node) {
        if (Node.isNULL(node)) {
            return;
        }
        Tree tree = new Tree(node);
        this.addNewTree(tree);
    }

    public int getTreeSize() {
        return this.trees.size();
    }

    int getNodeSize() {
        int n = 0;
        int n2 = this.getTreeSize();
        for (int i = 0; i < n2; ++i) {
            n += this.getTree(i).getSize();
        }
        return n;
    }

    int getDeep() {
        int n = 0;
        int n2 = this.getTreeSize();
        for (int i = 0; i < n2; ++i) {
            n = Math.max(n, this.getTree(i).getDeep());
        }
        return n;
    }

    Object[][] toTableArray() {
        return this.toTableArray(this.getNodeSize());
    }

    Object[][] toTableArray(int n) {
        int n2 = this.getDeep();
        Object[][] objectArray = new Object[n][n2];
        this.bufferedRow = new Object[n2];
        int n3 = this.getTreeSize();
        for (int i = 0; i < n3; ++i) {
            this.putTreeToData(objectArray, this.getTree(i).getRoot());
        }
        objectArray = this.deleteEmptyCols(n, n2, objectArray);
        return objectArray;
    }

    private Object[][] deleteEmptyCols(int n, int n2, Object[][] objectArray) {
        IntList intList = this.findEmptyCols(n, n2, objectArray);
        int n3 = intList.size();
        if (n3 == 0) {
            return objectArray;
        }
        int n4 = n2 - n3;
        Object[][] objectArray2 = new Object[n][n4];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n4; ++j) {
                objectArray2[i][j] = objectArray[i][j];
            }
        }
        return objectArray2;
    }

    private IntList findEmptyCols(int n, int n2, Object[][] objectArray) {
        IntList intList = new IntList();
        for (int i = 0; i < n2; ++i) {
            boolean bl = true;
            for (int j = 0; j < n; ++j) {
                bl = bl && objectArray[j][i] == null;
            }
            if (!bl) continue;
            intList.add(i);
        }
        return intList;
    }

    String[] createQNodeIdArray(int n) {
        String[] stringArray = new String[n];
        int n2 = this.getTreeSize();
        for (int i = 0; i < n2; ++i) {
            String string;
            Node node = this.getTree(i).getRoot();
            if (!node.hasIdentifyRow()) continue;
            stringArray[node.getRow()] = string = i + 1 + "";
            this.putQNodeIdTree(stringArray, node, string);
        }
        return stringArray;
    }

    Node[] getNodeArrayOrderByRow(int n) {
        Node[] nodeArray = new Node[n];
        int n2 = this.getTreeSize();
        for (int i = 0; i < n2; ++i) {
            Node node = this.getTree(i).getRoot();
            this.putNodeToArr(nodeArray, node);
        }
        return nodeArray;
    }

    private void putNodeToArr(Node[] nodeArray, Node node) {
        if (node.hasIdentifyRow()) {
            nodeArray[node.getRow()] = node;
        }
        int n = node.getChildSize();
        for (int i = 0; i < n; ++i) {
            this.putNodeToArr(nodeArray, node.getChild(i));
        }
    }

    private void putQNodeIdTree(String[] stringArray, Node node, String string) {
        int n = node.getChildSize();
        for (int i = 0; i < n; ++i) {
            String string2 = string + "-" + (i + 1);
            Node node2 = node.getChild(i);
            if (!node2.hasIdentifyRow()) continue;
            stringArray[node2.getRow()] = string2;
            this.putQNodeIdTree(stringArray, node.getChild(i), string2);
        }
    }

    private void putTreeToData(Object[][] objectArray, Node node) {
        this.putNodeToData(objectArray, node);
        int n = node.getChildSize();
        for (int i = 0; i < n; ++i) {
            this.putTreeToData(objectArray, node.getChild(i));
        }
    }

    private void putNodeToData(Object[][] objectArray, Node node) {
        this.putNodePathToBufferedRow(node);
        int n = node.getRow();
        if (n < 0) {
            return;
        }
        this.filledByBufferedRow(objectArray[n]);
    }

    private void filledByBufferedRow(Object[] objectArray) {
        int n = this.getLastNotNullIndex(this.bufferedRow);
        for (int i = 0; i < n + 1; ++i) {
            objectArray[i] = this.bufferedRow[n - i];
        }
    }

    private int getLastNotNullIndex(Object[] objectArray) {
        for (int i = objectArray.length - 1; i >= 0; --i) {
            if (objectArray[i] == null) continue;
            return i;
        }
        return 0;
    }

    private void putNodePathToBufferedRow(Node node) {
        this.reSetBufferedRow();
        int n = 0;
        for (Node node2 = node; node2 != null; node2 = node2.getParent()) {
            if (!node2.hasIdentifyRow()) {
                return;
            }
            this.bufferedRow[n++] = node2.getId();
        }
    }

    private void reSetBufferedRow() {
        for (int i = 0; i < this.bufferedRow.length; ++i) {
            this.bufferedRow[i] = null;
        }
    }

    public boolean contains(Node node) {
        return this.find(node) != Node.NULL;
    }

    Node find(Node node) {
        return this.find(node, true);
    }

    private Node findMountNode(Tree tree) {
        List list = this.getNodeList(tree.getRoot());
        if (list == null || list.size() < 1) {
            return Node.NULL;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (tree.containsSame((Node)list.get(i))) continue;
            return (Node)list.get(i);
        }
        return Node.NULL;
    }

    private Node findMountNod_bak(Tree tree) {
        int n = this.getTreeSize();
        for (int i = 0; i < n; ++i) {
            Node node;
            if (tree == this.getTree(i) || (node = this.getTree(i).find(tree.getRoot())) == Node.NULL) continue;
            return node;
        }
        return Node.NULL;
    }

    private Node find(Node node, boolean bl) {
        int n = this.getTreeSize();
        for (int i = 0; i < n; ++i) {
            Node node2 = this.getTree(i).find(node);
            if (!bl && node2 == node || node2 == Node.NULL) continue;
            return node2;
        }
        return Node.NULL;
    }

    private Node getNode(Node node) {
        List list = this.getNodeList(node);
        if (list != null && !list.isEmpty()) {
            return (Node)list.get(0);
        }
        return Node.NULL;
    }

    private List getNodeList(Node node) {
        return (List)this.nodeMap.get(node.getId());
    }

    private Tree getTree(int n) {
        return (Tree)this.trees.get(n);
    }
}

