/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.ExcelUtils;
import com.fr.base.Parameter;
import com.fr.data.ExcelDataModelProcessor;
import com.fr.data.impl.DirectoryConnectionContainer;
import com.fr.data.impl.ExcelDataModel;
import com.fr.data.impl.FileTableData;
import com.fr.data.impl.excelplus.ExcelDataModelPlus;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralContext;
import com.fr.general.data.DataModel;
import com.fr.script.Calculator;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.plugin.ExtraClassManagerProvider;
import com.fr.stable.xml.StableXMLUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;

public class ExcelTableData
extends FileTableData
implements XMLable,
DirectoryConnectionContainer {
    private String filePath = null;
    private Parameter[] params;
    private boolean needColumnName;
    private boolean isFromEnv = true;

    public Parameter[] getParams() {
        return this.params;
    }

    public void setParams(Parameter[] parameterArray) {
        this.params = parameterArray;
    }

    public Parameter[] getParameters(Calculator calculator) {
        return this.params == null ? new Parameter[]{} : this.params;
    }

    public DataModel createDataModel(Calculator calculator) {
        String string;
        Parameter[] parameterArray = Parameter.providers2Parameter(Calculator.processParameters(calculator, this.params));
        Parameter[] parameterArray2 = this.params = parameterArray.length == 0 ? this.params : parameterArray;
        if (ExcelUtils.checkThirdJarSupportPOI()) {
            if (this.filePath.indexOf("http") != -1 || !this.isFromEnv) {
                return new ExcelDataModelPlus(this.filePath, this.needColumnName, this.params);
            }
            String string2 = StringUtils.isBlank(this.filePath) ? "" : StableUtils.pathJoin(GeneralContext.getEnvProvider().getPath(), this.filePath);
            return new ExcelDataModelPlus(string2, this.needColumnName, this.params);
        }
        ExtraClassManagerProvider extraClassManagerProvider = StableFactory.getMarkedObject("ExtraClassManager", ExtraClassManagerProvider.class);
        ExcelDataModelProcessor excelDataModelProcessor = (ExcelDataModelProcessor)extraClassManagerProvider.getSingle("ExcelDataModelProcessor");
        if (this.filePath.indexOf("http") != -1 || !this.isFromEnv) {
            if (excelDataModelProcessor != null) {
                return excelDataModelProcessor.getExcelDataModel(this.filePath, this.needColumnName, this.params);
            }
            return new ExcelDataModel(this.filePath, this.needColumnName, this.params);
        }
        String string3 = string = StringUtils.isBlank(this.filePath) ? "" : StableUtils.pathJoin(GeneralContext.getEnvProvider().getPath(), this.filePath);
        if (excelDataModelProcessor != null) {
            return excelDataModelProcessor.getExcelDataModel(string, this.needColumnName, this.params);
        }
        return new ExcelDataModel(string, this.needColumnName, this.params);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String string) {
        this.filePath = string;
    }

    public boolean needColumnName() {
        return this.needColumnName;
    }

    public void setNeedColumnName(boolean bl) {
        this.needColumnName = bl;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("ExcelTableDataAttr".equals(string)) {
                String string2 = xMLableReader.getAttrAsString("filePath", null);
                if (string2 != null) {
                    this.filePath = string2;
                }
                if ((string2 = xMLableReader.getAttrAsString("needColumnName", null)) != null) {
                    this.needColumnName = ComparatorUtils.equals(string2, "true");
                }
                if ((string2 = xMLableReader.getAttrAsString("isFromEnv", null)) != null) {
                    this.isFromEnv = ComparatorUtils.equals(string2, "true");
                }
            } else if ("Parameters".equals(string)) {
                final ArrayList arrayList = new ArrayList();
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if ("Parameter".equals(xMLableReader.getTagName())) {
                            arrayList.add(StableXMLUtils.readParameter(xMLableReader));
                        }
                    }
                });
                if (!arrayList.isEmpty()) {
                    this.params = new Parameter[arrayList.size()];
                    arrayList.toArray(this.params);
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("ExcelTableDataAttr").attr("needColumnName", this.needColumnName()).attr("isFromEnv", this.isFromEnv).attr("filePath", this.getFilePath()).end();
        StableXMLUtils.writeParameters(xMLPrintWriter, this.params);
    }

    public boolean equals(Object object) {
        return object instanceof ExcelTableData && super.equals(object) && this.needColumnName == ((ExcelTableData)object).needColumnName && this.isFromEnv == ((ExcelTableData)object).isFromEnv && ComparatorUtils.equals(this.filePath, ((ExcelTableData)object).filePath);
    }

    public void setFromEnv(boolean bl) {
        this.isFromEnv = bl;
    }
}

