/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.cache.list.IntList;
import com.fr.data.AbstractDataModel;
import com.fr.general.data.Condition;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;

public class DecoratedDataModel
extends AbstractDataModel
implements DataModel {
    public static final String NAME_OF_SOURCE_TABLEDATA = "NAME_OF_SOURCE_TABLEDATA";
    private SOURCE_KNOWABLE_DATA_MODEL[] sourceDataModels;
    private int[][] rowIndicesSurvived;
    private Condition condition;
    private Calculator calculatorContext;

    public DecoratedDataModel(DataModel[] dataModelArray, String[] stringArray, Condition condition, Calculator calculator) {
        this.sourceDataModels = new SOURCE_KNOWABLE_DATA_MODEL[dataModelArray.length];
        for (int i = 0; i < this.sourceDataModels.length; ++i) {
            this.sourceDataModels[i] = new SOURCE_KNOWABLE_DATA_MODEL(dataModelArray[i], stringArray[i]);
        }
        this.condition = condition;
        this.calculatorContext = calculator;
        this.rowIndicesSurvived = new int[this.sourceDataModels.length][];
    }

    public int getColumnCount() throws TableDataException {
        if (this.sourceDataModels.length > 0) {
            return this.sourceDataModels[0].getColumnCount();
        }
        return 0;
    }

    public String getColumnName(int n) throws TableDataException {
        return this.sourceDataModels[0].getColumnName(n);
    }

    private void beSureSurvivedRowIndicesCalculatedByModelIndex(int n) throws TableDataException {
        if (this.rowIndicesSurvived[n] == null) {
            this.rowIndicesSurvived[n] = this.sourceDataModels[n].survivedRowIndices();
        }
    }

    public boolean hasRow(int n) throws TableDataException {
        int n2 = 0;
        while (n2 < this.rowIndicesSurvived.length) {
            this.beSureSurvivedRowIndicesCalculatedByModelIndex(n2);
            if (this.rowIndicesSurvived[n2].length > n) continue;
            n -= this.rowIndicesSurvived[n2].length;
            ++n2;
        }
        return n2 < this.sourceDataModels.length;
    }

    public int getRowCount() throws TableDataException {
        int n = 0;
        for (int i = 0; i < this.rowIndicesSurvived.length; ++i) {
            this.beSureSurvivedRowIndicesCalculatedByModelIndex(i);
            n += this.rowIndicesSurvived[i].length;
        }
        return n;
    }

    public Object getValueAt(int n, int n2) throws TableDataException {
        int n3;
        for (n3 = 0; n3 < this.rowIndicesSurvived.length; ++n3) {
            this.beSureSurvivedRowIndicesCalculatedByModelIndex(n3);
            if (this.rowIndicesSurvived[n3].length > n) break;
            n -= this.rowIndicesSurvived[n3].length;
        }
        if (n3 < this.sourceDataModels.length) {
            return this.sourceDataModels[n3].getValueAt(this.rowIndicesSurvived[n3][n], n2);
        }
        return null;
    }

    public void release() throws Exception {
        int n = ArrayUtils.getLength(this.sourceDataModels);
        for (int i = 0; i < n; ++i) {
            this.sourceDataModels[i].release();
        }
    }

    private class SOURCE_KNOWABLE_DATA_MODEL
    extends AbstractDataModel
    implements DataModel {
        private String sourceName;
        private DataModel original;

        public SOURCE_KNOWABLE_DATA_MODEL(DataModel dataModel, String string) {
            this.original = dataModel;
            this.sourceName = string;
        }

        private int[] survivedRowIndices() throws TableDataException {
            if (DecoratedDataModel.this.condition == null) {
                return IntList.range(this.getRowCount());
            }
            return DecoratedDataModel.this.condition.evalTableData(this, null, 0, DecoratedDataModel.this.calculatorContext);
        }

        public int getColumnCount() throws TableDataException {
            return 1 + this.original.getColumnCount();
        }

        public String getColumnName(int n) throws TableDataException {
            if (n == 0) {
                return DecoratedDataModel.NAME_OF_SOURCE_TABLEDATA;
            }
            return this.original.getColumnName(n - 1);
        }

        public boolean hasRow(int n) throws TableDataException {
            return this.original.hasRow(n);
        }

        public int getRowCount() throws TableDataException {
            return this.original.getRowCount();
        }

        public Object getValueAt(int n, int n2) throws TableDataException {
            if (n2 == 0) {
                return this.sourceName;
            }
            return this.original.getValueAt(n, n2 - 1);
        }

        public void release() throws Exception {
            this.original.release();
        }
    }
}

