/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.data.AbstractDataModel;
import com.fr.data.core.DataCoreUtils;
import com.fr.data.core.db.ColumnInformation;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dialect.MySQLDialect;
import com.fr.data.core.db.dialect.OracleDialect;
import com.fr.data.core.db.handler.SQLTypeHandler;
import com.fr.data.impl.Connection;
import com.fr.data.impl.GroupColumnMap;
import com.fr.data.impl.GroupList;
import com.fr.data.impl.Grouper;
import com.fr.data.impl.IterateResultSetListener;
import com.fr.data.impl.SharedDBDataModel;
import com.fr.general.DateUtils;
import com.fr.general.FRLogManager;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.general.data.TableDataException;
import com.fr.performance.PerformanceManager;
import com.fr.stable.StringUtils;
import com.fr.stable.monitor.MemoryHelper;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDBDataModel
extends AbstractDataModel {
    protected Set registedDBTableData = new HashSet();
    protected Connection database;
    protected String sql;
    protected transient java.sql.Connection connection;
    protected transient Statement statement;
    protected transient ResultSet resultSet;
    private transient boolean isCheckRowOver = false;
    protected transient ColumnInformation[] columnInformations = null;
    protected transient Dialect dialect = null;
    private int timeoutSeconds = 0;
    protected transient int shortcutRowCount = -1;

    protected AbstractDBDataModel() {
        this(null, null);
    }

    protected AbstractDBDataModel(Connection connection, String string) {
        this.database = connection;
        this.sql = string;
        this.dealSQLCharset();
    }

    public void setTimeoutSeconds(int n) {
        if (n > 0) {
            this.timeoutSeconds = n;
        }
    }

    private void dealSQLCharset() {
        if (StringUtils.isNotBlank(this.database.getOriginalCharsetName()) && StringUtils.isNotBlank(this.database.getNewCharsetName())) {
            try {
                this.sql = new String(this.sql.getBytes(this.database.getNewCharsetName()), this.database.getOriginalCharsetName());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FRLogger.getLogger().error(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(SharedDBDataModel sharedDBDataModel) {
        AbstractDBDataModel abstractDBDataModel = this;
        synchronized (abstractDBDataModel) {
            this.registedDBTableData.add(sharedDBDataModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unRegister(SharedDBDataModel sharedDBDataModel) {
        AbstractDBDataModel abstractDBDataModel = this;
        synchronized (abstractDBDataModel) {
            this.registedDBTableData.remove(sharedDBDataModel);
        }
    }

    public int getColumnCount() throws TableDataException {
        if (this.columnInformations == null) {
            this.initConnectionAndResultAndCheckInColumns();
        }
        return this.columnInformations.length;
    }

    public String getColumnName(int n) throws TableDataException {
        if (this.columnInformations == null) {
            this.initConnectionAndResultAndCheckInColumns();
        }
        return this.columnInformations[n].getColumnName();
    }

    protected void iterateResultSet(IterateResultSetListener iterateResultSetListener) throws Exception {
        iterateResultSetListener.init();
        this.initConnectionAndResultAndCheckInColumns();
        this.dialect = this.dialect == null ? DialectFactory.generateDialect(this.connection) : this.dialect;
        int n = this.getColumnCount();
        String string = this.database.getOriginalCharsetName();
        String string2 = this.database.getNewCharsetName();
        int[] nArray = new int[n];
        SQLTypeHandler[] sQLTypeHandlerArray = new SQLTypeHandler[n];
        this.initColumnType(n, sQLTypeHandlerArray, nArray);
        boolean bl = string != null && string.length() > 0;
        int n2 = 0;
        while (this.resultSet.next()) {
            ++n2;
            if (iterateResultSetListener.beforeGetValuesByRowIndex(n)) {
                this.iteratorColumn(n, n2, nArray, sQLTypeHandlerArray, string, string2, bl, iterateResultSetListener);
                if (iterateResultSetListener.checkLastAndBreak()) break;
                if (iterateResultSetListener.afterGetValuesByRowIndex()) {
                    return;
                }
            }
            if ((n2 & 0xFF) != 0) continue;
            MemoryHelper.getMemoryAlarmProcessor().interruptIfConditionMet("DataModel" + n2);
            MemoryHelper.getMemoryAlarmProcessor().doDSLimitCheck(n2);
            PerformanceManager.getRuntimeMonitor().addMemoryAndCheck(255 * n * 65);
        }
        iterateResultSetListener.afterIterator();
        this.setCheckRowOverState(true);
        this.releaseConnection();
        FRLogManager.declareSQLEnd(this.getSQLInfo());
    }

    private void initColumnType(int n, SQLTypeHandler[] sQLTypeHandlerArray, int[] nArray) {
        for (int i = 0; i < n; ++i) {
            int n2;
            nArray[i] = n2 = this.columnInformations[i].getColumnType();
            sQLTypeHandlerArray[i] = this.dialect.buildSQLTypeHandlerFactory().getTypeHandler(new Integer(n2));
        }
    }

    private void iteratorColumn(int n, int n2, int[] nArray, SQLTypeHandler[] sQLTypeHandlerArray, String string, String string2, boolean bl, IterateResultSetListener iterateResultSetListener) throws TableDataException, Exception {
        for (int i = 0; i < n; ++i) {
            try {
                iterateResultSetListener.afterGetValueByColumnRowIndex(this.getResultObject(i + 1, n2, nArray[i], sQLTypeHandlerArray[i], this.dialect, string, string2, bl), i);
                continue;
            }
            catch (SQLException sQLException) {
                iterateResultSetListener.exceptionOnGetValueByColumnRowIndex(i);
            }
        }
    }

    private String getSQLInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append("[").append(" sql : ").append(this.sql).append(" ;").append(" rowcount : ").append(this.getRowCount()).append(" ;").append(" time : ").append(DateUtils.DATETIMEFORMAT2.format(new Date())).append(" ;").append("]");
        }
        catch (TableDataException tableDataException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    private Object getResultObject(int n, int n2, int n3, SQLTypeHandler sQLTypeHandler, Dialect dialect, String string, String string2, boolean bl) throws Exception {
        return DataCoreUtils.getResultSetObject(this.resultSet, n3, n, string, string2, dialect, sQLTypeHandler, bl);
    }

    private boolean delayLoadData(int n, Dialect dialect) {
        return n == 2004 && dialect instanceof OracleDialect || n == -4 && dialect instanceof MySQLDialect;
    }

    public Object[] iterateResultSet4Group(int[] nArray, int n, Grouper[] grouperArray) throws Exception {
        boolean bl;
        this.initConnectionAndResultAndCheckInColumns();
        Dialect dialect = DialectFactory.generateDialect(this.connection);
        int n2 = nArray.length;
        String string = this.database.getOriginalCharsetName();
        String string2 = this.database.getNewCharsetName();
        Object[] objectArray = new Object[n2];
        Object[] objectArray2 = new Object[n2];
        SQLTypeHandler[] sQLTypeHandlerArray = new SQLTypeHandler[n2];
        int[] nArray2 = new int[n2];
        this.getColumnTypeAndHandler(sQLTypeHandlerArray, nArray2, nArray, objectArray, n2);
        int n3 = 0;
        boolean bl2 = bl = string != null && string.length() > 0;
        while (this.resultSet.next()) {
            ++n3;
            String string3 = "";
            for (int i = 0; i < n2; ++i) {
                Object object = null;
                try {
                    object = DataCoreUtils.getResultSetObject(this.resultSet, nArray2[i], nArray[i] + 1, string, string2, dialect, sQLTypeHandlerArray[i], bl);
                }
                catch (SQLException sQLException) {
                    for (int j = 0; j < nArray.length; ++j) {
                        if (nArray[i] != nArray[j]) continue;
                        object = objectArray2[j];
                        break;
                    }
                }
                objectArray2[i] = object;
                AbstractDBDataModel.dealGroupMode(n3, i, objectArray, object, string3, grouperArray[i]);
                if (n != -1 && i > n) continue;
                string3 = string3 + object;
            }
        }
        this.setCheckRowOverState(true);
        this.releaseConnection();
        this.calculateAfterGet(n, n2, objectArray, grouperArray);
        FRLogManager.declareSQLEnd(this.getSQLInfo());
        return objectArray;
    }

    private void getColumnTypeAndHandler(SQLTypeHandler[] sQLTypeHandlerArray, int[] nArray, int[] nArray2, Object[] objectArray, int n) {
        for (int i = 0; i < n; ++i) {
            int n2;
            objectArray[i] = new GroupColumnMap();
            nArray[i] = n2 = this.columnInformations[nArray2[i]].getColumnType();
            sQLTypeHandlerArray[i] = this.dialect.buildSQLTypeHandlerFactory().getTypeHandler(new Integer(n2));
        }
    }

    private void calculateAfterGet(int n, int n2, Object[] objectArray, Grouper[] grouperArray) {
        for (int i = n = n == -1 ? 0 : n; i < n2; ++i) {
            GroupColumnMap groupColumnMap = (GroupColumnMap)objectArray[i];
            Grouper grouper = grouperArray[i];
            Iterator iterator = groupColumnMap.getIterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                GroupList groupList = (GroupList)entry.getValue();
                grouper.cal_after_traverse_result(groupList);
            }
        }
    }

    private static void dealGroupMode(int n, int n2, Object[] objectArray, Object object, Object object2, Grouper grouper) {
        GroupList groupList;
        GroupColumnMap groupColumnMap = (GroupColumnMap)objectArray[n2];
        if (groupColumnMap == null) {
            groupColumnMap = new GroupColumnMap();
        }
        if ((groupList = groupColumnMap.get(object2)) == null) {
            groupList = new GroupList();
        }
        grouper.cal_when_traverse_result(groupList, object, n);
        groupColumnMap.put(object2, groupList);
    }

    protected abstract void initRowValueStatus();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initConnectionAndResultAndCheckInColumns() throws TableDataException {
        AbstractDBDataModel abstractDBDataModel = this;
        synchronized (abstractDBDataModel) {
            if (this.connection != null && this.columnInformations != null) {
                return;
            }
            try {
                if (this.database == null) {
                    throw new TableDataException(Inter.getLocText("Utils-Connection_can_not_be_null"));
                }
                this.connection = this.database.createConnection();
                if (this.connection == null) {
                    throw new TableDataException(Inter.getLocText("Utils-Can_not_create_connection") + ":" + this.database.toString());
                }
                String string = this.database.getOriginalCharsetName();
                String string2 = this.database.getNewCharsetName();
                if (DBUtils.isProcedure(this.sql)) {
                    if (this.dialect == null) {
                        this.dialect = DialectFactory.generateDialect(this.connection);
                    }
                    Object[] objectArray = this.dialect.remoteProcedureCall(this.connection, this.sql);
                    this.statement = (Statement)objectArray[0];
                    this.resultSet = (ResultSet)objectArray[1];
                    if (this.columnInformations == null) {
                        this.columnInformations = DBUtils.checkInColumnInformationByMetaData(this.resultSet.getMetaData(), string, string2);
                    }
                } else {
                    if (this.dialect == null) {
                        this.dialect = DialectFactory.generateDialect(this.connection);
                    }
                    this.statement = this.dialect.createStatement(this.connection, this.sql);
                    if (this.timeoutSeconds > 0) {
                        FRLogger.getLogger().info("setQueryTimeout:" + this.timeoutSeconds + "seconds");
                        this.statement.setQueryTimeout(this.timeoutSeconds);
                    }
                    this.resultSet = this.dialect.executeQuery(this.statement, this.sql, this.connection);
                    if (this.columnInformations == null) {
                        this.columnInformations = this.dialect.getColumnInformation(this.connection, this.resultSet, this.sql, string, string2);
                    }
                }
            }
            catch (Exception exception) {
                try {
                    this.releaseConnection();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw new TableDataException("Query:\n" + exception.getMessage(), exception);
            }
            this.initRowValueStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int shortcutGetRowCount() {
        if (this.shortcutRowCount == -1) {
            java.sql.Connection connection = null;
            try {
                connection = this.database.createConnection();
                if (this.dialect == null) {
                    this.dialect = DialectFactory.generateDialect(connection);
                }
                String string = this.dialect.getCountSql(this.sql);
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(string);
                resultSet.next();
                this.shortcutRowCount = resultSet.getInt(1);
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                this.shortcutRowCount = Integer.MIN_VALUE;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                    }
                }
            }
        }
        return this.shortcutRowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void tryDestroy() throws SQLException {
        AbstractDBDataModel abstractDBDataModel = this;
        synchronized (abstractDBDataModel) {
            if (this.registedDBTableData.isEmpty()) {
                this.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws SQLException {
        AbstractDBDataModel abstractDBDataModel = this;
        synchronized (abstractDBDataModel) {
            this.releaseConnection();
            this.setCheckRowOverState(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseConnection() throws SQLException {
        AbstractDBDataModel abstractDBDataModel = this;
        synchronized (abstractDBDataModel) {
            if (this.connection != null) {
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
                if (this.statement != null) {
                    this.statement.close();
                }
                this.connection.close();
                this.connection = null;
                this.statement = null;
                this.resultSet = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        AbstractDBDataModel abstractDBDataModel = this;
        synchronized (abstractDBDataModel) {
            super.finalize();
            this.release();
        }
    }

    public boolean isCheckRowOver() {
        return this.isCheckRowOver;
    }

    protected void setCheckRowOverState(boolean bl) {
        this.isCheckRowOver = bl;
    }
}

