/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.dao;

import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dialect.OracleDialect;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.ClassArrayKey;
import com.fr.data.dao.DAOException;
import com.fr.data.dao.DAOUtils;
import com.fr.data.dao.DataAccessObjectOperator;
import com.fr.data.dao.DataAccessObjectSession;
import com.fr.data.dao.DatabaseAction;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.JDBCDAOSession;
import com.fr.data.dao.MToOForeignFCMapper;
import com.fr.data.dao.ObjectMappingTable;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.dao.PrimaryKeyFCMapper;
import com.fr.data.impl.Connection;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.stable.ListMap;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class JDBCDataAccessObjectOperator
implements DataAccessObjectOperator {
    private Connection databaseConnection;
    private ListMap mapping;
    private ObjectMappingTable[] tableObjs;
    private int isOracleState = -5;
    private boolean isTransferState;
    private static Comparator STR_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return ComparatorUtils.compare(object, object2);
        }
    };

    public JDBCDataAccessObjectOperator(JDBCDatabaseConnection jDBCDatabaseConnection, ObjectTableMapper[] objectTableMapperArray) {
        this.databaseConnection = jDBCDatabaseConnection;
        this.mapping = new ListMap();
        for (int i = 0; i < objectTableMapperArray.length; ++i) {
            this.mapping.put(objectTableMapperArray[i].getObjectClass().getName(), objectTableMapperArray[i]);
        }
        this.initTableObject();
    }

    private void initTableObject() {
        if (this.tableObjs == null) {
            int n;
            ObjectTableMapper objectTableMapper;
            ArrayList<ObjectMappingTable> arrayList = new ArrayList<ObjectMappingTable>(this.mapping.size());
            HashMap<ClassArrayKey, ObjectTableMapper> hashMap = new HashMap<ClassArrayKey, ObjectTableMapper>();
            int n2 = this.mapping.size();
            for (int i = 0; i < n2; ++i) {
                objectTableMapper = (ObjectTableMapper)this.mapping.getByIndex(i);
                FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
                if (fieldColumnMapperArray == null) continue;
                for (n = 0; n < fieldColumnMapperArray.length; ++n) {
                    Serializable serializable;
                    ClassArrayKey classArrayKey;
                    Class[] classArray = fieldColumnMapperArray[n].getIndirectRelatedClass();
                    if (classArray == null || classArray.length <= 0 || hashMap.containsKey(classArrayKey = ClassArrayKey.getInstance(objectTableMapper.getObjectClass(), classArray))) continue;
                    boolean bl = true;
                    FieldColumnMapper[] fieldColumnMapperArray2 = new FieldColumnMapper[classArray.length + 2];
                    FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
                    if (fieldColumnMapper == null) {
                        bl = false;
                    } else {
                        String[] stringArray;
                        fieldColumnMapperArray2[0] = new PrimaryKeyFCMapper("id", -5, new ColumnSize(10));
                        fieldColumnMapperArray2[1] = new MToOForeignFCMapper(DAOUtils.getClassNameWithOutPath(objectTableMapper.getObjectClass()), fieldColumnMapper.getType(), DAOUtils.getClassNameWithOutPath(objectTableMapper.getObjectClass()) + "id", fieldColumnMapper.getColumnSize().cloneNew(), false, objectTableMapper.getObjectClass(), true);
                        serializable = new ArrayList(4);
                        serializable.add(DAOUtils.getClassNameWithOutPath(objectTableMapper.getObjectClass()));
                        for (int j = 0; j < classArray.length; ++j) {
                            stringArray = (String[])this.mapping.get(classArray[j].getName());
                            if (stringArray == null) {
                                bl = false;
                                break;
                            }
                            fieldColumnMapper = stringArray.getPrimaryKey();
                            if (fieldColumnMapper == null) {
                                bl = false;
                                break;
                            }
                            fieldColumnMapperArray2[j + 2] = new MToOForeignFCMapper(DAOUtils.getClassNameWithOutPath(classArray[j]), fieldColumnMapper.getType(), DAOUtils.getClassNameWithOutPath(classArray[j]) + "id", fieldColumnMapper.getColumnSize().cloneNew(), false, classArray[j], true);
                            serializable.add(DAOUtils.getClassNameWithOutPath(classArray[j]));
                        }
                        Collections.sort(serializable, STR_COMPARATOR);
                        StringBuffer stringBuffer = new StringBuffer("FR_T_");
                        int n3 = serializable.size();
                        for (int j = 0; j < n3; ++j) {
                            if (j == 0) {
                                stringBuffer.append(serializable.get(j));
                                continue;
                            }
                            stringBuffer.append("_");
                            stringBuffer.append(serializable.get(j));
                        }
                        stringArray = new String[fieldColumnMapperArray2.length - 1];
                        for (n3 = 0; n3 < stringArray.length; ++n3) {
                            stringArray[n3] = fieldColumnMapperArray2[n3 + 1].getColumnName();
                        }
                        String[][] stringArray2 = new String[][]{stringArray};
                        ObjectTableMapper objectTableMapper2 = new ObjectTableMapper(new Table(stringBuffer.toString()), fieldColumnMapperArray2, stringArray2);
                        hashMap.put(classArrayKey, objectTableMapper2);
                    }
                    if (bl) continue;
                    serializable = new StringBuffer("The related Table with Class ");
                    ((StringBuffer)serializable).append(objectTableMapper.getObjectClass());
                    for (int j = 0; j < classArray.length; ++j) {
                        ((StringBuffer)serializable).append(", ");
                        ((StringBuffer)serializable).append(classArray[j]);
                    }
                    ((StringBuffer)serializable).append(" create failed!");
                    FRLogger.getLogger().error(((StringBuffer)serializable).toString());
                }
            }
            Set set = hashMap.entrySet();
            for (Map.Entry entry : set) {
                this.mapping.put(entry.getKey(), entry.getValue());
            }
            int n4 = this.mapping.size();
            for (n = 0; n < n4; ++n) {
                objectTableMapper = (ObjectTableMapper)this.mapping.getByIndex(n);
                if (!objectTableMapper.shouleCheckTable()) continue;
                arrayList.add(ObjectMappingTable.createObjectMappingTable(objectTableMapper, this.mapping));
            }
            this.tableObjs = arrayList.toArray(new ObjectMappingTable[arrayList.size()]);
        }
    }

    public void checkTables() throws Exception {
        java.sql.Connection connection = null;
        try {
            connection = this.databaseConnection.createConnection();
            connection.setAutoCommit(false);
            Dialect dialect = DialectFactory.generateDialect(connection);
            dialect.initTables(this, connection, this.tableObjs);
        }
        finally {
            DBUtils.closeConnection(connection);
        }
    }

    public void dropTables() throws Exception {
        java.sql.Connection connection = null;
        try {
            connection = this.databaseConnection.createConnection();
            connection.setAutoCommit(false);
            for (int i = this.tableObjs.length - 1; i >= 0; --i) {
                this.tableObjs[i].dropTable(connection);
            }
            connection.commit();
        }
        catch (Exception exception) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                }
            }
            throw exception;
        }
        finally {
            DBUtils.closeConnection(connection);
        }
    }

    public DataAccessObjectSession startSession() {
        return new JDBCDAOSession(this);
    }

    public DataAccessObjectSession startSession(DatabaseAction databaseAction) {
        return new JDBCDAOSession(this, databaseAction);
    }

    protected java.sql.Connection createConnection() throws Exception {
        return this.databaseConnection.createConnection();
    }

    protected ObjectTableMapper getObjectMapper(Class clazz) {
        return clazz == null ? null : (ObjectTableMapper)this.mapping.get(clazz.getName());
    }

    protected ObjectTableMapper getObjectMapper(ClassArrayKey classArrayKey) {
        return (ObjectTableMapper)this.mapping.get(classArrayKey);
    }

    protected void assertIsInMapping(Class clazz) throws DAOException {
        if (clazz == null || !this.mapping.containsKey(clazz.getName())) {
            throw new DAOException(clazz + " doesn't exists in mapping");
        }
    }

    protected void assertIsInMapping(ClassArrayKey classArrayKey) throws DAOException {
        if (!this.mapping.containsKey(classArrayKey)) {
            throw new DAOException(classArrayKey + " doesn't exists in mapping");
        }
    }

    protected synchronized boolean isOracleDatabaseConnection() {
        if (this.isOracleState < 0) {
            Object object;
            if (this.databaseConnection instanceof JDBCDatabaseConnection) {
                object = (JDBCDatabaseConnection)this.databaseConnection;
                String string = ((JDBCDatabaseConnection)object).getDriver();
                this.isOracleState = string != null && string.endsWith("OracleDriver") ? 1 : 0;
            }
            object = null;
            try {
                object = this.databaseConnection.createConnection();
                this.isOracleState = DialectFactory.generateDialect((java.sql.Connection)object) instanceof OracleDialect ? 1 : 0;
            }
            catch (Exception exception) {
                ++this.isOracleState;
            }
            finally {
                DBUtils.closeConnection((java.sql.Connection)object);
            }
        }
        return this.isOracleState == 1;
    }

    public boolean isTransferState() {
        return this.isTransferState;
    }

    public void setTransferState(boolean bl) {
        this.isTransferState = bl;
    }
}

