/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dml;

import com.fr.cache.list.IntList;
import com.fr.data.core.db.DBConstants;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.Fragment;
import com.fr.data.core.db.dml.Table;
import com.fr.general.GeneralUtils;
import com.fr.stable.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class Where
implements Fragment {
    private List<String> columnNameList = new ArrayList<String>();
    private IntList columnTypeList = new IntList();
    private IntList compareTypeList = new IntList();
    private List<Object> columnValueList = new ArrayList<Object>();
    private IntList relationTypeList = new IntList();
    private ArrayList<Integer> ignoreList = new ArrayList();

    public void addColumn(String string, Object object) {
        this.addColumn(string, 12, 0, object, 0);
    }

    public void addColumn(String string, int n, int n2, Object object) {
        this.addColumn(string, n, n2, object, 0);
    }

    public void addColumn(String string, int n, int n2, Object object, int n3) {
        if (string != null) {
            if (this.getColumnSize() > 0) {
                this.relationTypeList.add(n3);
            }
            this.columnNameList.add(string);
            this.columnTypeList.add(n);
            this.compareTypeList.add(n2);
            this.columnValueList.add(object);
        }
    }

    public int getColumnSize() {
        return this.columnNameList == null ? 0 : this.columnNameList.size();
    }

    public static boolean validate(Where where) {
        return where != null && where.getColumnSize() > 0;
    }

    public static boolean validateWithoutEmptyCondition(Where where) {
        if (!Where.validate(where)) {
            return false;
        }
        if (where.columnValueList.size() == 0) {
            return false;
        }
        for (Object object : where.columnValueList) {
            String string = GeneralUtils.objectToString(object);
            if (!StringUtils.isEmpty(string)) continue;
            return false;
        }
        return true;
    }

    public String toStatementSQLString(Dialect dialect) {
        if (dialect == null) {
            dialect = DialectFactory.getDefaultDialect();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.getColumnSize();
        if (n > 0) {
            stringBuilder.append(" WHERE ");
            for (int i = 0; i < n; ++i) {
                String[] stringArray;
                if (i != 0) {
                    int n2 = this.relationTypeList.get(i - 1);
                    stringBuilder.append(n2 == 0 ? " AND " : " OR ");
                }
                stringBuilder.append(dialect.column2SQL4WhereSQL(this.columnNameList.get(i), this.columnTypeList.get(i)));
                int n3 = this.compareTypeList.get(i);
                if (DBUtils.isNULL(this.columnValueList.get(i), dialect) && n3 == 0) {
                    this.ignoreList.add(i);
                    stringArray = new String[]{" is ", "null"};
                } else {
                    stringArray = Where.getOPAndValueString(n3, "?");
                }
                n3 = this.compareTypeList.get(i);
                stringBuilder.append(stringArray[0]);
                stringBuilder.append(stringArray[1]);
            }
        }
        return stringBuilder.toString();
    }

    public int applyColumnTypeValue(Dialect dialect, Connection connection, Table table, PreparedStatement preparedStatement, int n) throws SQLException {
        if (preparedStatement == null || n <= 0) {
            return n;
        }
        int n2 = this.columnNameList.size();
        for (int i = 0; i < n2; ++i) {
            if (this.ignoreList.contains(new Integer(i))) {
                --n;
                continue;
            }
            DBUtils.applyColumnTypeValue(dialect, connection, table, this.columnNameList.get(i), this.columnValueList.get(i), preparedStatement, n + i, this.columnTypeList.get(i), this.columnValueList.get(i));
        }
        return n + n2;
    }

    public String toNormalSQLString(Dialect dialect) {
        if (dialect == null) {
            dialect = DialectFactory.getDefaultDialect();
        }
        int n = this.columnNameList.size();
        StringBuilder stringBuilder = new StringBuilder();
        if (n > 0) {
            stringBuilder.append(" WHERE ");
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                String string;
                int n2 = this.columnTypeList.get(i);
                int n3 = DBUtils.getColumnFRType(n2);
                if (n3 == DBConstants.FR_STREAM || (string = GeneralUtils.objectToString(this.columnValueList.get(i))).contains("'") || string.contains("\"")) continue;
                if (bl) {
                    int n4 = this.relationTypeList.size() > i - 1 ? this.relationTypeList.get(i - 1) : 0;
                    stringBuilder.append(n4 == 0 ? " AND " : " OR ");
                }
                bl = true;
                int n5 = this.compareTypeList.get(i);
                String[] stringArray = Where.getOPAndValueString(n5, string);
                String string2 = stringArray[0];
                string = stringArray[1];
                stringBuilder.append(dialect.column2SQL(this.columnNameList.get(i)));
                stringBuilder.append(string2);
                this.appendValueString(stringBuilder, string, n3);
            }
        }
        return stringBuilder.toString();
    }

    private void appendValueString(StringBuilder stringBuilder, String string, int n) {
        if (n == DBConstants.FR_STRING) {
            stringBuilder.append('\'');
            stringBuilder.append(string);
            stringBuilder.append('\'');
        } else {
            stringBuilder.append(string);
        }
    }

    public void clearAllColumn() {
        this.columnNameList.clear();
        this.columnTypeList.clear();
        this.compareTypeList.clear();
        this.columnValueList.clear();
        this.relationTypeList.clear();
    }

    private static String[] getOPAndValueString(int n, String string) {
        String string2 = Where.getNewOp(n);
        string = Where.getNewValueString(n, string);
        return new String[]{string2, string};
    }

    private static String getNewValueString(int n, String string) {
        switch (n) {
            case 6: {
                return string + "%";
            }
            case 7: {
                return string + "%";
            }
            case 8: {
                return "%" + string;
            }
            case 9: {
                return "%" + string;
            }
            case 10: {
                return "%" + string + "%";
            }
            case 11: {
                return "%" + string + "%";
            }
        }
        return string;
    }

    private static String getNewOp(int n) {
        switch (n) {
            case 0: {
                return "=";
            }
            case 1: {
                return "!=";
            }
            case 2: {
                return ">";
            }
            case 3: {
                return ">=";
            }
            case 4: {
                return "<";
            }
            case 5: {
                return "<=";
            }
            case 6: {
                return " like ";
            }
            case 7: {
                return " not like ";
            }
            case 8: {
                return " like ";
            }
            case 9: {
                return " not like ";
            }
            case 10: {
                return " like ";
            }
            case 11: {
                return " not like ";
            }
        }
        return "=";
    }

    public String toString() {
        return this.toNormalSQLString(null);
    }
}

