/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dialect;

import com.fr.base.StoreProcedureParameter;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.AbstractDialect;
import com.fr.data.core.db.dialect.TypeUtils;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.field.FieldMessage;
import com.fr.data.impl.Connection;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.IOUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLDialect
extends AbstractDialect {
    private static Map yearDataMap = new HashMap();
    private static final int DEFAULT_HASH_VALUE = 37;
    private static final int LIMITED_STRING_LENGTH = 20;
    private static final String DEFAULT_INCREMENT_EM = "auto_increment";

    public MySQLDialect() {
        this.left_quote = "`";
        this.right_quote = "`";
    }

    @Override
    public int getFetchSize() {
        return Integer.MIN_VALUE;
    }

    @Override
    public String columnType2SQL(int n, String string) {
        switch (n) {
            case -2: {
                return "TINYBLOB";
            }
            case 2004: {
                return "MEDIUMBLOB";
            }
            case -4: {
                return "LONGBLOB";
            }
            case 2005: {
                return "longtext";
            }
            case 4: {
                return "int";
            }
            case -1: {
                return "longtext";
            }
            case 1: {
                return "varchar(" + string + ")";
            }
            case 12: {
                return "varchar(" + string + ")";
            }
            case -3: {
                return "varbinary(" + string + ")";
            }
            case 3: {
                return "decimal(" + string + ")";
            }
            case 2: {
                return "numeric(" + string + ")";
            }
            case 7: {
                return "FLOAT";
            }
            case -5: {
                return "BIGINT(" + string + ")";
            }
            case 5: {
                return "SMALLINT(" + string + ")";
            }
            case -7: {
                return "VARCHAR(1)";
            }
        }
        return TypeUtils.getTypeName(n);
    }

    @Override
    protected Object parseOtherValue(Object object, int n) {
        if (object instanceof String && n == -7) {
            object = Integer.parseInt((String)object) != 0;
        }
        return object;
    }

    @Override
    public String createSequence(java.sql.Connection connection, String string, String string2, String string3) {
        return new StringBuffer().append(string3).append(' ').append(DEFAULT_INCREMENT_EM).toString();
    }

    @Override
    public String getIdentitySelectString() {
        return "select last_insert_id()";
    }

    @Override
    public String getIdentitySelectString(String string, String string2, int n) throws Exception {
        return this.getIdentitySelectString();
    }

    @Override
    public String getLimitString(String string, int n, int n2) {
        return new StringBuffer(string.length() + 20).append(string).append(" limit " + n + ", " + n2).toString();
    }

    @Override
    public boolean isYearData(java.sql.Connection connection, int n, Table table, String string) {
        if (n != 91) {
            return false;
        }
        CTC cTC = new CTC(connection, table, string);
        if (yearDataMap.get(cTC) == null) {
            boolean bl = this.isYear(connection, table, string);
            yearDataMap.put(cTC, bl);
            return bl;
        }
        return (Boolean)yearDataMap.get(cTC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private boolean isYear(java.sql.Connection connection, Table table, String string) {
        block12: {
            PreparedStatement preparedStatement;
            block11: {
                String string2 = "select " + string + " from " + table.toString();
                preparedStatement = null;
                preparedStatement = connection.prepareStatement(string2);
                ResultSet resultSet = preparedStatement.executeQuery();
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                if (!resultSetMetaData.getColumnTypeName(1).equalsIgnoreCase("YEAR")) break block11;
                boolean bl = true;
                Object var10_11 = null;
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {
                    FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                }
                return bl;
            }
            Object var10_12 = null;
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
            }
            break block12;
            {
                catch (SQLException sQLException) {
                    FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException2) {
                        FRLogger.getLogger().error(sQLException2.getMessage(), sQLException2);
                    }
                    Object var10_13 = null;
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException3) {
                        FRLogger.getLogger().error(sQLException3.getMessage(), sQLException3);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {
                    FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                }
                throw throwable;
            }
        }
        return false;
    }

    @Override
    public String quartzDelegateClass() {
        return "com.fr.third.org.quartz.impl.jdbcjobstore.MSSQLDelegate";
    }

    @Override
    public String defaultValidationQuery(java.sql.Connection connection) {
        return "select 1";
    }

    @Override
    public boolean supportsCascadeDelete() {
        return false;
    }

    @Override
    public String buildForeignKeyString(String string, String[] stringArray, String string2, String[] stringArray2, boolean bl) {
        String string3 = StringUtils.join(", ", stringArray);
        return new StringBuffer(30).append(" add index ").append(string).append(" (").append(string3).append("), add constraint ").append(string).append(" foreign key (").append(string3).append(") references ").append(string2).append(" (").append(StringUtils.join(", ", stringArray2)).append(')').toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StoreProcedureParameter[] getStoreProcedureDeclarationParameters(java.sql.Connection connection, String string, String string2) {
        ArrayList arrayList = new ArrayList();
        String[] stringArray = string.split("\\.");
        String string3 = stringArray[stringArray.length - 1];
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                String string4 = connection.getMetaData().getURL();
                string4 = string4.substring(string4.lastIndexOf("/") == -1 ? 0 : string4.lastIndexOf("/") + 1, string4.length());
                string4 = this.getDBName(string4);
                String string5 = this.getProcedureParametersSql(string4 + "`" + string3);
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string5);
                this.addPara2ListFromResultset(arrayList, resultSet);
            }
            catch (SQLException sQLException) {
                FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                Object var12_13 = null;
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
                return arrayList.toArray(new StoreProcedureParameter[arrayList.size()]);
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(statement);
            throw throwable;
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(statement);
        return arrayList.toArray(new StoreProcedureParameter[arrayList.size()]);
    }

    private String getDBName(String string) {
        int n = string.indexOf("?");
        return n == -1 ? string : string.substring(0, n);
    }

    private void addPara2ListFromResultset(List list, ResultSet resultSet) {
        try {
            while (resultSet.next()) {
                Blob blob = resultSet.getBlob("param_list");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(blob.getBinaryStream()));
                List list2 = this.getParaFromBufferReader(bufferedReader);
                if (list2.isEmpty()) continue;
                String[] stringArray = new String[list2.size()];
                for (int i = 0; i < list2.size(); ++i) {
                    String string = (String)list2.get(i);
                    stringArray[i] = string.endsWith(",") ? string.substring(0, string.length() - 1) : string;
                }
                list.addAll(this.parameterToList(stringArray));
            }
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
        }
    }

    private List getParaFromBufferReader(BufferedReader bufferedReader) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                if (!StringUtils.isNotBlank(string)) continue;
                String[] stringArray = string.split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    if (StringUtils.isBlank(string2)) continue;
                    arrayList.add(string2);
                }
            }
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage(), iOException);
        }
        return arrayList;
    }

    @Override
    protected String getProcedureParametersSql(String string) {
        String[] stringArray = string.split("`");
        return "select param_list, body from mysql.proc where mysql.proc.name='" + stringArray[1] + "' and mysql.proc.db='" + stringArray[0] + "' and mysql.proc.type='PROCEDURE'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getStoreProcedureText(java.sql.Connection connection, String string, String string2) {
        ResultSet resultSet;
        Statement statement;
        block7: {
            String string3;
            statement = null;
            resultSet = null;
            try {
                try {
                    String string4 = connection.getMetaData().getURL();
                    string4 = string4.substring(string4.lastIndexOf("/") == -1 ? 0 : string4.lastIndexOf("/") + 1, string4.length());
                    string4 = this.getDBName(string4);
                    String[] stringArray = string.split("\\.");
                    String string5 = this.getProcedureSql(string4 + "`" + stringArray[stringArray.length - 1]);
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(string5);
                    StringBuffer stringBuffer = new StringBuffer();
                    if (!resultSet.next()) break block7;
                    Blob blob = resultSet.getBlob("body");
                    string3 = IOUtils.inputStream2String(blob.getBinaryStream(), string2);
                    Object var13_14 = null;
                }
                catch (SQLException sQLException) {
                    FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                    Object var13_16 = null;
                    DBUtils.closeResultSet(resultSet);
                    DBUtils.closeStatement(statement);
                    return "ERROR FETCHING...";
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    FRLogger.getLogger().error(unsupportedEncodingException.getMessage());
                    Object var13_17 = null;
                    DBUtils.closeResultSet(resultSet);
                    DBUtils.closeStatement(statement);
                    return "ERROR FETCHING...";
                }
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
                throw throwable;
            }
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(statement);
            return string3;
        }
        Object var13_15 = null;
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(statement);
        return "ERROR FETCHING...";
    }

    @Override
    protected String getProcedureSql(String string) {
        return this.getProcedureParametersSql(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getTableCommentName(java.sql.Connection connection, String string, String string2, String string3) {
        ResultSet resultSet;
        Statement statement;
        block6: {
            String string4;
            statement = null;
            resultSet = null;
            try {
                try {
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery("select table_comment from information_schema.tables  where table_schema = '" + connection.getCatalog() + "' and table_name ='" + string + "'");
                    if (!resultSet.next()) break block6;
                    string4 = resultSet.getString("table_comment");
                    Object var9_9 = null;
                }
                catch (SQLException sQLException) {
                    Object var9_11 = null;
                    DBUtils.closeResultSet(resultSet);
                    DBUtils.closeStatement(statement);
                    return "";
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
                throw throwable;
            }
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(statement);
            return string4;
        }
        Object var9_10 = null;
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(statement);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<FieldMessage> getTableFieldsMessage(java.sql.Connection connection, String string, String string2, String string3) {
        List<FieldMessage> list = super.getTableFieldsMessage(connection, string, string2, string3);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery("select COLUMN_NAME, COLUMN_COMMENTfrom information_schema.COLUMNS where TABLE_SCHEMA='" + connection.getCatalog() + "' and table_name ='" + string + "'");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                while (resultSet.next()) {
                    hashMap.put(resultSet.getString("COLUMN_NAME"), resultSet.getString("COLUMN_COMMENT"));
                }
                for (FieldMessage fieldMessage : list) {
                    String string4 = fieldMessage.getColumnName();
                    if (!hashMap.containsKey(string4)) continue;
                    fieldMessage.setColumnComment((String)hashMap.get(string4));
                }
                Object var13_13 = null;
            }
            catch (SQLException sQLException) {
                Object var13_14 = null;
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
                return list;
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(statement);
            throw throwable;
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(statement);
        return list;
    }

    @Override
    public ResultSet createLimitResultSet(Connection connection, java.sql.Connection connection2, Statement statement, String[] stringArray, String string, String string2, String string3, long l) throws SQLException {
        Table table = new Table(string, string2);
        String string4 = "select * from " + this.table2SQL(table) + " limit " + l + "," + Integer.MAX_VALUE;
        statement.setFetchSize(Integer.MIN_VALUE);
        return statement.executeQuery(this.processCharset(string4, connection));
    }

    @Override
    public Statement createLimitUseStatement(java.sql.Connection connection) throws SQLException {
        return connection.createStatement(1003, 1007);
    }

    @Override
    public String createLimitSQL(String string, String[] stringArray, long l) {
        if (string.indexOf("limit") != -1) {
            return "select * from (" + string + ") t limit " + l + "," + Integer.MAX_VALUE;
        }
        return string + " limit " + l + "," + Integer.MAX_VALUE;
    }

    @Override
    public String getSpecificRowSql(String string, int n) {
        return "select * from (" + string + ") as newTab limit " + (n - 1) + " , 1";
    }

    @Override
    public String getRowRangeSql(String string, int n, int n2, String[] stringArray) {
        String string2 = "select ";
        string2 = stringArray == null || stringArray.length == 0 ? string2 + "*" : string2 + StableUtils.join(stringArray, ",");
        string2 = string2 + " from (" + string + ") as newTab limit " + n + " , " + (n - n2);
        return string2;
    }

    @Override
    public String getTopNRowSql(int n, Table table) {
        return "select * from " + this.table2SQL(table) + " limit 0, " + n;
    }

    @Override
    public void setForeignKeyChecks(java.sql.Connection connection, int n) {
        String string = "SET FOREIGN_KEY_CHECKS = " + n + ";";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(sQLException.getMessage());
        }
    }

    @Override
    public boolean supportsUniqueViolationExceptionCheck() {
        return true;
    }

    @Override
    public boolean isUniqueViolationException(SQLException sQLException) {
        return sQLException != null && sQLException.getMessage() != null && sQLException.getMessage().indexOf("Duplicate entry") > -1;
    }

    private class CTC {
        private String url = null;
        private String user = null;
        private Table table = null;
        private String columnName = null;

        public CTC(java.sql.Connection connection, Table table, String string) {
            try {
                this.url = connection.getMetaData().getURL();
                this.user = connection.getMetaData().getUserName();
            }
            catch (SQLException sQLException) {
                FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
            }
            this.table = table;
            this.columnName = string;
        }

        public int hashCode() {
            int n = 0;
            n = 37 * n + this.url.hashCode();
            n = 37 * n + this.user.hashCode();
            n = 37 * n + this.table.hashCode();
            n = 37 * n + this.columnName.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CTC)) {
                return false;
            }
            CTC cTC = (CTC)object;
            return ComparatorUtils.equals(this.url, cTC.url) && ComparatorUtils.equals(this.user, cTC.user) && ComparatorUtils.equals(this.table, cTC.table) && ComparatorUtils.equals(this.columnName, cTC.columnName);
        }
    }
}

