/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dialect;

import com.fr.base.StoreProcedureParameter;
import com.fr.data.DataUtils;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.AbstractDialect;
import com.fr.data.core.db.dialect.TypeUtils;
import com.fr.general.FRLogger;
import java.io.BufferedReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class DB2Dialect
extends AbstractDialect {
    private static final int SELECT_OFFSET = 6;
    private static final int SQL_SIZE = 100;
    private int db2FetchSize = 50;
    private String defaultAutoIncrease = "GENERATED ALWAYS AS IDENTITY (START WITH 1,INCREMENT BY 1,MINVALUE 1,NO CACHE)";

    public DB2Dialect() {
        this.left_quote = "\"";
        this.right_quote = "\"";
    }

    public String columnType2SQL(int n, String string) {
        switch (n) {
            case -7: {
                return "varchar(1)";
            }
            case 4: {
                return "integer";
            }
            case 12: {
                return "varchar(" + string + ")";
            }
            case -3: {
                return "varbinary(" + string + ")";
            }
            case -6: {
                return "smallint";
            }
            case 3: {
                return "decimal(" + string + ")";
            }
            case 2: {
                return "numeric(" + string + ")";
            }
            case 1: {
                return "char(" + string + ")";
            }
            case -1: {
                return "long varchar";
            }
            case -4: {
                return "long varchar";
            }
            case 2004: {
                return "blob(" + string + ")";
            }
        }
        return TypeUtils.getTypeName(n);
    }

    public int getFetchSize() {
        return this.db2FetchSize;
    }

    public void setFetchSize(int n) {
        this.db2FetchSize = n;
    }

    public String createSequence(Connection connection, String string, String string2, String string3) {
        return new StringBuffer().append(string3).append(' ').append(this.defaultAutoIncrease).toString();
    }

    public String getIdentitySelectString() {
        return "values identity_val_local()";
    }

    public String getLimitString(String string, int n, int n2) {
        int n3 = string.toLowerCase().indexOf("select");
        StringBuffer stringBuffer = new StringBuffer(string.length() + 100).append(string.substring(0, n3)).append("select * from ( select ").append(this.getRowNumber(string));
        if (DB2Dialect.hasDistinct(string)) {
            stringBuffer.append(" row_.* from ( ").append(string.substring(n3)).append(" ) as row_");
        } else {
            stringBuffer.append(string.substring(n3 + 6));
        }
        stringBuffer.append(" ) as temp_ where rownumber_ ");
        stringBuffer.append("between " + (n + 1) + " and " + n2);
        return stringBuffer.toString();
    }

    private static boolean hasDistinct(String string) {
        return string.toLowerCase().indexOf("select distinct") >= 0;
    }

    private String getRowNumber(String string) {
        StringBuffer stringBuffer = new StringBuffer(50).append("rownumber() over(");
        int n = string.toLowerCase().indexOf("order by");
        if (n > 0 && !DB2Dialect.hasDistinct(string)) {
            stringBuffer.append(string.substring(n));
        }
        stringBuffer.append(") as rownumber_,");
        return stringBuffer.toString();
    }

    public String quartzDelegateClass() {
        return "";
    }

    protected Object clone() throws CloneNotSupportedException {
        return "SELECT 1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StoreProcedureParameter[] getStoreProcedureDeclarationParameters(Connection connection, String string, String string2) {
        ArrayList<StoreProcedureParameter> arrayList = new ArrayList<StoreProcedureParameter>();
        String[] stringArray = string.split("\\.");
        String string3 = stringArray[stringArray.length - 1];
        String string4 = "SELECT * FROM SYSCAT.PROCPARMS where PROCNAME='" + string3 + "'";
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string4);
                while (resultSet.next()) {
                    String string5 = resultSet.getString("PARMNAME");
                    String string6 = resultSet.getString("TYPENAME");
                    String string7 = resultSet.getString("PARM_MODE");
                    StoreProcedureParameter storeProcedureParameter = new StoreProcedureParameter(string5, string2, this.sql2ParameterType(string7), this.sql2ColumnTypeForProcedure(string6));
                    arrayList.add(storeProcedureParameter);
                }
                Object var15_15 = null;
            }
            catch (SQLException sQLException) {
                FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                Object var15_16 = null;
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
                return arrayList.toArray(new StoreProcedureParameter[arrayList.size()]);
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(statement);
            throw throwable;
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(statement);
        return arrayList.toArray(new StoreProcedureParameter[arrayList.size()]);
    }

    protected String getProcedureParametersSql(String string) {
        return "SELECT text FROM syscat.routines WHERE ROUTINENAME='" + string + "' AND ROUTINETYPE='P'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getStoreProcedureText(Connection connection, String string, String string2) {
        ResultSet resultSet;
        Statement statement;
        block7: {
            String string3;
            block9: {
                String string4;
                block8: {
                    String[] stringArray = string.split("\\.");
                    String string5 = this.getProcedureSql(stringArray[stringArray.length - 1]);
                    statement = null;
                    resultSet = null;
                    try {
                        try {
                            statement = connection.createStatement();
                            resultSet = statement.executeQuery(string5);
                            if (!resultSet.next()) break block7;
                            Reader reader = resultSet.getCharacterStream("text");
                            if (reader != null) {
                                BufferedReader bufferedReader = new BufferedReader(reader);
                                string4 = DataUtils.reader2String(bufferedReader);
                                Object var12_13 = null;
                                break block8;
                            }
                            string3 = "ERROR FETCHING...";
                            break block9;
                        }
                        catch (SQLException sQLException) {
                            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                            Object var12_16 = null;
                            DBUtils.closeResultSet(resultSet);
                            DBUtils.closeStatement(statement);
                            return "ERROR FETCHING...";
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_17 = null;
                        DBUtils.closeResultSet(resultSet);
                        DBUtils.closeStatement(statement);
                        throw throwable;
                    }
                }
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
                return string4;
            }
            Object var12_14 = null;
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(statement);
            return string3;
        }
        Object var12_15 = null;
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(statement);
        return "ERROR FETCHING...";
    }

    protected String getProcedureSql(String string) {
        return this.getProcedureParametersSql(string);
    }
}

