/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dialect;

import com.fr.base.StoreProcedureParameter;
import com.fr.data.core.db.ColumnInformation;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.TableProcedure;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dialect.OracleDialect;
import com.fr.data.core.db.dialect.TriggerAction;
import com.fr.data.core.db.dialect.TypeUtils;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.field.FieldMessage;
import com.fr.data.core.db.field.NormalFieldMessage;
import com.fr.data.core.db.handler.DefaultSQLTypeHandlerFactory;
import com.fr.data.core.db.handler.SQLTypeHandlerFactory;
import com.fr.data.core.db.tableObject.Column;
import com.fr.data.dao.JDBCDataAccessObjectOperator;
import com.fr.data.dao.ObjectMappingTable;
import com.fr.data.impl.Connection;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.stable.StringUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.transaction.NotSupportedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractDialect
implements Dialect,
Serializable {
    private static int fetchSize = -1;
    private static final int SCHEMA = 2;
    private static final int TABLE = 3;
    private static final int TYPE = 4;
    protected String left_quote = null;
    protected String right_quote = null;

    @Override
    public void initTables(JDBCDataAccessObjectOperator jDBCDataAccessObjectOperator, java.sql.Connection connection, ObjectMappingTable[] objectMappingTableArray) throws Exception {
        try {
            int n;
            for (n = 0; n < objectMappingTableArray.length; ++n) {
                objectMappingTableArray[n].createTable(connection);
            }
            for (n = 0; n < objectMappingTableArray.length; ++n) {
                objectMappingTableArray[n].createForeignKey(connection);
            }
            for (n = 0; n < objectMappingTableArray.length; ++n) {
                objectMappingTableArray[n].initData(jDBCDataAccessObjectOperator.startSession());
            }
            connection.commit();
        }
        catch (Exception exception) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                }
            }
            throw exception;
        }
    }

    @Override
    public StringBuffer columnInit(StringBuffer stringBuffer, Column column) {
        stringBuffer.append(" ").append(column.isAllowNull() ? "NULL" : "NOT NULL");
        return stringBuffer;
    }

    @Override
    public String cascadeDeletePosition(boolean bl, boolean bl2, StringBuffer stringBuffer) {
        return bl && bl2 ? stringBuffer.toString() + " on delete cascade" : stringBuffer.toString();
    }

    @Override
    public int getFetchSize() {
        return fetchSize;
    }

    @Override
    public String column2SQL(String string) {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        if (StringUtils.isBlank(this.left_quote) || StringUtils.isBlank(this.right_quote)) {
            return string;
        }
        return this.left_quote + string.trim() + this.right_quote;
    }

    @Override
    public String column2SQL4WhereSQL(String string, int n) {
        return this.column2SQL(string);
    }

    @Override
    public String columnType2SQL(int n, String string) {
        return TypeUtils.getTypeName(n);
    }

    @Override
    public String table2SQL(Table table) {
        if (table == null) {
            return "";
        }
        if (StringUtils.isBlank(this.left_quote) || StringUtils.isBlank(this.right_quote)) {
            return table.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = table.getSchema();
        if (StringUtils.isNotBlank(string)) {
            stringBuffer.append(string).append('.');
        }
        stringBuffer.append(this.column2SQL(table.getName()));
        return stringBuffer.toString();
    }

    @Override
    public String[] getSchemas(java.sql.Connection connection) throws Exception {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (StringUtils.isNotBlank(databaseMetaData.getSchemaTerm())) {
            ResultSet resultSet = databaseMetaData.getSchemas();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1).trim());
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public TableProcedure[] getTableProcedure(Connection connection, java.sql.Connection connection2, String string, boolean bl) throws Exception {
        if (connection2 == null) {
            throw new Exception("Cannot connect to database!");
        }
        ArrayList<TableProcedure> arrayList = new ArrayList<TableProcedure>();
        String string2 = null;
        if (string != null) {
            string2 = connection2.getCatalog();
        }
        DatabaseMetaData databaseMetaData = connection2.getMetaData();
        String[] stringArray = new String[]{"TABLE"};
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getTables(string2, string, "%", stringArray);
        }
        catch (SQLException sQLException) {
            resultSet = databaseMetaData.getTables(string2, string, "%", stringArray);
        }
        while (resultSet.next()) {
            String string3 = this.processCharsetDB2Server(resultSet.getString(2), connection);
            String string4 = this.processCharsetDB2Server(resultSet.getString(3), connection);
            String string5 = this.processCharsetDB2Server(resultSet.getString(4), connection);
            arrayList.add(new TableProcedure(string3, string4, string5, this));
        }
        resultSet.close();
        if (arrayList.isEmpty()) {
            return this.getAllTableInfoFromPlugin(connection, connection2);
        }
        return arrayList.toArray(new TableProcedure[arrayList.size()]);
    }

    private TableProcedure[] getAllTableInfoFromPlugin(Connection connection, java.sql.Connection connection2) {
        Dialect dialect = DialectFactory.generateDialect(connection2, connection.getDriver());
        return dialect.getAllTableProcedure(connection, "ALLTABLE");
    }

    @Override
    public TableProcedure[] getTableProcedure(java.sql.Connection connection, String string, boolean bl) throws Exception {
        return this.getTableProcedure(new JDBCDatabaseConnection(), connection, string, bl);
    }

    @Override
    public TableProcedure[] getProcedureList(java.sql.Connection connection, ResultSet resultSet, String string, String string2) {
        ArrayList<TableProcedure> arrayList = new ArrayList<TableProcedure>();
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            resultSet = databaseMetaData.getProcedures(string, string2, "%");
            while (resultSet.next()) {
                String string3 = resultSet.getString(3);
                int n = string3.lastIndexOf(";");
                if (n > 0) {
                    string3 = string3.substring(0, n);
                }
                arrayList.add(new TableProcedure(resultSet.getString(2), string3, "PROCEDURE", this));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().errorWithServerLevel(sQLException.getMessage(), sQLException);
        }
        return arrayList.toArray(new TableProcedure[arrayList.size()]);
    }

    @Override
    public boolean supportsUniqueConstraintInCreateAlterTable() {
        return true;
    }

    @Override
    public boolean supportsUniqueViolationExceptionCheck() {
        return false;
    }

    @Override
    public boolean isUniqueViolationException(SQLException sQLException) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStoreProcedureText(java.sql.Connection connection, String string, String string2) {
        String[] stringArray = string.split("\\.");
        String string3 = "";
        boolean bl = stringArray.length == 3 && this instanceof OracleDialect;
        string3 = bl ? ((OracleDialect)this).getProcedureSql(stringArray[stringArray.length - 2], stringArray[stringArray.length - 1]) : this.getProcedureSql(stringArray[stringArray.length - 1]);
        if (StringUtils.isEmpty(string3)) {
            return " Not Support Yet";
        }
        Statement statement = null;
        ResultSet resultSet = null;
        String string4 = "";
        try {
            block7: {
                try {
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(string3);
                    while (resultSet.next()) {
                        String string5 = resultSet.getString(this.getValueName());
                        string4 = string4 + string5;
                    }
                    if (!StringUtils.isEmpty(string4)) break block7;
                    string4 = "ERROR FETCHING...";
                }
                catch (SQLException sQLException) {
                    String string6 = "ERROR FETCHING...";
                    Object var13_13 = null;
                    DBUtils.closeResultSet(resultSet);
                    DBUtils.closeStatement(statement);
                    return string6;
                }
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(statement);
            throw throwable;
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(statement);
        if (bl) {
            return this.dealWithOraclePacakge(string4, stringArray);
        }
        return this.dealWithShowText(stringArray[stringArray.length - 1], string4);
    }

    private String dealWithOraclePacakge(String string, String[] stringArray) {
        int n = string.toLowerCase().indexOf(("PROCEDURE " + stringArray[stringArray.length - 1]).toLowerCase());
        int n2 = string.toLowerCase().indexOf(("END " + stringArray[stringArray.length - 1]).toLowerCase());
        if (n2 != -1) {
            return string.substring(n, n2 + "END".length()) + ";";
        }
        try {
            String string2 = "";
            String string3 = string.substring(n + "PROCEDURE".length());
            int n3 = string3.indexOf("PROCEDURE");
            if (n3 == -1) {
                n2 = string.lastIndexOf("END");
                string2 = string.substring(n, n2);
            } else {
                string2 = "PROCEDURE" + string3.substring(0, n3);
            }
            return string2;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String dealWithShowText(String string, String string2) {
        return string2;
    }

    @Override
    public String createSequence(java.sql.Connection connection, String string, String string2, String string3) {
        return string3;
    }

    @Override
    public String getIdentitySelectString(String string, String string2, int n) throws Exception {
        return this.getIdentitySelectString();
    }

    @Override
    public void setAutoCommit(java.sql.Connection connection, boolean bl) throws SQLException {
        connection.setAutoCommit(bl);
    }

    @Override
    public String getLimitString(String string, int n, int n2) {
        throw new UnsupportedOperationException("paged queries not supported");
    }

    @Override
    public boolean supportsLimitOffset(String string) {
        return true;
    }

    @Override
    public String getCountSql(String string) {
        return string == null ? null : "SELECT COUNT(*) AS rowcount FROM (" + string + ") t";
    }

    @Override
    public boolean isYearData(java.sql.Connection connection, int n, Table table, String string) {
        return false;
    }

    @Override
    public String quartzDelegateClass() {
        return "com.fr.third.org.quartz.impl.jdbcjobstore.StdJDBCDelegate";
    }

    @Override
    public String quartzDelegateKey() {
        return "com.fr.third.org.quartz.jobStore.driverDelegateClass";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String defaultValidationQuery(java.sql.Connection var1_1) {
        block17: {
            block16: {
                try {
                    try {
                        var2_2 = var1_1.getMetaData();
                        var3_4 = var2_2.getTableTypes();
                        while (var3_4.next()) {
                            if (!"TABLE".equals(var3_4.getString("TABLE_TYPE"))) continue;
                            var4_7 = var2_2.getTables(null, null, "%", new String[]{"TABLE"});
                            while (var4_7.next()) {
                                var5_8 = var4_7.getString("TABLE_NAME");
                                if (!StringUtils.isNotBlank(var5_8)) continue;
                                var6_9 = var4_7.getString("TABLE_SCHEM");
                                if (StringUtils.isNotBlank(var6_9)) {
                                    var5_8 = var6_9 + "." + var5_8;
                                }
                                var7_10 = "select count(*) from " + var5_8 + " where 1 = 2";
                                FRLogger.getLogger().info("try ValidationQuery:" + var7_10);
                                var8_11 = var7_10;
                                var10_12 = null;
                                break block16;
                            }
                            break block17;
                        }
                        break block17;
                    }
                    catch (SQLException var2_3) {
                        try {
                            if (var1_1 != null) {
                                var1_1.close();
                                var1_1 = null;
                            }
                        }
                        catch (SQLException var3_5) {
                            // empty catch block
                        }
                        var3_6 = "";
                        var10_14 = null;
                        try {
                            if (var1_1 == null) return var3_6;
                            var1_1.close();
                            return var3_6;
                        }
                        catch (SQLException var11_18) {
                            // empty catch block
                        }
                        return var3_6;
                    }
                }
                catch (Throwable var9_20) {
                    var10_15 = null;
                    ** try [egrp 3[TRYBLOCK] [7 : 242->257)] { 
lbl44:
                    // 1 sources

                    if (var1_1 == null) throw var9_20;
                    var1_1.close();
                    var1_1 = null;
                    throw var9_20;
lbl48:
                    // 1 sources

                    catch (SQLException var11_19) {
                        // empty catch block
                    }
                    throw var9_20;
                }
            }
            ** try [egrp 3[TRYBLOCK] [7 : 242->257)] { 
lbl53:
            // 1 sources

            if (var1_1 == null) return var8_11;
            var1_1.close();
            return var8_11;
lbl56:
            // 1 sources

            catch (SQLException var11_16) {
                // empty catch block
            }
            return var8_11;
        }
        var10_13 = null;
        try {}
        catch (SQLException var11_17) {}
        if (var1_1 == null) return "";
        var1_1.close();
        return "";
        return "";
    }

    @Override
    public boolean isSupportFetchText() {
        return StringUtils.isNotEmpty(this.getProcedureSql("abc`bca"));
    }

    @Override
    public String getTableCommentName(java.sql.Connection connection, String string, String string2, String string3) {
        return "";
    }

    @Override
    public List<Map<String, Object>> getTableFieldsInfor(java.sql.Connection connection, String string, String string2, String string3) {
        List<FieldMessage> list = this.getTableFieldsMessage(connection, string, string2, string3);
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (FieldMessage fieldMessage : list) {
            arrayList.add(fieldMessage.toCompatibleMap());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<FieldMessage> getTableFieldsMessage(java.sql.Connection connection, String string, String string2, String string3) {
        ArrayList<FieldMessage> arrayList = new ArrayList<FieldMessage>();
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        try {
            try {
                HashSet<String> hashSet = new HashSet<String>();
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                resultSet = databaseMetaData.getPrimaryKeys(connection.getCatalog(), string2, string);
                while (resultSet.next()) {
                    hashSet.add(resultSet.getString("COLUMN_NAME"));
                }
                resultSet2 = databaseMetaData.getColumns(connection.getCatalog(), string2, string, null);
                while (resultSet2.next()) {
                    FieldMessage fieldMessage = this.createFieldMessage();
                    String string4 = resultSet2.getString("REMARKS");
                    if (StringUtils.isEmpty(string4)) {
                        string4 = null;
                    }
                    fieldMessage.setColumnName(resultSet2.getString("COLUMN_NAME"));
                    fieldMessage.setColumnComment(string4);
                    fieldMessage.setColumnType(resultSet2.getInt("DATA_TYPE"));
                    fieldMessage.setColumnSize(resultSet2.getInt("COLUMN_SIZE"));
                    fieldMessage.setPrimaryKey(hashSet.contains(resultSet2.getString("COLUMN_NAME")));
                    if (resultSet2.getObject("DECIMAL_DIGITS") != null) {
                        fieldMessage.setColumnDecimalDigits(resultSet2.getInt("DECIMAL_DIGITS"));
                    }
                    arrayList.add(fieldMessage);
                }
                Object var13_13 = null;
            }
            catch (SQLException sQLException) {
                Object var13_14 = null;
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeResultSet(resultSet2);
                return arrayList;
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeResultSet(resultSet2);
            throw throwable;
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeResultSet(resultSet2);
        return arrayList;
    }

    protected FieldMessage createFieldMessage() {
        return new NormalFieldMessage();
    }

    @Override
    public Object parseValue(Object object, int n) {
        if (object instanceof BigDecimal && (n == -5 || n == 4)) {
            object = new Long(((BigDecimal)object).longValue());
        }
        return this.parseOtherValue(object, n);
    }

    @Override
    public StoreProcedureParameter[] getStoreProcedureDeclarationParameters(java.sql.Connection connection, String string, String string2) {
        return new StoreProcedureParameter[0];
    }

    @Override
    public SQLTypeHandlerFactory buildSQLTypeHandlerFactory() {
        return DefaultSQLTypeHandlerFactory.getInstance();
    }

    @Override
    public boolean supportsCascadeDelete() {
        return true;
    }

    @Override
    public String buildForeignKeyString(String string, String[] stringArray, String string2, String[] stringArray2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(30).append(" add constraint ").append(string).append(this.foreignKeyString(stringArray, string2, stringArray2, bl));
        return stringBuffer.toString();
    }

    protected String foreignKeyString(String[] stringArray, String string, String[] stringArray2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer().append(" foreign key (").append(StringUtils.join(", ", stringArray)).append(") references ").append(string);
        if (!bl) {
            stringBuffer.append(" (").append(StringUtils.join(", ", stringArray2)).append(')');
        }
        return stringBuffer.toString();
    }

    protected int sql2ColumnTypeForProcedure(String string) {
        if (string == null) {
            return 12;
        }
        if (string.toUpperCase().indexOf("CHAR") > -1 || string.toUpperCase().indexOf("BIT") > -1) {
            return 12;
        }
        if (string.toUpperCase().indexOf("INT") > -1) {
            return 4;
        }
        if (this.isDecimalType(string)) {
            return 3;
        }
        if (string.toUpperCase().indexOf("DATE") > -1) {
            return 91;
        }
        if (string.toUpperCase().indexOf("BOOLEAN") > -1) {
            return 16;
        }
        return 12;
    }

    protected String getIdentitySelectString() throws Exception {
        throw new Exception("Dialect does not support identity key generation");
    }

    protected int sql2ParameterType(String string) {
        if (ComparatorUtils.equals(string.toUpperCase(), "OUT")) {
            return 0x7FFFFFFD;
        }
        if (ComparatorUtils.equals(string.toUpperCase(), "IN")) {
            return 0x7FFFFFFE;
        }
        if (ComparatorUtils.equals(string.toUpperCase(), "IN/OUT")) {
            return 0x7FFFFFFC;
        }
        return 0x7FFFFFFE;
    }

    protected List parameterToList(String[] stringArray) {
        ArrayList<StoreProcedureParameter> arrayList = new ArrayList<StoreProcedureParameter>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].trim();
            String[] stringArray2 = string.split(" ");
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (int j = 0; j < stringArray2.length; ++j) {
                if (ComparatorUtils.equals(stringArray2[j], "")) continue;
                arrayList2.add(stringArray2[j].trim());
            }
            if (arrayList2.size() == 2) {
                StoreProcedureParameter storeProcedureParameter = new StoreProcedureParameter((String)arrayList2.get(0), 0x7FFFFFFE, this.sql2ColumnTypeForProcedure((String)arrayList2.get(1)));
                arrayList.add(storeProcedureParameter);
                continue;
            }
            if (arrayList2.size() < 2) continue;
            StoreProcedureParameter storeProcedureParameter = new StoreProcedureParameter((String)arrayList2.get(1), this.sql2ParameterType((String)arrayList2.get(0)), this.sql2ColumnTypeForProcedure((String)arrayList2.get(2)));
            arrayList.add(storeProcedureParameter);
        }
        return arrayList;
    }

    protected String getValueName() {
        return "";
    }

    protected String getProcedureSql(String string) {
        return "";
    }

    protected String getProcedureParametersSql(String string) {
        return "";
    }

    protected Object parseOtherValue(Object object, int n) {
        return object;
    }

    private boolean isDecimalType(String string) {
        return string.toUpperCase().indexOf("DECIMAL") > -1 || string.toUpperCase().indexOf("NUMERIC") > -1 || string.toUpperCase().indexOf("DOUBLE") > -1 || string.toUpperCase().indexOf("FLOAT") > -1 || string.toUpperCase().indexOf("NUMBER") > -1;
    }

    @Override
    public ResultSet createLimitResultSet(Connection connection, java.sql.Connection connection2, Statement statement, String[] stringArray, String string, String string2, String string3, long l) throws SQLException {
        Table table = new Table(string, string2);
        String string4 = "select * from " + this.table2SQL(table);
        ResultSet resultSet = statement.executeQuery(this.processCharset(string4, connection));
        resultSet.absolute((int)l);
        return resultSet;
    }

    @Override
    public Statement createLimitUseStatement(java.sql.Connection connection) throws SQLException {
        return connection.createStatement(1005, 1007);
    }

    protected String processCharset(String string, Connection connection) {
        String string2 = connection.getOriginalCharsetName();
        String string3 = connection.getNewCharsetName();
        return this.getNewCharSet(string3, string2, string);
    }

    private String getNewCharSet(String string, String string2, String string3) {
        if (StringUtils.isEmpty(string3)) {
            return string3;
        }
        if (StringUtils.isNotBlank(string) && StringUtils.isNotBlank(string)) {
            try {
                return new String(string3.getBytes(string), string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FRLogger.getLogger().error(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        }
        return string3;
    }

    protected String processCharsetDB2Server(String string, Connection connection) {
        String string2 = connection.getOriginalCharsetName();
        String string3 = connection.getNewCharsetName();
        return this.getNewCharSet(string2, string3, string);
    }

    @Override
    public String createLimitSQL(String string, String[] stringArray, long l) throws NotSupportedException {
        throw new NotSupportedException();
    }

    @Override
    public String getSpecificRowSql(String string, int n) {
        return string;
    }

    @Override
    public String getRowRangeSql(String string, int n, int n2, String[] stringArray) {
        return string;
    }

    @Override
    public String getTopNRowSql(int n, Table table) {
        return "select top " + n + " * from " + this.table2SQL(table);
    }

    @Override
    public boolean isSupportQueryWhileInsert(int n) {
        return n > 0;
    }

    @Override
    public ColumnInformation[] getColumnInformation(java.sql.Connection connection, ResultSet resultSet, String string, String string2, String string3) throws SQLException {
        return DBUtils.checkInColumnInformationByMetaData(resultSet.getMetaData(), string2, string3);
    }

    @Override
    public void setForeignKeyChecks(java.sql.Connection connection, int n) {
    }

    @Override
    public String createSQL4Columns(String string) {
        return "select * from (" + string + ") t where 4 = 5";
    }

    @Override
    public TableProcedure[] getAllTableProcedure(Connection connection, String string) {
        return new TableProcedure[0];
    }

    @Override
    public Statement createStatement(java.sql.Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement();
        if (this.getFetchSize() > 0) {
            statement.setFetchSize(this.getFetchSize());
        }
        return statement;
    }

    @Override
    public ResultSet executeQuery(Statement statement, String string, java.sql.Connection connection) throws SQLException {
        return statement.executeQuery(string);
    }

    @Override
    public boolean isNULL(Object object) {
        return object == null;
    }

    @Override
    public void notifyTriggerChange(java.sql.Connection connection, Table table, TriggerAction triggerAction) {
    }

    @Override
    public Object[] remoteProcedureCall(java.sql.Connection connection, String string) throws SQLException {
        Object[] objectArray = new Object[2];
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        CallableStatement callableStatement2 = callableStatement = connection.prepareCall(string, 1003, 1007);
        resultSet = callableStatement2.executeQuery();
        objectArray[0] = callableStatement;
        objectArray[1] = resultSet;
        return objectArray;
    }
}

