/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db;

import com.fr.data.core.db.dialect.Dialect;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.io.Serializable;

public class TableProcedure
implements XMLReadable,
Serializable,
Cloneable {
    public static final String TABLE = "TABLE";
    public static final String VIEW = "VIEW";
    public static final String PROCEDURE = "PROCEDURE";
    public static final String ALLTABLE = "ALLTABLE";
    private String schema;
    private String name = "";
    private String type = "TABLE";
    private Dialect dialect = null;

    public TableProcedure() {
    }

    public TableProcedure(String string, String string2, String string3, Dialect dialect) {
        this.schema = string;
        this.name = string2;
        this.type = string3;
        this.dialect = dialect;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getType() {
        return this.type;
    }

    public void setSchema(String string) {
        this.schema = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TableProcedure)) {
            return false;
        }
        TableProcedure tableProcedure = (TableProcedure)object;
        return ComparatorUtils.equals(tableProcedure.getName(), this.getName()) && ComparatorUtils.equals(tableProcedure.getSchema(), this.getSchema()) && ComparatorUtils.equals(tableProcedure.getType(), this.getType());
    }

    public String toString() {
        return (this.schema != null ? this.schema + "." : "") + this.getName();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            String string = xMLableReader.getAttrAsString("schema", null);
            if (string != null) {
                this.setSchema(string);
            }
            if ((string = xMLableReader.getAttrAsString("name", null)) != null) {
                this.setName(string);
            }
            if ((string = xMLableReader.getAttrAsString("type", null)) != null) {
                this.setType(string);
            }
            if ((string = xMLableReader.getAttrAsString("dialect", null)) != null) {
                try {
                    this.setDialect((Dialect)Class.forName(string).newInstance());
                }
                catch (Exception exception) {
                    FRLogger.getLogger().error(exception.getMessage(), exception);
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("TableProcedure").attr("type", this.getType()).attr("name", this.getName());
        if (this.getSchema() != null) {
            xMLPrintWriter.attr("schema", this.getSchema());
        }
        if (this.getDialect() != null) {
            xMLPrintWriter.attr("dialect", this.getDialect().getClass().getName());
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

