/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.condition;

import com.fr.cache.list.IntList;
import com.fr.data.condition.AbstractCondition;
import com.fr.data.condition.CommonCondition;
import com.fr.data.condition.JoinCondition;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.data.Condition;
import com.fr.general.data.DataModel;
import com.fr.general.data.EvalFormulaAction;
import com.fr.general.data.TableDataException;
import com.fr.general.data.index.IndexDataModel;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ColumnRow;
import com.fr.stable.ModColumnRowProvider;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.ExTool;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ListCondition
extends AbstractCondition {
    private List joinConditionList;

    public ListCondition() {
        this.joinConditionList = new ArrayList();
    }

    public ListCondition(List list) {
        this.joinConditionList = list;
    }

    public int getJoinConditionCount() {
        return this.joinConditionList.size();
    }

    public void addCondition(Condition condition) {
        this.addJoinCondition(new JoinCondition(0, condition));
    }

    public void addJoinCondition(int n, Condition condition) {
        this.addJoinCondition(new JoinCondition(n, condition));
    }

    public void addJoinCondition(JoinCondition joinCondition) {
        Condition condition = joinCondition.getCondition();
        if (condition == null) {
            return;
        }
        if (condition instanceof ListCondition && ((ListCondition)condition).getJoinConditionCount() == 0) {
            return;
        }
        this.joinConditionList.add(joinCondition);
    }

    public JoinCondition getJoinCondition(int n) {
        if (n < 0 || n >= this.joinConditionList.size()) {
            return null;
        }
        return (JoinCondition)this.joinConditionList.get(n);
    }

    public void setJoinCondition(int n, JoinCondition joinCondition) {
        this.joinConditionList.set(n, joinCondition);
    }

    public void clearJoinConditions() {
        this.joinConditionList.clear();
    }

    public String[] dependence(CalculatorProvider calculatorProvider) {
        String[] stringArray = new String[]{};
        Iterator iterator = this.joinConditionList.iterator();
        while (iterator.hasNext()) {
            Condition condition = ((JoinCondition)iterator.next()).getCondition();
            stringArray = ArrayUtils.addAll(stringArray, condition.dependence(calculatorProvider));
        }
        return stringArray;
    }

    public void modColumnRow(ModColumnRowProvider modColumnRowProvider) {
        for (Object e : this.joinConditionList) {
            ((JoinCondition)e).getCondition().modColumnRow(modColumnRowProvider);
        }
    }

    public void formula2Value(Calculator calculator) {
        Iterator iterator = this.joinConditionList.iterator();
        while (iterator.hasNext()) {
            ((AbstractCondition)((JoinCondition)iterator.next()).getCondition()).formula2Value(calculator);
        }
    }

    public void buildExecuteSequenceList(List list, Calculator calculator) {
        Iterator iterator = this.joinConditionList.iterator();
        while (iterator.hasNext()) {
            ((AbstractCondition)((JoinCondition)iterator.next()).getCondition()).buildExecuteSequenceList(list, calculator);
        }
    }

    public boolean eval(Object object, CalculatorProvider calculatorProvider) {
        return this.eval(object, calculatorProvider, EvalFormulaAction.EVAL_STRING);
    }

    public boolean eval(Object object, CalculatorProvider calculatorProvider, EvalFormulaAction evalFormulaAction) {
        return this.inner_eval(object, calculatorProvider, evalFormulaAction);
    }

    public void analyzeCorrelative(CalculatorProvider calculatorProvider, ExTool exTool, ColumnRow columnRow) {
        int n = this.getJoinConditionCount();
        for (int i = 0; i < n; ++i) {
            this.getJoinCondition(i).analyzeCorrelative(calculatorProvider, exTool, columnRow);
        }
    }

    public int[] evalTableData(DataModel dataModel, int[] nArray, int n, CalculatorProvider calculatorProvider) {
        nArray = super.getFilterRows(dataModel, n, nArray, calculatorProvider);
        int[] nArray2 = new int[]{};
        if (dataModel == null) {
            return nArray2;
        }
        int n2 = 0;
        try {
            n2 = dataModel.getRowCount();
        }
        catch (TableDataException tableDataException) {
            FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
        }
        nArray2 = nArray == null ? IntList.range(n2) : nArray;
        int n3 = this.getJoinConditionCount();
        for (int i = 0; i < n3; ++i) {
            JoinCondition joinCondition = this.getJoinCondition(i);
            Condition condition = joinCondition.getCondition();
            if (i == 0 || joinCondition.getJoin() == 0) {
                if (condition instanceof CommonCondition && dataModel instanceof IndexDataModel && nArray2.length == n2) {
                    nArray2 = ((AbstractCondition)condition).getFilterRows(dataModel, n, nArray, calculatorProvider);
                }
                nArray2 = condition.evalTableData(dataModel, nArray2, n, calculatorProvider);
                continue;
            }
            if (joinCondition.getJoin() != 1) continue;
            nArray2 = IntList.unionArray(nArray2, condition.evalTableData(dataModel, nArray, n, calculatorProvider));
        }
        return nArray2;
    }

    private boolean inner_eval(Object object, CalculatorProvider calculatorProvider, EvalFormulaAction evalFormulaAction) {
        int n = this.getJoinConditionCount();
        if (n <= 0) {
            return true;
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            JoinCondition joinCondition = this.getJoinCondition(i);
            int n2 = joinCondition.getJoin();
            Condition condition = joinCondition.getCondition();
            bl = i == 0 ? condition.eval(object, calculatorProvider, evalFormulaAction) : (n2 == 0 ? bl && condition.eval(object, calculatorProvider) : bl || condition.eval(object, calculatorProvider));
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i = 0; i < this.joinConditionList.size(); ++i) {
            JoinCondition joinCondition = (JoinCondition)this.joinConditionList.get(i);
            if (i != 0) {
                if (joinCondition.getJoin() == 0) {
                    stringBuffer.append(" and ");
                } else {
                    stringBuffer.append(" or ");
                }
            }
            if (joinCondition.getCondition() == null) continue;
            stringBuffer.append(joinCondition.getCondition().toString());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ListCondition)) {
            return false;
        }
        ListCondition listCondition = (ListCondition)object;
        if (listCondition.getJoinConditionCount() != this.getJoinConditionCount()) {
            return false;
        }
        for (int i = 0; i < this.getJoinConditionCount(); ++i) {
            if (ComparatorUtils.equals(listCondition.getJoinCondition(i), this.getJoinCondition(i))) continue;
            return false;
        }
        return true;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.clearJoinConditions();
        }
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("JoinCondition")) {
            JoinCondition joinCondition = new JoinCondition();
            this.joinConditionList.add(joinCondition);
            xMLableReader.readXMLObject(joinCondition);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n = this.getJoinConditionCount();
        for (int i = 0; i < n; ++i) {
            JoinCondition joinCondition = this.getJoinCondition(i);
            joinCondition.writeXML(xMLPrintWriter);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ListCondition listCondition = (ListCondition)super.clone();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.getJoinConditionCount(); ++i) {
            arrayList.add(this.getJoinCondition(i).clone());
        }
        listCondition.joinConditionList = arrayList;
        return listCondition;
    }

    public JSONObject createJSON() throws Exception {
        JSONObject jSONObject = super.createJSON();
        if (this.getJoinConditionCount() > 0) {
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < this.getJoinConditionCount(); ++i) {
                jSONArray.put(this.getJoinCondition(i).getCondition().createJSON());
            }
            jSONObject.put("commonconditions", jSONArray);
        }
        return jSONObject;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        JSONArray jSONArray = jSONObject.getJSONArray("commonconditions");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            CommonCondition commonCondition = new CommonCondition();
            commonCondition.parseJSON(jSONArray.getJSONObject(i));
            this.addCondition(commonCondition);
        }
    }
}

