/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data;

import com.fr.general.ComparatorUtils;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.stable.collections.map.ObjectIntMap;

public abstract class AbstractDataModel
implements DataModel {
    public static final int NOT_CONTAINS = Integer.MIN_VALUE;
    private static final int NOT_GET = -2;
    private transient ObjectIntMap<String> columnCacheMap = new ObjectIntMap();

    public boolean hasRow(int n) throws TableDataException {
        return n >= 0 && n < this.getRowCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumnIndex(String string) throws TableDataException {
        int n;
        if (this.columnCacheMap == null) {
            this.columnCacheMap = new ObjectIntMap();
        }
        if ((n = this.columnCacheMap.get(string, -2)) != -2) {
            return n;
        }
        ObjectIntMap<String> objectIntMap = this.columnCacheMap;
        synchronized (objectIntMap) {
            n = Integer.MIN_VALUE;
            int n2 = this.getColumnCount();
            for (int i = 0; i < n2; ++i) {
                if (!ComparatorUtils.tableDataColumnNameEquals(string, this.getColumnName(i))) continue;
                n = i;
                break;
            }
            this.columnCacheMap.put(string, n);
            this.columnCacheMap.put(string.replaceAll(" ", ""), n);
            return n;
        }
    }

    public void release() throws Exception {
        if (this.columnCacheMap != null) {
            this.columnCacheMap.clear();
        }
    }
}

