/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cluster.rpc.cache;

import com.fr.cluster.rpc.exception.CacheUnavailableException;
import com.fr.general.ComparatorUtils;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Accelerator<K, V> {
    public static final long INTERVAL = 2048L;
    public static final int THRESHOLD = 0;
    public static final boolean ENABLE = true;
    private long intervalTime = 2048L;
    private int cacheThreshold = 0;
    protected Map<K, V> caches = new HashMap();
    private Map<K, Integer> cacheCounts = new HashMap<K, Integer>();
    private Map<K, Long> lastTimes = new HashMap<K, Long>();

    public Accelerator(int n, long l) {
        this.cacheThreshold = n;
        this.intervalTime = l;
    }

    public Accelerator() {
    }

    protected boolean canRead(K k) {
        this.updateTime(k);
        return this.isAchieved(k);
    }

    protected void cache(K k, V v2) {
        this.updateResult(k, v2);
    }

    protected V read(K k) throws CacheUnavailableException {
        if (this.canRead(k)) {
            return this.caches.get(k);
        }
        throw new CacheUnavailableException("need to cache first.");
    }

    private void updateTime(K k) {
        if (this.isBeyondTimeLimit(k)) {
            this.clearCount(k);
        }
        this.recordOneInvoke(k);
    }

    private void updateResult(K k, V v2) {
        if (!this.isEquals(k, v2)) {
            if (this.caches.containsKey(k)) {
                this.caches.remove(k);
            }
            this.clearCount(k);
            this.caches.put(k, v2);
        }
        this.recordCacheUpdate(k);
    }

    protected boolean isEquals(K k, V v2) {
        if (this.caches.containsKey(k)) {
            V v3 = this.caches.get(k);
            return ComparatorUtils.equals(v3, v2);
        }
        return false;
    }

    private void recordOneInvoke(K k) {
        this.recordLastTime(k);
    }

    private void recordCacheUpdate(K k) {
        this.increaseCount(k);
        this.recordOneInvoke(k);
    }

    private boolean isAchieved(K k) {
        if (this.cacheCounts.containsKey(k)) {
            return this.cacheCounts.get(k) > this.cacheThreshold;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCount(K k) {
        Accelerator accelerator = this;
        synchronized (accelerator) {
            this.cacheCounts.put(k, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increaseCount(K k) {
        Accelerator accelerator = this;
        synchronized (accelerator) {
            if (this.cacheCounts.containsKey(k)) {
                this.cacheCounts.put(k, this.cacheCounts.get(k) + 1);
            } else {
                this.cacheCounts.put(k, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordLastTime(K k) {
        Accelerator accelerator = this;
        synchronized (accelerator) {
            this.lastTimes.put(k, System.currentTimeMillis());
        }
    }

    private boolean isBeyondTimeLimit(K k) {
        if (!this.lastTimes.containsKey(k)) {
            return false;
        }
        long l = this.lastTimes.get(k);
        return System.currentTimeMillis() - l >= this.intervalTime;
    }

    public void refreshCache() {
        this.caches.clear();
        this.cacheCounts.clear();
        this.lastTimes.clear();
    }

    public void refreshCache(K k) {
        this.caches.remove(k);
        this.cacheCounts.remove(k);
        this.lastTimes.remove(k);
    }
}

