/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cache.list;

import com.fr.cache.list.IntList;
import com.fr.general.FRLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractList;
import sun.misc.Cleaner;

public class MappedByteBufferList
extends AbstractList {
    private File cacheFile = null;
    private MappedByteBuffer mapped_read;
    private MappedByteBuffer mapped_write;
    private byte[] page;
    private int pageSize = 0x2FFFFF;
    private int pageoffset = 0;
    private FileChannel fc;
    private int total_size;
    private IntList size_array;
    private IntList index_array;
    private int count = 0;

    public MappedByteBufferList(File file, int n) {
        this.pageSize = n;
        this.page = new byte[this.pageSize];
        this.size_array = new IntList(2000);
        this.index_array = new IntList(2001);
        this.index_array.add(0);
        this.cacheFile = file;
    }

    public static void un_map(final MappedByteBuffer mappedByteBuffer) {
        if (mappedByteBuffer != null) {
            mappedByteBuffer.force();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Method method = mappedByteBuffer.getClass().getMethod("cleaner", new Class[0]);
                        method.setAccessible(true);
                        Cleaner cleaner = (Cleaner)method.invoke((Object)mappedByteBuffer, new Object[0]);
                        if (cleaner != null) {
                            cleaner.clean();
                            cleaner.clear();
                        }
                    }
                    catch (Exception exception) {
                        FRLogger.getLogger().error(exception.getMessage(), exception);
                    }
                    return null;
                }
            });
        }
    }

    public boolean add(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (this.pageoffset + byArray.length < this.pageSize) {
                for (int i = 0; i < byArray.length; ++i) {
                    this.page[this.pageoffset++] = byArray[i];
                }
            } else {
                for (int i = 0; i < byArray.length; ++i) {
                    this.page[this.pageoffset++] = byArray[i];
                    if (this.pageoffset < this.pageSize) continue;
                    if (this.mapped_write != null) {
                        this.mapped_write.clear();
                        MappedByteBufferList.un_map(this.mapped_write);
                        this.mapped_write = null;
                    }
                    this.getFileChannel();
                    this.mapped_write = this.fc.map(FileChannel.MapMode.READ_WRITE, this.fc.size(), this.pageSize);
                    this.mapped_write.put(this.page);
                    this.pageoffset = 0;
                    this.total_size += this.pageSize;
                    if (this.mapped_read == null) continue;
                    this.mapped_read.clear();
                    MappedByteBufferList.un_map(this.mapped_read);
                    this.mapped_read = null;
                }
            }
            this.size_array.add(this.count, byArray.length);
            this.index_array.add(this.count + 1, this.index_array.get(this.count) + byArray.length);
            ++this.count;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return true;
    }

    public Object get(int n) {
        try {
            byte[] byArray = new byte[this.size_array.get(n)];
            int n2 = this.index_array.get(n) + this.size_array.get(n);
            if (this.total_size == 0) {
                return this.readWhenNoCache(n, n2, byArray);
            }
            return this.readWhenHasCache(n, n2, byArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private Object readWhenNoCache(int n, int n2, byte[] byArray) throws IOException, ClassNotFoundException {
        int n3 = 0;
        int n4 = this.index_array.get(n);
        while (n4 < n2) {
            byArray[n3] = this.page[n4];
            ++n4;
            ++n3;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    private Object readWhenHasCache(int n, int n2, byte[] byArray) throws IOException, ClassNotFoundException {
        int n3;
        int n4 = 0;
        this.getFileChannel();
        if (this.mapped_read == null) {
            this.mapped_read = this.fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.total_size);
        }
        if ((long)n2 <= this.fc.size()) {
            n3 = this.index_array.get(n);
            while (n3 < n2) {
                byArray[n4] = this.mapped_read.get(n3);
                ++n3;
                ++n4;
            }
        } else if (n2 > this.total_size && this.index_array.get(n) < this.total_size) {
            n3 = this.index_array.get(n);
            while ((long)n3 < this.fc.size()) {
                byArray[n4] = this.mapped_read.get(n3);
                ++n3;
                ++n4;
            }
            n3 = this.total_size;
            while (n3 < n2) {
                byArray[n4] = this.page[n3 - this.total_size];
                ++n3;
                ++n4;
            }
        } else {
            n3 = this.index_array.get(n);
            while (n3 < n2) {
                byArray[n4] = this.page[n3 - this.total_size];
                ++n3;
                ++n4;
            }
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    private FileChannel getFileChannel() {
        if (this.fc == null) {
            try {
                this.fc = new RandomAccessFile(this.cacheFile, "rw").getChannel();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return this.fc;
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        this.size_array = null;
        if (this.mapped_read != null) {
            this.mapped_read.clear();
            MappedByteBufferList.un_map(this.mapped_read);
            this.mapped_read = null;
        }
        if (this.mapped_write != null) {
            this.mapped_write.clear();
            MappedByteBufferList.un_map(this.mapped_write);
            this.mapped_write = null;
        }
        this.pageoffset = 0;
        if (this.fc != null) {
            try {
                this.fc.close();
                this.fc = null;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.page = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clear();
    }
}

