/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cache.list;

import com.fr.stable.StableUtils;
import com.fr.stable.collections.map.IntMap;
import java.io.Serializable;
import java.util.Arrays;

public class IntList
implements Cloneable,
Serializable {
    private int[] data;
    private int size = 0;
    private static final int CACHE_SIZE = 100;
    private static IntMap<int[]> cacheMap = new IntMap(100);

    public IntList() {
        this(8);
    }

    public IntList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.data = new int[n];
    }

    public int get(int n) throws ArrayIndexOutOfBoundsException {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.data[n];
    }

    public void set(int n, int n2) throws ArrayIndexOutOfBoundsException {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this.data[n] = n2;
    }

    public void add(int n) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = n;
    }

    public void add(int n, int n2) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        this.data[n] = n2;
        ++this.size;
    }

    public boolean contain(int n) {
        return this.indexOf(n) >= 0;
    }

    public int indexOf(int n) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != n) continue;
            return i;
        }
        return -1;
    }

    public int size() {
        return this.size;
    }

    public void remove(int n) {
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.data, n + 1, this.data, n, n2);
        }
        --this.size;
    }

    public void removeEqual() {
        int[] nArray = this.toArray();
        this.clear();
        for (int i = 0; i < nArray.length; ++i) {
            if (this.contain(nArray[i])) continue;
            this.add(nArray[i]);
        }
    }

    public void sort() {
        this.trimToSize();
        Arrays.sort(this.data);
    }

    public void clear() {
        this.data = new int[0];
        this.size = 0;
    }

    public void trimToSize() {
        this.data = this.toArray();
    }

    public int[] toArray() {
        int[] nArray = new int[this.size];
        System.arraycopy(this.data, 0, nArray, 0, this.size);
        return nArray;
    }

    public boolean addAll(int n, IntList intList) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        int[] nArray = intList.toArray();
        int n2 = nArray.length;
        this.ensureCapacity(this.size + n2);
        int n3 = this.size - n;
        if (n3 > 0) {
            System.arraycopy(this.data, n, this.data, n + n2, n3);
        }
        System.arraycopy(nArray, 0, this.data, n, n2);
        this.size += n2;
        return n2 != 0;
    }

    public boolean addAll(IntList intList) {
        int[] nArray = intList.toArray();
        int n = nArray.length;
        this.ensureCapacity(this.size + n);
        System.arraycopy(nArray, 0, this.data, this.size, n);
        this.size += n;
        return n != 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntList)) {
            return false;
        }
        IntList intList = (IntList)object;
        if (this.size != intList.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == intList.data[i]) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        IntList intList = (IntList)super.clone();
        intList.clear();
        for (int i = 0; i < this.size(); ++i) {
            intList.add(this.get(i));
        }
        return intList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.get(i));
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n > n2) {
            int[] nArray = this.data;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.data = new int[n3];
            System.arraycopy(nArray, 0, this.data, 0, this.size);
        }
    }

    public static IntList asList(int[] nArray) {
        if (nArray == null) {
            throw new NullPointerException();
        }
        IntList intList = new IntList();
        intList.data = nArray;
        intList.size = intList.data.length;
        return intList;
    }

    public static IntList toIntListDecimal(String string, char c) {
        IntList intList = new IntList();
        if (string == null) {
            return intList;
        }
        String[] stringArray = StableUtils.splitString(string, "" + c);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].trim();
            try {
                intList.add(Integer.parseInt(string2));
                continue;
            }
            catch (Exception exception) {
                int n;
                String[] stringArray2 = StableUtils.splitString(string2, "-");
                int n2 = -1;
                int n3 = -1;
                for (n = 0; n < stringArray2.length; ++n) {
                    int n4 = 0;
                    try {
                        n4 = Integer.parseInt(stringArray2[n]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n == 0) {
                        n2 = n4;
                        n3 = n4;
                        continue;
                    }
                    n2 = Math.min(n4, n2);
                    n3 = Math.max(n4, n3);
                }
                for (n = n2; n <= n3; ++n) {
                    intList.add(n);
                }
            }
        }
        return intList;
    }

    public static int[] toIntArrayDecimal(String string, char c) {
        return IntList.toIntListDecimal(string, c).toArray();
    }

    public static int[] unionArray(int[] nArray, int[] nArray2) {
        if (nArray == null) {
            return nArray2 == null ? nArray2 : (int[])nArray2.clone();
        }
        if (nArray2 == null) {
            return (int[])nArray.clone();
        }
        int[] nArray3 = (int[])nArray.clone();
        int[] nArray4 = (int[])nArray2.clone();
        Arrays.sort(nArray3);
        Arrays.sort(nArray4);
        IntList intList = new IntList();
        int n = 0;
        int n2 = 0;
        while (n < nArray3.length || n2 < nArray4.length) {
            if (n == nArray3.length) {
                intList.add(nArray4[n2]);
                ++n2;
                continue;
            }
            if (n2 == nArray4.length) {
                intList.add(nArray3[n]);
                ++n;
                continue;
            }
            if (nArray3[n] < nArray4[n2]) {
                intList.add(nArray3[n]);
                ++n;
                continue;
            }
            if (nArray3[n] > nArray4[n2]) {
                intList.add(nArray4[n2]);
                ++n2;
                continue;
            }
            if (nArray3[n] != nArray4[n2]) continue;
            intList.add(nArray4[n2]);
            ++n;
            ++n2;
        }
        return intList.toArray();
    }

    public static void sort(IntList intList) {
        int[] nArray = intList.toArray();
        Arrays.sort(nArray);
        intList.data = nArray;
    }

    public static int[] getRangeFromCache(int n) {
        int[] nArray = IntList.getCache(n);
        if (nArray == null) {
            nArray = IntList.range(n);
            IntList.putCache(n, nArray);
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] getCache(int n) {
        IntMap<int[]> intMap = cacheMap;
        synchronized (intMap) {
            return cacheMap.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putCache(int n, int[] nArray) {
        IntMap<int[]> intMap = cacheMap;
        synchronized (intMap) {
            if (IntList.cacheMap.size > 1000) {
                cacheMap.clear();
            }
            cacheMap.put(n, nArray);
        }
    }

    public static int[] range(int n) {
        if (n > 0) {
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
            return nArray;
        }
        return IntList.range(0, n);
    }

    public static int[] range(int n, int n2) {
        return IntList.range(n, n2, 1);
    }

    public static int[] range(int n, int n2, int n3) {
        IntList intList = new IntList();
        if (n3 > 0) {
            while (n < n2) {
                intList.add(n);
                n += n3;
            }
        } else {
            while (n > n2) {
                intList.add(n);
                n += n3;
            }
        }
        return intList.toArray();
    }

    public static IntList reverse(IntList intList) {
        int n = intList.size();
        int[] nArray = intList.toArray();
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray[n - i - 1];
        }
        return IntList.asList(nArray2);
    }
}

