/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cache.list;

import com.fr.cache.list.IntList;
import com.fr.general.FRLogger;
import com.fr.general.ManagerFactory;
import com.fr.stable.StableUtils;
import com.fr.stable.serialize.SerializationUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FRCacheList
extends AbstractList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static List prefix_list = new ArrayList();
    private File cacheDirectory = null;
    private int initCount = 800;
    private String prefix = "FRCL";
    private int activePoolCount = 1;
    private boolean cacheFirst = false;
    private ActiveFileInfo firstCacheInfo = null;
    private List cacheFileList = new ArrayList();
    private IntList cacheIndexList = new IntList();
    private ArrayList lastCachePool = new ArrayList();
    private LinkedList cachedPoolIndexLL;
    private Map activeCachePoolMap = new HashMap();

    public FRCacheList(int n, String string) {
        this(n, 1, string, false);
    }

    public FRCacheList(int n, int n2, String string, boolean bl) {
        this.initCount = n;
        string = string.replaceAll("_", "");
        String string2 = this.prefix = "FRCL" + string;
        int n3 = 1;
        while (prefix_list.contains(string2)) {
            string2 = this.prefix + n3;
            ++n3;
        }
        this.prefix = string2;
        prefix_list.add(this.prefix);
        this.cacheIndexList.add(0);
        this.activePoolCount = n2;
        this.initCachePoolIndexLL();
        this.cacheFirst = bl;
    }

    private void initCachePoolIndexLL() {
        this.cachedPoolIndexLL = new LinkedList();
        for (int i = 0; i < this.activePoolCount; ++i) {
            this.cachedPoolIndexLL.add(new ActiveFileInfo(-3, null));
        }
    }

    public synchronized int size() {
        return this.cacheIndexList.get(this.cacheIndexList.size() - 1) + this.lastCachePool.size();
    }

    public synchronized boolean add(Object object) {
        if (this.lastCachePool.size() >= this.initCount) {
            try {
                this.cacheIndexList.add(this.size());
                if (this.cacheIndexList.size() == 2 && this.cacheFirst) {
                    this.firstCacheInfo = new ActiveFileInfo(0, this.lastCachePool);
                    this.lastCachePool = new ArrayList();
                    this.cacheFileList.add(new Object());
                } else {
                    File file = new File(this.getCacheDirectory(), this.getPrefix() + "_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0));
                    int n = 0;
                    while (file.exists()) {
                        file = new File(this.getCacheDirectory(), this.getPrefix() + "_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0) + n);
                        ++n;
                    }
                    SerializationUtils.serializable(this.lastCachePool, file);
                    this.lastCachePool.clear();
                    file.deleteOnExit();
                    this.cacheFileList.add(file);
                }
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
        this.lastCachePool.add(object);
        return true;
    }

    public synchronized Object set(int n, Object object) {
        this.rangeCheck(n);
        try {
            int n2 = this.getCachePoolFileIndex(n);
            if (n2 == -2) {
                return this.lastCachePool.set(n - this.cacheIndexList.get(this.cacheIndexList.size() - 1), object);
            }
            ActiveFileInfo activeFileInfo = this.getCachePoolFileByFileIndex(n2);
            if (activeFileInfo != null) {
                Object object2 = activeFileInfo.getActiveCachedPool().set(n - this.cacheIndexList.get(activeFileInfo.getFileIndex()), object);
                activeFileInfo.setChanged(true);
                return object2;
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
        return null;
    }

    public synchronized void add(int n, Object object) {
        this.rangeCheck(n);
        if (n == this.size()) {
            this.add(object);
            return;
        }
        try {
            int n2 = this.getCachePoolFileIndex(n);
            if (n2 == -2) {
                this.lastCachePool.add(n - this.cacheIndexList.get(this.cacheIndexList.size() - 1), object);
                return;
            }
            ActiveFileInfo activeFileInfo = this.getCachePoolFileByFileIndex(n2);
            if (activeFileInfo != null) {
                activeFileInfo.getActiveCachedPool().add(n - this.cacheIndexList.get(activeFileInfo.getFileIndex()), object);
                for (int i = activeFileInfo.getFileIndex() + 1; i < this.cacheIndexList.size(); ++i) {
                    this.cacheIndexList.set(i, this.cacheIndexList.get(i) + 1);
                }
                activeFileInfo.setChanged(true);
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
    }

    public synchronized Object remove(int n) {
        this.rangeCheck(n);
        try {
            int n2 = this.getCachePoolFileIndex(n);
            if (n2 == -2) {
                return this.lastCachePool.remove(n - this.cacheIndexList.get(this.cacheIndexList.size() - 1));
            }
            ActiveFileInfo activeFileInfo = this.getCachePoolFileByFileIndex(n2);
            if (activeFileInfo != null) {
                Object e = activeFileInfo.getActiveCachedPool().remove(n - this.cacheIndexList.get(activeFileInfo.getFileIndex()));
                for (int i = activeFileInfo.getFileIndex() + 1; i < this.cacheIndexList.size(); ++i) {
                    this.cacheIndexList.set(i, this.cacheIndexList.get(i) - 1);
                }
                activeFileInfo.setChanged(true);
                return e;
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
        return null;
    }

    public synchronized Object get(int n) {
        try {
            this.rangeCheck(n);
            int n2 = this.getCachePoolFileIndex(n);
            if (n2 == -2) {
                return this.lastCachePool.get(n - this.cacheIndexList.get(this.cacheIndexList.size() - 1));
            }
            ActiveFileInfo activeFileInfo = this.getCachePoolFileByFileIndex(n2);
            if (activeFileInfo != null) {
                return activeFileInfo.getActiveCachedPool().get(n - this.cacheIndexList.get(activeFileInfo.getFileIndex()));
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
        return null;
    }

    private void rangeCheck(int n) {
        int n2 = this.size();
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException("Index: " + n + ",Size: " + n2);
        }
    }

    private int getCachePoolFileIndex(int n) {
        if (n >= this.cacheIndexList.get(this.cacheIndexList.size() - 1)) {
            return -2;
        }
        if (n < 0) {
            return -1;
        }
        int n2 = n / this.initCount;
        if (this.cacheIndexList.get(n2) <= n) {
            for (int i = n2; i < this.cacheIndexList.size() - 1; ++i) {
                if (n < this.cacheIndexList.get(i) || n >= this.cacheIndexList.get(i + 1)) continue;
                return i;
            }
        } else {
            for (int i = n2 - 1; i >= 0; --i) {
                if (n < this.cacheIndexList.get(i) || n >= this.cacheIndexList.get(i + 1)) continue;
                return i;
            }
        }
        return -1;
    }

    private ActiveFileInfo getCachePoolFileByFileIndex(int n) throws IOException, ClassNotFoundException {
        if (n < 0) {
            return null;
        }
        if (n == 0 && this.firstCacheInfo != null) {
            return this.firstCacheInfo;
        }
        Integer n2 = new Integer(n);
        if (this.cachedPoolIndexLL.remove(n2)) {
            this.cachedPoolIndexLL.add(n2);
            return (ActiveFileInfo)this.activeCachePoolMap.get(n2);
        }
        ActiveFileInfo activeFileInfo = (ActiveFileInfo)this.activeCachePoolMap.remove(this.cachedPoolIndexLL.removeFirst());
        this.ChangeActiveCachedFile(activeFileInfo);
        ArrayList arrayList = this.getActiveFileFromDisk(n);
        ActiveFileInfo activeFileInfo2 = new ActiveFileInfo(n, arrayList);
        this.cachedPoolIndexLL.add(n2);
        this.activeCachePoolMap.put(n2, activeFileInfo2);
        return activeFileInfo2;
    }

    private ArrayList getActiveFileFromDisk(int n) throws IOException, ClassNotFoundException {
        File file = (File)this.cacheFileList.get(n);
        return (ArrayList)SerializationUtils.deserializable(file);
    }

    private synchronized void ChangeActiveCachedFile(ActiveFileInfo activeFileInfo) throws IOException {
        if (activeFileInfo == null) {
            return;
        }
        if (!activeFileInfo.isChanged()) {
            return;
        }
        File file = (File)this.cacheFileList.get(activeFileInfo.getFileIndex());
        SerializationUtils.serializable(activeFileInfo.getActiveCachedPool(), file);
    }

    public synchronized void clear() {
        this.lastCachePool.clear();
        this.cacheFileList.clear();
        this.cacheIndexList.clear();
        this.cacheIndexList.add(0);
        this.initCachePoolIndexLL();
        this.activeCachePoolMap.clear();
        if (this.firstCacheInfo != null) {
            this.firstCacheInfo.activeCachedPool.clear();
            this.firstCacheInfo = null;
        }
        if (this.cacheDirectory != null) {
            StableUtils.deleteFile(this.cacheDirectory);
            this.cacheDirectory = null;
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    private File getCacheDirectory() {
        if (this.cacheDirectory == null) {
            this.cacheDirectory = new File(ManagerFactory.getCacheProvider().getCacheDirectory(), "DATA_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0));
            int n = 0;
            while (this.cacheDirectory.exists()) {
                this.cacheDirectory = new File(ManagerFactory.getCacheProvider().getCacheDirectory(), "DATA_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0) + n);
                ++n;
            }
            StableUtils.mkdirs(this.cacheDirectory);
            this.cacheDirectory.deleteOnExit();
        }
        return this.cacheDirectory;
    }

    public String toString() {
        return "FRCacheList" + this.hashCode();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.cacheDirectory != null) {
            StableUtils.deleteFile(this.cacheDirectory);
            this.cacheDirectory = null;
        }
    }

    private class ActiveFileInfo
    implements Serializable {
        private int fileIndex;
        private ArrayList activeCachedPool;
        private boolean isChanged;

        public ActiveFileInfo(int n, ArrayList arrayList) {
            this.fileIndex = n;
            this.activeCachedPool = arrayList;
            this.isChanged = false;
        }

        public int getFileIndex() {
            return this.fileIndex;
        }

        public ArrayList getActiveCachedPool() {
            return this.activeCachedPool;
        }

        public boolean isChanged() {
            return this.isChanged;
        }

        public void setChanged(boolean bl) {
            this.isChanged = bl;
        }
    }
}

