/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.Formula;
import com.fr.general.ComparatorUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class ResultFormula
extends Formula {
    private String transferContent = "";
    private boolean executed = false;

    public ResultFormula() {
    }

    public ResultFormula(Formula formula) {
        this.setContent(formula.getContent());
        this.setResult(formula.getResult());
        this.setReserveInResult(formula.isReserveInResult());
        this.setReserveOnWriteOrAnaly(formula.isReserveOnWriteOrAnaly());
    }

    public String getTransferContent() {
        if (this.transferContent.trim().startsWith("=")) {
            return this.transferContent;
        }
        return "=" + this.transferContent;
    }

    public void setTransferContent(String string) {
        this.transferContent = string;
        if (this.transferContent.trim().startsWith("=")) {
            this.transferContent = this.transferContent.trim().substring(1);
        }
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public void setExecuted() {
        this.executed = true;
    }

    public void resetExecuted() {
        this.executed = false;
    }

    public boolean isResult() {
        return true;
    }

    public String getXmlTag() {
        return "TFC";
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "TFC".equals(xMLableReader.getTagName()) && (string = xMLableReader.getElementValue()) != null) {
            this.setTransferContent(string);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (StringUtils.isNotBlank(this.transferContent)) {
            xMLPrintWriter.startTAG("TFC");
            xMLPrintWriter.textNode(this.transferContent);
            xMLPrintWriter.end();
        }
    }

    public boolean equals(Object object) {
        return object instanceof ResultFormula && super.equals(object) && ComparatorUtils.equals(this.transferContent, ((ResultFormula)object).transferContent);
    }
}

