/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.DoubleDimension2D;
import com.fr.base.FRContext;
import com.fr.base.Style;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.plugin.ExtraClassManager;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.StringUtils;
import com.fr.stable.core.FontProvider;
import com.fr.stable.fun.FontProcessor;
import com.fr.stable.fun.GraphDrawProcessor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GraphHelper {
    private static Line2D tmpLine2D = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
    private static final float MITERLIMIT = 10.0f;
    private static final float DASHINCR = 8.0f;
    private static final float DASHMIN = 4.0f;
    private static final char A = '\uac00';
    private static final char B = '\ud7a3';
    private static final char C = '\u3130';
    private static final char D = '\u318f';
    private static final char E = '\u1100';
    private static final char F = '\u11ff';
    private static final char G = '\u20a9';
    private static Font oldFont = null;
    private static FontMetrics oldFontMetrics = null;
    private static Map fontMetricsHash = new ConcurrentHashMap();
    private static Stroke[] LineStrokeArray = new Stroke[15];

    private GraphHelper() {
    }

    public static void draw(Graphics graphics, Shape shape) {
        GraphHelper.draw(graphics, shape, 1);
    }

    public static void draw(Graphics graphics, Shape shape, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        BasicStroke basicStroke = (BasicStroke)GraphHelper.getStroke(n);
        if (shape instanceof RoundRectangle2D && GraphHelper.getLineStyleSize(n) == 1) {
            basicStroke = new BasicStroke(0.2f, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase());
        }
        GraphHelper.setStroke(graphics2D, basicStroke);
        graphics2D.draw(shape);
        graphics2D.setStroke(stroke);
    }

    public static void drawLine(Graphics graphics, double d, double d2, double d3, double d4) {
        GraphHelper.drawLine(graphics, d, d2, d3, d4, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawLine(Graphics graphics, double d, double d2, double d3, double d4, int n) {
        double d5;
        int n2;
        double d6;
        if (n == 0) {
            return;
        }
        if (n == 6) {
            d6 = d3 - d;
            double d7 = d4 - d2;
            int n3 = (int)Math.sqrt(d6 * d6 + d7 * d7);
            if (n3 != 0) {
                int n4 = (int)(-d7 / (double)n3);
                int n5 = (int)(d6 / (double)n3);
                GraphHelper.drawLine(graphics, d - (double)n4, d2 - (double)n5, d3 - (double)n4, d4 - (double)n5, 1);
                GraphHelper.drawLine(graphics, d + (double)n4, d2 + (double)n5, d3 + (double)n4, d4 + (double)n5, 1);
                return;
            }
        } else if (n == 15 && (n2 = (int)Math.sqrt((d6 = d3 - d) * d6 + (d5 = d4 - d2) * d5)) != 0) {
            boolean bl = true;
            int n6 = (int)(-d5 * (double)bl / (double)n2);
            int n7 = (int)(d6 * (double)bl / (double)n2);
            GraphHelper.drawLine(graphics, d, d2, d3, d4, 7);
            GraphHelper.drawLine(graphics, d + (double)n6, d2 + (double)n7, d3 + (double)n6, d4 + (double)n7, 7);
            return;
        }
        Line2D line2D = tmpLine2D;
        synchronized (line2D) {
            tmpLine2D.setLine(d, d2, d3, d4);
            GraphHelper.draw(graphics, tmpLine2D, n);
        }
    }

    public static void drawRect(Graphics graphics, double d, double d2, double d3, double d4) {
        GraphHelper.drawRect(graphics, d, d2, d3, d4, 1);
    }

    public static void drawRect(Graphics graphics, double d, double d2, double d3, double d4, int n) {
        GraphHelper.draw(graphics, new Rectangle2D.Double(d, d2, d3, d4), n);
    }

    public static void drawArc(Graphics graphics, double d, double d2, double d3, double d4, double d5, double d6) {
        GraphHelper.drawArc(graphics, d, d2, d3, d4, d5, d6, 1);
    }

    public static void drawArc(Graphics graphics, double d, double d2, double d3, double d4, double d5, double d6, int n) {
        GraphHelper.draw(graphics, new Arc2D.Double(d, d2, d3, d4, d5, d6, 2), n);
    }

    public static void fill(Graphics graphics, Shape shape) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.fill(shape);
    }

    public static void fillRect(Graphics graphics, double d, double d2, double d3, double d4) {
        GraphHelper.fill(graphics, new Rectangle2D.Double(d, d2, d3, d4));
    }

    public static void fillArc(Graphics graphics, double d, double d2, double d3, double d4, double d5, double d6) {
        GraphHelper.fill(graphics, new Arc2D.Double(d, d2, d3, d4, d5, d6, 2));
    }

    public static void drawString(Graphics graphics, String string, double d, double d2) {
        if (StringUtils.isBlank(string)) {
            return;
        }
        if (graphics.getFont() instanceof FRFont) {
            FRFont fRFont = (FRFont)graphics.getFont();
            FontMetrics fontMetrics = graphics.getFontMetrics(fRFont);
            int n = fRFont.getStyle();
            if (fRFont.isSuperscript()) {
                d2 -= (double)(fontMetrics.getAscent() / 3);
                fRFont = FRFont.getInstance(fRFont.getName(), n, fRFont.getSize() * 2 / 3, fRFont.getForeground(), fRFont.getUnderline(), fRFont.isStrikethrough(), fRFont.isShadow(), fRFont.isSuperscript(), fRFont.isSubscript());
                fontMetrics = graphics.getFontMetrics(fRFont);
                graphics.setFont(fRFont);
            } else if (fRFont.isSubscript()) {
                d2 += (double)(fontMetrics.getDescent() / 3);
                fRFont = FRFont.getInstance(fRFont.getName(), n, fRFont.getSize() * 2 / 3, fRFont.getForeground(), fRFont.getUnderline(), fRFont.isStrikethrough(), fRFont.isShadow(), fRFont.isSuperscript(), fRFont.isSubscript());
                fontMetrics = graphics.getFontMetrics(fRFont);
                graphics.setFont(fRFont);
            }
            if (fRFont.isShadow()) {
                Color color = graphics.getColor();
                graphics.setColor(color.brighter());
                GraphHelper.drawNormalString(graphics, string, d + 1.0, d2 + 1.0);
                graphics.setColor(color);
            }
            GraphHelper.drawNormalString(graphics, string, d, d2);
            if (fRFont.getUnderline() != 0) {
                double d3 = d2 + (double)fontMetrics.getDescent() + (double)GraphHelper.getLineStyleSize(fRFont.getUnderline());
                GraphHelper.drawLine(graphics, d, d3, d + (double)fontMetrics.stringWidth(string), d3, fRFont.getUnderline());
            }
            if (fRFont.isStrikethrough()) {
                int n2 = fontMetrics.getHeight() + 1;
                double d4 = d2 - (double)fontMetrics.getAscent() + (double)(n2 / 2);
                GraphHelper.drawLine(graphics, d, d4, d + (double)fontMetrics.stringWidth(string), d4, 1);
            }
        } else {
            GraphHelper.drawNormalString(graphics, string, d, d2);
        }
    }

    private static void drawNormalString(Graphics graphics, String string, double d, double d2) {
        if (StringUtils.isEmpty(string)) {
            return;
        }
        Font font = GraphHelper.initFont(graphics);
        FRFont fRFont = FRFont.getInstance(Inter.getLocText("FR-Base-Song_TypeFace"), font.getStyle(), font.getSize());
        char[] cArray = new char[1];
        int n = (int)d;
        int n2 = (int)d2;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            if (font.canDisplay(c)) {
                cArray[0] = c;
                graphics.drawChars(cArray, 0, 1, n, n2);
                n += GraphHelper.getFontMetrics(font).charWidth(c);
                continue;
            }
            if (GraphHelper.isKoreanCharacter(string, fRFont)) {
                Font font2 = new Font("", font.getSize(), font.getSize());
                graphics.setFont(font2);
            } else {
                graphics.setFont(fRFont);
            }
            cArray[0] = c;
            graphics.drawChars(cArray, 0, 1, n, n2);
            n += GraphHelper.getFontMetrics(fRFont).charWidth(c);
            graphics.setFont(font);
        }
    }

    private static Font initFont(Graphics graphics) {
        Font font = graphics.getFont();
        FontProcessor fontProcessor = (FontProcessor)ExtraClassManager.getInstance().getSingle("FontProcessor");
        if (fontProcessor != null) {
            font = fontProcessor.readExtraFont(font);
            graphics.setFont(font);
        }
        return font;
    }

    private static boolean isKoreanCharacter(String string, Font font) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (!GraphHelper.inKoreanCharacter(cArray[i]) && font.canDisplay(cArray[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean inKoreanCharacter(char c) {
        return c >= '\uac00' && c <= '\ud7a3' || c > '\u3130' && c < '\u318f' || c > '\u1100' && c < '\u11ff' || c == '\u20a9';
    }

    public static void drawString2(Graphics graphics, String string, double d, double d2, int n) {
        if (StringUtils.isBlank(string)) {
            return;
        }
        if (graphics.getFont() instanceof FRFont) {
            FRFont fRFont = (FRFont)graphics.getFont();
            FontMetrics fontMetrics = graphics.getFontMetrics(fRFont);
            int n2 = fRFont.getStyle();
            if (fRFont.isSuperscript()) {
                d2 -= (double)(fontMetrics.getAscent() / 3);
                fRFont = FRFont.getInstance(fRFont.getName(), n2, fRFont.getSize() * 2 / 3, fRFont.getForeground(), fRFont.getUnderline(), fRFont.isStrikethrough(), fRFont.isShadow(), fRFont.isSuperscript(), fRFont.isSubscript());
                fontMetrics = graphics.getFontMetrics(fRFont);
                graphics.setFont(fRFont);
            } else if (fRFont.isSubscript()) {
                d2 += (double)(fontMetrics.getDescent() / 3);
                fRFont = FRFont.getInstance(fRFont.getName(), n2, fRFont.getSize() * 2 / 3, fRFont.getForeground(), fRFont.getUnderline(), fRFont.isStrikethrough(), fRFont.isShadow(), fRFont.isSuperscript(), fRFont.isSubscript());
                fontMetrics = graphics.getFontMetrics(fRFont);
                graphics.setFont(fRFont);
            }
            if (fRFont.isShadow()) {
                Color color = graphics.getColor();
                graphics.setColor(color.brighter());
                GraphHelper.drawNormalString2(graphics, string, d + 1.0, d2 + 1.0, n);
                graphics.setColor(color);
            }
            GraphHelper.drawNormalString2(graphics, string, d, d2, n);
            if (fRFont.getUnderline() != 0) {
                double d3 = d2 + (double)fontMetrics.getDescent() + (double)GraphHelper.getLineStyleSize(fRFont.getUnderline());
                GraphHelper.drawLine(graphics, d, d3, d + (double)fontMetrics.stringWidth(string), d3, fRFont.getUnderline());
            }
            if (fRFont.isStrikethrough()) {
                int n3 = fontMetrics.getHeight() + 1;
                double d4 = d2 - (double)fontMetrics.getAscent() + (double)(n3 / 2);
                GraphHelper.drawLine(graphics, d, d4, d + (double)fontMetrics.stringWidth(string), d4, 1);
            }
        } else {
            GraphHelper.drawNormalString2(graphics, string, d, d2, n);
        }
    }

    private static void drawNormalString2(Graphics graphics, String string, double d, double d2, int n) {
        int n2;
        PP[] pPArray;
        if (StringUtils.isEmpty(string)) {
            return;
        }
        Font font = graphics.getFont();
        Font font2 = null;
        char[] cArray = new char[1];
        int n3 = (int)d;
        int n4 = (int)d2;
        int n5 = string.length();
        n3 = GraphHelper.initPPsAndChartX(string, n5, n3, font2, font, graphics, pPArray = new PP[n5]);
        int n6 = n3 - (int)d;
        if (n6 < n - 1 && n5 > 1) {
            n2 = n - n6;
            int n7 = n2 / (n5 - 1);
            int n8 = n2 % (n5 - 1);
            double d3 = 0.0;
            if (n8 != 0) {
                d3 = (double)n8 / (double)(n5 - 1);
            }
            double d4 = 0.0;
            int n9 = 0;
            for (int i = 1; i < pPArray.length; ++i) {
                n9 += n7;
                if ((d4 += d3) > 1.0) {
                    ++n9;
                    d4 -= 1.0;
                }
                PP pP = pPArray[i];
                pP.textX = pP.textX + n9;
            }
        }
        for (n2 = 0; n2 < pPArray.length; ++n2) {
            if (pPArray[n2].font != font) {
                graphics.setFont(pPArray[n2].font);
            }
            cArray[0] = pPArray[n2].c;
            graphics.drawChars(cArray, 0, 1, pPArray[n2].textX, n4);
            if (pPArray[n2].font == font) continue;
            graphics.setFont(font);
        }
    }

    private static int initPPsAndChartX(String string, int n, int n2, Font font, Font font2, Graphics graphics, PP[] pPArray) {
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (font2.canDisplay(c)) {
                pPArray[i] = new PP(c, font2, n2);
                n2 += GraphHelper.getFontMetrics(font2).charWidth(c);
                continue;
            }
            if (font == null) {
                font = new Font(Inter.getLocText("FR-Base-Song_TypeFace"), font2.getStyle(), font2.getSize());
            }
            graphics.setFont(font);
            pPArray[i] = new PP(c, font, n2);
            n2 += GraphHelper.getFontMetrics(font).charWidth(c);
            graphics.setFont(font2);
        }
        return n2;
    }

    public static void drawRotatedString(Graphics graphics, String string, double d, double d2, int n) {
        GraphHelper.drawRotatedString(graphics, string, d, d2, n, 1.0);
    }

    public static void drawRotatedString(Graphics graphics, String string, double d, double d2, int n, double d3) {
        if (string == null || string.length() == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Font font = graphics2D.getFont();
        if (font instanceof FRFont) {
            GraphHelper.createCellFont(graphics2D, (FRFont)font, d2);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        double d4 = lineMetrics.getDescent();
        double d5 = lineMetrics.getLeading();
        double[] dArray = new double[]{-rectangle2D.getWidth() / 2.0, -d4 - d5 + rectangle2D.getHeight() / 2.0};
        double[] dArray2 = new double[]{rectangle2D.getWidth() / 2.0, d4 + d5 - rectangle2D.getHeight() / 2.0};
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.transform(AffineTransform.getRotateInstance(Math.toRadians(n), d + dArray[0] + dArray2[0], d2 + dArray[1] + dArray2[1]));
        if (graphics2D.getFont() instanceof FRFont) {
            GraphHelper.drawTextWithFRFont((FRFont)graphics2D.getFont(), graphics2D, string, d, d2, d3, fontMetrics, dArray);
        } else {
            TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), graphics2D.getFontRenderContext());
            graphics2D.scale(d3, d3);
            textLayout.draw(graphics2D, (float)((d + dArray[0]) / d3), (float)((d2 + dArray[1]) / d3));
            graphics2D.scale(1.0 / d3, 1.0 / d3);
        }
        graphics2D.setTransform(affineTransform);
    }

    private static void drawTextWithFRFont(FRFont fRFont, Graphics2D graphics2D, String string, double d, double d2, double d3, FontMetrics fontMetrics, double[] dArray) {
        TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), graphics2D.getFontRenderContext());
        float f = (float)(d + dArray[0]);
        float f2 = (float)(d2 + dArray[1]);
        if (fRFont.isShadow()) {
            Color color = graphics2D.getColor();
            graphics2D.setColor(color.brighter());
            graphics2D.scale(d3, d3);
            textLayout.draw(graphics2D, (float)((double)(f + 1.0f) / d3), (float)((double)(f2 + 1.0f) / d3));
            graphics2D.scale(1.0 / d3, 1.0 / d3);
            graphics2D.setColor(color);
        }
        int n = fontMetrics.stringWidth(string);
        GraphHelper.drawLine(graphics2D, f, f2 + (float)fontMetrics.getDescent(), f + (float)n, f2 + (float)fontMetrics.getDescent(), fRFont.getUnderline());
        if (fRFont.isStrikethrough()) {
            GraphHelper.drawLine(graphics2D, f, f2 + (float)fontMetrics.getDescent() - (float)(fontMetrics.getAscent() / 2) - (float)(fontMetrics.getDescent() / 2), f + (float)n, f2 + (float)fontMetrics.getDescent() - (float)(fontMetrics.getAscent() / 2) - (float)(fontMetrics.getDescent() / 2));
        }
        graphics2D.scale(d3, d3);
        textLayout.draw(graphics2D, (float)((double)f / d3), (float)((double)f2 / d3));
        graphics2D.scale(1.0 / d3, 1.0 / d3);
    }

    private static void createCellFont(Graphics2D graphics2D, FRFont fRFont, double d) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics(fRFont);
        int n = fRFont.getStyle();
        if (fRFont.isSuperscript()) {
            d -= (double)(fontMetrics.getAscent() / 3);
            fRFont = FRFont.getInstance(fRFont.getName(), n, fRFont.getSize() * 2 / 3, fRFont.getForeground(), fRFont.getUnderline(), fRFont.isStrikethrough(), fRFont.isShadow(), fRFont.isSuperscript(), fRFont.isSubscript());
            graphics2D.setFont(fRFont);
        } else if (fRFont.isSubscript()) {
            d += (double)(fontMetrics.getDescent() / 3);
            fRFont = FRFont.getInstance(fRFont.getName(), n, fRFont.getSize() * 2 / 3, fRFont.getForeground(), fRFont.getUnderline(), fRFont.isStrikethrough(), fRFont.isShadow(), fRFont.isSuperscript(), fRFont.isSubscript());
            graphics2D.setFont(fRFont);
        }
    }

    public static BufferedImage createBufferedImageFromImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        CoreGraphHelper.waitForImage(image);
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        return bufferedImage;
    }

    public static BufferedImage createBufferedImageFromImageWithLayout(Image image, int n, int n2, Style style) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        CoreGraphHelper.waitForImage(image);
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        int n3 = CoreGraphHelper.changeImageLayout4Draw(image, style.getImageLayout(), n, n2);
        GraphHelper.paintImage(graphics2D, n, n2, image, n3, style.getHorizontalAlignment(), style.getVerticalAlignment(), -1, -1);
        return bufferedImage;
    }

    public static void setStroke(Graphics2D graphics2D, Stroke stroke) {
        Stroke stroke2 = graphics2D.getStroke();
        if (stroke.hashCode() != stroke2.hashCode()) {
            graphics2D.setStroke(stroke);
        }
    }

    public static Stroke getStroke(int n) {
        Stroke stroke = null;
        if (n < LineStrokeArray.length) {
            stroke = LineStrokeArray[n];
            if (stroke != null) {
                return stroke;
            }
        } else {
            Stroke[] strokeArray = LineStrokeArray;
            LineStrokeArray = new Stroke[Math.max(10, strokeArray.length * 2)];
            System.arraycopy(strokeArray, 0, LineStrokeArray, 0, strokeArray.length);
        }
        int n2 = 0;
        int n3 = 0;
        if ((stroke = GraphHelper.createStrokeWithLineStyle(stroke, n)) == null) {
            stroke = new BasicStroke(1.0f, n2, n3);
        }
        GraphHelper.LineStrokeArray[n] = stroke;
        return stroke;
    }

    private static Stroke createStrokeWithLineStyle(Stroke stroke, int n) {
        int n2 = 0;
        int n3 = 0;
        if (n == 1 || n == 21) {
            stroke = new BasicStroke(1.0f, n2, n3);
        } else if (n == 2 || n == 22) {
            stroke = new BasicStroke(2.0f, n2, n3);
        } else if (n == 16) {
            stroke = new BasicStroke(3.0f, n2, n3);
        } else if (n == 3) {
            stroke = new BasicStroke(1.0f, n2, n3, 10.0f, new float[]{4.0f, 2.0f}, 0.0f);
        } else if (n == 4) {
            stroke = new BasicStroke(1.0f, n2, n3, 10.0f, new float[]{2.0f}, 0.0f);
        } else if (n == 5 || n == 23) {
            stroke = new BasicStroke(3.0f, n2, n3);
        } else if (n == 7) {
            stroke = new BasicStroke(1.0f, n2, n3, 10.0f, new float[]{1.0f}, 0.0f);
        } else if (n == 8) {
            stroke = new BasicStroke(2.0f, n2, n3, 10.0f, new float[]{8.0f, 2.0f}, 0.0f);
        } else if (n == 9) {
            stroke = new BasicStroke(1.0f, n2, n3, 10.0f, new float[]{8.0f, 4.0f, 2.0f, 4.0f}, 0.0f);
        } else if (n == 10) {
            stroke = new BasicStroke(2.0f, n2, n3, 10.0f, new float[]{8.0f, 4.0f, 2.0f, 4.0f}, 0.0f);
        } else if (n == 11) {
            stroke = new BasicStroke(1.0f, n2, n3, 10.0f, new float[]{8.0f, 4.0f, 2.0f, 4.0f, 2.0f, 4.0f}, 0.0f);
        } else if (n == 12) {
            stroke = new BasicStroke(2.0f, n2, n3, 10.0f, new float[]{8.0f, 4.0f, 2.0f, 4.0f, 2.0f, 4.0f}, 0.0f);
        } else if (n == 13) {
            stroke = new BasicStroke(2.0f, n2, n3, 10.0f, new float[]{8.0f, 4.0f, 2.0f, 4.0f}, 0.0f);
        } else if (n == 14) {
            stroke = new BasicStroke(1.0f, n2, n3, 10.0f, new float[]{4.0f}, 0.0f);
        }
        return stroke;
    }

    public static int getLineStyleSize(int n) {
        if (n == 0) {
            return 0;
        }
        if (n == 2 || n == 6 || n == 8 || n == 10 || n == 12 || n == 13) {
            return 2;
        }
        if (n == 5) {
            return 3;
        }
        return 1;
    }

    public static double stringWidth(String string, Font font, FontRenderContext fontRenderContext) {
        FontProvider fontProvider;
        if (string == null || string.length() <= 0) {
            return 0.0;
        }
        double d = font.getStringBounds(string, fontRenderContext).getWidth();
        if (font instanceof FontProvider && ((fontProvider = (FontProvider)((Object)font)).isSuperscript() || fontProvider.isSubscript())) {
            d = d * 2.0 / 3.0;
        }
        return d;
    }

    public static int getLocTextWidth(String string, Font font) {
        String string2 = Inter.getLocText(string);
        FontMetrics fontMetrics = GraphHelper.getFontMetrics(font);
        return fontMetrics.stringWidth(string2);
    }

    public static int getLocTextWidth(String string) {
        Font font = FRFont.getInstance().applyResolutionNP(96);
        return GraphHelper.getLocTextWidth(string, font);
    }

    public static Dimension2D stringDimensionWithRotation(String string, Font font, int n, FontRenderContext fontRenderContext) {
        Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
        double d = rectangle2D.getWidth();
        double d2 = Math.toRadians(n);
        return new DoubleDimension2D(d * Math.abs(Math.cos(d2)) + rectangle2D.getHeight() * Math.abs(Math.sin(d2)), d * Math.abs(Math.sin(d2)) + rectangle2D.getHeight() * Math.abs(Math.cos(d2)));
    }

    public static FontMetrics getFontMetrics(Font font, Graphics2D graphics2D) {
        if (graphics2D == null) {
            return GraphHelper.getFontMetrics(font);
        }
        return graphics2D.getFontMetrics(font);
    }

    public static FontMetrics getFontMetrics(Font font) {
        Serializable serializable;
        if (font == oldFont) {
            return oldFontMetrics;
        }
        if (font == null) {
            serializable = FRContext.getDefaultValues();
            font = serializable.getFRFont();
        }
        if ((serializable = (FontMetrics)fontMetricsHash.get(font)) == null) {
            serializable = Toolkit.getDefaultToolkit().getFontMetrics(font);
            fontMetricsHash.put(font, serializable);
        }
        oldFont = font;
        oldFontMetrics = serializable;
        return serializable;
    }

    public static void paintImage(Graphics graphics, int n, int n2, Image image, int n3, int n4, int n5, int n6, int n7) {
        GraphDrawProcessor graphDrawProcessor = (GraphDrawProcessor)ExtraClassManager.getInstance().getSingle("GraphDrawProcessor");
        if (graphDrawProcessor != null) {
            graphDrawProcessor.paintImage(graphics, n, n2, image, n3, n4, n5, n6, n7);
        } else {
            GraphHelper.paintImageMoved(graphics, n, n2, image, n3, n4, n5, n6, n7, 0, 0, false);
        }
    }

    public static void paintImage(Graphics graphics, int n, int n2, Image image, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        GraphHelper.paintImageMoved(graphics, n, n2, image, n3, n4, n5, n6, n7, 0, 0, bl);
    }

    public static void paintImageMoved(Graphics graphics, int n, int n2, Image image, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl) {
        GraphHelper.paintImageMoved(graphics, n, n2, image, n3, n4, n5, n6, n7, n8, n9, bl, Color.white);
    }

    public static void paintImageMoved(Graphics graphics, int n, int n2, Image image, int n3) {
        GraphHelper.paintImageMoved(graphics, n, n2, image, n3, 0, 0, -1, -1, 0, 0, true, Color.WHITE);
    }

    public static void paintImageMoved(Graphics graphics, int n, int n2, Image image, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, Color color) {
        if (image == null) {
            return;
        }
        CoreGraphHelper.waitForImage(image);
        int n10 = n6 == -1 ? image.getWidth(null) : n6;
        int n11 = n7 == -1 ? image.getHeight(null) : n7;
        if (n10 < 0 || n11 < 0) {
            return;
        }
        if ((n3 = CoreGraphHelper.changeImageLayout4Draw(image, n3, n, n2)) == 0) {
            GraphHelper.drawLayoutTile(graphics, n, n2, image, n10, n11, n8, n9, color);
        } else if (n3 == 1) {
            GraphHelper.drawLayoutCenter(graphics, n, n2, image, n10, n11, n8, n9, bl, color);
        } else if (n3 == 4) {
            GraphHelper.drawLayoutAdjust(graphics, n, n2, image, n8, n9, color, bl);
        } else if (n3 == 2) {
            for (int i = -n8 % n; i < n; i += n) {
                for (int j = -n9 % n2; j < n2; j += n2) {
                    graphics.drawImage(image, i, j, n, n2, null);
                }
            }
        } else if (n3 == 3) {
            GraphHelper.drawLayoutDefault(graphics, n, n2, image, n10, n11, n4, n5, n8, n9, bl, color);
        }
    }

    private static void drawLayoutTile(Graphics graphics, int n, int n2, Image image, int n3, int n4, int n5, int n6, Color color) {
        int n7 = -n5;
        int n8 = -n5;
        for (int i = -n5; i < n; i += n3) {
            if ((i + n5) / n > (n7 + n5) / n) {
                i = ((n7 + n5) / n + 1) * n - n5;
            }
            for (int j = -n6; j < n2; j += n4) {
                if ((j + n6) / n2 > (n8 + n6) / n2) {
                    j = ((n8 + n6) / n2 + 1) * n2 - n6;
                }
                try {
                    graphics.drawImage(image, i, j, n3, n4, null);
                }
                catch (Exception exception) {
                    BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(n3, n4, 2);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.setPaint(color);
                    GraphHelper.paintImage(graphics2D, n3, n4, image, 2, -1, 0, -1, -1);
                    graphics.drawImage(bufferedImage, i, j, n3, n4, null);
                }
                n7 = i;
                n8 = j;
            }
        }
    }

    private static void drawLayoutCenter(Graphics graphics, int n, int n2, Image image, int n3, int n4, int n5, int n6, boolean bl, Color color) {
        for (int i = ((n - n3) / 2 - n5) % n; i < n; i += n) {
            for (int j = ((n2 - n4) / 2 - n6) % n2; j < n2; j += n2) {
                graphics.drawImage(image, Math.max(i, i - (n - n3) / 2), Math.max(j, j - (n2 - n4) / 2), i > i - (n - n3) / 2 ? n3 : n, j > j - (n2 - n4) / 2 ? n4 : n2, null);
                if (!bl) continue;
                Color color2 = graphics.getColor();
                graphics.setColor(color);
                if (n2 > n4) {
                    graphics.fillRect(n5 % n, n6 % n2, n, (n2 - n4) / 2);
                    graphics.fillRect(n5 % n, Math.max(j, j - (n2 - n4) / 2) + n4, n, (n2 - n4) / 2);
                }
                if (n > n3) {
                    graphics.fillRect(n5 % n, n6 % n2, (n - n3) / 2, n2);
                    graphics.fillRect(Math.max(i, i - (n - n3) / 2) + n3, n6 % n2, (n - n3) / 2, n2);
                }
                graphics.setColor(color2);
            }
        }
    }

    private static void drawLayoutAdjust(Graphics graphics, int n, int n2, Image image, int n3, int n4, Color color, boolean bl) {
        if (n == 0 || n2 == 0) {
            return;
        }
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        for (int i = -n3 % n; i < n; i += n) {
            for (int j = -n4 % n2; j < n2; j += n2) {
                double d = (double)n / (double)n5;
                double d2 = (double)n2 / (double)n6;
                int n7 = i;
                int n8 = j;
                int n9 = n;
                int n10 = n2;
                if (d > d2) {
                    n9 = (int)((double)n * d2 / d);
                    i = (n - n9) / 2;
                } else {
                    n10 = (int)((double)n2 * d / d2);
                    j = (n2 - n10) / 2 + j;
                }
                Color color2 = graphics.getColor();
                if (bl) {
                    graphics.setColor(color);
                    graphics.fillRect(i, j, n, n2);
                    graphics.setColor(color2);
                }
                graphics.drawImage(image, i, j, n9, n10, null);
                if (!bl || n7 != 0 || n8 != 0) continue;
                GraphHelper.drawWhiteRec(graphics, color, n10, n9, n, n2, color2);
            }
        }
    }

    private static void drawWhiteRec(Graphics graphics, Color color, int n, int n2, int n3, int n4, Color color2) {
        graphics.setColor(color);
        if (n3 > n2) {
            graphics.fillRect(0, 0, (n3 - n2) / 2, n4);
        }
        if (n4 > n) {
            graphics.fillRect(0, 0, n3, (n4 - n) / 2);
        }
        graphics.setColor(color2);
    }

    private static void drawLayoutDefault(Graphics graphics, int n, int n2, Image image, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, Color color) {
        int n9 = n5 == 4 ? n - n3 - n7 : (n5 == 0 ? (n - n3) / 2 - n7 : -n7);
        int n10 = n6 == 3 ? n2 - n4 - n8 : (n6 == 0 ? (n2 - n4) / 2 - n8 : -n8);
        if (n3 > 0 && n4 > 0) {
            for (int i = n9 % n; i < n; i += n) {
                for (int j = n10 % n2; j < n2; j += n2) {
                    graphics.drawImage(image, i, j, n3, n4, null);
                    if (!bl) continue;
                    Color color2 = graphics.getColor();
                    graphics.setColor(color);
                    if (n > n3) {
                        graphics.fillRect(n3, j, n - n3, n2);
                    }
                    if (n2 > n4) {
                        graphics.fillRect(i, n4, n, n2 - n4);
                    }
                    graphics.setColor(color2);
                }
            }
        }
    }

    private static class PP {
        private char c;
        private Font font;
        private int textX;

        public PP(char c, Font font, int n) {
            this.c = c;
            this.font = font;
            this.textX = n;
        }
    }
}

