/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.general.ComparatorUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public abstract class DynamicValueList
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected long[] elementInts;
    private int size;
    protected long defaultValue = 1L;

    protected DynamicValueList(long l) {
        this(l, 10);
    }

    protected DynamicValueList(long l, int n) {
        this.elementInts = new long[n];
        Arrays.fill(this.elementInts, l);
        this.size = this.elementInts.length;
        this.defaultValue = l;
    }

    protected long getDefaultLongValue() {
        return this.defaultValue;
    }

    protected void setDefaultValue(long l) {
        this.defaultValue = l;
    }

    public int size() {
        return this.size;
    }

    protected long getValue(int n) {
        if (n < 0 || n >= this.size) {
            return this.defaultValue;
        }
        return this.elementInts[n];
    }

    protected void set(int n, long l) {
        if (n < 0) {
            return;
        }
        if (n >= this.size) {
            if (l == this.defaultValue) {
                return;
            }
            this.ensureCapacity(n + 1);
        }
        this.elementInts[n] = l;
        if (n >= this.size) {
            this.size = n + 1;
        }
    }

    public void insert(int n) {
        this.insert(n, 1);
    }

    public void insert(int n, int n2) {
        if (n < 0 || n2 <= 0 || n >= this.size) {
            return;
        }
        this.ensureCapacity(this.size + n2);
        System.arraycopy(this.elementInts, n, this.elementInts, n + n2, this.size - n);
        Arrays.fill(this.elementInts, n, n + n2, this.defaultValue);
        this.size += n2;
    }

    protected long removeValue(int n) {
        if (n < 0 || n >= this.size) {
            return this.defaultValue;
        }
        long l = this.elementInts[n];
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementInts, n + 1, this.elementInts, n, n2);
        }
        this.elementInts[--this.size] = this.defaultValue;
        return l;
    }

    public void reset() {
        Arrays.fill(this.elementInts, this.defaultValue);
        this.size = 0;
    }

    protected long getRangeLongValueFromZero(int n) {
        return this.getRangeLongValue(0, n);
    }

    protected long getRangeLongValueExcludeHidden(int n, HashSet hashSet) {
        return this.getRangeLongValueExcludeHidden(0, n, hashSet);
    }

    protected long getRangeLongValue(int n, int n2) {
        int n3;
        long l = 0L;
        boolean bl = n <= n2;
        int n4 = bl ? n : n2;
        int n5 = bl ? n2 : n;
        boolean bl2 = this.defaultValue != 1L;
        n4 = n4 > 0 ? n4 : 0;
        boolean bl3 = n5 > this.elementInts.length;
        int n6 = n3 = bl3 ? this.elementInts.length : n5;
        for (int i = n4; i < n3; ++i) {
            l += this.elementInts[i];
        }
        if (bl3) {
            long l2 = n5 - Math.max(this.elementInts.length, n4);
            l2 = bl2 ? l2 * this.defaultValue : l2;
            l += l2;
        }
        return n <= n2 ? l : -l;
    }

    protected long getRangeLongValueExcludeHidden(int n, int n2, HashSet hashSet) {
        long l = 0L;
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        long l2 = 0L;
        if (hashSet != null && hashSet.size() > 0) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                int n5 = (Integer)iterator.next();
                l2 += n5 < this.elementInts.length ? this.elementInts[n5] : this.defaultValue;
            }
        }
        int n6 = Math.min(n4, this.elementInts.length);
        for (int i = n3 = Math.max(0, n3); i < n6; ++i) {
            l += this.elementInts[i];
        }
        if (n4 > this.elementInts.length) {
            l += (long)(n4 - Math.max(this.elementInts.length, n3)) * this.defaultValue;
        }
        return n <= n2 ? l : -(l -= l2);
    }

    protected int getValueIndex(long l) {
        return this.getValueIndex(l, 0);
    }

    protected int getValueIndex(long l, int n) {
        int n2 = 0;
        int n3 = n;
        while ((long)(n2 = (int)((long)n2 + this.getValue(n3))) <= l) {
            ++n3;
        }
        return n3;
    }

    private void ensureCapacity(int n) {
        int n2 = this.elementInts.length;
        if (n > n2) {
            long[] lArray = this.elementInts;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.elementInts = new long[n3];
            System.arraycopy(lArray, 0, this.elementInts, 0, lArray.length);
            Arrays.fill(this.elementInts, lArray.length, this.elementInts.length, this.defaultValue);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DynamicValueList dynamicValueList = (DynamicValueList)super.clone();
        dynamicValueList.elementInts = (long[])this.elementInts.clone();
        return dynamicValueList;
    }

    public boolean equals(Object object) {
        return object instanceof DynamicValueList && ComparatorUtils.equals(this.elementInts, ((DynamicValueList)object).elementInts) && this.size == ((DynamicValueList)object).size && this.defaultValue == ((DynamicValueList)object).defaultValue;
    }
}

