/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.DynamicUnitList;
import com.fr.general.ComparatorUtils;
import com.fr.stable.unit.FU;

public class DynamicPixList {
    private long[] elements;
    private long defaultValue;
    private int size;

    public DynamicPixList(DynamicUnitList dynamicUnitList) {
        this.elements = new long[dynamicUnitList.size() + 1];
        this.size = dynamicUnitList.size();
        long l = 0L;
        for (int i = 0; i < this.size; ++i) {
            l += dynamicUnitList.elementInts[i];
            if (this.elements.length <= i + 1) continue;
            this.elements[i + 1] = l;
        }
        this.defaultValue = dynamicUnitList.getDefaultUnit().toFU();
    }

    public int get(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        if (n >= this.size) {
            return FU.toPixI(this.elements[this.size] + (long)(n - this.size + 1) * this.defaultValue, n2) - FU.toPixI(this.elements[this.size] + (long)(n - this.size) * this.defaultValue, n2);
        }
        return FU.toPixI(this.elements[n + 1], n2) - FU.toPixI(this.elements[n], n2);
    }

    public long getElement(int n) {
        if (n < 0 || n > this.size) {
            return 0L;
        }
        return this.elements[n];
    }

    public int getElementSize() {
        return this.elements != null ? this.elements.length : 0;
    }

    public int getRangeValueFromZero(int n, int n2) {
        return this.getRangeValue(0, n, n2);
    }

    public int getRangeValue(int n, int n2, int n3) {
        int n4 = 0;
        n = Math.max(0, n);
        n2 = Math.max(0, n2);
        int n5 = Math.min(n, n2);
        int n6 = Math.max(n, n2);
        if (n5 >= this.size) {
            n4 = FU.toPixI(this.elements[this.size] + (long)(n6 - this.size) * this.defaultValue, n3) - FU.toPixI(this.elements[this.size] + (long)(n5 - this.size) * this.defaultValue, n3);
        } else {
            long l = this.elements[n5];
            long l2 = n6 > this.size ? this.elements[this.size] + (long)(n6 - this.size) * this.defaultValue : this.elements[n6];
            n4 = FU.toPixI(l2, n3) - FU.toPixI(l, n3);
        }
        return n <= n2 ? n4 : -n4;
    }

    public boolean equals(Object object) {
        return object instanceof DynamicPixList && ComparatorUtils.equals(this.elements, ((DynamicPixList)object).elements) && this.defaultValue == ((DynamicPixList)object).defaultValue && this.size == ((DynamicPixList)object).size;
    }
}

