/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.ExcelImportAttr;
import com.fr.file.XMLFileManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLTools;
import com.fr.stable.xml.XMLableReader;
import java.io.InputStream;

public class CustomConfigManager
extends XMLFileManager {
    private static final long DEFAULT_DIGITAL_PRIVILEGE = 90000L;
    private static final long DEFAULT_USERNAME_PRIVILEGE = 1200000L;
    private static final String PRIVILEGE_TIMEOUT_XML = "privilegeTimeout";
    private static final String DIGITAL_PRIVILEGE_XML = "digitalPrivilegeTimeout";
    private static final String USERNAME_PRIVILEGE_XML = "usernamePrivilegeTimeout";
    private static final String EXPORT_FULL_IMAGE = "exportFullImage";
    private static final String EXCEL_ADJUST = "excelAdjust";
    public static final String REPORT_PREFIX = "reportPrefix";
    private long digitalPrivilegeTimeout = 90000L;
    private long usernamePrivilegeTimeout = 1200000L;
    private boolean exportFullImg4Excel = false;
    private float excelAdjustHeight = 20.1f;
    private double excelAdjustWidth = 34.742;
    private boolean checkWidget = false;
    private boolean printWidget = false;
    private boolean polyBlocksShowInOne = true;
    private String reportPrefix = "";
    private String preReportPrefix = "";
    private boolean readDialectAgain = false;
    private ExcelImportAttr excelImportAttr = new ExcelImportAttr();
    private static CustomConfigManager configManager = null;

    public static synchronized CustomConfigManager getInstance() {
        if (configManager == null) {
            configManager = new CustomConfigManager();
            configManager.readXMLFile();
        }
        return configManager;
    }

    private static synchronized void envChanged() {
        configManager = null;
    }

    private CustomConfigManager() {
    }

    public long getUsernamePrivilegeTimeout() {
        return this.usernamePrivilegeTimeout;
    }

    public void setUsernamePrivilegeTimeout(long l) {
        this.usernamePrivilegeTimeout = l;
    }

    public long getDigitalPrivilegeTimeout() {
        return this.digitalPrivilegeTimeout;
    }

    public void setDigitalPrivilegeTimeout(long l) {
        this.digitalPrivilegeTimeout = l;
    }

    public boolean isImportDoubleDir() {
        return this.excelImportAttr.isImportDouble();
    }

    public void setImportDoubleDir(boolean bl) {
        this.excelImportAttr.setImportDouble(bl);
    }

    public boolean isCheckWidget() {
        return this.checkWidget;
    }

    public void setCheckWidget(boolean bl) {
        this.checkWidget = bl;
    }

    public boolean isExcelMatchTitle() {
        return this.excelImportAttr.isImportMatchTitle();
    }

    public void setExcelMatchTitle(boolean bl) {
        this.excelImportAttr.setImportMatchTitle(bl);
    }

    public boolean isExportFullImg4Excel() {
        return this.exportFullImg4Excel;
    }

    public void setExportFullImg4Excel(boolean bl) {
        this.exportFullImg4Excel = bl;
    }

    public float getExcelAdjustHeight() {
        return this.excelAdjustHeight;
    }

    public void setExcelAdjustHeight(float f) {
        this.excelAdjustHeight = f;
    }

    public double getExcelAdjustWidth() {
        return this.excelAdjustWidth;
    }

    public void setExcelAdjustWidth(double d) {
        this.excelAdjustWidth = d;
    }

    public boolean isPrintWidget() {
        return this.printWidget;
    }

    public void setPrintWidget(boolean bl) {
        this.printWidget = bl;
    }

    public boolean isPolyBlocksShowInOne() {
        return this.polyBlocksShowInOne;
    }

    public void setPolyBlocksShowInOne(boolean bl) {
        this.polyBlocksShowInOne = bl;
    }

    public String getReportPrefix() {
        return this.reportPrefix;
    }

    public void setReportPrefix(String string) {
        this.reportPrefix = string;
    }

    public String getPreReportPrefix() {
        return this.preReportPrefix;
    }

    public void setPreReportPrefix(String string) {
        this.preReportPrefix = string;
    }

    public ExcelImportAttr getExcelImportAttr() {
        return this.excelImportAttr;
    }

    public void setExcelImportAttr(ExcelImportAttr excelImportAttr) {
        this.excelImportAttr = excelImportAttr;
    }

    public boolean isReadDialectAgain() {
        return this.readDialectAgain;
    }

    public void setReadDialectAgain(boolean bl) {
        this.readDialectAgain = bl;
    }

    public boolean isShowImportValue() {
        return this.excelImportAttr.isShowValue();
    }

    public void setShowImportValue(boolean bl) {
        this.excelImportAttr.setShowValue(bl);
    }

    public String fileName() {
        return "customconfig.xml";
    }

    public void readXML(XMLableReader xMLableReader) {
        String string = xMLableReader.getTagName();
        if (xMLableReader.isChildNode()) {
            if (ComparatorUtils.equals(PRIVILEGE_TIMEOUT_XML, string)) {
                this.setDigitalPrivilegeTimeout(xMLableReader.getAttrAsLong(DIGITAL_PRIVILEGE_XML, 90000L));
                this.setUsernamePrivilegeTimeout(xMLableReader.getAttrAsLong(USERNAME_PRIVILEGE_XML, 1200000L));
            } else if (ComparatorUtils.equals(EXPORT_FULL_IMAGE, string)) {
                this.setExportFullImg4Excel(xMLableReader.getAttrAsBoolean("excel", false));
            } else if (ComparatorUtils.equals(EXCEL_ADJUST, string)) {
                this.setExcelAdjustHeight(xMLableReader.getAttrAsFloat("height", 20.1f));
                this.setExcelAdjustWidth(xMLableReader.getAttrAsDouble("width", 34.742));
            } else if (string.equals("PrintWidget")) {
                this.setPrintWidget(xMLableReader.getAttrAsBoolean("print", false));
            } else if (string.equals("PolyBlocks")) {
                this.setPolyBlocksShowInOne(xMLableReader.getAttrAsBoolean("showInOne", true));
            } else if (string.equals("CheckWidget")) {
                this.setCheckWidget(xMLableReader.getAttrAsBoolean("check", true));
            } else if (ComparatorUtils.equals(REPORT_PREFIX, string)) {
                String string2 = this.getPrefixFromReader(xMLableReader);
                this.setReportPrefix(string2);
            } else if ("Dialect".equals(string)) {
                this.setReadDialectAgain(xMLableReader.getAttrAsBoolean("readDialectAgain", false));
            } else {
                this.readExcelImportAttr(xMLableReader);
            }
        }
    }

    public void readExcelImportAttr(XMLableReader xMLableReader) {
        String string = xMLableReader.getTagName();
        if (string.equals("ImportDoubleDir")) {
            this.setImportDoubleDir(xMLableReader.getAttrAsBoolean("doubledir", false));
        } else if (string.equals("ExcelMatchTitle")) {
            this.setExcelMatchTitle(xMLableReader.getAttrAsBoolean("match", true));
        } else if (string.equals("ShowImportValue")) {
            this.setShowImportValue(xMLableReader.getAttrAsBoolean("show", false));
        } else if (string.equals("ExcelImportAttr")) {
            ExcelImportAttr excelImportAttr = new ExcelImportAttr();
            xMLableReader.readXMLObject(excelImportAttr);
            this.setExcelImportAttr(excelImportAttr);
        }
    }

    private String getPrefixFromReader(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttrAsString("prefix", "");
        this.setPreReportPrefix(string);
        string = string.replaceAll("\\\\", "/");
        if (StringUtils.isNotEmpty(string) && !string.startsWith("/")) {
            string = "/" + string;
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("ReportServerParameter");
        xMLPrintWriter.startTAG(PRIVILEGE_TIMEOUT_XML).attr(DIGITAL_PRIVILEGE_XML, this.getDigitalPrivilegeTimeout()).attr(USERNAME_PRIVILEGE_XML, this.getUsernamePrivilegeTimeout()).end();
        xMLPrintWriter.startTAG(EXPORT_FULL_IMAGE).attr("excel", this.isExportFullImg4Excel()).end();
        xMLPrintWriter.startTAG(EXCEL_ADJUST).attr("height", this.getExcelAdjustHeight()).attr("width", this.getExcelAdjustWidth()).end();
        xMLPrintWriter.startTAG("PrintWidget").attr("print", this.isPrintWidget()).end();
        xMLPrintWriter.startTAG("CheckWidget").attr("check", this.isCheckWidget()).end();
        xMLPrintWriter.startTAG(REPORT_PREFIX).attr("prefix", this.getPreReportPrefix()).end();
        xMLPrintWriter.startTAG("Dialect").attr("readDialectAgain", this.isReadDialectAgain()).end();
        this.writeExcelImportAttr(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public void writeExcelImportAttr(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("ExcelImportAttr");
        this.excelImportAttr.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public synchronized void readFromInputStream(InputStream inputStream) throws Exception {
        CustomConfigManager customConfigManager = new CustomConfigManager();
        XMLTools.readInputStreamXML(customConfigManager, inputStream);
        configManager = customConfigManager;
        GeneralContext.getEnvProvider().writeResource(customConfigManager);
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                CustomConfigManager.envChanged();
            }
        });
    }
}

