/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.BaseXMLUtils;
import com.fr.base.ConfigManagerProvider;
import com.fr.base.ConfigProvider;
import com.fr.base.EmailManager;
import com.fr.base.FRContext;
import com.fr.base.NameStyle;
import com.fr.base.Parameter;
import com.fr.base.PrintAttr;
import com.fr.base.Style;
import com.fr.cluster.rpc.RPC;
import com.fr.data.impl.EmbeddedTableData;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.file.BaseClusterHelper;
import com.fr.file.XMLFileManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.general.FRLogCleanAttr;
import com.fr.general.GeneralContext;
import com.fr.general.LogConfig;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.plugin.ExtraClassManager;
import com.fr.report.fun.ReportFitProcessor;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.ListMap;
import com.fr.stable.PrintAttrProvider;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.ReportFitAttrProvider;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.ObjectTokenizer;
import com.fr.stable.xml.StableXMLUtils;
import com.fr.stable.xml.XMLObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLTools;
import com.fr.stable.xml.XMLWriter;
import com.fr.stable.xml.XMLableReader;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;

public class ConfigManager
extends XMLFileManager
implements ConfigProvider,
ConfigManagerProvider {
    private static final long DEFAULT_CHECK_TIME = 400000L;
    private static ConfigManagerProvider configManager = null;
    private String serverCharset = null;
    private Level serverLogLevel = Level.SEVERE;
    private FArray mailAddress4log = new FArray();
    private Map globalAttrMap = new HashMap();
    private EmailManager emailManager = new EmailManager();
    private Parameter[] globeParameters = new Parameter[0];
    private EmbeddedTableData embeddedTableData = new EmbeddedTableData();
    private Map styleMap = new ListMap();
    private boolean writeShortCuts = true;
    private String ServletMapping = "ReportServer";
    private PrintAttrProvider printAttr = new PrintAttr();
    private boolean supportGzip = false;
    private boolean isLicUseLock = false;
    private boolean isUseResServer = false;
    private String resServerPath = null;
    private boolean isDownChromeFrameInLocal = false;
    private boolean isIncludeString = false;
    private int serverLanguage = 0;
    private String resultSaverClassName = null;
    private String errorTemplate = null;
    private JDBCDatabaseConnection platformConnection;
    private String jbosswebappname = "WebReport";
    private long sessionDeadCheckTime = 400000L;
    private long sessionDeadTime = 400000L;
    private boolean sendHeartBeat = true;
    private String hyperlinkAddress = "";
    private String serverAddress;
    private FRLogCleanAttr logCleanAttr;

    public static synchronized ConfigManager getInstance() {
        return (ConfigManager)ConfigManager.getProviderInstance();
    }

    public static synchronized ConfigManagerProvider getProviderInstance() {
        if (configManager == null) {
            if (ConfigManager.isClusterMember()) {
                return configManager;
            }
            if (!configManager.readXMLFile()) {
                ConfigManager.compatibleOldVersion();
            }
        }
        return configManager;
    }

    private static synchronized boolean isClusterMember() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                configManager = new ConfigManager();
                RPC.registerSkeleton(configManager);
                return false;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                configManager = (ConfigManagerProvider)RPC.getProxy(ConfigManager.class, string);
                return true;
            }
        }
        configManager = new ConfigManager();
        return false;
    }

    private static void compatibleOldVersion() {
        InputStream inputStream = FRContext.getResourceStream("ReportServerParameter.rxml");
        if (inputStream != null) {
            try {
                XMLTools.readInputStreamXML(configManager, inputStream);
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
            }
        }
    }

    private static synchronized void envChanged() {
        configManager = null;
    }

    public void readFromInputStream(InputStream inputStream) throws Exception {
        ConfigManager configManager = new ConfigManager();
        XMLTools.readInputStreamXML(configManager, inputStream);
        ConfigManager.configManager = configManager;
        FRContext.getCurrentEnv().writeResource(ConfigManager.configManager);
    }

    private ConfigManager() {
    }

    public String fileName() {
        return "config.xml";
    }

    public boolean isFitPaper() {
        return this.printAttr.isFlashFitPaper();
    }

    public void setFitPaper(boolean bl) {
        this.printAttr.setFlashFitPaper(bl);
    }

    public String getServerCharset() {
        if (this.serverCharset == null) {
            this.serverCharset = this.getDefaultBrowserCharset();
        }
        return this.serverCharset;
    }

    public void setServerCharset(String string) {
        this.serverCharset = string;
    }

    private String getDefaultBrowserCharset() {
        if (ComparatorUtils.equals(Locale.SIMPLIFIED_CHINESE, FRContext.getLocale())) {
            return "UTF-8";
        }
        if (ComparatorUtils.equals(Locale.TRADITIONAL_CHINESE, FRContext.getLocale())) {
            return "BIG5";
        }
        if (ComparatorUtils.equals(Locale.JAPANESE, FRContext.getLocale())) {
            return "EUC_JP";
        }
        if (ComparatorUtils.equals(Locale.KOREAN, FRContext.getLocale())) {
            return "EUC_KR";
        }
        return "UTF-8";
    }

    public Level getServerLogLevel() {
        return this.serverLogLevel;
    }

    public void setServerLogLevel(Level level) {
        this.serverLogLevel = level;
    }

    public FArray getMailAddress4log() {
        return this.mailAddress4log;
    }

    public void setMailAddress4log(FArray fArray) {
        this.mailAddress4log = fArray;
    }

    public void setMailAddress4log(String string) {
        String[] stringArray = string.split(",");
        this.mailAddress4log = new FArray<String>(stringArray);
    }

    public LogConfig getLogConfig() {
        return LogConfig.getLogConfig();
    }

    public void setLogConfig(LogConfig logConfig) {
        LogConfig.registerLogConfig(logConfig);
    }

    public boolean isWriteShortCuts() {
        return this.writeShortCuts;
    }

    public void setWriteShortCuts(boolean bl) {
        this.writeShortCuts = bl;
    }

    public boolean isPopupFlashPrintSetting() {
        return this.printAttr.isPopupFlashPrint();
    }

    public boolean isPopupAppletPrintSetting() {
        return this.printAttr.isPopupAppletPrint();
    }

    public boolean isPopupPdfPrintSetting() {
        return this.printAttr.isPopupPdfPrint();
    }

    public void setPopupAppletPrintSetting(boolean bl) {
        this.printAttr.setPopupAppletPrint(bl);
    }

    public void setPopupFlashPrintSetting(boolean bl) {
        this.printAttr.setPopupFlashPrint(bl);
    }

    public void setPopupPdfPrintSetting(boolean bl) {
        this.printAttr.setPopupPdfPrint(bl);
    }

    public PrintAttrProvider getPrintAttr() {
        return this.printAttr;
    }

    public void setPrintAttr(PrintAttrProvider printAttrProvider) {
        this.printAttr = printAttrProvider;
    }

    public void setSupportGzip(boolean bl) {
        this.supportGzip = bl;
    }

    public boolean isSupportGzip() {
        return this.supportGzip;
    }

    public void setLicUseLock(boolean bl) {
        this.isLicUseLock = bl;
    }

    public boolean isLicUseLock() {
        return this.isLicUseLock;
    }

    public boolean isUseResServer() {
        return this.isUseResServer;
    }

    public void setUseResServer(boolean bl) {
        this.isUseResServer = bl;
    }

    public String getResServerPath() {
        return this.resServerPath;
    }

    public void setResServerPath(String string) {
        this.resServerPath = string;
    }

    public void setServerLanguage(int n) {
        this.serverLanguage = n;
    }

    public int getServerLanguage() {
        return this.serverLanguage;
    }

    public FRLogCleanAttr getLogCleanAttr() {
        return this.logCleanAttr;
    }

    public void setLogCleanAttr(FRLogCleanAttr fRLogCleanAttr) {
        this.logCleanAttr = fRLogCleanAttr;
    }

    public boolean hasStyle() {
        return !this.styleMap.isEmpty();
    }

    public Iterator getStyleNameIterator() {
        return this.styleMap.keySet().iterator();
    }

    public Style getStyle(String string) {
        Style style = (Style)this.styleMap.get(string);
        if (style == null && string != null && string.indexOf("..") != -1) {
            style = this.getStyle4HalfName(string);
        }
        return style;
    }

    public ReportFitAttrProvider getFitAttrProvider() {
        ReportFitProcessor reportFitProcessor = (ReportFitProcessor)ExtraClassManager.getInstance().getSingle("ReportFitProcessor");
        if (reportFitProcessor != null) {
            return reportFitProcessor.newInstanceFitAttr();
        }
        return null;
    }

    public void setFitAttrProvider(ReportFitAttrProvider reportFitAttrProvider) {
    }

    private Style getStyle4HalfName(String string) {
        Iterator iterator = this.getStyleNameIterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.indexOf(string.replaceAll(".", "")) == -1) continue;
            return this.getStyle(string2);
        }
        return NameStyle.getInstance();
    }

    public void putStyle(String string, Style style) {
        if (style == null) {
            this.styleMap.remove(string);
        }
        if (this.styleMap.get(string) != null) {
            return;
        }
        this.styleMap.put(string, style);
    }

    public void clearAllStyle() {
        this.styleMap.clear();
    }

    public String getResultSaverClassName() {
        return this.resultSaverClassName;
    }

    public EmailManager getEmailManager() {
        return this.emailManager;
    }

    public void setEmailManager(EmailManager emailManager) {
        this.emailManager = emailManager;
    }

    public JDBCDatabaseConnection getPlatformConnection() {
        return this.platformConnection;
    }

    public void setPlatformConnection(JDBCDatabaseConnection jDBCDatabaseConnection) {
        this.platformConnection = jDBCDatabaseConnection;
    }

    public void putGlobalAttribute(Object object, Object object2) {
        this.globalAttrMap.put(object, object2);
    }

    public Object getGlobalAttribute(Object object) {
        return this.globalAttrMap.get(object);
    }

    public String getJbossWebappName() {
        return this.jbosswebappname;
    }

    private void setJbossWebappName(String string) {
        this.jbosswebappname = string;
    }

    public long getSessionDeadCheckTime() {
        return this.sessionDeadCheckTime;
    }

    public void setSessionDeadCheckTime(long l) {
        this.sessionDeadCheckTime = l;
    }

    public long getSessionDeadTime() {
        return this.sessionDeadTime;
    }

    public void setSessionDeadTime(long l) {
        this.sessionDeadTime = l;
    }

    public boolean isSendHeartBeat() {
        return this.sendHeartBeat;
    }

    public void setSendHeartBeat(boolean bl) {
        this.sendHeartBeat = bl;
    }

    public String getHyperlinkAddress() {
        return this.hyperlinkAddress;
    }

    public void setHyperlinkAddress(String string) {
        this.hyperlinkAddress = string;
    }

    private void setXMLVersionFromReader(XMLableReader xMLableReader) {
        String string = xMLableReader.getElementValue();
        if (string != null) {
            xMLableReader.setXmlVersionByString(string);
        }
    }

    private void setCharsetFromReader(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttrAsString("serverCharacterEncoding", null);
        if (string != null) {
            this.setServerCharset(string);
        }
    }

    private void setServletMapping(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttrAsString("pattern", null);
        if (string != null) {
            this.setServletMapping(string);
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        String string = xMLableReader.getTagName();
        if (xMLableReader.isChildNode()) {
            if (string.equals("XMLVersion")) {
                this.setXMLVersionFromReader(xMLableReader);
            } else if ("Write".equals(string)) {
                this.setCharsetFromReader(xMLableReader);
            } else if ("GZip".equals(string)) {
                this.setSupportGzip(xMLableReader.getAttrAsBoolean("run", false));
            } else if ("UseResServer".equals(string)) {
                this.setUseResServer(xMLableReader.getAttrAsBoolean("useResServer", false));
            } else if ("ResServerPath".equals(string)) {
                this.setResServerPath(xMLableReader.getAttrAsString("resServerPath", null));
            } else if ("Lic".equals(string)) {
                this.setLicUseLock(xMLableReader.getAttrAsBoolean("useLock", false));
            } else if ("ServletMapping".equals(string)) {
                this.setServletMapping(xMLableReader);
            } else if ("ChromeChart".equals(string)) {
                this.setDownChromeFrameInLocal(xMLableReader.getAttrAsBoolean("downLocal", false));
            } else if ("Parameters".equals(string) || "Global_Parameters".equals(string)) {
                this.globeParameters = BaseXMLUtils.readParameters(xMLableReader);
            } else if (string.equals("ReportWebAttr")) {
                this.readReportWebAttr(xMLableReader);
            } else if ("ServerLogLevel".equals(string) || "SetServerLogLevel".equals(string)) {
                this.readServerLog(xMLableReader);
            } else if ("ServerLogCleanRate".equals(string) || "FRLogCleanAttr".equals(string)) {
                this.logCleanAttr = new FRLogCleanAttr();
                this.logCleanAttr.readXML(xMLableReader);
            } else if (string.equals("EmailManager")) {
                this.emailManager = new EmailManager();
                xMLableReader.readXMLObject(this.emailManager);
            } else if (string.equals("Styles")) {
                this.readStyles(xMLableReader);
            } else if (string.equals("SessionInfo")) {
                this.readSessionRelate(xMLableReader);
            } else if (string.equals("writeShortCuts")) {
                this.setWriteShortCuts(xMLableReader.getAttrAsBoolean("writeShortCuts", true));
            } else if (string.equals("JbossWebappName")) {
                this.setJbossWebappName(xMLableReader.getAttrAsString("name", null));
            } else if (string.equals("Hyperlink")) {
                this.setHyperlinkAddress(xMLableReader.getAttrAsString("defaultLinkPath", null));
            } else {
                this.readSomeOther(xMLableReader);
                this.readPrintAttr(xMLableReader);
            }
        }
    }

    private void readSessionRelate(XMLableReader xMLableReader) {
        this.setSessionDeadCheckTime(xMLableReader.getAttrAsLong("checkTime", 400000L));
        this.setSessionDeadTime(xMLableReader.getAttrAsLong("deadTime", 400000L));
        this.setSendHeartBeat(xMLableReader.getAttrAsBoolean("heartBeat", true));
    }

    private void readReportWebAttr(XMLableReader xMLableReader) {
        ThreadLocal<ConfigManager> threadLocal = new ThreadLocal<ConfigManager>();
        threadLocal.set(this);
        try {
            Class<?> clazz = Class.forName("com.fr.xml.ReportXMLUtils$ReportObjectTokenizer");
            GeneralXMLTools.Object_Tokenizer = (ObjectTokenizer)clazz.newInstance();
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        GeneralXMLTools.Object_Tokenizer.tokenizerObject(xMLableReader, false, xMLableReader.getTagName(), threadLocal);
    }

    private void readSomeOther(XMLableReader xMLableReader) {
        String string = xMLableReader.getTagName();
        if (ComparatorUtils.equals("ErrorHandler", string)) {
            this.setErrorTemplate(xMLableReader.getAttrAsString("template", null));
        } else if (ComparatorUtils.equals("PlatformConnection", string)) {
            this.platformConnection = new JDBCDatabaseConnection();
            xMLableReader.readXMLObject(this.platformConnection);
        } else if (ComparatorUtils.equals("CustomLocale", string)) {
            this.embeddedTableData = new EmbeddedTableData();
            xMLableReader.readXMLObject(this.embeddedTableData);
        } else if (ComparatorUtils.equals(LogConfig.XML_TAG, string)) {
            this.setLogConfig((LogConfig)xMLableReader.readXMLObject(new LogConfig()));
        } else if (ComparatorUtils.equals("FARRAY", string)) {
            this.setMailAddress4log((FArray)xMLableReader.readXMLObject(new FArray()));
        }
    }

    private void readPrintAttr(XMLableReader xMLableReader) {
        String string = xMLableReader.getTagName();
        if (string.equals("FlashPrint")) {
            this.setPopupFlashPrintSetting(xMLableReader.getAttrAsBoolean("popupFlashPrintSetting", true));
            this.setFitPaper(xMLableReader.getAttrAsBoolean("fitPaper", false));
        } else if (string.equals("PdfPrint")) {
            this.setPopupPdfPrintSetting(xMLableReader.getAttrAsBoolean("popupPdfPrintSetting", true));
        } else if (string.equals("AppletPrint")) {
            this.setPopupAppletPrintSetting(xMLableReader.getAttrAsBoolean("popupAppletPrintSetting", true));
        } else if (string.equals("PrintAttrProvider")) {
            PrintAttr printAttr = new PrintAttr();
            xMLableReader.readXMLObject(printAttr);
            this.setPrintAttr(printAttr);
        }
    }

    private void readServerLog(XMLableReader xMLableReader) {
        String string = "";
        string = xMLableReader.getElementValue();
        if (string != null) {
            try {
                Level level = Level.parse(string);
                this.setServerLogLevel(level);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void readStyles(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                String string;
                if (xMLableReader.isAttr()) {
                    ConfigManager.this.styleMap.clear();
                }
                if (xMLableReader.isChildNode() && "SAttr".equals(string = xMLableReader.getTagName())) {
                    String string2 = "";
                    String string3 = xMLableReader.getAttrAsString("name", null);
                    if (string3 != null) {
                        string2 = string3;
                    }
                    xMLableReader.readXMLObject(new XMLObject(string2){

                        public void readXML(XMLableReader xMLableReader) {
                            if (xMLableReader.isChildNode() && "Style".equals(xMLableReader.getTagName())) {
                                Style style = BaseXMLUtils.readFullStyle(xMLableReader);
                                ConfigManager.this.putStyle((String)this.getObject(), style);
                            }
                        }
                    });
                }
            }
        });
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("ReportServerParameter");
        if (this.serverLogLevel != null) {
            xMLPrintWriter.startTAG("ServerLogLevel");
            xMLPrintWriter.textNode(String.valueOf(this.getServerLogLevel()));
            xMLPrintWriter.end();
        }
        if (this.logCleanAttr != null) {
            this.logCleanAttr.writeXML(xMLPrintWriter);
        }
        if (this.getLogConfig() != null) {
            this.getLogConfig().writeXML(xMLPrintWriter);
        }
        if (this.mailAddress4log != null) {
            this.mailAddress4log.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.startTAG("Write").attr("serverCharacterEncoding", this.getServerCharset());
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("GZip").attr("run", this.isSupportGzip()).end();
        xMLPrintWriter.startTAG("Lic").attr("useLock", this.isLicUseLock()).end();
        xMLPrintWriter.startTAG("UseResServer").attr("useResServer", this.isUseResServer()).end();
        xMLPrintWriter.startTAG("ResServerPath").attr("resServerPath", this.getResServerPath()).end();
        xMLPrintWriter.startTAG("ServletMapping").attr("pattern", this.getServletMapping()).end();
        xMLPrintWriter.startTAG("ChromeChart").attr("downLocal", this.isDownChromeFrameInLocal).end();
        xMLPrintWriter.startTAG("JbossWebappName").attr("name", this.getJbossWebappName()).end();
        xMLPrintWriter.startTAG("Hyperlink").attr("defaultLinkPath", this.getHyperlinkAddress()).end();
        for (Object v2 : this.globalAttrMap.values()) {
            if (!(v2 instanceof XMLWriter)) continue;
            ((XMLWriter)v2).writeXML(xMLPrintWriter);
        }
        if (this.emailManager != null) {
            this.emailManager.writeXML(xMLPrintWriter);
        }
        StableXMLUtils.writeParameters(xMLPrintWriter, this.globeParameters);
        this.writeStyles(xMLPrintWriter);
        this.writeSessionManage(xMLPrintWriter);
        this.writePrint(xMLPrintWriter);
        xMLPrintWriter.startTAG("CustomLocale");
        this.embeddedTableData.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
        this.writeSomeOther(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    private void writeStyles(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Styles");
        Iterator iterator = this.getStyleNameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Style style = this.getStyle(string);
            if (style == null) continue;
            xMLPrintWriter.startTAG("SAttr").attr("name", string);
            BaseXMLUtils.writeStyle(xMLPrintWriter, style);
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    private void writeSessionManage(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("SessionInfo").attr("checkTime", this.getSessionDeadCheckTime()).attr("deadTime", this.getSessionDeadTime()).attr("heartBeat", this.isSendHeartBeat()).end();
    }

    private void writePrint(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("PrintAttrProvider");
        this.printAttr.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    private void writeSomeOther(XMLPrintWriter xMLPrintWriter) {
        if (this.platformConnection != null) {
            xMLPrintWriter.startTAG("PlatformConnection");
            this.platformConnection.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        xMLPrintWriter.startTAG("writeShortCuts").attr("writeShortCuts", this.isWriteShortCuts()).end();
        if (StringUtils.isNotEmpty(this.errorTemplate)) {
            xMLPrintWriter.startTAG("ErrorHandler").attr("template", this.errorTemplate).end();
        }
    }

    public Parameter[] getGlobal_Parameters() {
        return this.globeParameters;
    }

    public void setGlobal_Parameters(Parameter[] parameterArray) {
        this.globeParameters = parameterArray;
    }

    public String getServletMapping() {
        return this.ServletMapping;
    }

    public void setServletMapping(String string) {
        this.ServletMapping = string;
    }

    public void setErrorTemplate(String string) {
        this.errorTemplate = string;
    }

    public String getErrorTemplate() {
        return this.errorTemplate;
    }

    public void setDownChromeFrameInLocal(boolean bl) {
        this.isDownChromeFrameInLocal = bl;
    }

    public boolean isDownChromeFrameInLocal() {
        return this.isDownChromeFrameInLocal;
    }

    public void setIncludeString(boolean bl) {
        this.isIncludeString = bl;
    }

    public boolean isIncludeString() {
        return this.isIncludeString;
    }

    public String getFlashInstallPath(Repository repository) {
        return repository.getBrowser().getFlashPlayerInstallerURL();
    }

    public boolean writeResource() throws Exception {
        return FRContext.getCurrentEnv().writeResource(ConfigManager.getProviderInstance());
    }

    public static void reinit() {
        ConfigManager.envChanged();
        ConfigManager.getProviderInstance();
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                ConfigManager.envChanged();
            }
        });
    }
}

