/**
 * 控件名不能重复，统一管理控件名，方便查找。
 */
var _WD = {
    taskTableWD: "taskTable",	//任务列表
    taskLogTableWD: "taskLogTable", //任务监控列表
    taskDialogWD: "addOrUpdateDialog",	//添加/删除定时任务弹出的对话框
    taskCardLayoutWD: "taskSettingCardLayout",	//添加/删除定时任务对话框里放的卡片局部

    taskFirstTableLayoutWD: "taskSettingFirstTableLayout",	//定时任务第一步，表格布局
    taskNameWD: "taskName",	//定时任务第一步，任务名称，文本控件
    taskAddTemplateNameWD: "add_template_name", //定时任务第一步，任务模板选择，下拉树控件
    taskTemplateTypeWD: "template_type",	//定时任务第一步，任务模板类型，单选按钮组
    taskReportParameterGridWD: "firstStepParameters",	//定时任务第一步，添加参数，lgrid

    taskSecondStepTableLayoutWD: "secondStepTableLayout",	//定时任务第二步，表格布局
    taskStartTimeSetRadioboxWD: "start_time_set_radiobox",//定时任务第二步，开始时间，单选按钮组
    taskStartTimeWD: "start_time",	//定时任务第二步，开始时间控件
    taskFrequencyCardLayoutWD: "frequencyCardLayout",	//定时任务第二步，执行频率的卡片局部
    taskFrequencyTypeGroupWD: "frequencyTypeGroup",	//定时任务第二步，执行频率单选按钮组
    taskConditionTypeGroupWD: "conditionTypeGroup",	//定时任务第二步，执行频率单选按钮组
    taskConditionCardLayoutWD: "conditionCardLayout",	//定时任务第二步，执行频率的卡片局部
    taskSimpleRepeatWD: "simpleRepeat",	//定时任务第二步，每隔多久执行文本控件
    taskRepeatUnitWD: "repeatUnit",	//定时任务第二步，间隔时间单位下拉框控件
    taskExecuteHourWD: "executeHour", //定时任务第二步，明细频率设置，执行时文本控件
    taskExecuteMinuteWD: "executeMinute",	//定时任务第二步，明细频率设置，执行分文本控件
    taskDefinedExecuteUnitWD: "defined_execute_unit",	//定时任务第二步，明细频率设置，执行日单选按钮组
    taskSecondStepUnitEveryWeekWD: "unit_every_week",	//定时任务第二步，明细频率设置，每周下拉复选框控件
    taskSecondStepUnitEveryMonthWD: "unit_every_month",	//定时任务第二步，明细频率设置，每月下拉复选框控件
    taskUnitExecuteMonthWD: "unit_execute_month",	//定时任务第二步，明细频率设置，执行月
    taskExpressionTextWD: "expressionText",	//定时任务第二步，表达式设定，文本控件
    taskSecondStepEndTimeCardLayoutWD: "endTimeCardLayout",	//定时任务第二步结束时间的卡片布局
    taskSecondStenEndTimeRadioGroupWD: "endTimeRadioGroup",	//定时任务第二步，结束时间，单选按钮组
    taskEndTimeWD: "end_time",	//定时任务第二步，结束时间，日期控件
    taskRepeatTimesWD: "repeat_times",	//定时任务第二步，结束时间，额外重复次数文本控件
    executeNoLimit: "executeNoLimit", //定时任务第二步，执行条件，始终执行
    executeFormula: "executeFormula", //定时任务第二步，执行条件，公式判断
    executeClass: "executeClass", //定时任务第二步，执行条件，自定义类判断
    taskRestartFromFailCheckBoxWD: "restartFromFailCheckBox", //定时任务第二步，失败重启，复选框控件
    taskRestartExecuteMinuteWD: "restartExecuteMinute",	//定时任务第二步，失败重启，分钟文本控件
    taskRestartExecuteTimesWD: "restartExecuteTimes",	//定时任务第二步，失败重启，次数文本控件
    taskRestartExecuteMostTimeRestartLabelWD: "restartExecuteMostTimeRestartLabel",   //定时任务第二步，失败重启，重启最多次数标签
    taskRestartExecuteMinuteLabelWD: "restartExecuteMinuteLabel",   //定时任务第二步，失败重启，分钟标签
    taskRestartExecuteTimesLabelWD: "restartExecuteTimesLabel",     //定时任务第二步，失败重启，次数标签

    taskThirdTableLayoutWD: "taskSettingThirdTableLayout",	//定时任务第三步，表格布局
    taskFileNameWD: "fileName",	//定时任务第三步，文件名称，文本控件
    taskFileDescriptionWD: "fileDescription",	//定时任务第三步，文件描述，文本控件
    taskVirtureDirectoryWD: "virtureDirectory",	//定时任务第三步，虚拟目录，下拉树控件
    taskVirtureDirectoryByUserWD: "virtureDirectoryByUser",	//定时任务第三步，根据用户生成不同内容，复选框控件
    taskVirtureDirectoryComboByUserWD: "virtureDirectoryComboByUser",	//定时任务第三步，根据用户生成不同内容，下拉复选框控件
    taskAttachmentTypeWD: "attachmentType",	//定时任务第三步，附件类型，复选框组
    taskEmailCheckboxWD: "emailCheckbox",	//定时任务第三步，邮件通知，复选框
    taskReceiverWD: "receiver",	    //定时任务第三步，邮件通知，收件人，下拉复选框
    taskEmailRoleWD: "emailRole",	//定时任务第三步，邮件通知，所有人，下拉复选框
    taskCopyReceiverWD: "copyReceiver",	//定时任务第三步，邮件通知，抄送，下拉复选框
    taskSecretReceiverWD: "secretReceiver",	//定时任务第三步，邮件通知，密送，下拉复选框
    taskSubjectWD: "subject",	//定时任务第三步，邮件通知，主题，文本框
    taskContentWD: "content",	//定时任务第三步，邮件通知，内容，文本框
    taskEmailByPersonCheckboxWD: "emailByPersonCheckbox",	//定时任务第三步，邮件通知，根据收件人生成不同邮件，复选框
    taskEmailCanPreviewAttachCheckboxWD: "CanPreviewAttachCheckbox",   //定时任务第三步，邮件通知，正文预览附件内容，复选框
    taskFtpCheckboxWD: "ftpCheckbox",	//定时任务第三步，FTP，复选框
    taskFtpAddressWD: "ftpAddress",	//定时任务第三步，FTP，服务器地址，文本框
    taskFtpPortWD: "ftpPort",	//定时任务第三步，FTP，服务器端口，文本框
    taskFtpSavePathWD: "ftpSavePath",	//定时任务第三步，FTP，保存路径，文本框
    taskFtpUsernameWD: "ftpUsername",	//定时任务第三步，FTP，用户名，文本框
    taskFtpPasswordWD: "ftpPassword",	//定时任务第三步，FTP，密码，文本框
    taskSelfDefineCheckboxWD: "selfDefineCheckbox",	//定时任务第三步，自定义附件，复选框
    taskSelfDefineClassNameWD: "selfDefineClassName",	//定时任务第三步，自定义附件，自定义类名，文本框
    taskPrinterCheckboxWD: "printerCheckbox",	//定时任务第三步，打印，复选框
    taskPushCheckboxWD: "pushCheckbox",
    taskPrinterNameWD: "printerName",	//定时任务第三步，打印，打印机，下拉框
    taskPushTextWD: "pushTextWD"	//定时任务第三步，推送内容文本域
};
var CONSTANTS = {
    currentStep: {
        FIRST_STEP: 0,
        SECOND_STEP: 1,
        THIRD_STEP: 2
    },
    showType: {
        WRITE: 0,
        VIEW: 1,
        ANALYSIS: 2
    },
    startType: {
        IMMEDIATE: 1,
        SET_TIME: 2
    },
    dayType: {
        EVERYDAY: 1,
        DAY_OF_WEEK: 2,
        DAY_OF_MONTH: 3
    },
    executeType: {
        NO_LIMIT: 0,
        FORMULA: 1,
        EXECUTE_CLASS: 2
    },
    endTimeType: {
        NO_LIMIT: 0,
        SET_END_TIME: 1,
        REPEAT_COUNTS: 2
    },
    recurrenceType: {
        ONCE: 0,
        SIMPLE: 1,
        CALENDAR: 2,
        CRONEXPRESSION: 3
    },
    recurrenceName: {
        ONCE: 'once',
        SIMPLE: "simple",
        CALENDAR: "calendar",
        CRONEXPRESSION: "cronexpression"
    },
    attachType: {
        CPR: '0',
        EXCEL: '1',
        WORD: '2',
        PDF: '3'
    },
    state: {
        STATE_NORMAL: 0,
        STATE_PAUSED: 1,
        STATE_NONE: -1,
        STATE_COMPLETED: 2
    },
    /**结束时间无限期时的默认值*/
    NO_LIMIT_REPEAT_COUNT: -1,
    CLASS_SUFFIX: ".class",
    taskTableSize: 10
};

FS.ScheduleOutput = FS.Plugin.ScheduleOutput = {
    /**
     * 根据输出格式对象返回一个格式组成数组
     * @param {JSON} outputFileFormat 格式对象
     * @param {Object} CONSTANTS 常用对象
     * @return {Array} 所有附件类型组成的数组
     */
    attachType: function (outputFileFormat, CONSTANTS) {
        var attachType = [];
        if (outputFileFormat.isConvertToExcel) {
            attachType.push(CONSTANTS.attachType.EXCEL);
        }
        if (outputFileFormat.isConvertToWord) {
            attachType.push(CONSTANTS.attachType.WORD);
        }
        if (outputFileFormat.isConvertToPdf) {
            attachType.push(CONSTANTS.attachType.PDF);
        }
        attachType.push(CONSTANTS.attachType.CPR);
        $.each(FS.Plugin.OutputformatProvider.items, function (index, item) {
            if (item && $.isFunction(item.markString) && $.isFunction(item.markNumber)) {
                var markString = item.markString();
                var markNum = item.markNumber();
                if (outputFileFormat[markString]) {
                    attachType.push(markNum);
                }
            }
        });
        return attachType;
    },

    /**
     * 附件选择控件的配置
     * @param {String} widgetName 控件名
     * @return {JSON} 控件配置
     */
    attachTypeSelectConfig: function (widgetName) {
        var items = [
            {text: 'excel', value: 1},
            {text: 'word', value: 2},
            {text: 'pdf', value: 3}
        ];
        $.each(FS.Plugin.OutputformatProvider.items, function (index, item) {
            if (item && $.isFunction(item.text) && $.isFunction(item.markNumber)) {
                items.push({
                    text : item.text(),
                    value : item.markNumber()
                });
            }
        });
        items.push({text: 'cpr', value: 0});
        return {
            type: 'checkboxgroup',
            items: items,
            columnsInRow: items.length,
            adaptive: false,
            widgetName: widgetName,
            width: 60 * items.length,
            returnArray: true,
            height: 21,
            x: FR.i18nTextWidth("FS-Schedule-Output_Attach_Type") > 48 ?
                FR.i18nTextWidth("FS-Schedule-Output_Attach_Type") + 10 : 55,
            y: 0,
            doSize: true,
            listeners: [{
                eventName: "afterinit",
                action: function () {
                    var cprCheck = this.buttonArray[items.length - 1];
                    cprCheck.setEnable(false);
                    cprCheck.setValue(true);
                    if (FSSM.Control.scheduleConfig.isOpTimer) {
                        //op=timer不显示cpr
                        cprCheck.setVisible(false);
                    }
                }
            }]
        }
    },

    /**
     * 将附件类型的选择结果传递回服务器
     * @param {String} attachmentType 表示附件类型的字符串
     * @returns {Object} 附件类型配置对象
     */
    attachResult: function (attachmentType) {
        var outputFileFormat = {};
        outputFileFormat.isConvertToExcel = (attachmentType.indexOf(1) >= 0);
        outputFileFormat.isConvertToWord = (attachmentType.indexOf(2) >= 0);
        outputFileFormat.isConvertToPdf = (attachmentType.indexOf(3) >= 0);
        $.each(FS.Plugin.OutputformatProvider.items, function (index, item) {
            if (item && $.isFunction(item.markString) && $.isFunction(item.markNumber)) {
                var markString = item.markString();
                var markNum = item.markNumber();
                outputFileFormat[markString] = (attachmentType.indexOf(markNum) >= 0);
            }
        });
        return outputFileFormat;
    }
};

FS.SCHEDULEMANAGER = FSSM = {

    //wei : 模型(Model)
    Model: {
        //定时任务的基本信息
        /**
         * 定时任务的基本信息
         * @param config 基本信息的json对象，具体内容如下：
         * name:任务名称;
         * showType:任务类型，填报/预览/分析；
         * reportletPath:模板路径；
         * transmitParameters:任务参数；
         * repeatTime:失败重启时，在X分后重新执行；
         * repeatTimes:失败重启时，最多尝试的重启次数。
         */
        TaskBasic: function (config) {
            $.extend(this, config);
            if (typeof FSSM.Model.TaskBasic._initialized === "undefined") {
                FSSM.Model.TaskBasic.prototype.isValid = function () {	//校验设置是否合法
                    var taskName = this.name;
                    //任务名称不能为空
                    if (!taskName) {
                        FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText("FS-Schedule-Task_Name_Should_Not_Be_Empty"));
                        return false;
                    }
                    //不能有重名的任务存在
                        var exists = true;
                        var result = FS.Sync.ajax({
                            url: FR.servletURL,
                            data: {
                                op: FSSM.Control.scheduleConfig.scheduleOP,
                                cmd: FSSM.Control.scheduleConfig.isNameExists,
                                name: taskName
                            }
                        });
                        exists = Boolean(result.exists);
						var task = FSSM.Control.currentTask;
                        if (task && task.name == taskName) {
                            exists = false;
                        }
                        if (exists) {
                            FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText("FS-Generic-Task_Name_Exist"));
                            return false;
                        }
                    //需要选择一张模板
                    if (!FSSM.Control.scheduleConfig.isSAPSyn && !this.reportletPath) {
                        FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText("FS-Schedule-Template_Name_Not_Null"));
                        return false;
                    }
                    //sap，必须选择转换
                    if (FSSM.Control.scheduleConfig.isSAPSyn && (!this.transfers || this.transfers.length <= 0)) {
                        FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText("FS-Generic-Need_Select_SAP_Task', 'FS_Process_Exclamation_Mark"));
                        return false;
                    }
                    return true;
                };
                FSSM.Model.TaskBasic._initialized = true;
            }
        },

        /**
         * 定时任务，调度周期
         * @param config 调度周期的json对象，具体信息如下：
         * startType:开始时间类型，1：立即执行，2：设置开始时间；
         * startTime:任务开始时间；
         * recurrenceType:执行频率，"once"：只执行一次；"simple"：简单重复执行；"calendar"：明细频率设置；"cronexpression"：自定义表达式；
         * recurrenceInterval:简单重复执行时，每隔多久（数字）执行；
         * recurrenceIntervalUnit:简单重复执行时，每隔多久执行的单位（分/时/日/周）；
         * hours:设置明细频率时，在几(hours)时执行；
         * dayType:设置明细频率时，执行日，1：每日；2：每周的星期X；3：每月的X号；
         * weekDays:设置明细频率时，记录每周的哪些天执行；
         * monthDays:设置明细频率时，记录每月的哪些天执行；
         * months:设置明细频率时，记录在哪些月执行；
         * cronExpression:表达式设定时，自定义表达式；
         * endTime:结束时间；
         * repeatCount:额外重复执行次数；
         *
         */
        TaskITrigger: function (config) {
            $.extend(this, config);
            if (typeof FSSM.Model.TaskITrigger._initialized === "undefined") {
                FSSM.Model.TaskITrigger.prototype.isValid = function () {	//校验设置是否合法
                    //设置开始时间
                    if (this.startType === CONSTANTS.startType.SET_TIME) {
                        if (!(/^(\d{4})-(0[1-9]|1[0-2])-(0[1-9]|[12]\d|3[01])\s([01]\d|2[0-3])(:[0-5]\d){2}$/).test(this.startTime)) {
                            FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText("FS-Generic-Enter_True_Time_Format"));
                            return false;
                        }
                    }
                    //简单重复执行
                    if (this.recurrenceType === CONSTANTS.recurrenceName.SIMPLE) {
                        //每隔多久执行
                        if (!(/^\d+$/).test(this.recurrenceInterval)) {
                            FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText("FS-Schedule-Enter_Correct_Run_Times"));
                            return false;
                        }
                        //间隔时间的单位
                        if (!this.recurrenceIntervalUnit) {
                            FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText('FS-Schedule-Select_True_Interval'));
                            return false;
                        }
                    } else if (this.recurrenceType === CONSTANTS.recurrenceName.CALENDAR) {	//明细频率设置
                        //需要设置在X时执行
                        if (!(/^\d+$/).test(this.hours)) {
                            FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText("FS-Generic-Hour_Wrong"));
                            return false;
                        }
                        //需要设置在X分执行
                        if (!(/^\d+$/).test(this.minutes)) {
                            FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText("FS-Generic-Minute_Wrong"));
                            return false;
                        }
                        if (this.dayType === CONSTANTS.dayType.DAY_OF_WEEK && !this.weekDays) {
                            //需要设置在每周的哪些天执行
                            FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText('FS-Schedule-Please_Select_Weekly_Execute_Time'));
                            return false;
                        } else if (this.dayType === CONSTANTS.dayType.DAY_OF_MONTH && !this.monthDays) {
                            //需要设置在每月的哪些天执行
                            FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText('FS-Schedule-Please_Select_Monthly_Execute_Time'));
                            return false;
                        }
                        if (!this.months) {
                            //需要设置在哪些月份执行
                            FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText('FS-Schedule-Please_Select_Execute_Month'));
                            return false;
                        }
                    } else if (this.recurrenceType === CONSTANTS.recurrenceName.CRONEXPRESSION) {	//表达式设定
                        if (!this.cronExpression) {
                            //需要设置自定义表达式
                            FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText("FS-Generic-Simple_Expression_Not_Null"));
                            return false;
                        }
                    }
                    //设置了结束时间
                    if (!FR.isNull(this.endTime)) {
                        if (!(/^(\d{4})-(0[1-9]|1[0-2])-(0[1-9]|[12]\d|3[01])\s([01]\d|2[0-3])(:[0-5]\d){2}$/).test(this.endTime)) {
                            FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText("FS-Generic-Enter_True_Time_Format"));
                            return false;
                        }
                        //开始时间要早于结束时间，未配置开始时间则比较当前时间
                        if (this.startTime && (Date.parse(this.startTime.replace(/-/g, "/")) > Date.parse(this.endTime.replace(/-/g, "/"))) ||
                            (!this.startTime && (new Date().getTime() > Date.parse(this.endTime.replace(/-/g, "/"))))) {
                            FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText('FS-Schedule-Time_Validate'));
                            return false;
                        }
                    }
                    if ((this.repeatCount && this.repeatCount !== CONSTANTS.NO_LIMIT_REPEAT_COUNT && !(/^\d+$/).test(this.repeatCount)) || this.repeatCount == '') {
                        //额外重复执行次数需要是数字
                        FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText('FS-Schedule-Enter_Correct_Extra_Run_Times'));
                        return false;
                    }
                    return true;
                };
                FSSM.Model.TaskITrigger._initialized = true;
            }
        },

        /**
         * 定时调度，输出设置
         * @param config 输出设置的json对象，具体信息如下：
         * baseFileName:生成的文件名称；
         * folderEntryId:生成文件挂载目录的ID；
         * email:TaskOutEmail对象，邮件设置；
         * ftp:TaskOutFtp对象，ftp设置；
         * customClass:TaskOutputCustomClass对象，自定义类名；
         * printer:TaskOutPrinter对象，使用的打印机。
         */
        TaskOutput: function (config) {
            $.extend(this, config);
            if (typeof FSSM.Model.TaskOutput._initialized === "undefined") {
                FSSM.Model.TaskOutput.prototype.isValid = function () {	//校验设置是否合法
                    if (!this.baseFileName) {
                        FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText("FS-Schedule-File_Name_Not_Null"));
                        return false;
                    }
                    if (this.folderEntryId == "-1") {
                        FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText("FS-Report-No_Dir_Selected"));
                        return false;
                    }
                    if (this.outputFileActionList.emailNotification) {
                        var email = new FSSM.Model.TaskOutputEmail(this.outputFileActionList.emailNotification);
                        if (!email.isValid()) {
                            return false;
                        }
                    }
                    if (this.outputFileActionList.ftpTransmission) {
                        var ftp = new FSSM.Model.TaskOutputFtp(this.outputFileActionList.ftpTransmission);
                        if (!ftp.isValid()) {
                            return false;
                        }
                    }
                    if (this.outputFileActionList.classOutputFileAction) {
                        var customClass = new FSSM.Model.TaskOutputCustomClass(this.outputFileActionList.classOutputFileAction);
                        if (!customClass.isValid()) {
                            return false;
                        }
                    }
                    if (this.outputFileActionList.printRWorkbookAction) {
                        var printer = new FSSM.Model.TaskOutputPrinter(this.outputFileActionList.printRWorkbookAction);
                        if (!printer.isValid()) {
                            return false;
                        }
                    }
                    if (this.outputFileActionList.pushAction) {
                        var pushContent = new FSSM.Model.TaskOutputPush(this.outputFileActionList.pushAction);
                        if (!pushContent.isValid()) {
                            return false;
                        }
                    }
                    return true;
                }
                FSSM.Model.TaskOutput._initialized = true;
            }
        },

        /**
         * 输出设置里的邮件通知配置
         * @param config 邮件配置的json对象，具体信息如下：
         * subject:邮件主题
         */
        TaskOutputEmail: function (config) {
            $.extend(this, config);
            if (typeof FSSM.Model.TaskOutputEmail._initialized === "undefined") {
                FSSM.Model.TaskOutputEmail.prototype.isValid = function () {
                    //TODO 主题不能为空？..
                    if (!this.subject) {
                        FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText("FS-Schedule-Subject_Not_Null"));
                        return false;
                    }
                    return true;
                }
                FSSM.Model.TaskOutputEmail._initialized = true;
            }
        },

        /**
         * 输出设置里的FTP配置
         * @param config FTP配置的json对象，具体信息如下：
         * serverAddress:FTP服务器地址
         */
        TaskOutputFtp: function (config) {
            $.extend(this, config);
            if (typeof FSSM.Model.TaskOutputFtp._initialized === "undefined") {
                FSSM.Model.TaskOutputFtp.prototype.isValid = function () {
                    if (!this.serverAddress) {
                        FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText("FS-Schedule-Server_Address_Not_Null"));
                        return false;
                    }
                    return true;
                };
                FSSM.Model.TaskOutputFtp._initialized = true;
            }
        },

        /**
         * 输出设置里的自定义附件处理
         * @param config 自定义附件的json对象，具体信息如下：
         * serverAddress:自定义类名
         */
        TaskOutputCustomClass: function (config) {
            $.extend(this, config);
            if (typeof FSSM.Model.TaskOutputCustomClass._initialized === "undefined") {
                FSSM.Model.TaskOutputCustomClass.prototype.isValid = function () {
                    //自定义附件处理的class名称
                    if (!this.customClassName) {
                        FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText("FS-Schedule-Define_Class_Name_Not_Null"));
                        return false;
                    }
                    return true;
                };
                FSSM.Model.TaskOutputCustomClass._initialized = true;
            }
        },

        /**
         * 输出设置里的打印生成的文件
         * @param config 打印配置的json对象，具体信息如下：
         * printerName:打印文件使用的打印机
         */
        TaskOutputPrinter: function (config) {
            $.extend(this, config);
            if (typeof FSSM.Model.TaskOutputPrinter._initialized === "undefined") {
                FSSM.Model.TaskOutputPrinter.prototype.isValid = function () {
                    //打印文件使用的打印机
                    if (!this.printerName) {
                        FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText("FS-Schedule-Printer_Not_Null"));
                        return false;
                    }
                    return true;
                };
                FSSM.Model.TaskOutputPrinter._initialized = true;
            }
        },

        TaskOutputPush: function (config) {
            $.extend(this, config);
            if (typeof FSSM.Model.TaskOutputPush._initialized === "undefined") {
                FSSM.Model.TaskOutputPush.prototype.isValid = function () {
                    //消息内容
                    if (!this.content) {
                        FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText("FS-Schedule-Output_Push_Content_Not_Null"));
                        return false;
                    }
                    return true;
                }
                FSSM.Model.TaskOutputPush._initialized = true;
            }
        }
    },

    //wei: 视图(View)
    View: {
        setTotalStep: 3,	//总共三步

        /**
         * 创建tabPane
         * @param render 父容器
         * @private
         */
        createTabPane: function (render) {
            var self = this;
            var schedulePaneItems = [this._taskManagerPaneConfig(), this._taskMonitorPaneConfig()];
            this.tabPane = new FS.LTabPane({
                width: '100%',
                height: '100%',
                items: schedulePaneItems,
                style: 'blue',
                vgap: 21,
                renderEl: render,
                loadEveryTime: true,
                opAfterActions: [
                    function() {
                        self.tabPane = this;
                    },
                    function () {
                        var tasknameCombo = self.tabPane.getWidgetByName("allTaskName");
                        tasknameCombo.options.renderEl = tasknameCombo.element;
                        var allTaskNames = [];
                        allTaskNames = FS.Sync.ajax({
                            url: FR.servletURL,
                            data: {
                                op: FSSM.Control.scheduleConfig.scheduleOP,
                                cmd: FSSM.Control.scheduleConfig.getAllTaskNamesURL
                            }
                        });
                        tasknameCombo.rebuild(allTaskNames);
                        FSSM.Control.queryTaskLog();
                    }
                ]
            });
        },

        /**
         * 任务管理面板的json配置
         * @private
         */
        _taskManagerPaneConfig: function () {
            var self = this;
            return {
                title: FR.i18nText("FS-Schedule-Task_Manage"),
                content: {
                    widgetName: 'taskManagerPanelWD',
                    type: 'panel',
                    width: 770,
                    height: 500,
                    doSize: true,
                    contentWidget: {
                        type: 'tablepane',
                        widgetName: 'taskManagerTableWD',
                        colSize: [20, 100, 20, 100, "fill"],
                        rowSize: [28, "fill"],
                        vgap: 20,
                        items: [
                            [
                                {}, {
                                //添加任务按钮
                                type: 'quickbutton',
                                text: FSSM.Control.scheduleConfig.taskAddText,
                                style: 'blue',
                                height: 28,
                                width: 100,
                                handler: function () {
                                    FSSM.Control.newTask();
                                }
                            }, {}, {
                                //删除任务按钮
                                type: 'quickbutton',
                                text: FSSM.Control.scheduleConfig.taskDelText,
                                style: 'grey',
                                height: 28,
                                width: 100,
                                handler: function () {
                                    var taskTable = self.taskTable();
                                    var selectedData = taskTable.getSelectedData();
                                    var dtaskids = [];
                                    for (var i = 0, len = selectedData.length; i < len; i++) {
                                        dtaskids.push(selectedData[i].id);
                                    }
                                    var callback = function () {
                                        taskTable.refresh();
                                    };
                                    FSSM.Control.removeTasks(dtaskids.join(","), callback);
                                }
                            }, null
                            ], [
                                $('<div/>').height(1), null, null, null, self._createTaskTable()
                            ]
                        ]
                    }
                }
            };
        },

        /**
         * 定时任务列表
         * @private
         */
        _createTaskTable: function () {
            var self = this;
            var columns = [
                {
                    //任务名称
                    key: 'name',
                    value: FR.i18nText("FS-Schedule-Task_Name"),
                    width: 190
                }, {
                    //模板路径
                    key: FSSM.Control.scheduleConfig.taskElemHeader,
                    value: FSSM.Control.scheduleConfig.taskElemText,
                    width: 369
                }, {
                    //任务状态
                    width: 60,
                    onCellCreate: function (rowIdx, colIdx, item) {
                        var $div = $('<div/>').addClass('taskStateTab');
                        if (item.state === CONSTANTS.state.STATE_PAUSED) {
                            $div.text(FR.i18nText("FS-Generic-Already_Pause"));
                        } else if (item.state === undefined || item.state === CONSTANTS.state.STATE_COMPLETED) {
                            $div.text(FR.i18nText("FS-Generic-Already_End"));
                        } else if (item.state === CONSTANTS.state.STATE_NORMAL) {
                            $div.text(FR.i18nText("FS-Generic-Simple_Running"));
                        }
                        return $div;
                    }
                }, {
                    //暂停/继续按钮
                    width: 24,
                    onCellCreate: function (rowIdx, colIdx, item) {
                        var taskGrid = this;
                        var imgSrc;
                        if (item.state === CONSTANTS.state.STATE_PAUSED) {
                            imgSrc = "fs-module-start-white";
                        } else if (item.state === CONSTANTS.state.STATE_NORMAL) {
                            imgSrc = "fs-module-stop-white";
                        }
                        var pauseBtn = new FR.IconButton({
                            width: 24,
                            height: 16,
                            imgsrc: imgSrc,
                            handler: function () {
                                FSSM.Control.stopOrRunTask(item, function () {
                                    taskGrid.refresh();
                                });
                            }
                        });
                        return pauseBtn.element;
                    }
                }, {
                    //编辑按钮
                    width: 24,
                    onCellCreate: function (rowIdx, colIdx, item) {
                        var taskGrid = this;
                        var editBtn = new FR.IconButton({
                            width: 24,
                            height: 24,
                            imgsrc: 'fs-module-edit-white',
                            handler: function () {
                                var callback = taskGrid.refresh();
                                FSSM.Control.editTask(item);
                            }
                        });
                        return editBtn.element;
                    }
                }, {
                    //删除按钮
                    width: 24,
                    onCellCreate: function (rowIdx, colIdx, item) {
                        var delBtn = new FR.IconButton({
                            width: 24,
                            height: 24,
                            imgsrc: 'fs-module-delete-white',
                            handler: function () {
                                var callback = function () {
                                    self.taskTable().refresh();
                                };
                                FSSM.Control.removeTasks(item.id, callback)
                            }
                        });
                        return delBtn.element;
                    }
                }
            ];
            return {
                type: 'quickgrid',
                page: true,
                autoPage: false,
                pageCount: CONSTANTS.taskTableSize,
                multiSelect: true,
                intervalColor: true,
                widgetName: _WD.taskTableWD,
                async: {
                    url: FR.servletURL,
                    type: 'POST',
                    data: {
                        op: FSSM.Control.scheduleConfig.scheduleOP,
                        cmd: FSSM.Control.scheduleConfig.getAllTasksURL,
                        start: 0,
                        count: CONSTANTS.taskTableSize,
                        serverID : FS.serverID
                    }
                },
                onPageTurn: function (active, count, nav) {
                    var async = this.options.async;
                    async.data.start = (active - 1) * count;
                    this.refresh();
                },
                onAsyncSuccess: function (res, status) {
                    var result = FR.jsonDecode(res);
                    this.options.items = result.tasks;
                    this.totalpages = Math.ceil(result.total / CONSTANTS.taskTableSize);
                },
                columnsConfig: columns
            }
        },

        /**
         * 运行监控面板的json配置
         * @private
         */
        _taskMonitorPaneConfig: function () {
            var self = this;
            var date = new Date();
            return {
                title: FR.i18nText("FS-Schedule-Operation_Monitoring"),
                content: {
                    widgetName: 'taskMonitorPanelWD',
                    type: 'panel',
                    width: 770,
                    height: 500,
                    doSize: true,
                    contentWidget: {
                        type: 'tablepane',
                        widgetName: 'taskMonitorTableWD',
                        colSize: [20, 60, 12, 139, 12, FR.i18nTextWidth('FS-Schedule-Start_Date') + 9, 12, 165, 12, FR.i18nTextWidth('FS-Schedule-End_Date') + 9, 12, 165, 12, 60, "fill"],
                        rowSize: [21, "fill"],
                        vgap: 20,
                        items: [
                            [
                                {}, {
                                type: 'llabel',
                                verticalcenter: true,
                                value: FR.i18nText("FS-Schedule-Task_Name")
                            }, {}, {
                                type: 'combocheckbox',
                                supportTag: false,
                                widgetName: "allTaskName"
                            }, {}, {
                                type: 'llabel',
                                verticalcenter: true,
                                value: FR.i18nText('FS-Schedule-Start_Date')
                            }, {}, {
                                type: "datetime",
                                directEdit: true,
                                format: "yyyy-MM-dd",
                                value: date,
                                widgetName: 'monitor_start_time'
                            }, {}, {
                                type: 'llabel',
                                verticalcenter: true,
                                value: FR.i18nText('FS-Schedule-End_Date')
                            }, {}, {
                                type: "datetime",
                                directEdit: true,
                                format: "yyyy-MM-dd",
                                value: date,
                                widgetName: 'monitor_end_time'
                            }, {}, {
                                type: 'quickbutton',
                                text: FR.i18nText("FS-Generic-Simple_Query"),
                                widgetName: 'monitor_query_button',
                                style: 'blue',
                                handler: function () {
                                    FSSM.Control.queryTaskLog();
                                }
                            }, null
                            ], [
                                $('<div/>').height(1),
                                null, null, null, null, null, null, null,
                                null, null, null, null, null, null,
                                self._createMonitorTable()
                            ]
                        ]
                    }
                }
            };
        },

        /**
         * 监控信息表
         * @private
         */
        _createMonitorTable: function () {
            var columns = [
                {
                    key: 'taskname',
                    value: FR.i18nText("FS-Schedule-Task_Name"),
                    width: 200
                }, {
                    key: 'logtime',
                    value: FR.i18nText("FS-Schedule-Task_Run_Moment"),
                    width: 200,
                    onCellCreate: function (rowIdx, colIdx, item) {
                        var t = item.logtime;
                        t = t.replace(/-/g, "/");
                        t = t.split('.')[0];
                        var date = new Date(t);
                        return $("<div/>").text(FR.date2Str(date, 'yyyy-MM-dd HH:mm:ss'));
                    }
                }, {
                    key: 'msg',
                    value: FR.i18nText('FS-Schedule-Task_Run_Info'),
                    width: 150,
                    onCellCreate: function (rowIdx, colIdx, item) {
                        if (!item.trace && !item.detailmsg) {
                            //信息
                            return $('<div/>').text(item.msg);
                        } else {
                            //错误
                            var $div = $('<div/>').css({
                                'cursor': 'pointer'
                            });
                            $('<div/>').text(item.msg).css({'float': 'left'}).appendTo($div);
                            $('<div class="fr_schedule_task_detail"/>')
                                .text(FR.i18nText('FS-System-Detail_Info'))
                                .appendTo($div);
                            $div.click(function (e) {
                                if (!item.trace && !item.detailmsg) {
                                    return;
                                }
                                var trace = item.trace;
                                var detailMsg = (item.detailmsg ? (item.detailmsg + "\n") : "") + (trace ? trace : "");
                                FSSM.Control.showTrace(detailMsg, e, this);
                            });
                            return $div;
                        }
                    }
                }, {
                    width: 150
                }
            ];
            return {
                type: 'quickgrid',
                page: true,
                autoPage: false,
                pageCount: 10,
                multiSelect: false,
                intervalColor: true,
                widgetName: _WD.taskLogTableWD,
                async: {
                    url: FR.servletURL,
                    data: {
                        op: FSSM.Control.scheduleConfig.scheduleOP,
                        cmd: FSSM.Control.scheduleConfig.monitorQueryURL,
                        start: 0,
                        count: 10,
                        taskname: "",
                        serverID : FS.serverID
                    }
                },
                onPageTurn: function (active, count, nav) {
                    var async = this.options.async;
                    async.data.start = (active - 1) * count;
                    this.refresh();
                },
                onAsyncSuccess: function (res, status) {
                    var result = FR.jsonDecode(res);
                    this.options.items = result.records;
                    this.totalpages = Math.ceil(result.total / 10);
                },
                columnsConfig: columns
            }
        },

        /**
         * 创建定时任务的对话框
         * @param task 定时任务配置的json对象
         */
        createTaskDialog: function (task) {
            var self = this;
            var dialogWidth = FR.i18nTextWidth('FS-Schedule-Restart_With_Frequency') > 210 ? 600 : 500;
            this.taskDialog = new FR.Dialog({
                title: FSSM.Control.scheduleConfig.taskAddText,               // 对话框的标题
                widgetName: _WD.taskDialogWD,
                width: dialogWidth,                 // 对话框的宽度
                height: 383,                // 对话框的高度
                modal: true,                // 是否是模态对话框（模态对话框将只有最上层的对话框可以被选中）
                confirm: false,              // 是否包含确定取消按钮面板，为false则弹出普通的对话框
                doSize: true,               // 初始化的时候是否需要计算内部元素大小，必须为true
                border: true,               // 对话框是否需要包含边框
                closable: true,             // 对话框是否可以被关闭，某些情况下需要通过API进行关闭此选项可以为false
                style: "blue",
                needSeparate: 8,
                otherButton: true,
                button4Other: [{
                    bT: FR.i18nText("FS-Generic-Simple_Next"),
                    bW: 80,
                    baseCls: 'nextButton',
                    bF: function () {
                        self.moveNextByStep();
                    }
                }, {
                    bT: FR.i18nText("FS-Generic-Simple_Previous"),
                    bW: 80,
                    invisible: true,
                    baseCls: 'preButton',
                    bF: function () {
                        self.movePreByStep();
                    }
                }],
                contentWidget: {
                    width: dialogWidth,
                    height: 300,
                    type: "card",
                    items: [
                        this._getFirstStepTableLayoutConfig(),
                        this._getSecondStepTableLayoutConfig(),
                        this._getThirdStepTableLayoutConfig()
                    ],
                    widgetName: _WD.taskCardLayoutWD,
                    defaultShowIndex: 0
                }
            });
            this._hideFirstStepRow();
            this.taskDialog.element.css({'color': '#000000'});
            this.taskDialog.setVisible(true);
            this.popTask();
        },

        /**
         * 设置的第一步，定时调度基本属性页面配置
         * @private
         */
        _getFirstStepTableLayoutConfig: function () {
            var self = this;
            var firstStepTableLayoutConfig = {
                type: 'tablelayout',
                columnSize: [89, 390, 'fill'],  //
                scrolly: true,
                rowSize: [10, 23, 23, 23, 28, 100],
                vgap: 17,
                widgetName: _WD.taskFirstTableLayoutWD,
                items: [
                    [
                        {
                            el: $('<div/>')
                        },
                        {
                            el: $('<div/>')
                        },
                        {
                            el: $('<div/>')
                        }
                    ],
                    [
                        {
                            el: $('<div/>')
                        },
                        {
                            el: this._createDialogTitle(1)
                        },
                        {
                            el: $('<div/>')
                        }
                    ],
                    [
                        {
                            el: this._createLeftLabel(FR.i18nText("FS-Schedule-Task_Name"))
                        },
                        {
                            el: {
                                type: 'text',
                                widgetName: _WD.taskNameWD,
                                width: 140
                            }
                        },
                        {
                            el: $('<div/>')
                        }
                    ],
                    [
                        {
                            el: this._createLeftLabel(FSSM.Control.scheduleConfig.choose)
                        },
                        {
                            el: FSSM.Control.scheduleConfig.chooseWidget
                        },
                        {
                            el: $('<div/>')
                        }
                    ],
                    [
                        {
                            el: this._createLeftLabel(FR.i18nText("FS-Generic-Report_Type")).css('margin-top', '4px')
                        },
                        {
                            el: {
                                type: 'radiogroup',
                                assureSelect: true,
                                items: [
                                    {
                                        text: FR.i18nText("FS-Generic-Simple_Preview"),
                                        value: 1
                                    },
                                    {
                                        text: FR.i18nText("FS-Generic-Face_Write"),
                                        value: 0
                                    },
                                    {
                                        text: FR.i18nText("FS-Report-Simple_Analysis"),
                                        value: 2
                                    }
                                ],
                                width: Math.max(200, 3 * (42 + Math.max(FR.i18nTextWidth("FS-Generic-Simple_Preview"),
                                    Math.max(FR.i18nTextWidth("FS-Generic-Face_Write"),
                                        FR.i18nTextWidth("FS-Report-Simple_Analysis"))))),
                                value: 1,
                                columnsInRow: 3,
                                widgetName: _WD.taskTemplateTypeWD
                            }
                        },
                        {
                            el: $('<div/>')
                        }
                    ],
                    [
                        {
                            el: this._createLeftLabel(FR.i18nText("FS-Generic-Parameter_Setting"))
                        },
                        {
                            el: {
                                type: "parametergrid",
                                widgetName: _WD.taskReportParameterGridWD,
                                width: 370
                            }
                        },
                        {
                            el: $('<div/>')
                        }
                    ]
                ]
            };
            return firstStepTableLayoutConfig;
        },

        /**
         * 设置的第二步，定时调度调度周期页面配置
         * @private
         */
        _getSecondStepTableLayoutConfig: function () {
            var self = this;
            var startPolicyRadioGroupWidth = FR.i18nTextWidth('FS-Schedule-Start_Policy_Immediately') > 110 ?
                (FR.i18nTextWidth('FS-Schedule-Start_Policy_Immediately') + 25) : 120;
            var restartWithFrequencyWidth = FR.i18nTextWidth('FS-Schedule-Restart_With_Frequency') > 210 ?
                (FR.i18nTextWidth('FS-Schedule-Restart_With_Frequency') + 30) : 220;
            var endTimeRadioGroupWidth = FR.i18nTextWidth('FS-Schedule-End_At_Time') > 90 ?
                (FR.i18nTextWidth('FS-Schedule-End_At_Time') + 30) : 128;
            var secondStepTablelayout = {
                type: 'tablelayout',
                scrolly: true,
                columnSize: [
                    FR.i18nTextWidth('FS-Schedule-Restart_Policy', 6.5) > 65 ?
                        (FR.i18nTextWidth('FS-Schedule-Restart_Policy', 6.5) + 30) : 90,
                    restartWithFrequencyWidth + 180,
                    'fill'
                ],
                rowSize: [10, 23, 46, 110, 33, 83, 55],
                vgap: 5,
                widgetName: _WD.taskSecondStepTableLayoutWD,
                items: [
                    [
                        {
                            el: $('<div/>')
                        }
                    ],
                    [
                        {
                            el: $('<div/>')
                        },
                        {
                            el: this._createDialogTitle(2)
                        },
                        {
                            el: $('<div/>')
                        }
                    ],
                    [
                        {
                            el: this._createLeftLabel(FR.i18nText('FS-Schedule-Start_Time')).addClass("mt5")
                        },
                        {
                            el: {
                                type: 'absolute',
                                items: [
                                    {
                                        type: 'radiogroup',
                                        assureSelect: true,
                                        items: [
                                            {
                                                text: FR.i18nText('FS-Schedule-Start_Policy_Immediately'),
                                                value: 1
                                            },
                                            {
                                                text: FR.i18nText('FS-Schedule-Start_Policy_At_Time'),
                                                value: 2
                                            }
                                        ],
                                        columnsInRow: 1,
                                        adaptive: false,
                                        widgetName: _WD.taskStartTimeSetRadioboxWD,
                                        width: startPolicyRadioGroupWidth,
                                        height: 46,
                                        value: 1,
                                        x: 2,
                                        y: 0,
                                        listeners: [{
                                            eventName: 'statechange',
                                            action: function () {
                                                var value = this.getValue();
                                                var startTimeDate = self.getWidgetFromTaskCardLayout(_WD.taskStartTimeWD);
                                                if (value === 1) {
                                                    startTimeDate.setEnable(false);
                                                } else {
                                                    startTimeDate.setEnable(true);
                                                }
                                            }
                                        }]
                                    },
                                    {
                                        type: "datetime",
                                        disable: false,
                                        directEdit: true,
                                        format: "yyyy-MM-dd HH:mm:ss",
                                        widgetName: _WD.taskStartTimeWD,
                                        value: new Date(),
                                        disabled: true,
                                        width: 166,
                                        height: 20,
                                        x: startPolicyRadioGroupWidth + 10,
                                        y: 25
                                    }
                                ]
                            }
                        },
                        {
                            el: $('<div/>')
                        }
                    ],
                    [
                        {
                            el: this._createLeftLabel(FR.i18nText('FS-Schedule-Execute_Frequency')).addClass("mt5")
                        },
                        {
                            el: {
                                type: 'absolute',
                                items: [
                                    {
                                        type: 'radiogroup',
                                        assureSelect: true,
                                        items: [
                                            {
                                                text: FR.i18nText("FS-Schedule-Execute_Once"),
                                                value: 0
                                            },
                                            {
                                                text: FR.i18nText('FS-Schedule-Execute_Repeat_Simply'),
                                                value: 1
                                            },
                                            {
                                                text: FR.i18nText('FS-Schedule-Execute_By_Frequency'),
                                                value: 2
                                            },
                                            {
                                                text: FR.i18nText('FS-Schedule-Execute_By_Expression'),
                                                value: 3
                                            }
                                        ],
                                        columnsInRow: 1,
                                        adaptive: false,
                                        widgetName: _WD.taskFrequencyTypeGroupWD,
                                        width: 115,
                                        height: 110,
                                        x: 2,
                                        y: 0,
                                        value: 0,
                                        listeners: [
                                            {
                                                eventName: 'statechange',
                                                action: function () {
                                                    var frequencyCardLayout = self.taskFrequencyCardLayout();
                                                    frequencyCardLayout.element.addClass("bl1d");
                                                    var frequencyType = this.getValue();

                                                    frequencyCardLayout.showCardByIndex(frequencyType);
                                                    self._showEndTimeCard(frequencyType);

                                                    var tablelayout = self.getWidgetFromTaskCardLayout(_WD.taskSecondStepTableLayoutWD);
                                                    var rowSize = self._getTableLayoutRowSize(frequencyType);
                                                    tablelayout.refreshRowSize(rowSize);
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        type: "card",
                                        items: [this._frequencyCard1(), this._frequencyCard2(), this._frequencyCard3(), this._frequencyCard4()],
                                        widgetName: _WD.taskFrequencyCardLayoutWD,
                                        defaultShowIndex: 0,
                                        x: 120,
                                        y: 0,
                                        width: 350,
                                        height: 160
                                    }
                                ]
                            }
                        },
                        {
                            el: $('<div/>')
                        }
                    ],
                    [
                        {
                            el: this._createLeftLabel(FR.i18nText("FS-Generic-End_Time"))
                        },
                        {
                            el: {
                                type: "card",
                                widgetName: _WD.taskSecondStepEndTimeCardLayoutWD,
                                defaultShowIndex: 0,
                                items: [
                                    //任务执行一次后即结束
                                    {
                                        type: "absolute",
                                        items: [
                                            {
                                                type: 'checkbox',
                                                text: '',
                                                value: true,
                                                disabled: true,
                                                height: 21,
                                                x: 2,
                                                y: 1
                                            },
                                            {
                                                type: 'llabel',
                                                value: FR.i18nText('FS-Schedule-End_If_Executed'),
                                                height: 21,
                                                width: FR.i18nTextWidth('FS-Schedule-End_If_Executed') + 15,
                                                x: 25,
                                                y: 0
                                            }
                                        ]
                                    },
                                    //无限期，结束时间，额外重复执行次数。
                                    {
                                        type: "absolute",
                                        items: [
                                            {
                                                type: 'radiogroup',
                                                assureSelect: true,
                                                items: [
                                                    {text: FR.i18nText("FS-Schedule-Simple_Unlimited"), value: 0},
                                                    {text: FR.i18nText('FS-Schedule-End_At_Time'), value: 1},
                                                    {text: FR.i18nText('FS-Schedule-Extra_Execute_Times'), value: 2}
                                                ],
                                                columnsInRow: 1,
                                                value: 0,
                                                adaptive: false,
                                                widgetName: _WD.taskSecondStenEndTimeRadioGroupWD,
                                                width: endTimeRadioGroupWidth,
                                                height: '100%',//REPORT-444 父层会限定高度的,100%就可以解决问题
                                                x: 2,
                                                y: 0,
                                                doSize: true,
                                                listeners: [{
                                                    eventName: 'statechange', action: function () {
                                                        var value = this.getValue();
                                                        var endTimeWidget = self.getWidgetFromEndTimeCardLayout(_WD.taskEndTimeWD);
                                                        var repeatTimesWidget = self.getWidgetFromEndTimeCardLayout(_WD.taskRepeatTimesWD);
                                                        switch (value) {
                                                            case 0:
                                                                endTimeWidget.setEnable(false);
                                                                repeatTimesWidget.setEnable(false);
                                                                break;
                                                            case 1:
                                                                endTimeWidget.setEnable(true);
                                                                repeatTimesWidget.setEnable(false);
                                                                break;
                                                            case 2:
                                                                endTimeWidget.setEnable(false);
                                                                repeatTimesWidget.setEnable(true);
                                                                break;
                                                        }
                                                    }
                                                }]
                                            },
                                            {
                                                type: "datetime",
                                                disabled: true,
                                                directEdit: true,
                                                format: "yyyy-MM-dd HH:mm:ss",
                                                widgetName: _WD.taskEndTimeWD,
                                                value: new Date(),
                                                width: 166,
                                                height: 20,
                                                disable: true,
                                                x: endTimeRadioGroupWidth + 7,
                                                y: 25
                                            },
                                            {
                                                type: "number",
                                                disabled: true,
                                                widgetName: _WD.taskRepeatTimesWD,
                                                width: 61,
                                                height: 20,
                                                x: endTimeRadioGroupWidth + 7,
                                                y: 55
                                            },
                                            {
                                                type: "label",
                                                width: 50,
                                                height: 21,
                                                value: FR.i18nText("FS-Schedule-Simple_Times"),
                                                x: endTimeRadioGroupWidth + 72,
                                                y: 55
                                            }
                                        ]
                                    }
                                ]
                            }
                        },
                        {
                            el: $('<div/>')
                        }
                    ],
                    [
                        {
                            el: this._createLeftLabel(FR.i18nText('FS-Schedule-Execute_Condition')).addClass("mt5")
                        },
                        {
                            el: {
                                type: 'absolute',
                                items: [
                                    {
                                        type: 'radiogroup',
                                        assureSelect: true,
                                        items: [
                                            {
                                                text: FR.i18nText('FS-Schedule-Execute_Condition_Always'),
                                                value: 0
                                            },
                                            {
                                                text: FR.i18nText('FS-Schedule-Execute_Condition_Formula'),
                                                value: 1
                                            },
                                            {
                                                text: FR.i18nText('FS-Schedule-Execute_Condition_Custom_Class'),
                                                value: 2
                                            }
                                        ],
                                        columnsInRow: 1,
                                        widgetName: _WD.taskConditionTypeGroupWD,
                                        adaptive: false,
                                        width: 200,
                                        height: 83,
                                        x: 2,
                                        y: 0,
                                        value: 0,
                                        listeners: [
                                            {
                                                eventName: 'statechange',
                                                action: function () {
                                                    var conditionCardLayout = self.getWidgetFromTaskCardLayout(_WD.taskConditionCardLayoutWD);
                                                    var conditionType = this.getValue();
                                                    conditionCardLayout.showCardByIndex(conditionType);
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        type: "card",
                                        items: [this._conditionCard1(), this._conditionCard2(), this._conditionCard3()],
                                        widgetName: _WD.taskConditionCardLayoutWD,
                                        defaultShowIndex: 0,
                                        x: 120,
                                        y: 0,
                                        baseCls: 'bl1d',
                                        width: 350,
                                        height: 78
                                    }
                                ]
                            }
                        },
                        {
                            el: $('<div/>')
                        }

                    ],
                    [
                        {
                            el: this._createLeftLabel(FR.i18nText('FS-Schedule-Restart_Policy'))
                        },
                        {
                            el: {
                                type: 'absolute',
                                items: [
                                    {
                                        type: 'checkbox',
                                        text: FR.i18nText('FS-Schedule-Restart_With_Frequency'),
                                        widgetName: _WD.taskRestartFromFailCheckBoxWD,
                                        x: 2,
                                        y: 0,
                                        width: restartWithFrequencyWidth,
                                        height: 25,
                                        listeners: [{
                                            eventName: 'afteredit',
                                            action: function () {
                                                var value = this.getValue();
                                                if (value === true) {
                                                    self.getWidgetFromTaskCardLayout(_WD.taskRestartExecuteMinuteWD).setEnable(true);
                                                    self.getWidgetFromTaskCardLayout(_WD.taskRestartExecuteTimesWD).setEnable(true);
                                                    self.getWidgetFromTaskCardLayout(_WD.taskRestartExecuteMinuteLabelWD).setEnable(true);
                                                    self.getWidgetFromTaskCardLayout(_WD.taskRestartExecuteTimesLabelWD).setEnable(true);
                                                    self.getWidgetFromTaskCardLayout(_WD.taskRestartExecuteMostTimeRestartLabelWD).setEnable(true);
                                                } else {
                                                    self.getWidgetFromTaskCardLayout(_WD.taskRestartExecuteMinuteWD).setEnable(false);
                                                    self.getWidgetFromTaskCardLayout(_WD.taskRestartExecuteTimesWD).setEnable(false);
                                                    self.getWidgetFromTaskCardLayout(_WD.taskRestartExecuteMinuteLabelWD).setEnable(false);
                                                    self.getWidgetFromTaskCardLayout(_WD.taskRestartExecuteTimesLabelWD).setEnable(false);
                                                    self.getWidgetFromTaskCardLayout(_WD.taskRestartExecuteMostTimeRestartLabelWD).setEnable(false);
                                                }
                                            }
                                        }]
                                    },
                                    {
                                        type: 'label',
                                        widgetName: _WD.taskRestartExecuteMostTimeRestartLabelWD,
                                        verticalcenter: true,
                                        value: FR.i18nText("FS-Generic-Most_Time_Restart"),
                                        x: 22,
                                        y: 27,
                                        width: 140,
                                        height: 21,
                                        disabled: true
                                    },
                                    {
                                        type: 'number',
                                        allowDecimals: false,
                                        allowNegative: false,
                                        widgetName: _WD.taskRestartExecuteMinuteWD,
                                        x: restartWithFrequencyWidth + 10,
                                        y: 0,
                                        height: 21,
                                        width: 48,
                                        disabled: true
                                    },
                                    {
                                        type: 'label',
                                        widgetName: _WD.taskRestartExecuteMinuteLabelWD,
                                        verticalcenter: true,
                                        value: FR.i18nText("FS-Generic-Simple_Minute"),
                                        x: restartWithFrequencyWidth + 65,
                                        y: 0,
                                        height: 21,
                                        width: 80,
                                        disabled: true
                                    },
                                    {
                                        type: 'number',
                                        allowDecimals: false,
                                        allowNegative: false,
                                        widgetName: _WD.taskRestartExecuteTimesWD,
                                        x: restartWithFrequencyWidth + 10,
                                        y: 27,
                                        height: 21,
                                        width: 48,
                                        disabled: true
                                    },
                                    {
                                        type: 'label',
                                        widgetName: _WD.taskRestartExecuteTimesLabelWD,
                                        verticalcenter: true,
                                        value: FR.i18nText("FS-Schedule-Simple_Times"),
                                        x: restartWithFrequencyWidth + 65,
                                        y: 27,
                                        height: 21,
                                        width: 80,
                                        disabled: true
                                    }
                                ]
                            }
                        },
                        {
                            el: $('<div/>')
                        }
                    ]
                ]
            }
            return secondStepTablelayout;
        },

        outputFileConfig: function() {
            var self = this;
            if(!FSSM.outputFileConfig) {
                FSSM.outputFileConfig = {
                    emailNotification: {
                        rowHeight:[23, 267],
                        element:[
                            [
                                {
                                    el: $("<div/>")
                                },
                                {
                                    el: this._createEmailOptionConfig()
                                },
                                {
                                    el: $('<div/>')
                                }
                            ],
                            [
                                {
                                    el: $("<div/>")
                                },
                                {
                                    el: this._createEmailDetailConfig()
                                },
                                {
                                    el: $('<div/>')
                                }
                            ]
                        ],
                        toJson:function() {
                            var emailNotification = {};
                            emailNotification.toAddress = self.emailContactWidget.getValue();
                            emailNotification.ccAddress = self.emailCopyContactWidget.getValue();
                            emailNotification.bccAddress = self.emailSecretContactWidget.getValue();
                            emailNotification.subject = FR.cjkEncode(self.getWidgetFromTaskCardLayout(_WD.taskSubjectWD).getValue());
                            emailNotification.bodyContent = FR.cjkEncode(self.getWidgetFromTaskCardLayout(_WD.taskContentWD).getValue());
                            emailNotification.canPreviewAttach = self.getWidgetFromTaskCardLayout(_WD.taskEmailCanPreviewAttachCheckboxWD).getValue();
                            emailNotification.isRole = self.getWidgetFromTaskCardLayout(_WD.taskEmailRoleWD).getValue() === 2;
                            self.emailContactWidget.setValue("");
                            self.emailCopyContactWidget.setValue("");
                            self.emailSecretContactWidget.setValue("");
                            return emailNotification;
                        },
                        isSelected:function() {
                            return self.getWidgetFromTaskCardLayout(_WD.taskEmailCheckboxWD).getValue();
                        },
                        deSelect:function() {
                            self.getWidgetFromTaskCardLayout(_WD.taskEmailCheckboxWD).setValue(false, true);
                        },
                        select:function() {
                            self.getWidgetFromTaskCardLayout(_WD.taskEmailCheckboxWD).setValue(true, true);
                        },
                        pop:function(config) {
                            self.getWidgetFromTaskCardLayout(_WD.taskEmailRoleWD).setValue(config.isRole ? 2 : 1);
                            self.emailContactWidget.setValue(config.toAddress)
                            self.emailCopyContactWidget.setValue(config.ccAddress);
                            self.emailSecretContactWidget.setValue(config.bccAddress);
                            self.getWidgetFromTaskCardLayout(_WD.taskSubjectWD).setValue(config.subject);
                            self.getWidgetFromTaskCardLayout(_WD.taskContentWD).setValue(config.bodyContent);
                            self.getWidgetFromTaskCardLayout(_WD.taskEmailCanPreviewAttachCheckboxWD).setValue(config.canPreviewAttach, true);
                        }
                    },

                    ftpTransmission: {
                        rowHeight:[23, 135],
                        element:[
                            [
                                {
                                    el: $("<div/>")
                                },
                                {
                                    el: this._createFtpOptionConfig()
                                },
                                {
                                    el: $('<div/>')
                                }
                            ],
                            [
                                {
                                    el: $("<div/>")
                                },
                                {
                                    el: this._createFtpDetailConfig()
                                },
                                {
                                    el: $('<div/>')
                                }
                            ]
                        ],
                        toJson:function() {
                            var ftpTransmission = {};
                            ftpTransmission.serverAddress = self.getWidgetFromTaskCardLayout(_WD.taskFtpAddressWD).getValue();
                            ftpTransmission.port = self.getWidgetFromTaskCardLayout(_WD.taskFtpPortWD).getValue();
                            ftpTransmission.savePath = self.getWidgetFromTaskCardLayout(_WD.taskFtpSavePathWD).getValue();
                            ftpTransmission.username = self.getWidgetFromTaskCardLayout(_WD.taskFtpUsernameWD).getValue();
                            ftpTransmission.password = self.getWidgetFromTaskCardLayout(_WD.taskFtpPasswordWD).getValue();
                            return ftpTransmission;
                        },
                        isSelected:function() {
                            return self.getWidgetFromTaskCardLayout(_WD.taskFtpCheckboxWD).getValue();
                        },
                        deSelect:function() {
                            self.getWidgetFromTaskCardLayout(_WD.taskFtpCheckboxWD).setValue(false, true);
                        },
                        select:function() {
                            self.getWidgetFromTaskCardLayout(_WD.taskFtpCheckboxWD).setValue(true, true);
                        },
                        pop:function(config) {
                            self.getWidgetFromTaskCardLayout(_WD.taskFtpAddressWD).setValue(config.serverAddress);
                            self.getWidgetFromTaskCardLayout(_WD.taskFtpPortWD).setValue(config.port);
                            self.getWidgetFromTaskCardLayout(_WD.taskFtpSavePathWD).setValue(config.savePath);
                            self.getWidgetFromTaskCardLayout(_WD.taskFtpUsernameWD).setValue(config.username);
                            self.getWidgetFromTaskCardLayout(_WD.taskFtpPasswordWD).setValue(config.password);
                        }
                    },

                    classOutputFileAction: {
                        rowHeight:[23, 25],
                        element:[
                            [
                                {
                                    el: $("<div/>")
                                },
                                {
                                    el: this._createSelfDefineOptionConfig()
                                },
                                {
                                    el: $('<div/>')
                                }
                            ],
                            [
                                {
                                    el: $("<div/>")
                                },
                                {
                                    el: this._createSelfDefineDetailConfig()
                                },
                                {
                                    el: $('<div/>')
                                }
                            ]
                        ],
                        toJson:function() {
                            var classOutputFileAction = {};
                            var className = self.getWidgetFromTaskCardLayout(_WD.taskSelfDefineClassNameWD).getValue().join(".");
                            if (className.endWith(CONSTANTS.CLASS_SUFFIX)) {
                                className = className.substr(0, className.length - CONSTANTS.CLASS_SUFFIX.length);
                            }
                            classOutputFileAction.customClassName = className;
                            return classOutputFileAction;
                        },
                        isSelected:function() {
                            return self.getWidgetFromTaskCardLayout(_WD.taskSelfDefineCheckboxWD).getValue();
                        },
                        deSelect:function() {
                            self.getWidgetFromTaskCardLayout(_WD.taskSelfDefineCheckboxWD).setValue(false, true);
                        },
                        select:function() {
                            self.getWidgetFromTaskCardLayout(_WD.taskSelfDefineCheckboxWD).setValue(true, true);
                        },
                        pop:function(config) {
                            self.getWidgetFromTaskCardLayout(_WD.taskSelfDefineClassNameWD).setValue(config.customClassName);
                        }
                    },

                    printRWorkbookAction: {
                        rowHeight:[23, 25],
                        element:[
                            [
                                {
                                    el: $("<div/>")
                                },
                                {
                                    el: this._createPrinterOptionConfig()
                                },
                                {
                                    el: $('<div/>')
                                }
                            ],
                            [
                                {
                                    el: $("<div/>")
                                },
                                {
                                    el: this._createPrinterDetailConfig()
                                },
                                {
                                    el: $('<div/>')
                                }
                            ]
                        ],
                        toJson:function() {
                            printRWorkbookAction = {};
                            printRWorkbookAction.printerName = self.getWidgetFromTaskCardLayout(_WD.taskPrinterNameWD).getValue();
                            return printRWorkbookAction;
                        },
                        isSelected:function() {
                            return self.getWidgetFromTaskCardLayout(_WD.taskPrinterCheckboxWD).getValue();
                        },
                        deSelect:function() {
                            self.getWidgetFromTaskCardLayout(_WD.taskPrinterCheckboxWD).setValue(false, true);
                        },
                        select:function() {
                            self.getWidgetFromTaskCardLayout(_WD.taskPrinterCheckboxWD).setValue(true, true);
                        },
                        pop:function(config) {
                            self.getWidgetFromTaskCardLayout(_WD.taskPrinterNameWD).setValue(config.printerName);
                        }
                    },

                    pushAction: {
                        rowHeight:[23, 50],
                        element:[
                            [
                                {
                                    el: $("<div/>")
                                },
                                {
                                    el: this._createPushOptionConfig()
                                },
                                {
                                    el: $('<div/>')
                                }
                            ],
                            [
                                {
                                    el: $("<div/>")
                                },
                                {
                                    el: this._createPushDetailConfig()
                                },
                                {
                                    el: $('<div/>')
                                }
                            ]
                        ],
                        toJson:function() {
                            var pushAction = {};
                            pushAction.content = self.getWidgetFromTaskCardLayout(_WD.taskPushTextWD).getValue();
                            return pushAction;
                        },
                        isSelected:function() {
                            return self.getWidgetFromTaskCardLayout(_WD.taskPushCheckboxWD).getValue();
                        },
                        deSelect:function() {
                            self.getWidgetFromTaskCardLayout(_WD.taskPushCheckboxWD).setValue(false, true);
                        },
                        select:function() {
                            self.getWidgetFromTaskCardLayout(_WD.taskPushCheckboxWD).setValue(true, true);
                        },
                        pop:function(config) {
                            self.getWidgetFromTaskCardLayout(_WD.taskPushTextWD).setValue(config.content);
                        }
                    }
                };
            }
            var provider = FS.Plugin.ScheduleOutputActionProvider;
            var items = provider.items;
            $.each(items, function(i, item) {
                if ($.isFunction(item.action) && FR.Plugin.validLevel(provider, item)) {
                    item.action.call(self);
                }
            });
            // richie:这是是一个兼容写法
            if($.isFunction(FS.Plugin.addScheduleOutputFileAction)) {
                FS.Plugin.addScheduleOutputFileAction(this);
            }

            return FSSM.outputFileConfig;
        },

        /**
         * 通知配置
         * @private
         */
        _createNotificationConfig: function() {
            var config = [];
            for(var notificationType in this.outputFileConfig()) {
                config = config.concat(this.outputFileConfig()[notificationType].element);
            }
            return config;
        },

        _createNotificationRowSize: function() {
            var rowSize = [];
            for(var notificationType in this.outputFileConfig()) {
                rowSize = rowSize.concat(this.outputFileConfig()[notificationType].rowHeight);
            }
            return rowSize;
        },

        /**
         * 设置的第三步
         * @private
         */
        _getThirdStepTableLayoutConfig: function () {
            var self = this;
            var descriptionLabelWidth = parseInt(FR.i18nText("FS-Schedule-Step3_Label_Width") || 100);
            var outputDifferentContentCheckboxWidth = FR.i18nTextWidth('FS-Schedule-Output_Different_Content_By_Different_User') > 190 ?
                (FR.i18nTextWidth('FS-Schedule-Output_Different_Content_By_Different_User') + 30) : 200;
            var items = [
                [
                    {
                        el: $('<div/>')
                    }
                ],
                [
                    {
                        el: $('<div/>')
                    },
                    {
                        el: this._createDialogTitle(3)
                    },       //
                    {
                        el: $('<div/>')
                    }
                ],
                [
                    {
                        el: this._createThirdStepLeftLabel(FR.i18nText('FS-Schedule-Output_File_Name'))
                    },
                    {
                        el: {
                            type: 'text',
                            widgetName: _WD.taskFileNameWD,
                            height: 21,
                            width: 234
                        }
                    },
                    {
                        el: $('<div/>')
                    }
                ],
                [
                    {
                        el: this._createThirdStepLeftLabel(FR.i18nText('FS-Schedule-Output_File_Description'))
                    },
                    {
                        el: {
                            type: 'textarea',
                            widgetName: _WD.taskFileDescriptionWD,
                            height: 80,
                            width: 234,
                            x: 0,
                            y: 0
                        }
                    },
                    {
                        el: $('<div/>')
                    }
                ],
                [
                    {
                        el: self._createThirdStepLeftLabel(FR.i18nText('FS-Schedule-Output_Mount_Virtual_Directory'))
                    },
                    {
                        el: {
                            type: 'absolute',
                            items: [
                                {
                                    type: 'treecombobox',
                                    returnFullPath: true,
                                    widgetName: _WD.taskVirtureDirectoryWD,
                                    x: 0,
                                    y: 0,
                                    height: 21,
                                    width: 234,
                                    widgetUrl: FR.servletURL + "?op=fs_entry&cmd=getfolder&serverID=" + FS.serverID
                                },
                                {
                                    type: 'checkbox',
                                    text: FR.i18nText('FS-Schedule-Output_Different_Content_By_Different_User'),
                                    fontweight: 'bold',
                                    widgetName: _WD.taskVirtureDirectoryByUserWD,
                                    x: 0,
                                    y: 30,
                                    height: 21,
                                    width: outputDifferentContentCheckboxWidth,
                                    listeners: [{
                                        eventName: 'afteredit',
                                        action: function () {
                                            var value = this.getValue();
                                            var widget = self.getWidgetFromTaskCardLayout(_WD.taskVirtureDirectoryComboByUserWD);
                                            widget.setEnable(value);
                                        }
                                    }]
                                },
                                {
                                    type: 'combocheckbox',
                                    supportTag: false,
                                    widgetName: _WD.taskVirtureDirectoryComboByUserWD,
                                    widgetUrl: FR.servletURL + "?op=fs_set&cmd=auth_getallusers&serverID=" + FS.serverID,
                                    disabled: true,
                                    x: outputDifferentContentCheckboxWidth + 10,
                                    y: 30,
                                    height: 23,
                                    width: 120
                                }
                            ]
                        }
                    },
                    {
                        el: $('<div/>')
                    }
                ],
                [
                    {
                        el: this._createThirdStepLeftLabel(FR.i18nText('FS-Schedule-Output_Information_And_Archive'))
                    },
                    {
                        el: this._createAttachmentTypeConfig()
                    },
                    {
                        el: $('<div/>')
                    }
                ]
            ];
            items = items.concat(this._createNotificationConfig());
            var rowSize = [10, 23, 23, 80, 55, 25];
            rowSize = rowSize.concat(this._createNotificationRowSize());
            var thirdStepTableLayout = {
                type: 'tablelayout',
                scrolly: true,
                position: 'relative',
                widgetName: _WD.taskThirdTableLayoutWD,
                columnSize: [descriptionLabelWidth, outputDifferentContentCheckboxWidth + 200, 'fill'],
                rowSize: rowSize,
                vgap: 5,
                width: 498,                 // 对话框的宽度
                height: 298,
                items: items
            };
            return thirdStepTableLayout;
        },

        /**
         * 定时周期设置频率用到的卡片布局-一
         * @private
         */
        _frequencyCard1: function () {
            return $('<div/>').addClass("bl1d").css({
                width: 350,
                height: 110
            });
        },
        /**
         * 定时周期设置频率用到的卡片布局-二
         * @private
         */
        _frequencyCard2: function () {
            return {
                type: 'absolute',
                width: 350,
                height: 110,
                items: [
                    {
                        type: 'label',
                        verticalcenter: true,
                        value: FR.i18nText('FS-Schedule-Interval_Execute_Interval'),
                        x: 9,
                        y: 0,
                        height: 21,
                        width: 40
                    },
                    {
                        type: 'text',
                        widgetName: _WD.taskSimpleRepeatWD,
                        x: 48,
                        y: 0,
                        height: 23,
                        width: 48
                    },
                    {
                        type: 'combo',
                        value: 1,
                        items: [
                            {
                                text: FR.i18nText("FS-Generic-Simple_Minute"),
                                value: 1
                            },
                            {
                                text: FR.i18nText("FS-Generic-Simple_Hour"),
                                value: 2
                            },
                            {
                                text: FR.i18nText("FS-Generic-Simple_Day"),
                                value: 3
                            },
                            {
                                text: FR.i18nText("FS-Generic-Simple_Week"),
                                value: 4
                            }
                        ],
                        widgetName: _WD.taskRepeatUnitWD,
                        x: 105,
                        y: 0,
                        height: 23,
                        width: 66
                    },
                    {
                        type: 'label',
                        verticalcenter: true,
                        value: FR.i18nText('FS-Schedule-Interval_Execute_Once'),
                        x: 180,
                        y: 0,
                        height: 21,
                        width: 120
                    }
                ]
            }
        },

        /**
         * 定时周期设置频率用到的卡片布局-三
         * @private
         */
        _frequencyCard3: function () {
            var self = this;
            var monthItems = [];
            for (var i = 1; i < 32; i++) {
                var item = {
                    text: i + FR.i18nText("FS-Generic-Simgle_Number"),
                    value: i
                };
                monthItems.push(item);
            }
            // 选择每月最后一天执行
            var lastDayItem = {
                text: FR.i18nText("FS-Generic-Last_Day"),
                value: 32
            };
            var perTimeLabelX = 60, perTimeLabelWidth = parseInt(FR.i18nText("FS-Schedule-Frequency_Label_Width") || 50);

            monthItems.push(lastDayItem);
            return {
                type: 'absolute',
                width: 350,
                height: 160,
                items: [
                    //第一行
                    {
                        type: 'label',
                        verticalcenter: true,
                        value: FR.i18nText("FS-Schedule-Simple_Execute_Time"),
                        x: 9,
                        y: 0,
                        height: 21,
                        width: 50
                    },
                    {
                        type: 'text',
                        widgetName: _WD.taskExecuteHourWD,
                        x: 67,
                        y: 0,
                        height: 23,
                        width: 48
                    },
                    {
                        type: 'label',
                        verticalcenter: true,
                        value: FR.i18nText('FS-Schedule-Simple_Execute_Time_Unit_Hour'),
                        x: 120,
                        y: 0,
                        height: 21,
                        width: 15
                    },
                    {
                        type: 'text',
                        widgetName: _WD.taskExecuteMinuteWD,
                        x: 140,
                        y: 0,
                        height: 23,
                        width: 48
                    },
                    {
                        type: 'label',
                        verticalcenter: true,
                        value: FR.i18nText('FS-Schedule-Simple_Execute_Time_Unit_Minute'),
                        x: 193,
                        y: 0,
                        height: 21,
                        width: 15
                    },
                    //第二行
                    {
                        type: 'label',
                        verticalcenter: true,
                        value: FR.i18nText('FS-Schedule-Simple_Execute_Time_Unit_Day'),
                        x: 9,
                        y: 31,
                        height: 21,
                        width: 50
                    },
                    {
                        type: 'radiogroup',
                        assureSelect: true,
                        items: [
                            {text: FR.i18nText('FS-Schedule-Execute_Period_Time_Unit_Day'), value: 1},
                            {text: FR.i18nText('FS-Schedule-Execute_Period_Time_Unit_Week'), value: 2},
                            {text: FR.i18nText('FS-Schedule-Execute_Period_Time_Unit_Month'), value: 3}
                        ],
                        columnsInRow: 1,
                        adaptive: false,
                        value: 1,
                        widgetName: _WD.taskDefinedExecuteUnitWD,
                        width: perTimeLabelWidth,
                        height: 80,
                        x: perTimeLabelX,
                        y: 31,
                        doSize: true,
                        listeners: [
                            {
                                eventName: 'statechange',
                                action: function () {
                                    var value = this.getValue();
                                    var weekWidget = self.getWidgetFromFrequencyCardLayout(_WD.taskSecondStepUnitEveryWeekWD);
                                    var monthWidget = self.getWidgetFromFrequencyCardLayout(_WD.taskSecondStepUnitEveryMonthWD);
                                    switch (value) {
                                        case 1:
                                            weekWidget.setEnable(false);
                                            monthWidget.setEnable(false);
                                            break;
                                        case 2:
                                            weekWidget.setEnable(true);
                                            monthWidget.setEnable(false);
                                            break;
                                        case 3:
                                            weekWidget.setEnable(false);
                                            monthWidget.setEnable(true);
                                            break;
                                    }
                                }
                            }
                        ]
                    },
                    {
                        type: 'combocheckbox',
                        widgetName: _WD.taskSecondStepUnitEveryWeekWD,
                        supportTag: false,
                        disabled: true,
                        x: perTimeLabelX + perTimeLabelWidth + 10,
                        y: 58,
                        height: 21,
                        width: 197 - perTimeLabelWidth,
                        items: [
                            {
                                text: FR.i18nText("FS-Generic-Simple_Mon"),
                                value: 2
                            },
                            {
                                text: FR.i18nText("FS-Generic-Simple_Tue"),
                                value: 3
                            },
                            {
                                text: FR.i18nText("FS-Generic-Simple_Wed"),
                                value: 4
                            },
                            {
                                text: FR.i18nText("FS-Generic-Simple_Thu"),
                                value: 5
                            },
                            {
                                text: FR.i18nText("FS-Generic-Simple_Fri"),
                                value: 6
                            },
                            {
                                text: FR.i18nText("FS-Generic-Simple_Sat"),
                                value: 7
                            },
                            {
                                text: FR.i18nText("FS-Generic-Simple_Sun"),
                                value: 1
                            }
                        ]
                    },
                    {
                        type: 'combocheckbox',
                        widgetName: _WD.taskSecondStepUnitEveryMonthWD,
                        supportTag: false,
                        disabled: true,
                        x: perTimeLabelX + perTimeLabelWidth + 10,
                        y: 88,
                        height: 21,
                        width: 197 - perTimeLabelWidth,
                        items: monthItems
                    },
                    {
                        type: 'label',
                        verticalcenter: true,
                        value: FR.i18nText('FS-Schedule-Simple_Execute_Time_Unit_Month'),
                        x: 9,
                        y: 121,
                        height: 21,
                        width: 50
                    },
                    {
                        type: 'combocheckbox',
                        widgetName: _WD.taskUnitExecuteMonthWD,
                        supportTag: false,
                        x: 60,
                        y: 121,
                        height: 21,
                        width: 159,
                        value: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12],
                        items: [
                            {text: FR.i18nText("FS-Generic-Simple_January"), value: 1},
                            {text: FR.i18nText("FS-Generic-Simple_February"), value: 2},
                            {text: FR.i18nText("FS-Generic-Simple_March"), value: 3},
                            {text: FR.i18nText("FS-Generic-Simple_April"), value: 4},
                            {text: FR.i18nText("FS-Generic-Simple_May"), value: 5},
                            {text: FR.i18nText("FS-Generic-Simple_June"), value: 6},
                            {text: FR.i18nText("FS-Generic-Simple_July"), value: 7},
                            {text: FR.i18nText("FS-Generic-Simple_August"), value: 8},
                            {text: FR.i18nText("FS-Generic-Simple_September"), value: 9},
                            {text: FR.i18nText("FS-Generic-Simple_October"), value: 10},
                            {text: FR.i18nText("FS-Generic-Simple_November"), value: 11},
                            {text: FR.i18nText("FS-Generic-Simple_December"), value: 12}
                        ]
                    }
                ]
            }
        },

        /**
         * 定时周期设置频率用到的卡片布局-四
         * @private
         */
        _frequencyCard4: function () {
            var self = this;
            var cronExpressions = [{
                text: FR.i18nText("FS-Generic-Cro_Expression_1"),
                value: "0 50 19 L * ?"
            }, {
                text: FR.i18nText("FS-Generic-Cro_Expression_2"),
                value: "0 50 19 LW * ?"
            }, {
                text: FR.i18nText("FS-Generic-Cro_Expression_3"),
                value: "0 50 19 ? * 6#4"
            }, {
                text: FR.i18nText("FS-Generic-Cro_Expression_4"),
                value: "0 50 19 * 10-12 ? 2013"
            }, {
                text: FR.i18nText("FS-Generic-Cro_Expression_5"),
                value: "0 0 9,18 ? * MON-FRI"
            }];
            return {
                type: 'absolute',
                items: [
                    {
                        type: 'text',
                        widgetName: _WD.taskExpressionTextWD,
                        x: 9,
                        y: 0,
                        height: 25,
                        width: 147
                    },
                    {
                        type: 'button',
                        text: FR.i18nText('FS-Schedule-Prepare_Expression'),
                        x: 163,
                        y: 0,
                        height: 25,
                        width: FR.i18nTextWidth('FS-Schedule-Prepare_Expression') > 60 ?
                            (FR.i18nTextWidth('FS-Schedule-Prepare_Expression')  + 20) : 80,
                        listeners: [{
                            eventName: "click",
                            action: function () {
                                var expressionlist = self.getWidgetFromFrequencyCardLayout("expressionlist");
                                if (expressionlist.isVisible()) {
                                    expressionlist.setVisible(false);
                                } else {
                                    expressionlist.setVisible(true)
                                }
                            }
                        }]
                    },
                    {
                        type: 'list',
                        width: 225,
                        height: 90,
                        invisible: true,
                        items: cronExpressions,
                        widgetName: 'expressionlist',
                        x: 9,
                        y: 28,
                        listeners: [{
                            eventName: 'click',
                            action: function () {
                                self.getWidgetFromFrequencyCardLayout("expressionText").setValue(this.getValue());
                            }
                        }]
                    }
                ]
            };
        },

        //定时周期设置执行条件用到的卡片布局-一
        _conditionCard1: function () {
            return {
                type: 'absolute',
                widgetName: _WD.executeNoLimit,
                items: []
            };
        },
        //定时周期设置执行条件用到的卡片布局-二
        _conditionCard2: function () {
            return {
                type: 'absolute',
                items: [
                    {
                        type: 'textarea',
                        widgetName: _WD.executeFormula,
                        x: 15,
                        y: 0,
                        width: 166,
                        height: 78,
                        watermark: 'sum(B8,C8)>10000'
                    }
                ]
            };
        },
        //定时周期设置执行条件用到的卡片布局-三
        _conditionCard3: function () {
            return {
                type: 'absolute',
                items: [
                    {
                        type: 'treecombobox',
                        returnFullPath: true,
                        widgetName: _WD.executeClass,
                        x: 15,
                        y: 0,
                        height: 21,
                        width: 166,
                        loadByLayer: true,
                        selectLeafOnly: true,
                        widgetUrl: FR.servletURL + "?op=fs_entry&cmd=getClasses&serverID=" + FS.serverID
                    }
                ]
            };
        },

        /**
         * 任务设置第三步，附件类型
         * @private
         */
        _createAttachmentTypeConfig: function () {
            var attachmentTypeConfig = {
                type: 'absolute',
                items: [
                    {
                        type: 'label',
                        verticalcenter: true,
                        value: FR.i18nText("FS-Schedule-Output_Attach_Type"),
                        height: 21,
                        width: FR.i18nTextWidth("FS-Schedule-Output_Attach_Type") > 48 ?
                            FR.i18nTextWidth("FS-Schedule-Output_Attach_Type") + 5 : 50,
                        x: 0,
                        y: 0
                    },
                    FS.Plugin.ScheduleOutput.attachTypeSelectConfig(_WD.taskAttachmentTypeWD)
                ]
            }
            return attachmentTypeConfig;
        },

        /**
         * 任务设置第三步，邮件通知
         * @private
         */
        _createEmailOptionConfig: function () {
            var self = this;
            var emailOptionConfig = {
                type: 'absolute',
                items: [
                    {
                        type: 'checkbox',
                        text: FR.i18nText('FS-Schedule-Notification_Email'),
                        widgetName: _WD.taskEmailCheckboxWD,
                        x: 0,
                        y: 0,
                        height: 21,
                        width: FR.i18nTextWidth('FS-Schedule-Notification_Email') + 30,
                        listeners: [{
                            eventName: 'afteredit',
                            action: function () {
                                var value = this.getValue();
                                var tableWidget = self.getWidgetFromTaskCardLayout(_WD.taskThirdTableLayoutWD);
                                if (value === false) {
                                    tableWidget.setRowVisible(7, false);
                                } else {
                                    tableWidget.setRowVisible(7, true);
                                }
                                tableWidget.doLayout();
                            }
                        }]
                    }
                ]
            };
            return emailOptionConfig;
        },

        /**
         * 任务设置第三步，邮件配置具体内容
         * @private
         */
        _createEmailDetailConfig: function () {
            var self = this;
            this.emailContactWidget = FR.createWidget({
                type: 'combocheckbox',
                supportTag: false,
                widgetName: _WD.taskReceiverWD,
                height: 23,
                width: 139,
                widgetUrl: FR.servletURL + '?op=fr_email&cmd=get_contacts_name'
            });
            this.emailCopyContactWidget = FR.createWidget({
                type: 'combocheckbox',
                supportTag: false,
                widgetName: _WD.taskCopyReceiverWD,
                height: 23,
                width: 139,
                widgetUrl: FR.servletURL + '?op=fr_email&cmd=get_contacts_name'
            });
            this.emailSecretContactWidget = FR.createWidget({
                type: 'combocheckbox',
                supportTag: false,
                widgetName: _WD.taskSecretReceiverWD,
                height: 23,
                width: 139,
                widgetUrl: FR.servletURL + '?op=fr_email&cmd=get_contacts_name'
            });
            var emailDetailConfig = {
                top: 10,
                type: 'tablelayout',
                widgetName: 'receiverDetailTableLayout',
                columnSize: [
                    77,
                    FR.i18nTextWidth("FS-Generic-Attenchments_By_Receiver") > 230 ?
                        (FR.i18nTextWidth("FS-Generic-Attenchments_By_Receiver") + 30) : 260
                ],
                rowSize: [23, 23, 23, 23, 30, 21, 80, 30],
                vgap: 2,
                width: 340,                 // 对话框的宽度
                x: 0,
                y: 45,
                items: [
                    [
                        {
                            el: this._createThirdStepInnerLeftLabel(FR.i18nText("FS-Generic-Simple_Criterion"))          //添加国际化字段(分类标准)
                        },
                        {
                            el: {
                            type: 'absolute',
                            items:[
                                {
                                    widgetName: _WD.taskEmailRoleWD,
                                    type:'combo',
                                    height: 23,
                                    width: 139,
                                    items: [
                                        {value: 1, text: FR.i18nText("FS-Generic-Simple_User")},
                                        {value: 2, text: FR.i18nText("FS-Generic-Simple_Role")}
                                    ],
                                    value: 1,
                                    allowBlank: false,
                                    directEdit: false,
                                        listeners: [
                                            {
                                                eventName: FR.Events.AFTEREDIT,
                                                action: function () {
                                                    var isRole = this.getValue() === 2;
                                                    var url = FR.servletURL + '?op=fr_email&cmd=get_contacts_name&isRole=' + isRole;
                                                    self.emailContactWidget.rebuild({
                                                        widgetUrl: url
                                                    });
                                                    var $email_contact = $('.email_contact');
                                                    $email_contact.empty();
                                                    self.emailContactWidget.element.appendTo($email_contact)

                                                    self.emailCopyContactWidget.rebuild({
                                                        widgetUrl: url
                                                    });
                                                    var $email_copy_contact = $('.email_copy_contact');
                                                    $email_copy_contact.empty();
                                                    self.emailCopyContactWidget.element.appendTo($email_copy_contact)

                                                    self.emailSecretContactWidget.rebuild({
                                                        widgetUrl: url
                                                    });
                                                    var $email_secret_contact = $('.email_secret_contact');
                                                    $email_secret_contact.empty();
                                                    self.emailSecretContactWidget.element.appendTo($email_secret_contact)
                                                }
                                            }
                                        ]
                                    }
                                ]
                            }
                        }
                    ],
                    [
                        {
                            el: this._createThirdStepInnerLeftLabel(FR.i18nText("FS-Generic-Simple_Receiver"))
                        },
                        {
                            el:this._createEmailContactDiv(self.emailContactWidget)
                        }
                    ],
                    [
                        {
                            el: this._createThirdStepInnerLeftLabel(FR.i18nText("FS-Generic-HJS_CC_To"))
                        },
                        {
                            el: this._createEmailCopyContactDiv(self.emailCopyContactWidget)
                        }
                    ],
                    [
                        {
                            el: this._createThirdStepInnerLeftLabel(FR.i18nText("FS-Generic-EmailPane_BCC"))
                        },
                        {
                            el: this._createEmailSecretContactDiv(self.emailSecretContactWidget)
                        }
                    ],
                    [
                        {
                            el: this._createThirdStepInnerLeftLabel('')
                        },
                        {
                            el: {
                                type: 'absolute',
                                items: [
                                    {
                                        type: 'checkbox',
                                        text: FR.i18nText("FS-Generic-Attenchments_By_Receiver"),
                                        widgetName: _WD.taskEmailByPersonCheckboxWD,
                                        x: 0,
                                        y: 4,
                                        height: 21,
                                        width: FR.i18nTextWidth("FS-Generic-Attenchments_By_Receiver") + 30
                                    }
                                ]
                            }
                        }
                    ],
                    [
                        {
                            el: this._createThirdStepInnerLeftLabel(FR.i18nText("FS-Generic-Simple_Schema"))
                        },
                        {
                            el: {
                                type: 'text',
                                widgetName: _WD.taskSubjectWD,
                                height: 21,
                                width: 234
                            }
                        }
                    ],
                    [
                        {
                            el: this._createThirdStepInnerLeftLabel(FR.i18nText("FS-Generic-Simple_Content"))
                        },
                        {
                            el: {
                                type: 'textarea',
                                widgetName: _WD.taskContentWD,
                                height: 80,
                                width: 234
                            }
                        }
                    ],
                    [
                        {
                            el: this._createThirdStepInnerLeftLabel('')
                        },
                        {
                            el: {
                                type: 'absolute',
                                items: [
                                    {
                                        type: 'checkbox',
                                        text: FR.i18nText("FS-Generic-Email_Can_Preview_Report_Content"),
                                        widgetName: _WD.taskEmailCanPreviewAttachCheckboxWD,
                                        x: 0,
                                        y: 4,
                                        height: 21,
                                        width: 234
                                    }
                                ]
                            }
                        }
                    ]
                ]
            };
            return emailDetailConfig;
        },

        /**
         * 任务设置第三步，ftp
         * @private
         */
        _createFtpOptionConfig: function () {
            var self = this;
            var ftpOptionConfig = {
                type: 'absolute',
                items: [
                    {
                        type: 'checkbox',
                        text: FR.i18nText("FS-Schedule-Output_Upload_By_FTP"),
                        widgetName: _WD.taskFtpCheckboxWD,
                        x: 0,
                        y: 0,
                        height: 21,
                        width: FR.i18nTextWidth("FS-Schedule-Output_Upload_By_FTP", 6.5) + 30,
                        listeners: [{
                            eventName: 'afteredit',
                            action: function () {
                                var value = this.getValue();
                                var tableWidget = self.getWidgetFromTaskCardLayout(_WD.taskThirdTableLayoutWD);
                                if (value === false) {
                                    tableWidget.setRowVisible(9, false);
                                } else {
                                    tableWidget.setRowVisible(9, true);
                                }
                                tableWidget.doLayout();
                            }
                        }]
                    }
                ]
            };
            return ftpOptionConfig;
        },

        /**
         * 任务设置第三步，ftp具体内容配置
         * @private
         */
        _createFtpDetailConfig: function () {
            var ftpDetailConfig = {
                top: 10,
                type: 'tablelayout',
                widgetName: 'createFtpDetailTableLayout',
                columnSize: [
                    FR.i18nTextWidth("FS-Schedule-Output_FTP_Address", 6.5) > 70 ?
                        FR.i18nTextWidth("FS-Schedule-Output_FTP_Address", 6.5) + 18 : 77,
                    234
                ],
                rowSize: [25, 25, 25, 25, 25, 25],
                vgap: 2,
                items: [
                    [
                        {
                            el: this._createThirdStepInnerLeftLabel(FR.i18nText("FS-Schedule-Output_FTP_Address"))
                        },
                        {
                            el: {
                                type: 'text',
                                height: 21,
                                width: 234,
                                widgetName: _WD.taskFtpAddressWD
                            }
                        }
                    ],
                    [
                        {
                            el: this._createThirdStepInnerLeftLabel(FR.i18nText('FS-Schedule-Output_FTP_Port'))
                        },
                        {
                            el: {
                                type: 'text',
                                height: 21,
                                width: 234,
                                widgetName: _WD.taskFtpPortWD
                            }
                        }
                    ],
                    [
                        {
                            el: this._createThirdStepInnerLeftLabel(FR.i18nText("FS-Generic-Save_Path"))
                        },
                        {
                            el: {
                                type: 'text',
                                height: 21,
                                width: 234,
                                widgetName: _WD.taskFtpSavePathWD
                            }
                        }
                    ],
                    [
                        {
                            el: this._createThirdStepInnerLeftLabel(FR.i18nText("FS-Generic-Simple_Username"))
                        },
                        {
                            el: {
                                type: 'text',
                                height: 21,
                                width: 234,
                                widgetName: _WD.taskFtpUsernameWD
                            }
                        }
                    ],
                    [
                        {
                            el: this._createThirdStepInnerLeftLabel(FR.i18nText("FS-Generic-Simple_Password"))
                        },
                        {
                            el: {
                                type: 'password',
                                height: 21,
                                width: 234,
                                widgetName: _WD.taskFtpPasswordWD
                            }
                        }
                    ]
                ]
            };
            return ftpDetailConfig;
        },

        /**
         * 任务设置第三步，自定义类
         * @private
         */
        _createSelfDefineOptionConfig: function () {
            var self = this;
            var selfDefineOptionConfig = {
                type: 'absolute',
                items: [
                    {
                        type: 'checkbox',
                        text: FR.i18nText('FS-Schedule-Output_Attach_Class_Deal'),
                        widgetName: _WD.taskSelfDefineCheckboxWD,
                        x: 0,
                        y: 0,
                        height: 21,
                        width: 180,
                        listeners: [{
                            eventName: 'afteredit',
                            action: function () {
                                var value = this.getValue();
                                var tableWidget = self.getWidgetFromTaskCardLayout(_WD.taskThirdTableLayoutWD);
                                if (value === false) {
                                    tableWidget.setRowVisible(11, false);
                                } else {
                                    tableWidget.setRowVisible(11, true);
                                }
                                tableWidget.doLayout();
                            }
                        }]
                    }
                ]
            };
            return selfDefineOptionConfig;
        },

        /**
         * 任务设置第三步，自定义类具体配置
         * @private
         */
        _createSelfDefineDetailConfig: function () {
            var selfDefineDetailConfig = {
                top: 10,
                type: 'tablelayout',
                widgetName: 'selfDefineDetailTableLayout',
                columnSize: [
                    FR.i18nTextWidth('FS-Schedule-Output_Attach_Class_Name', 6.5) > 85 ?
                        (FR.i18nTextWidth('FS-Schedule-Output_Attach_Class_Name', 6.5) + 30) : 100,
                    220
                ],
                rowSize: [25],
                vgap: 2,
                width: 380,
                items: [
                    [
                        {
                            el: this._createThirdStepInnerLeftLabel(FR.i18nText('FS-Schedule-Output_Attach_Class_Name'))
                        },
                        {
                            el: {
                                type: 'treecombobox',
                                returnFullPath: true,
                                widgetName: _WD.taskSelfDefineClassNameWD,
                                height: 21,
                                width: 210,
                                loadByLayer: true,
                                selectLeafOnly: true,
                                widgetUrl: FR.servletURL + "?op=fs_entry&cmd=getClasses&serverID=" + FS.serverID
                            }
                        }
                    ]
                ]
            };
            return selfDefineDetailConfig;
        },

        /**
         * 任务设置第三步，打印
         * @private
         */
        _createPrinterOptionConfig: function () {
            var self = this;
            var printerOptionConfig = {
                type: 'absolute',
                items: [
                    {
                        type: 'checkbox',
                        text: FR.i18nText('FS-Schedule-Output_Attach_Print'),
                        widgetName: _WD.taskPrinterCheckboxWD,
                        x: 0,
                        y: 0,
                        height: 21,
                        width: 120,
                        listeners: [{
                            eventName: 'afteredit',
                            action: function () {
                                var value = this.getValue();
                                var tableWidget = self.getWidgetFromTaskCardLayout(_WD.taskThirdTableLayoutWD);
                                if (value === false) {
                                    tableWidget.setRowVisible(13, false);
                                } else {
                                    tableWidget.setRowVisible(13, true);
                                }
                                tableWidget.doLayout();
                            }
                        }]
                    }
                ]
            };
            return printerOptionConfig;
        },

        /**
         * 任务设置第三步，打印具体配置
         * @private
         */
        _createPrinterDetailConfig: function () {
            var printerDetailConfig = {
                top: 10,
                type: 'tablelayout',
                widgetName: 'printerDetailTableLayout',
                columnSize: [77, 139, 'fill'],
                rowSize: [25],
                vgap: 2,
                width: 324,
                items: [
                    [
                        {
                            el: this._createThirdStepInnerLeftLabel(FR.i18nText("FS-Generic-Simple_Printer"))
                        },
                        {
                            el: {
                                type: 'combo',
                                height: 23,
                                width: 139,
                                widgetName: _WD.taskPrinterNameWD,
                                widgetUrl: FR.servletURL + '?op=fr_server&cmd=sc_get_printer'
                            }
                        },
                        {
                            el: $('<div/>')
                        }
                    ]
                ]
            };
            return printerDetailConfig;
        },

        /**
         * 任务设置第三步，推送
         * @private
         */
        _createPushOptionConfig: function () {
            var self = this;
            var pushOptionConfig = {
                type: 'absolute',
                items: [
                    {
                        type: 'checkbox',
                        text: FR.i18nText('FS-Schedule-Output_Push_Message'),
                        widgetName: _WD.taskPushCheckboxWD,
                        x: 0,
                        y: 0,
                        height: 21,
                        width: 120,
                        listeners: [{
                            eventName: 'afteredit',
                            action: function () {
                                var value = this.getValue();
                                var tableWidget = self.getWidgetFromTaskCardLayout(_WD.taskThirdTableLayoutWD);
                                if (value === false) {
                                    tableWidget.setRowVisible(15, false);
                                } else {
                                    tableWidget.setRowVisible(15, true);
                                }
                                tableWidget.doLayout();
                            }
                        }]
                    }
                ]
            }
            return pushOptionConfig;
        },

        /**
         * 任务设置第三步，推送具体配置
         * @private
         */
        _createPushDetailConfig: function () {
            var pushDetailConfig = {
                top: 10,
                type: 'tablelayout',
                widgetName: 'pushDetailTableLayout',
                columnSize: [77, 139, 'fill'],
                rowSize: [50],
                vgap: 2,
                width: 324,
                items: [
                    [
                        {
                            el: this._createThirdStepInnerLeftLabel(FR.i18nText('FS-Schedule-Output_Push_Content'))
                        },
                        {
                            el: {
                                type: 'textarea',
                                height: 48,
                                width: 234,
                                widgetName: _WD.taskPushTextWD,
                                value: FR.i18nText("FS-Schedule-Output_Push_New_Message")
                            }
                        }
                    ]
                ]
            };
            return pushDetailConfig;
        },

        /**
         * 弹出任务对话框数据
         * @private
         */
        popTask: function () {
            var task = FSSM.Control.currentTask;
            if (!task) {
                return;
            }
            var taskCardLayout = this.taskCardLayout();
            var index = taskCardLayout.showIndex;
            if (index === CONSTANTS.currentStep.FIRST_STEP) {
                //第一步
                var taskName = this.getWidgetFromTaskCardLayout(_WD.taskNameWD),
                    taskTemplate = this.getWidgetFromTaskCardLayout(_WD.taskAddTemplateNameWD);
                taskName.setValue(task.name);
                // 如果当前任务正在执行，不允许修改定时任务名称
                if (task.state === CONSTANTS.state.STATE_NORMAL) {
                    taskName.setEnable(false);
                    taskTemplate.setEnable(false);
                }
                if (FSSM.Control.scheduleConfig.isSAPSyn) {
                    taskTemplate.setValue(task.transfers);
                } else {
                    taskTemplate.setValue(task.reportletPath);
                }
                this.getWidgetFromTaskCardLayout(_WD.taskTemplateTypeWD).setValue(task.showType);
                this.getWidgetFromTaskCardLayout(_WD.taskReportParameterGridWD).popData(task.taskParameters);
            } else if (index === CONSTANTS.currentStep.SECOND_STEP) {
                //第二步
                var iTrigger = task.iTrigger;
                this.getWidgetFromTaskCardLayout(_WD.taskStartTimeSetRadioboxWD).setValue(iTrigger.startType, true);
                if (iTrigger.startTime) {
                    this.getWidgetFromTaskCardLayout(_WD.taskStartTimeWD).setValue(iTrigger.startTime);
                }
                var frequencyRadio = this.getWidgetFromTaskCardLayout(_WD.taskFrequencyTypeGroupWD);
                if (iTrigger.recurrenceType === CONSTANTS.recurrenceName.ONCE) {
                    //只执行一次
                    frequencyRadio.setValue(CONSTANTS.recurrenceType.ONCE, true);
                } else if (iTrigger.recurrenceType === CONSTANTS.recurrenceName.SIMPLE) {
                    //简单重复执行
                    frequencyRadio.setValue(CONSTANTS.recurrenceType.SIMPLE, true);
                    this.getWidgetFromFrequencyCardLayout(_WD.taskSimpleRepeatWD).setValue(iTrigger.recurrenceInterval);
                    this.getWidgetFromFrequencyCardLayout(_WD.taskRepeatUnitWD).setValue(iTrigger.recurrenceIntervalUnit);
                } else if (iTrigger.recurrenceType === CONSTANTS.recurrenceName.CALENDAR) {
                    //明细频率设置
                    frequencyRadio.setValue(CONSTANTS.recurrenceType.CALENDAR, true);
                    this.getWidgetFromFrequencyCardLayout(_WD.taskExecuteHourWD).setValue(iTrigger.hours);
                    this.getWidgetFromFrequencyCardLayout(_WD.taskExecuteMinuteWD).setValue(iTrigger.minutes);
                    var dayTypeRadio = this.getWidgetFromFrequencyCardLayout(_WD.taskDefinedExecuteUnitWD);
                    dayTypeRadio.setValue(iTrigger.dayType, true);
                    if (iTrigger.dayType === CONSTANTS.dayType.DAY_OF_WEEK) {
                        //每周
                        this.getWidgetFromFrequencyCardLayout(_WD.taskSecondStepUnitEveryWeekWD).setValue(iTrigger.weekDays);
                    } else if (iTrigger.dayType === CONSTANTS.dayType.DAY_OF_MONTH) {
                        //每月
                        this.getWidgetFromFrequencyCardLayout(_WD.taskSecondStepUnitEveryMonthWD).setValue(iTrigger.monthDays);
                    }
                    //执行月
                    this.getWidgetFromFrequencyCardLayout(_WD.taskUnitExecuteMonthWD).setValue(iTrigger.months);
                } else if (iTrigger.recurrenceType === CONSTANTS.recurrenceName.CRONEXPRESSION) {
                    frequencyRadio.setValue(CONSTANTS.recurrenceType.CRONEXPRESSION, true);
                    this.getWidgetFromFrequencyCardLayout(_WD.taskExpressionTextWD).setValue(iTrigger.cronExpression);
                }
                //结束时间
                var endTimeRadio = this.getWidgetFromTaskCardLayout(_WD.taskSecondStenEndTimeRadioGroupWD);
                if (iTrigger.repeatCount === CONSTANTS.NO_LIMIT_REPEAT_COUNT) {
                    endTimeRadio.setValue(CONSTANTS.endTimeType.NO_LIMIT, true);
                } else if (iTrigger.endTime) {
                    endTimeRadio.setValue(CONSTANTS.endTimeType.SET_END_TIME, true);
                    this.getWidgetFromEndTimeCardLayout(_WD.taskEndTimeWD).setValue(iTrigger.endTime);
                } else if (iTrigger.repeatCount) {
                    endTimeRadio.setValue(CONSTANTS.endTimeType.REPEAT_COUNTS, true);
                    this.getWidgetFromEndTimeCardLayout(_WD.taskRepeatTimesWD).setValue(iTrigger.repeatCount);
                }
                //执行条件
                var executeConditionRadio = this.getWidgetFromTaskCardLayout(_WD.taskConditionTypeGroupWD);
                executeConditionRadio.setValue(task.executeType, true);
                if (task.executeType === CONSTANTS.executeType.FORMULA && task.executeFormula) {
                    this.getWidgetFromTaskCardLayout(_WD.executeFormula).setValue(task.executeFormula);
                } else if (task.executeType === CONSTANTS.executeType.EXECUTE_CLASS && task.executeClass) {
                    this.getWidgetFromTaskCardLayout(_WD.executeClass).setValue(task.executeClass);
                }
                //失败重启
                if (task.repeatTime > 0 && task.repeatTimes > 0) {
                    this.getWidgetFromTaskCardLayout(_WD.taskRestartFromFailCheckBoxWD).setValue(true, true);
                    this.getWidgetFromTaskCardLayout(_WD.taskRestartExecuteMinuteWD).setValue(task.repeatTime);
                    this.getWidgetFromTaskCardLayout(_WD.taskRestartExecuteTimesWD).setValue(task.repeatTimes);
                } else {
                    this.getWidgetFromTaskCardLayout(_WD.taskRestartFromFailCheckBoxWD).setValue(false, true);
                    this.getWidgetFromTaskCardLayout(_WD.taskRestartExecuteMinuteWD).setValue("");
                    this.getWidgetFromTaskCardLayout(_WD.taskRestartExecuteTimesWD).setValue("");
                }
            } else if (index === CONSTANTS.currentStep.THIRD_STEP) {
                //第三步
                var scheduledOutput = task.scheduledOutput;
                if (scheduledOutput) {
                    this.getWidgetFromTaskCardLayout(_WD.taskFileNameWD).setValue(scheduledOutput.baseFileName);
                    this.getWidgetFromTaskCardLayout(_WD.taskFileDescriptionWD).setValue(scheduledOutput.description);
                    var virtureTree = this.getWidgetFromTaskCardLayout(_WD.taskVirtureDirectoryWD);
                    virtureTree.setValue(scheduledOutput.folderEntryId);
                    var folder = virtureTree.getNodeByID(scheduledOutput.folderEntryId);
                    var folderText = scheduledOutput.folderEntryId;
                    if (folder) {
                        folderText = folder.getText();
                    }
                    virtureTree.setText(folderText);

                    this.getWidgetFromTaskCardLayout(_WD.taskVirtureDirectoryByUserWD).setValue(scheduledOutput.isCreateCPRByUsername, true);
                    if (scheduledOutput.isCreateCPRByUsername) {
                        this.getWidgetFromTaskCardLayout(_WD.taskVirtureDirectoryComboByUserWD).setValue(scheduledOutput.usernames);
                    }
                    var outputFileFormat = scheduledOutput.outputFileFormat;
                    if (outputFileFormat) {
                        var attachType = FS.Plugin.ScheduleOutput.attachType(outputFileFormat, CONSTANTS);
                        this.getWidgetFromTaskCardLayout(_WD.taskAttachmentTypeWD).setValue(attachType);
                    }
                    var outputFileActionList = scheduledOutput.outputFileActionList;
                    if (outputFileActionList) {
                        for(var notificationName in this.outputFileConfig()) {
                            var notificationConfig = outputFileActionList[notificationName];
                            if (!notificationConfig) {
                                this.outputFileConfig()[notificationName].deSelect();
                            } else {
                                this.outputFileConfig()[notificationName].select();
                                this.outputFileConfig()[notificationName].pop(notificationConfig);
                            }
                        }
                        this.getWidgetFromTaskCardLayout(_WD.taskEmailByPersonCheckboxWD).setValue(scheduledOutput.isSendEmailByUsername, true);
                    }
                }
            }
        },

        /**
         * 读取页面上控件的设置信息更新定时任务信息
         * @param currentStep 当前设置到哪一步
         */
        updateTask: function (currentStep) {
            var task = FSSM.Control.currentTask;
            if (!task) {
                task = FSSM.Control.currentTask = {};
            }
            if (currentStep === CONSTANTS.currentStep.FIRST_STEP) {
                //第一步
                var taskBasicConfig = {
                    name: this.getWidgetFromTaskCardLayout(_WD.taskNameWD).getValue(),
                    transmitParameters: this.getWidgetFromTaskCardLayout(_WD.taskReportParameterGridWD).getData()
                }
                if (FSSM.Control.scheduleConfig.isSAPSyn) {
                    $.extend(taskBasicConfig, {
                        transfers: this.getWidgetFromTaskCardLayout(_WD.taskAddTemplateNameWD).getValue()
                    });
                } else {
                    $.extend(taskBasicConfig, {
                        showType: this.getWidgetFromTaskCardLayout(_WD.taskTemplateTypeWD).getValue(),
                        reportletPath: this.getWidgetFromTaskCardLayout(_WD.taskAddTemplateNameWD).getValue().join("/")
                    });
                }
                var taskBasic = new FSSM.Model.TaskBasic(taskBasicConfig);
                if (!taskBasic.isValid()) {
                    return false;
                } else {
                    if (taskBasicConfig.showType === CONSTANTS.showType.WRITE || FSSM.Control.scheduleConfig.isSAPSyn === true) {
                        //填报
                        this.setTotalStep = 2;
                    } else {
                        this.setTotalStep = 3;
                    }
                    $.extend(task, taskBasicConfig);
                    return true;
                }
            } else if (currentStep === CONSTANTS.currentStep.SECOND_STEP) {
                //第二步
                var startType = this.getWidgetFromTaskCardLayout(_WD.taskStartTimeSetRadioboxWD).getValue();
                var recurrenceType = this.getWidgetFromTaskCardLayout(_WD.taskFrequencyTypeGroupWD).getValue();
                var executeType = this.getWidgetFromTaskCardLayout(_WD.taskConditionTypeGroupWD).getValue();
                var taskITriggerConfig = {};
                taskITriggerConfig.startType = startType;
                task.executeType = executeType;
                if (startType === CONSTANTS.startType.SET_TIME) {
                    taskITriggerConfig.startTime = this.getWidgetFromTaskCardLayout(_WD.taskStartTimeWD).getValue();
                }
                if (recurrenceType === CONSTANTS.recurrenceType.ONCE) {
                    taskITriggerConfig.recurrenceType = CONSTANTS.recurrenceName.ONCE;
                } else if (recurrenceType === CONSTANTS.recurrenceType.SIMPLE) {
                    taskITriggerConfig.recurrenceType = CONSTANTS.recurrenceName.SIMPLE;
                    taskITriggerConfig.recurrenceInterval = this.getWidgetFromFrequencyCardLayout(_WD.taskSimpleRepeatWD).getValue();
                    taskITriggerConfig.recurrenceIntervalUnit = this.getWidgetFromFrequencyCardLayout(_WD.taskRepeatUnitWD).getValue();
                } else if (recurrenceType === CONSTANTS.recurrenceType.CALENDAR) {
                    taskITriggerConfig.recurrenceType = CONSTANTS.recurrenceName.CALENDAR;
                    taskITriggerConfig.repeatType = "timerepeat";
                    taskITriggerConfig.hours = this.getWidgetFromFrequencyCardLayout(_WD.taskExecuteHourWD).getValue();
                    taskITriggerConfig.minutes = this.getWidgetFromFrequencyCardLayout(_WD.taskExecuteMinuteWD).getValue();
                    var dayType = this.getWidgetFromFrequencyCardLayout(_WD.taskDefinedExecuteUnitWD).getValue();
                    taskITriggerConfig.dayType = dayType;
                    if (dayType === CONSTANTS.dayType.DAY_OF_WEEK) {
                        var unit_every_week_values = this.getWidgetFromFrequencyCardLayout(_WD.taskSecondStepUnitEveryWeekWD).getValue();
                        var checkeddays = $.makeArray(unit_every_week_values);
                        taskITriggerConfig.weekDays = checkeddays.toString();
                    } else if (dayType === CONSTANTS.dayType.DAY_OF_MONTH) {
                        taskITriggerConfig.monthDays = this.getWidgetFromFrequencyCardLayout(_WD.taskSecondStepUnitEveryMonthWD).getValue();
                    }
                    var unit_execute_month_values = this.getWidgetFromFrequencyCardLayout(_WD.taskUnitExecuteMonthWD).getValue();
                    var checkedmonths = $.makeArray(unit_execute_month_values);
                    taskITriggerConfig.months = checkedmonths.toString();
                } else if (recurrenceType === CONSTANTS.recurrenceType.CRONEXPRESSION) {
                    taskITriggerConfig.recurrenceType = CONSTANTS.recurrenceName.CRONEXPRESSION;
                    taskITriggerConfig.repeatType = "cronexpression";
                    taskITriggerConfig.cronExpression = this.getWidgetFromFrequencyCardLayout(_WD.taskExpressionTextWD).getValue();
                }
                //结束时间
                var endTimeRadio = this.getWidgetFromTaskCardLayout(_WD.taskSecondStenEndTimeRadioGroupWD);
                var endTimeValue = endTimeRadio ? endTimeRadio.getValue() : CONSTANTS.NO_LIMIT_REPEAT_COUNT;
                if (recurrenceType !== CONSTANTS.recurrenceType.ONCE) {
                    if (endTimeValue === CONSTANTS.endTimeType.SET_END_TIME) {
                        taskITriggerConfig.endTime = this.getWidgetFromEndTimeCardLayout(_WD.taskEndTimeWD).getValue();
                        delete taskITriggerConfig.repeatCount;
                    } else if (endTimeValue === CONSTANTS.endTimeType.REPEAT_COUNTS) {
                        taskITriggerConfig.repeatCount = this.getWidgetFromEndTimeCardLayout(_WD.taskRepeatTimesWD).getValue();
                        delete taskITriggerConfig.endTime;
                    } else if (endTimeValue === CONSTANTS.endTimeType.NO_LIMIT) {
                        taskITriggerConfig.repeatCount = CONSTANTS.NO_LIMIT_REPEAT_COUNT;
                        delete taskITriggerConfig.endTime;
                    }
                }
                //执行条件
                if (executeType === CONSTANTS.executeType.NO_LIMIT) {
                    task.executeFormula = '';
                    task.executeClass = '';
                } else if (executeType === CONSTANTS.executeType.FORMULA) { //执行公式
                    var formula = this.getWidgetFromEndTimeCardLayout(_WD.executeFormula).getValue();
                    if (!formula || (/^[　\s]*$/).test(formula)) {
                        FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"),
                            FR.i18nText('FS-Schedule-Enter_Execute_Formula'));
                        return false;
                    }
                    task.executeFormula = formula;
                    task.executeClass = '';
                } else if (executeType === CONSTANTS.executeType.EXECUTE_CLASS) {
                    task.executeFormula = '';
                    task.executeClass = this.getWidgetFromEndTimeCardLayout(_WD.executeClass).getValue().join(".");
                }
                var isRestartOnFailure = this.getWidgetFromTaskCardLayout(_WD.taskRestartFromFailCheckBoxWD).getValue();
                if (isRestartOnFailure) {
                    task.repeatTime = this.getWidgetFromTaskCardLayout(_WD.taskRestartExecuteMinuteWD).getValue();
                    task.repeatTimes = this.getWidgetFromTaskCardLayout(_WD.taskRestartExecuteTimesWD).getValue();
                } else {
                    task.repeatTime = "0";
                    task.repeatTimes = "0";
                }
                //重复时间需要是数字
                if (this.repeatTime && !(/^\d+$/).test(this.repeatTime)) {
                    FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText("FS-Schedule-Restart_Time_Gap_Must_Be_Number"));
                    return false;
                }
                if (this.repeatTimes && !(/^\d+$/).test(this.repeatTimes)) {
                    FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Wrong"), FR.i18nText("FS-Schedule-Restart_Number_Of_Times_Must_Be_Number"));
                    return false;
                }
                var taskITrigger = new FSSM.Model.TaskITrigger(taskITriggerConfig);
                if (!taskITrigger.isValid()) {
                    return false;
                } else {
                    task.iTrigger = taskITriggerConfig;
                    return true;
                }
            } else if (currentStep === CONSTANTS.currentStep.THIRD_STEP) {
                //最后一步
                var scheduledOutputConfig = {};
                scheduledOutputConfig.isCreateCPRByUsername = false;
                scheduledOutputConfig.usernames = [];
                scheduledOutputConfig.isSendEmailByUsername = false;
                scheduledOutputConfig.baseFileName = this.getWidgetFromTaskCardLayout(_WD.taskFileNameWD).getValue();
                scheduledOutputConfig.description = this.getWidgetFromTaskCardLayout(_WD.taskFileDescriptionWD).getValue();
                var virtureDirectory = this.getWidgetFromTaskCardLayout(_WD.taskVirtureDirectoryWD).getValue();
                var directoryArray = $.makeArray(virtureDirectory);
                if (!FR.isEmptyArray(directoryArray)) {
                    scheduledOutputConfig.folderEntryId = directoryArray[directoryArray.length - 1].substr(1);
                }
                scheduledOutputConfig.isCreateCPRByUsername = this.getWidgetFromTaskCardLayout(_WD.taskVirtureDirectoryByUserWD).getValue();
                if (scheduledOutputConfig.isCreateCPRByUsername) {
                    scheduledOutputConfig.usernames = this.getWidgetFromTaskCardLayout(_WD.taskVirtureDirectoryComboByUserWD).getValue();
                }
                var attachmentType = this.getWidgetFromTaskCardLayout(_WD.taskAttachmentTypeWD).getValue();
                scheduledOutputConfig.outputFileFormat = FS.Plugin.ScheduleOutput.attachResult(attachmentType);
                var outputFileActionList = scheduledOutputConfig.outputFileActionList = {};

                this._createOutputFileActionConfig(outputFileActionList);
                scheduledOutputConfig.isSendEmailByUsername = this.outputFileConfig()["emailNotification"].isSelected() &&
                    this.getWidgetFromTaskCardLayout(_WD.taskEmailByPersonCheckboxWD).getValue();
                var taskScheduleOutput = new FSSM.Model.TaskOutput(scheduledOutputConfig);
                if (!taskScheduleOutput.isValid()) {
                    return false;
                } else {
                    task.scheduledOutput = scheduledOutputConfig;
                    return true;
                }
            }
        },

        _createOutputFileActionConfig : function(outputFileActionList) {
            for(var notificationName in this.outputFileConfig()) {
                if(this.outputFileConfig()[notificationName].isSelected()) {
                    outputFileActionList[notificationName] = this.outputFileConfig()[notificationName].toJson();
                }
            }
        },

        //几个获取常用控件/布局的方法
        /**
         * 获取任务列表
         * @return 任务列表
         */
        taskTable: function () {
            return this.tabPane.getWidgetByName(_WD.taskTableWD);
        },

        /**
         * 获取参数列表
         * @return 参数列表
         */
        taskReportParameterGrid: function () {
            return this.taskDialog.getWidgetByName(_WD.taskReportParameterGridWD);
        },

        /**
         * 获取定时任务设置时的cardlayout
         * @return 定时任务设置时的cardlayout
         */
        taskCardLayout: function () {
            return this.taskDialog.getWidgetByName(_WD.taskCardLayoutWD);
        },

        /**
         * 从定时任务的cardlayout中获取控件
         * @param widgetName 控件名
         * @return 控件对象
         */
        getWidgetFromTaskCardLayout: function (widgetName) {
            return this.taskCardLayout().getWidgetByName(widgetName);
        },

        /**
         * 获取定时任务设置时执行频率设置的cardlayout
         * @return 执行频率设置的cardlayout
         */
        taskFrequencyCardLayout: function () {
            return this.taskCardLayout().getWidgetByName(_WD.taskFrequencyCardLayoutWD);
        },

        /**
         * 从执行频率的cardlayout中获取控件
         * @param widgetName 控件名
         * @return 控件对象
         */
        getWidgetFromFrequencyCardLayout: function (widgetName) {
            return this.taskFrequencyCardLayout().getWidgetByName(widgetName);
        },

        /**
         * 获取定时任务设置时结束时间设置的cardlayout
         * @return 结束时间设置的cardlayout
         */
        taskEndTimeCardLayout: function () {
            return this.taskCardLayout().getWidgetByName(_WD.taskSecondStepEndTimeCardLayoutWD);
        },

        /**
         * 从结束时间的cardlayout中获取控件
         * @param widgetName 控件名
         * @return 控件对象
         */
        getWidgetFromEndTimeCardLayout: function (widgetName) {
            return this.taskEndTimeCardLayout().getWidgetByName(widgetName);
        },

        /**
         * 点击下一步/完成按钮执行跳转到下一步
         * @private
         */
        moveNextByStep: function () {
            var cardLayout = this.taskCardLayout();
            var currentStep = cardLayout.showIndex;
            if (!this.updateTask(currentStep)) {
                return;
            }
            if (currentStep == this.setTotalStep - 1) {
                //最后一步了，提交任务
                //提交
//				FSSM.View.taskDialog.win.doClose();
                FSSM.View.taskDialog.doClose();
                FSSM.Control.saveTask();
                return;
            }
            cardLayout.showCardByIndex(currentStep + 1);
            $(".preButton").show();
            if (currentStep + 1 == this.setTotalStep - 1) {
                //倒数第二步进到最后一步
                $('.nextButton').find('span').text(FR.i18nText("FS-Generic-Simple_Submit"));
                //最后一步，隐藏一些tablelayout的行
                if (this.setTotalStep === 3) {
                    this._hideThirdStepRow();
                }
            }
            if (FSSM.Control.isEdit) {
                this.popTask();
            }
        },

        /**
         * 点击上一步按钮执行跳转到上一步
         * @private
         */
        movePreByStep: function () {
            var cardLayout = this.taskCardLayout();
            var currentStep = cardLayout.showIndex;
            if (currentStep == this.setTotalStep - 1) {
                //完成变下一步
                $('.nextButton').find('span').text(FR.i18nText("FS-Generic-Simple_Next"));
            }
            if (currentStep === 1) {
                //隐藏上一步
                $(".preButton").hide();
            }
            cardLayout.showCardByIndex(currentStep - 1);
        },

        //下面是弹出对话框部分的使用方法
        /**
         * 创建/编辑定时任务弹出对话框的标题
         * @private
         */
        _createDialogTitle: function (step) {
            //标题栏
            var titleClass = "dialog_title";
            var titleSelectedClass = "dialog_title_selected";
            var basic_set_div = $('<div/>').css({
                'margin-left': '9px'
            }).text(FR.i18nText('FS-Schedule-Basic_Properties'));
            var first_title_point_div = $('<div class="fs_schedule_next_step"/>').html('&rsaquo;');
            var marginLeft = parseInt(FR.i18nText("FS-Schedule-Step_Margin_Left")) || 22 + "px";

            var manage_cycle_div = $('<div/>').addClass(titleClass).text(FR.i18nText('FS-Schedule-Execute_Period')).css({
                'margin-left': marginLeft
            });
            var second_title_point_div = $('<div class="fs_schedule_next_step"/>').html('&rsaquo;');
            var output_set_div = $('<div/>').addClass(titleClass).text(FR.i18nText('FS-Schedule-Export_Settings')).css({
                'margin-left': marginLeft
            });
            var title_div = $('<div/>').addClass(titleClass);
            basic_set_div.appendTo(title_div);
            first_title_point_div.appendTo(title_div);
            manage_cycle_div.appendTo(title_div);
            second_title_point_div.appendTo(title_div);
            output_set_div.appendTo(title_div);
            switch (step) {
                case 1:
                    basic_set_div.addClass(titleSelectedClass);
                    break;
                case 2:
                    manage_cycle_div.addClass(titleSelectedClass);
                    break;
                case 3:
                    output_set_div.addClass(titleSelectedClass);
                    break;
            }
            return title_div;
        },

        /**
         * 普通左边标签
         * @private
         */
        _createLeftLabel: function (name) {
            var $label_div = $('<div/>').addClass('dialog_label');
            $('<span/>').text(name).appendTo($label_div);
            return $label_div;
        },

        /**
         * 定时任务第三步需要用到的靠右对齐标签
         * @param name 标签文字
         * @private
         */
        _createThirdStepLeftLabel: function (name) {
            var $label_div = $('<div/>').addClass('third_step_dialog_label');
            $('<span/>').text(name).appendTo($label_div);
            return $label_div;
        },

        /**
         * 邮件，ftp，自定义附件/打印需要用到的标签
         * @param name 标签文字
         * @private
         */
        _createThirdStepInnerLeftLabel: function (name) {
            var $label_div = $('<div/>').addClass('third_step_dialog_inner_label');
            $('<span/>').text(name).appendTo($label_div);
            return $label_div;
        },
        _createEmailContactDiv: function (emailContactWidget) {
            var $email_div = $('<div/>').addClass('email_contact');
            $email_div.css('left', '80px');
            emailContactWidget.element.appendTo($email_div);
            return $email_div;
        },
        _createEmailCopyContactDiv: function (emailCopyContactWidget) {
            var $email_copy_div = $('<div/>').addClass('email_copy_contact');
            $email_copy_div.css('left', '80px');
            emailCopyContactWidget.element.appendTo($email_copy_div);
            return $email_copy_div;
        },
        _createEmailSecretContactDiv: function (emailSecretContactWidget) {
            var $email_secret_div = $('<div/>').addClass('email_secret_contact');
            $email_secret_div.css('left', '80px');
            emailSecretContactWidget.element.appendTo($email_secret_div);
            return $email_secret_div;
        },

        /**
         * 获取定时任务选择不同执行频率时，对应的tablelayout的行高
         * @private
         */
        _getTableLayoutRowSize: function (frequencyType) {
            var result;
            switch (frequencyType) {
                case CONSTANTS.recurrenceType.ONCE :
                    result = [10, 23, 46, 110, 33, 83, 55];
                    break;
                case CONSTANTS.recurrenceType.SIMPLE :
                    result = [10, 23, 46, 110, 83, 83, 55];
                    break;
                case CONSTANTS.recurrenceType.CALENDAR :
                    result = [10, 23, 46, 160, 53, 83, 55];
                    break;
                case CONSTANTS.recurrenceType.CRONEXPRESSION :
                    result = [10, 23, 46, 110, 53, 83, 55];
                    break;
            }
            return result;
        },

        /**
         * 根据不同的执行频率，显示不同的结束时间设置界面
         * @param frequencyType 执行频率
         * @private
         */
        _showEndTimeCard: function (frequencyType) {
            var endTimeCardLayout = this.taskEndTimeCardLayout();
            if (frequencyType > CONSTANTS.recurrenceType.SIMPLE) {
                endTimeCardLayout.showCardByIndex(1);
                var radioGroup = this.getWidgetFromEndTimeCardLayout(_WD.taskSecondStenEndTimeRadioGroupWD);
                radioGroup.rebuild([
                    {text: FR.i18nText("FS-Schedule-Simple_Unlimited"), value: 0},
                    {text: FR.i18nText('FS-Schedule-End_At_Time'), value: 1}
                ]);
            } else {
                endTimeCardLayout.showCardByIndex(frequencyType);
                var radioGroup = this.getWidgetFromEndTimeCardLayout(_WD.taskSecondStenEndTimeRadioGroupWD);
                if (frequencyType === CONSTANTS.recurrenceType.SIMPLE) {
                    radioGroup.rebuild([
                        {text: FR.i18nText("FS-Schedule-Simple_Unlimited"), value: 0},
                        {text: FR.i18nText('FS-Schedule-End_At_Time'), value: 1},
                        {text: FR.i18nText('FS-Schedule-Extra_Execute_Times'), value: 2}
                    ]);
                }
            }
            var endTime = this.getWidgetFromEndTimeCardLayout(_WD.taskEndTimeWD);
            if (endTime) {
                endTime.setEnable(false);
            }
        },

        /**
         * 第一步时tablelayout需要隐藏的行
         * @private
         */
        _hideFirstStepRow: function () {
            if (FSSM.Control.scheduleConfig.isSAPSyn) {
                var tableWidget = this.getWidgetFromTaskCardLayout(_WD.taskFirstTableLayoutWD);
                tableWidget.setRowVisible(4, false);
                tableWidget.doLayout();
            }
        },

        /**
         * 第三步时tablelayout需要隐藏的行
         * @private
         */
        _hideThirdStepRow: function () {
            var tableWidget = this.getWidgetFromTaskCardLayout(_WD.taskThirdTableLayoutWD);
            //隐藏不展示部分
            tableWidget.setRowVisible([7, 9, 11, 13, 15], false);
            if (FSSM.Control.scheduleConfig.isOpTimer) {
                //op=timer不支持挂载报表目录
                tableWidget.setRowVisible(4, false);
            }
            tableWidget.doLayout();
        }
    },

    //wei : 控制(Control)
    Control: {
        /**
         * sap定时和普通模板定时都要用到这边的界面，默认为普通模板定时。
         */
        scheduleConfig: {
            taskAddText: FR.i18nText("FS-Schedule-New_Task"),
            taskDelText: FR.i18nText("FS-Schedule-Remove_Task"),
            taskElemText: FR.i18nText('FS-Report-Using_Templates'),
            taskElemHeader: 'reportletPath',
            getAllTasksURL: 'get_all_tasks',
            aouTaskURL: 'se_aoutask',
            delTaskURL: 'se_deltask',
            stateJobURL: 'se_statejob',
            executeClassURL: 'se_executeClass',
            monitorQueryURL: 'get_task_log',
            scheduleOP: 'fr_schedule',
            getAllTaskNamesURL: 'get_all_task_names',
            isNameExists: 'check_task_exists',
            isSAPSyn: false,
            isOpTimer: false,
            choose: FR.i18nText("FS-Generic-Schedule_Template"),
            chooseWidget: {
                type: 'treecombobox',
                returnFullPath: true,
                widgetName: _WD.taskAddTemplateNameWD,
                height: 21,
                width: 280,
                selectLeafOnly: true,
                widgetUrl: FR.servletURL + "?op=fs_entry&cmd=get_user_reports&form=true&file=cpt&serverID=" + FS.serverID,
                listeners: [{
                    eventName: 'afteredit',
                    action: function () {
                        if (this.getValue()) {
                            FSSM.View.taskReportParameterGrid().reportletPath = this.getValue().join("/");
                        }
                    }
                }]
            }
        },

        /**
         * 创建新的定时任务
         */
        newTask: function () {
            this.currentTask = {};
            this.isEdit = false;
            FSSM.View.createTaskDialog();
        },

        /**
         * 删除定时任务
         * @param taskIds 需要删除的定时任务id数组
         * @param callback 删除后执行的回调函数
         */
        removeTasks: function (taskIds, callback) {
            var self = this;
            FR.Msg.confirm(FR.i18nText('FS-Frame-Delete_Data'), FR.i18nText("FS-Generic-Sure_To_Delete") + "?", function (result) {
                if (result) {
                    var config = {
                        url: FR.servletURL,
                        data: {
                            op: self.scheduleConfig.scheduleOP,
                            cmd: self.scheduleConfig.delTaskURL,
                            taskIds: taskIds
                        },
                        type: 'GET'
                    };
                    FS.Async.ajax(config, callback);
                }
            });
        },

        /**
         * 暂停或开启定时任务
         * @param task 定时任务对象
         * @param callback 暂停或开启后执行的回调函数
         */
        stopOrRunTask: function (task, callback) {
            FR.post(
                FR.servletURL,
                {
                    op: this.scheduleConfig.scheduleOP,
                    cmd: this.scheduleConfig.stateJobURL,
                    taskId: task.id
                },
                callback
            );
        },

        /**
         * 编辑定时任务
         * @param task 定时任务对象
         * @param index 定时任务在所有任务里的下标
         */
        editTask: function (task, index) {
            this.currentTask = task;
            this.currentTask.index = index;
            this.isEdit = true;
            FSSM.View.createTaskDialog(task);
        },

        /**
         * 查询满足条件的定时任务
         */
        queryTaskLog: function () {
            var logTable = FSSM.View.tabPane.getWidgetByName(_WD.taskLogTableWD);
            var async = logTable.options.async;
            async.data.taskname = FSSM.View.tabPane.getWidgetByName("allTaskName").getValue();
            async.data.startdate = FSSM.View.tabPane.getWidgetByName("monitor_start_time").getValue();
            async.data.enddate = FSSM.View.tabPane.getWidgetByName("monitor_end_time").getValue();
            logTable.refresh();
        },
        /**
         * 自定义类路径校验
         * @param classPath
         */
        validClassPath: function (classPath) {
            var result;
            if (!classPath || (/^[　\s]*$/).test(classPath)) {
                return false;
            }
            result = FS.Sync.ajax({
                url: FR.servletURL,
                data: {
                    op: this.scheduleConfig.scheduleOP,
                    cmd: this.scheduleConfig.executeClassURL,
                    executeClass: classPath
                }
            });
            return result;
        },

        /**
         * 任务出错时，显示定时日志里的堆栈信息
         * @private
         */
        showTrace: function (msg, e, el) {
            var detailDiv = $("div.fr_schedule_detailmsg");
            if (detailDiv.length === 0) {
                detailDiv = $("<div/>").addClass('fr_schedule_detailmsg');
            }
            msg = msg.replace(/\n/g, "<br />").replace(/\t/g, '&nbsp;&nbsp;&nbsp;&nbsp;');
            detailDiv.html(msg);
            detailDiv.css({'z-index': FR.widget.opts.zIndex++});
            detailDiv.css('left', e.pageX - 450);
            var eH = parseInt(el.offsetTop);
            if (eH < document.body.clientHeight - eH) {
                detailDiv.css('top', e.pageY);
            } else {
                detailDiv.css('top', e.pageY - 90);
            }
            detailDiv.appendTo('body');
            detailDiv.show();
            var collapseIf = function (e) {
                var self = e.data;
                //b:改用鼠标位置
                var el = $('.fr_schedule_detailmsg');
                if (e.pageX < el.offset().left - 10 || e.pageX > el.offset().left + el.width() + 10
                    || e.pageY < el.offset().top + 10 || e.pageY > el.offset().top + el.height() - 10) {
                    el.hide();
                    $(document).unbind('mousedown', collapseIf);
                }
            };
            $(document).bind('mousedown', collapseIf);
        },

        /**
         * 设置完成后，保存定时任务
         */
        saveTask: function () {
            var completeFn = function (res, status) {
                if (status === 'success') {
                    FR.Msg.toast(FR.i18nText("FS-Generic-Simple_Successfully"));
                    FSSM.View.taskTable().refresh();
                } else {
                    FR.Msg.toast(FR.i18nText("FS-Generic-Simple_Failed"));
                }
            };
            var config = {
                url: FR.servletURL,
                data: {
                    op: this.scheduleConfig.scheduleOP,
                    cmd: this.scheduleConfig.aouTaskURL,
                    taskJason: this.currentTask
                },
                type: 'POST'
            };
            FS.Async.ajax(config, completeFn);
        }
    },

    /**
     * 初始化定时调度
     * @param render 父容器
     * @param config 为sap/普通模板调度定制界面请求等。
     */
    init: function (render, config) {
        FR.$defaultImport('/com/fr/fs/web/css/manager/fs_schedule.css', 'css');
        if (config) {
            $.extend(this.Control.scheduleConfig, config)
        }
        this.View.createTabPane(render);
    }
};