FS.LookAndFeelSettings = FS.Plugin.LookAndFeelSettings;

/**
 * kyle: 平台外观配置
 */
FS.CONFIGSETTING = FSCS = {
    /**
     * 统一管理控件名
     */
    _WD: {
        configLoginPageTablePaneWD: "loginPageTablePane", //登录页配置标签页布局
        configLoginPageTypeRadioGroupWD: "loginPageTypeRadioGroup", //登录页类型选择单选按钮组
        configLoginPageUrlPaneWD: "loginPageUrlPane", ////登录页 Url 配置控件
        configLoginPageUrlTextWD: "loginPageUrlText", //登录页 Url 配置文本框
        configLoginPageImgUploadWD: "loginPageImgUpload", //登录页图片上传控件

        styleConfigTablePaneWD: "styleConfigTablePane", //样式配置标签页布局
        configLogoTypeRadioGroupWD: "logoTypeRadioGroup", //Logo样式类型
        configLogoImgUploadWD: "logoImgUpload", //Logo图片上传控件
        configBackgroundTypeRadioGroupWD: "BackgroundTypeRadioGroup", //背景类型单选按钮组
        configBackgroundImgUploadWD: "backgroundImgUpload", //平台样式自定义背景图上传控件
        colorPureBackgroundPicker: "colorPureBackgroundPicker", //纯色背景取色器
        colorSchemeRadioGroup: "colorSchemeRadioGroup", //配色按钮组
        colorSchemeColorPicker: "colorSchemeColorPicker", //配色取色器

        configHomePageAbsoluteWD: "homePageAbsolute", //首页配置标签页布局
        configHomePageUrlTextWD4PC: "homePageUrlText4PC", //首页 Url 配置文本框
        configHomePageUrlTextWD4Pad: "homePageUrlText4Pad", //首页 Url 配置文本框
        configHomePageUrlTextWD4Phone: "homePageUrlText4Phone", //首页 Url 配置文本框
        configHomePagePosAndCRoleInsideTabWD: "homePagePosAndCRoleInsideTab", //首页部门职位、自定义角色查看权限控制
        configHomePageListInPanelWD: "homePageListInPanel", //首页列表

        configPlatformStylePanelWD: "platformStylePanel", //平台样式配置面板
        configPlatformStyleTablePaneWD: "platformStyleTablePane", //平台样式配置标签页布局
        configPlatformTitleTextWD: "platformTitleText", //平台标题文本框
        configPlatformHasNavigationSwitchWD: "platformHasNavigationSwitch", //顶部导航栏开关

        configCustomHomePageListWD: "customHomePageList", //自定义首页列表
        configDepartmentTableTreeWD: "departmentTableTree", //部门职位树
        configCustomRoleListWD: "customRoleList" //自定义角色列表
    },

    /**
     * 统一管理常量
     */
    _Constants: {
        configPostIdPrefix: "10086",
        configCustomRoleListItemCls: "fs_cs_customRoleListItem", //自定义角色列表项
        folderIcons: [
            '\ue62f', '\ue630', '\ue631', '\ue632', '\ue633', '\ue634',
            '\ue635', '\ue636', '\ue637', '\ue638', '\ue639', '\ue63a',
            '\ue63b', '\ue63c', '\ue63d', '\ue63e', '\ue63f', '\ue640',
            '\ue641', '\ue642', '\ue643', '\ue644', '\ue645', '\ue646',
            '\ue647', '\ue648', '\ue649', '\ue64a'
        ],
        colorSchemes: [
            [
                {r: 0, g: 176, b: 244}, {r: 111, g: 211, b: 255},
                {r: 41, g: 90, b: 148}, {r: 255, g: 255, b: 255}
            ], [
                {r: 170, g: 160, b: 210}, {r: 179, g: 185, b: 196},
                {r: 120, g: 131, b: 157}, {r: 255, g: 255, b: 255}
            ], [
                {r: 230, g: 151, b: 70}, {r: 179, g: 185, b: 196},
                {r: 38, g: 60, b: 88}, {r: 255, g: 255, b: 255}
            ], [
                {r: 1, g: 184, b: 186}, {r: 157, g: 216, b: 217},
                {r: 6, g: 146, b: 151}, {r: 255, g: 255, b: 255}
            ]
        ],
        defaultCustomColors: [
            {r: 212, g: 63, b: 58}, {r: 55, g: 189, b: 100},
            {r: 20, g: 131, b: 255}, {r: 0, g: 0, b: 0}
        ]
    },

    data: null,

    /**
     * 初始化平台样式
     * @param renderer 父容器
     */
    init: function (renderer) {
        FR.$defaultImport('/com/fr/fs/web/css/manager/fs_configsetting.css', 'css');
        FSCS.Control.initData();
        FSCS.View.initView(renderer);
    },

    Model: {
        TabTitle: {
            createTitle: function (text, clickFunc) {
                return $("<span/>").text(text).addClass("fs_privilege_manager_tabTitle")
                    .click(function () {
                        if ($.isFunction(clickFunc)) {
                            clickFunc.call();
                        }
                    });
            }
        }
    },

    /**
     * 视图
     */
    View: {
        /**
         * 初始化布局
         * @param renderer 父容器
         */
        initView: function (renderer) {
            var self = this;
            self.createTabPane(renderer);
            renderer.data("onResize", function (width, height) {
                self.configPane.doResize({
                    width: width,
                    height: height
                });
            });
            self.previousId = null;
        },

        /**
         * 创建标签配置面板
         * @param renderer 父容器
         */
        createTabPane: function (renderer) {
            var self = this;
            this.renderEl = renderer;
            var items = [
                self.loginPageTab(),
                self.homePageTab(),
                self.themeConfigTab(),
                self.styleConfigTab()
            ];
            var actions = [
                function () {
                    FSCS.Control.popLoginPageData(this);
                }, function () {
                    FSCS.Control.popHomePageData(this);
                    self._makeHomePageListSortable();
                    self.departmentTableTree = this.getWidgetByName(FSCS._WD.configDepartmentTableTreeWD);
                    this.getWidgetByName(FSCS._WD.configCustomHomePageListWD).element.css("position", "relative");
                }, function () {
                    FSCS.Control.popThemeConfigData();
                }, function () {
                    FSCS.Control.popStyleConfigData(this);
                }
            ];
            if (FS.Plugin.LookAndFeelSettings) {
                _.each(FS.Plugin.LookAndFeelSettings, function (data) {
                    items.push(data.item.apply(self));
                    actions.push(data.action);
                });
            }
            this.configPane = new FS.LTabPane({
                width: '100%',
                height: '100%',
                style: 'blue',
                marginLeft: 40,
                renderEl: renderer,
                items: items,
                initAfterActions: actions
            });
        },

        /**
         * 登录页配置标签页
         * 第一页
         */
        loginPageTab: function () {
            var saveBtn = {
                type: 'quickbutton',
                style: 'blue',
                text: FR.i18nText("FS-Frame-Simple_Save"),
                handler: function () {
                    FSCS.Control.saveLoginPageData();
                }
            };
            return {
                title: FR.i18nText("FS-Setting-Login_Page"),
                content: {
                    widgetName: FSCS._WD.configLoginPageTablePaneWD,
                    type: 'tablepane',
                    colSize: [80, 131, 'fill'],
                    rowSize: [21, 'fill', 52, 25, 150, 30, 10],
                    vgap: 20,
                    items: [
                        this._createLoginPageTypeConfig(),
                        this._createLoginStyle(),
                        this._createLoginPageUrlConfig(),
                        this._createLoginImgUploadConfig(),
                        [null, {}, $('<img/>').addClass('fs_csview_loginimg')],
                        [saveBtn, null, null],
                        [{}, null, null]
                    ]
                }
            };
        },

        /**
         * 创建登录风格选择选项
         * @private
         */
        _createLoginStyle: function (inUseId, changeUseId) {
            var self = this;
            var $resultLoginStyle = $('<div class="result_login_style"/>');
            //默认风格
            var defaultInfo = {
                "name": "default",
                "id": "",
                "active": true,
                "img": FR.servletURL + '?op=resource&resource=/com/fr/fs/resources/images/loginstyle/A.png'
            };
            self.addLoginStyle($resultLoginStyle, defaultInfo);
            //根据接口获取到所有已经安装的登陆页面插件的信息
            FS.Async.getLoginStyleList(function (res, status) {
                if (status === 'success') {
                    var list = FR.jsonDecode(res.responseText);
                    var info = list.loginUI || [];
                    for (var i = 0; i < info.length; i++) {
                        self.addLoginStyle($resultLoginStyle, info[i]);
                    }
                }
            });
            return [
                null, {
                    type: 'llabel',
                    cls:'fs-login-style-label',
                    value: FR.i18nText("FS-Setting-Customize_Login_Style")
                }, $resultLoginStyle
            ]
        },


        addLoginStyle: function ($resultLoginStyle, info) {
            var $loginStyleDiv = $('<div class="fs-login-style"/>');
            $loginStyleDiv.appendTo($resultLoginStyle);
            var $extraStyleDiv = $('<div/>').addClass("login_style_select");
            $extraStyleDiv.css("display", "none").appendTo($loginStyleDiv);
            $loginStyleDiv.hover(function () {
                $(this).addClass('hover');
            }, function () {
                $(this).removeClass('hover');
            }).click(function () {
                $(".login_style_select").hide();
                $extraStyleDiv.show();
                //切换选中的风格
                FSCS.View.changeUseId = info.id;
            });
            if (info.active) {
                //改主题目前正在被使用
                FSCS.View.inUseId = info.id;
                FSCS.View.changeUseId = info.id;
                $(".login_style_select").hide();
                $extraStyleDiv.show();
            }
            if (info.img != undefined) {
                $('<img class="login_style_img">').attr('src', info.img)
                    .appendTo($loginStyleDiv);
            } else {
                $('<img class="login_style_img">').attr('src', FR.servletURL + '?op=resource&resource=/com/fr/fs/resources/images/loginstyle/B.png')
                    .appendTo($loginStyleDiv);
            }

            $('<div class="login-style-title"/>').attr("title", info.name)
                .text(info.name).appendTo($loginStyleDiv);
        },
        /**
         * 创建登录页类型选择选项
         * @private
         */
        _createLoginPageTypeConfig: function () {
            return [
                null,
                {
                    type: 'llabel',
                    value: FR.i18nText("FS-Setting-Login_Option")
                }, {
                    widgetName: FSCS._WD.configLoginPageTypeRadioGroupWD,
                    type: 'radiogroup',
                    assureSelect: true,
                    width: 360,
                    height: 21,
                    items: [
                        {
                            text: FR.i18nText("FS-Setting-Login_Style_Plugin"),
                            value: 1,
                            width: 180
                        },
                        {
                            text: FR.i18nText("FS-Setting-Login_URL"),
                            value: 2,
                            width: 180
                        }
                    ],
                    listeners: [{
                        eventName: FR.Events.AFTEREDIT,
                        action: function () {
                            var widget = this.getWidgetByName(FSCS._WD.configLoginPageTypeRadioGroupWD);
                            if (widget && widget.getValue() === 1) {
                                this.getWidgetByName(FSCS._WD.configLoginPageTablePaneWD).setRowVisible([2], false);
                                this.getWidgetByName(FSCS._WD.configLoginPageTablePaneWD).setRowVisible([1], true);
                                this.getWidgetByName(FSCS._WD.configLoginPageTablePaneWD).setRowVisible([3, 4], true);
                            } else {
                                this.getWidgetByName(FSCS._WD.configLoginPageTablePaneWD).setRowVisible([1], false);
                                this.getWidgetByName(FSCS._WD.configLoginPageTablePaneWD).setRowVisible([2], true);
                                this.getWidgetByName(FSCS._WD.configLoginPageTablePaneWD).setRowVisible([3, 4], false);
                            }
                        }
                    }],
                    columnsInRow: 2
                }
            ]
        },

        /**
         * 创建登录页标签 Url 配置部分
         * @private
         */
        _createLoginPageUrlConfig: function () {
            return [
                null,
                {},
                {
                    widgetName: FSCS._WD.configLoginPageUrlPaneWD,
                    type: 'tablepane',
                    colSize: [122, 322],
                    rowSize: [21, 21],
                    vgap: 10,
                    items: [
                        [{type: 'llabel', value: FR.i18nText("FS-Setting-Login_URL_Detail")}, null],
                        [null, {widgetName: FSCS._WD.configLoginPageUrlTextWD, type: 'text'}]
                    ]
                }
            ]
        },

        /**
         * 创建登录页标签自定义图片上传配置部分
         * @private
         */
        _createLoginImgUploadConfig: function () {
            var self = this;
            return [
                null, {
                    type: 'llabel',
                    value: FR.i18nText("FS-Setting-Background_Img")
                },
                {
                    type: 'multifile',
                    widgetName: FSCS._WD.configLoginPageImgUploadWD,
                    maxlength: 1,
                    accept: '.png.jpg.gif',
                    hideFileList: true,
                    height: 32,
                    width: 32,
                    tooltipText: FR.i18nText("FS-Setting-BG_Upload_ToolTip"),
                    listeners: [{
                        eventName: "afteredit",
                        action: function () {
                            var widget = self.configPane.getWidgetByName(FSCS._WD.configLoginPageImgUploadWD);
                            if (widget) {
                                var attachid = widget.getValue().attach_id;
                                var url = FR.servletURL + ('?op=fr_attach&cmd=ah_image&id=' + attachid + '&isAdjust=false');
                                $('.fs_csview_loginimg').attr('src', url);
                                $('td', widget.element).remove();
                            }
                        }
                    }]
                }
            ]
        },

        /**
         * 首页配置标签页
         * 第二页
         */
        homePageTab: function () {
            var self = this;
            return {
                title: FR.i18nText("FS-Setting-Home_Page"),
                content: {
                    type: 'panel',
                    width: 700,
                    height: 500,
                    doSize: true,
                    contentWidget: {
                        type: 'absolute',
                        widgetName: FSCS._WD.configHomePageAbsoluteWD,
                        items: [
                            {el: self._createHomePageManagementPanel(), x: 0, y: 0},
                            {el: self._createHomePageUrlConfig(), x: 300, y: 0},
                            {el: self._createPositionAndCustomRoleTabPane(), x: 300, y: 80},
                            {
                                el: {
                                    type: 'quickbutton',
                                    style: 'blue',
                                    width: 80,
                                    height: 30,
                                    text: FR.i18nText("FS-Frame-Simple_Save"),
                                    handler: function () {
                                        //保存首页数据
                                        FSCS.Control.saveHomePageData();
                                    }
                                }, x: 0, y: 450
                            }
                        ]
                    }
                }
            }
        },

        /**
         * 创建首页页面管理配置面板
         * @private
         */
        _createHomePageManagementPanel: function () {
            var self = this;
            return {
                type: 'panel',
                doSize: true,
                border: true,
                title: FR.i18nText("FS-Setting_Home_Page_Manage"),
                width: 260,
                height: 400,
                contentWidget: self._createCustomHomePageList(),
                tools: [
                    {
                        //添加目录按钮及其事件
                        iconCls: 'fs-module-add-white',
                        width: 24,
                        height: 24,
                        handler: function () {
                            var homepageList = self.configPane.getWidgetByName(FSCS._WD.configCustomHomePageListWD);
                            $(this).removeClass('fs_reportmgr_add_icon_white_click');
                            var data = {
                                id: -1,
                                name: self._createUnRepeatName(null),
                                sort: homepageList.getItemLength(),
                                url: {"phoneUrl":"","pcUrl":"","padUrl":""}
                            };
                            var addPageDialog = self._createHomePageDialog(data, false);
                            addPageDialog.setVisible(true);
                        }
                    }
                ]
            }
        },

        /**
         * 自定义首页列表
         * @private
         */
        _createCustomHomePageList: function () {
            var self = this;
            var itemTools = [
                {
                    iconCls: 'fs-module-delete-white',
                    iconCls4Hover: 'fs-module-delete-white-hover'
                }, {
                    iconCls: 'fs-module-edit-white',
                    iconCls4Hover: 'fs-module-edit-white-hover'
                }
            ];
            //自定义角色按钮
            var customHomePageList = {
                type: 'quicklist',
                scrollLoading: true,
                async: {
                    url: FR.servletURL + '?op=fs_manager&cmd=fs_get_all_homepages',
                    data: {
                        serverID: FS.serverID
                    }
                },
                valueField: 'id',
                width: 258,
                height: 400,
                itemCanBeSelect: true,
                widgetName: FSCS._WD.configCustomHomePageListWD,
                tools: itemTools,
                alwaysShowTools: false,
                onBeforeItemCreate: function (element, opts) {
                    if (opts.id === 0) {
                        opts.tools = [];
                    } else {
                        if (opts.tools.length === 0) {
                            opts.tools = itemTools;
                        }
                        element.addClass("fs_cs_homepage_item")
                    }
                    if (opts.localeKey) {
                        //在前台做下国际化
                        opts[opts.showField] = FR.i18nText(opts.localeKey);
                    }

                    element.attr("id", opts.id);
                },
                onItemToolClick: function (toolindex, index, e) {
                    var homepageList = self.configPane.getWidgetByName(FSCS._WD.configCustomHomePageListWD);
                    var homepageId = homepageList.getValueAtIndex(index);
                    if (toolindex === 1) {
                        //编辑
                        var homepageItem = homepageList.getItemById(homepageId);
                        var homepageName = homepageList.getTextAtIndex(index);
                        var data = {
                            id: homepageId,
                            name: homepageName,
                            description: homepageItem.options.description,
                            sort: homepageItem.options.sortindex,
                            url: homepageItem.options.url,
                            index: index
                        };
                        var editDialog = self._createHomePageDialog(data, true);
                        editDialog.setVisible(true);
                    } else {
                        //删除
                        if (homepageId === 0) {
                            //默认首页不能删除
                            return;
                        }
                        FR.Msg.confirm(FR.i18nText("FS-Frame-Delete_Data"), FR.i18nText("FS-Generic-Sure_To_Delete") + '?', function (result) {
                            if (result) {
                                //先向后台请求删除数据，请求成功再在web端删除
                                FS.Async.ajax({
                                    url: FR.servletURL + "?op=fs_manager&cmd=fs_remove_homepage",
                                    data: {
                                        homepageId: homepageId
                                    }
                                })
                                //清楚缓存对应数据
                                FSCS.Cache.deleteHomePageCache(homepageId);
                                FSCS.Cache.deleteHomePageUrlCache(homepageId);
                                homepageList.remove(index);
                                if (homepageList.getItemLength() > 0) {
                                    homepageList.selectItemByIndex(0, true);
                                } else {
                                    //最后一个了
                                }
                            }
                        });
                    }
                    //在可拖动层触发mouseUp事件，结束被捕捉的额外拖放操作
                    homepageList.options.listItems[index].element.mouseup()
                },
                onCustomItemSelect: function () {
                    //保存之前选中的首页URL
                    if (self.previousId != null) {
                        var prevUrl = {
                            pcUrl: FSCS.View.configPane.getWidgetByName(FSCS._WD.configHomePageUrlTextWD4PC).getText(),
                            padUrl: FSCS.View.configPane.getWidgetByName(FSCS._WD.configHomePageUrlTextWD4Pad).getText(),
                            phoneUrl: FSCS.View.configPane.getWidgetByName(FSCS._WD.configHomePageUrlTextWD4Phone).getText()
                        }
                        FSCS.Cache.setHomePageUrlCache(self.previousId, prevUrl)
                    }
                    //更新选中首页对应的信息
                    var homepageId = this.getValue();
                    var url = FSCS.Cache.getHomePageUrlCache()[homepageId];
                    if (!url && url !== "") {
                        url = this.options.url;
                        FSCS.Cache.keepOriginalHomePageUrlCache(homepageId, url);
                    }
                    self.configPane.getWidgetByName(FSCS._WD.configHomePageUrlTextWD4PC).setValue(url.pcUrl, false);
                    self.configPane.getWidgetByName(FSCS._WD.configHomePageUrlTextWD4Pad).setValue(url.padUrl, false);
                    self.configPane.getWidgetByName(FSCS._WD.configHomePageUrlTextWD4Phone).setValue(url.phoneUrl, false);
                    self.showHomePageAuth(homepageId);
                    self.previousId = homepageId;
                }
            };
            return {
                type: 'vertical',
                items: [{
                    el: customHomePageList
                }],
                width: 260
            }
        },

        /**
         * 创建首页编辑对话框
         * @param data
         * @param isEdit
         * @private
         */
        _createHomePageDialog: function (data, isEdit) {
            var self = this;
            var hGap = 10;//标签和文本框之间的间隙
            var labelWidth = parseInt(FR.i18nText("FS-Report-Create_Home_Page_Dialog_Label_width") || 58);
            var title = isEdit ? FR.i18nText("FS-Setting-Edit_Home_Page") : FR.i18nText("FS-Setting-Add_Home_Page");
            return new FR.Dialog({
                title: title,
                text4OK: FR.i18nText("FS-Generic-Simple_OK"),
                text4Cancel: FR.i18nText("FS-Generic-Simple_Cancel"),
                onOK: function () {
                    var name = this.getWidgetByName("nameText").getValue();
                    var description = this.getWidgetByName("descriptionText").getValue();
                    if (!self._checkValidName(name, data.index, isEdit)) {
                        return;
                    }
                    var homepage = {
                        id: data.id,
                        text: name,
                        description: description,
                        sortindex: data.sort,
                        url: data.url.pcUrl,
                        url4Pad: data.url.padUrl,
                        url4Phone: data.url.phoneUrl
                    };
                    var result = FSCS.Control.saveHomePage(homepage);
                    //更新首页列表
                    if (result && result.id) {
                        var homepageList = self.configPane.getWidgetByName(FSCS._WD.configCustomHomePageListWD);
                        if (isEdit) {
                            homepageList.setTextAtIndex(data.index, name);
                        } else {
                            homepageList.addItem(result, true);
                        }
                    }
                },
                onCancel: function () {
                },
                destroyOnClose: true,
                animate: false,
                width: 300,
                height: 220,
                confirm: true,
                border: true,
                closable: true,
                contentWidget: {
                    type: 'absolute',
                    items: [
                        {
                            type: 'llabel',
                            value: FR.i18nText("FS-Generic-WF_Name"),
                            height: 21,
                            width: labelWidth,
                            textalign: 'right',
                            x: 0,
                            y: 16
                        },
                        {
                            type: 'text',
                            height: 21,
                            width: 130,
                            widgetName: 'nameText',
                            value: data.name,
                            x: hGap + labelWidth,
                            y: 16
                        },
                        {
                            type: 'llabel',
                            value: FR.i18nText("FS-Generic-Simple_Description"),
                            height: 21,
                            width: labelWidth,
                            textalign: 'right',
                            x: 0,
                            y: 47
                        },
                        {
                            type: 'textarea',
                            height: 85,
                            width: 185,
                            widgetName: 'descriptionText',
                            value: data.description,
                            x: hGap + labelWidth,
                            y: 47
                        }
                    ]
                }
            })
        },

        /**
         * 检查首页是否重名
         * @param name
         * @param index
         * @param isEdit
         * @private
         */
        _checkValidName: function (name, index, isEdit) {
            var self = this;
            if (!name) {
                FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Setting-Input_Homepage_Name"));
                return false;
            }
            var homepageList = self.configPane.getWidgetByName(FSCS._WD.configCustomHomePageListWD);
            if (index !== null && isEdit === true) {
                var oldName = homepageList.getTextAtIndex(index);
                if (name === oldName) {
                    return true;
                }
            }
            var nameList = homepageList.getAllItemText();
            for (var i = 0, len = nameList.length; i < len; i++) {
                var itemName = nameList[i];
                if (itemName === name) {
                    FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Report-Simple_Named") + name + FR.i18nText("FS-Setting-Homepage_Exists"));
                    return false;
                }
            }
            return true;
        },

        /**
         * 创建初始首页名称
         * @param name
         * @returns {*}
         * @private
         */
        _createUnRepeatName: function (name) {
            var self = this;
            if (name == null) {
                name = FR.i18nText("FS-Setting-Custom_Homepage");
            }
            var homepageList = self.configPane.getWidgetByName(FSCS._WD.configCustomHomePageListWD);
            var allPages = homepageList.getAllItemText();
            if (allPages.length === 0) {
                return name + "-1";
            }
            for (var i = 1; i < 10000; i++) {
                var newName = name + "-" + i;
                for (var m = 0; m < allPages.length; m++) {
                    if (allPages[m] == newName) {
                        break;
                    }
                    if (m == allPages.length - 1) {
                        return newName;
                    }
                }
            }
        },

        /**
         * 设置首页列表可排序
         * @private
         */
        _makeHomePageListSortable: function () {
            var self = this;
            var beforeDrag = 0;
            var afterDrag = 0;
            var sortID;
            var itemCls = "div.fs_cs_homepage_item";
            var homepageList = self.configPane.getWidgetByName(FSCS._WD.configCustomHomePageListWD);
            var list = homepageList.element;
            list.sortable({
                nested: false,
                delay: 200,
                itemSelector: itemCls,
                handler: itemCls,
                containerSelector: "fr-core-list",
                placeholder: "<div style = 'height: 24px'/>",
                onDrag: function ($item, position, _super, event) {
                    position.left = 0;
                    _super($item, position);
                    beforeDrag = $(itemCls, list).index($item[0]);
                    sortID = parseInt($item.attr('id'));
                },
                onDrop: function ($item, container, _super, event) {
                    afterDrag = $(itemCls, list).index($item[0]);
                    if ((beforeDrag != afterDrag) && (beforeDrag >= 0) && (afterDrag >= 0)) {
                        var sortIndex = homepageList.getItemLength() - afterDrag - 1;
                        //拖拽后同时修改后台顺序
                        var config = {
                            url: FR.servletURL + "?op=fs_manager&cmd=fs_modify_homepage_sort",
                            type: 'POST',
                            data: {
                                sortId: sortID,
                                sortIndex: sortIndex,
                                serverID: FS.serverID
                            }
                        }
                        var completeFn = function (res, status) {
                            if (status !== 'success') {
                                FR.Msg.toast(FR.i18nText("FS-Generic-Simple_Failed"));
                            }
                        };
                        FS.Async.ajax(config, completeFn);
                    }
                    _super($item);
                }
            });
        },

        /**
         * 创建首页 Url 配置
         * @private
         */
        _createHomePageUrlConfig: function () {
            var labelWidth = FR.i18nTextWidth("FS-Setting-Homepage_URL_Mobile", 6.5) > 40 ?
                (FR.i18nTextWidth("FS-Setting-Homepage_URL_Mobile", 6.5) + 10) : 45;
            var hGap = 10;
            return {
                type: 'absolute',
                height: 78,
                width: labelWidth + 255,
                items: [
                    {
                        type: 'llabel',
                        value: FR.i18nText("FS-Setting-Homepage_URL_PC"),
                        height: 21,
                        width: labelWidth,
                        textalign: 'left',
                        x: 0,
                        y: 0
                    },
                    {
                        type: 'text',
                        height: 21,
                        width: 245,
                        widgetName: FSCS._WD.configHomePageUrlTextWD4PC,
                        watermark: FR.i18nText("FS-Setting-Homepage_URL"),
                        x: hGap + labelWidth,
                        y: 0
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("FS-Setting-Homepage_URL_Mobile"),
                        height: 21,
                        width: labelWidth,
                        textalign: 'left',
                        x: 0,
                        y: 25
                    },
                    {
                        type: 'text',
                        height: 21,
                        width: 245,
                        widgetName: FSCS._WD.configHomePageUrlTextWD4Phone,
                        watermark: FR.i18nText("FS-Setting-Homepage_URL"),
                        x: hGap + labelWidth,
                        y: 25
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("FS-Setting-Homepage_URL_Pad"),
                        height: 21,
                        width: labelWidth,
                        textalign: 'left',
                        x: 0,
                        y: 50
                    },
                    {
                        type: 'text',
                        height: 21,
                        width: 245,
                        widgetName: FSCS._WD.configHomePageUrlTextWD4Pad,
                        watermark: FR.i18nText("FS-Setting-Homepage_URL"),
                        x: hGap + labelWidth,
                        y: 50
                    }
                ]
            }
        },

        /**
         * 创建职位列表和自定义角色配置（有checkbox的工具按钮）
         * @private
         */
        _createPositionAndCustomRoleTabPane: function () {
            var self = this;
            var authorityTitle = $("<div/>").css({
                'textAlign': 'right',
                'paddingRight': '5px'
            });
            var viewTitle = FSCS.Model.TabTitle.createTitle(FR.i18nText("FS-Generic-Face_View"), function () {
                var positionAndCustomRoleInsideTab = self.configPane.getWidgetByName(FSCS._WD.configHomePagePosAndCRoleInsideTabWD);
                if (positionAndCustomRoleInsideTab.getActiveIndex() === 0) {
                    if (self.departmentTableTree.hasNodeSelect(0)) {
                        self.departmentTableTree.deSelectAll(0);
                    } else {
                        self.departmentTableTree.selectAll(0);
                    }
                    FSCS.Cache.saveHomePageDepartmentCache();
                } else {
                    var customRoleList = positionAndCustomRoleInsideTab.getWidgetByName(FSCS._WD.configCustomRoleListWD);
                    if (customRoleList.hasNodeSelect(0)) {
                        customRoleList.deSelectAll(0);
                    } else {
                        customRoleList.selectAll(0);
                    }
                    FSCS.Cache.saveHomePageCustomRoleCache();
                }
            });
            authorityTitle.append(viewTitle);

            return {
                type: 'insidetab',
                widgetName: FSCS._WD.configHomePagePosAndCRoleInsideTabWD,
                items: [
                    self.Tabs._departmentAndPositionTab(298, 319, "departmentTableTreeWithCheck", FR.emptyFn),
                    self.Tabs._customRoleTab(300, 319),
                    {
                        title: authorityTitle,
                        keepActive: true,
                        borderWidth: 2,
                        width: 70
                    }
                ],
                width: 300,
                height: 319,
                marginLeft: 0,
                afterTabClick: [
                    function () {
                        if (FSCS.View.configPane) {
                            setTimeout(function () {
                                var homepageId = FSCS.View.configPane.getWidgetByName(FSCS._WD.configCustomHomePageListWD).getValue();
                                self.showHomePageAuth(homepageId);
                            }, 50);
                        }
                    },
                    function () {
                        if (FSCS.View.configPane) {
                            setTimeout(function () {
                                var homepageId = FSCS.View.configPane.getWidgetByName(FSCS._WD.configCustomHomePageListWD).getValue();
                                self.showHomePageAuth(homepageId);
                            }, 50);
                        }
                    }
                ]
            }
        },

        /**
         * 首页显示授权配置
         * @param homepageId
         */
        showHomePageAuth: function (homepageId) {
            var self = this;
            if (homepageId == null) {
                return;
            }
            var authTabPane = self.configPane.getWidgetByName(FSCS._WD.configHomePagePosAndCRoleInsideTabWD);
            var customRoleList = authTabPane.getWidgetByName(FSCS._WD.configCustomRoleListWD);
            //默认首页权限配置
            if (homepageId === 0) {
                if (authTabPane.getActiveIndex() === 0) {
                    self.departmentTableTree.selectAll(0);
                    self.departmentTableTree.options.toolUnEditAble = true;
                    $.each(self.departmentTableTree.getSelectedNodes(), function (idx, node) {
                        node.toolDiv[0].addClass("fs_tool_disabled");
                        self.departmentTableTree.expandNode(node, false);
                    });
                } else {
                    customRoleList.selectAll(0);
                    $.each(customRoleList.options.listItems, function (idx, item) {
                        item.toolDivs[0].addClass("fs_tool_disabled");
                        item.options.toolUnEditAble = true;
                    });
                }
                return;
            }
            //清理默认首页锁定的配置
            if (self.previousId != null && self.previousId === 0) {
                //部门职位
                self.departmentTableTree.options.toolUnEditAble = false;
                $.each(self.departmentTableTree.getSelectedNodes(), function (idx, node) {
                    node.toolDiv[0].removeClass("fs_tool_disabled");
                });
                //角色
                if (customRoleList) {
                    $.each(customRoleList.options.listItems, function (idx, item) {
                        item.toolDivs[0].removeClass("fs_tool_disabled");
                        item.options.toolUnEditAble = false;
                    });
                }
            }
            //收缩树节点
            if (authTabPane.getActiveIndex() === 0) {
                $.each(self.departmentTableTree.getNodes(), function (idx, node) {
                    self.departmentTableTree.expandNode(node, false);
                });
            }
            //处理节点数据
            var filterNodes = function (isDep, homePageRoles) {
                var depNodes = [];
                var customRoleNodes = [];
                for (var i = 0, len = homePageRoles.length; i < len; i++) {
                    if (homePageRoles[i].departmentId != undefined) {
                        if (!isDep) {
                            continue;
                        }
                        if (homePageRoles[i].postId != undefined) {
                            homePageRoles[i].id = homePageRoles[i].departmentId + homePageRoles[i].id;
                        }
                        depNodes.push(homePageRoles[i]);
                    } else {
                        customRoleNodes.push(homePageRoles[i]);
                    }
                }
                if (isDep) {
                    return depNodes;
                } else {
                    return customRoleNodes;
                }
            };
            //获取缓存
            var cacheHomePageRolePrivilege = FSCS.Cache.getHomePageCache()[homepageId];
            if (!cacheHomePageRolePrivilege) {
                //没有缓存，要去服务器端取下
                var homePageRoles = FS.Trans.ajax({
                    url: FR.servletURL + "?op=fs_manager&cmd=fs_get_homepage_roles",
                    data: {
                        homepageId: homepageId
                    }
                });
                //缓存下
                var companyRoles = filterNodes(true, homePageRoles);
                var customRoles = filterNodes(false, homePageRoles);
                FSCS.Cache.keepOriginalHomePageCache(homepageId, companyRoles, true);
                FSCS.Cache.keepOriginalHomePageCache(homepageId, customRoles, false);
                cacheHomePageRolePrivilege = FSCS.Cache.getHomePageCache()[homepageId];
            }
            //显示权限
            if (authTabPane.getActiveIndex() === 0) {
                //部门
                self.departmentTableTree.clearState();
                self.departmentTableTree.selectNodesByData(cacheHomePageRolePrivilege["companyRole"]);
            } else {
                customRoleList.clearState();
                customRoleList.selectByData(cacheHomePageRolePrivilege["customRole"]);
            }
        },

        /**
         * 标签页
         */
        Tabs: {
            /**
             * 部门职位标签页
             * @param contentWidth  标签宽度
             * @param contentHeight 标签高度
             * @param treeID
             * @param clickFunc
             * @private
             */
            _departmentAndPositionTab: function (contentWidth, contentHeight, treeID, clickFunc) {
                function filter(parentNode, node, newNodes, result) {
                    if (!newNodes) {
                        return null;
                    }
                    if (!result) {
                        result = [];
                    }
                    for (var i = 0, l = newNodes.length; i < l; i++) {
                        var item = newNodes[i];
                        if (item.postId) {
                            var postItem = {};
                            postItem.id = item.departmentId + FSCS._Constants.configPostIdPrefix + item.postId;
                            postItem.pId = item.departmentId + FSCS._Constants.configPostIdPrefix;
                            postItem.open = false;
                            postItem.name = item.postName;
                            if (FSCS.Control._alreadyExists(postItem.id, result)) {
                                continue;
                            }
                            result.push(postItem);
                        }
                        //department/entry
                        var zItem = {};
                        zItem.id = item.departmentId + FSCS._Constants.configPostIdPrefix;
                        zItem.pId = item.departmentPId + FSCS._Constants.configPostIdPrefix;
                        zItem.name = item.departmentName;
                        zItem.open = false;
                        zItem.description = item.description;

                        if (item.ChildNodes && item.ChildNodes.length > 0) {
                            filter(parentNode, node, item.ChildNodes, result);
                        }
                        if (!FSCS.Control._alreadyExists(zItem.id, result)) {
                            result.push(zItem);
                        }
                    }
                    return result;
                }

                var departmentAndPostTreeSetting = {
                    view: {
                        showIcon: false,  //不显示每个节点前的ICON
                        selectedMulti: true
                    },
                    data: {
                        simpleData: {
                            enable: true,
                            idKey: "id",
                            pidKey: "pId",
                            rootPId: "-1"
                        }
                    },
                    callback: {
                        onClick: function (e, treeId, treeNode) {
                            clickFunc.call(this, treeNode);
                        },
                        beforeClick: function () {
                            return false;
                        }
                    },
                    async: {
                        enable: true,
                        url: FR.servletURL + "?op=fs_set&cmd=auth_getcompanyrole",
                        dataFilter: filter,
                        data: {
                            serverID: FS.serverID
                        }
                    }
                };
                var tools = [{
                    name: 'view',
                    //编辑按钮事件
                    onToolClick: function (e) {
                        e.stopEvent();
                    }
                }];
                return {
                    title: FR.i18nText("FS-Privilege-Department_And_Post"),
                    content: {
                        type: 'fstabletree',
                        treeID: treeID,
                        height: contentHeight,
                        setting: departmentAndPostTreeSetting,
                        alwaysShowTools: true,
                        toolMargin: 10,
                        width: contentWidth,
                        widgetName: FSCS._WD.configDepartmentTableTreeWD,
                        fit: false,
                        tools: tools,
                        tooltype: 'check',
                        onItemToolClick: function () {
                            //缓存数据
                            FSCS.Cache.saveHomePageDepartmentCache();
                        }
                    },
                    width: 110
                };
            },

            /**
             * 自定义角色标签页
             * @param contentWidth  标签宽度
             * @param contentHeight 标签高度
             * @private
             */
            _customRoleTab: function (contentWidth, contentHeight) {
                //自定义角色按钮
                var items = [];
                var tools = [{
                    name: "view",
                    width: 20
                }];
                var customRoleList = {
                    type: 'quicklist',
                    scrollLoading: true,
                    async: {
                        url: FR.servletURL + '?op=fs_set&cmd=auth_getcustomrole',
                        data: {
                            serverID: FS.serverID
                        }
                    },
                    onBeforeItemCreate: function (element, opts) {
                        if (opts.id < 0) {
                            element.addClass(FSCS._Constants.configCustomRoleListItemCls);
                        }
                    },
                    valueField: 'id',
                    width: contentWidth,
                    height: contentHeight,
                    widgetName: FSCS._WD.configCustomRoleListWD,
                    tools: tools,
                    alwaysShowTools: true,
                    toolMargin: 10,
                    tooltype: 'check',
                    itemCanBeSelect: false,
                    onItemToolClick: function () {
                        //缓存数据
                        FSCS.Cache.saveHomePageCustomRoleCache();
                    }
                };
                items.push({
                    el: customRoleList
                });
                return {
                    title: FR.i18nText("FS-Generic-Simple_Role"),
                    content: {
                        type: 'vertical',
                        items: items,
                        width: contentWidth
                    },
                    width: 120
                }
            }
        },

        /**
         * 主题配置标签页
         * 第三页
         */
        themeConfigTab: function () {
            var self = this;
            this.loadedThemes = [];
            this.$themeContainer = $('<div class="fs-theme-container"/>');
            return {
                title: FR.i18nText("FS-Setting-Theme_Config"),
                content: this.$themeContainer
            }
        },

        addThemeCard: function (theme) {
            var cover, self = this;
            // 去重
            if ($.inArray(theme.name, this.loadedThemes) > -1) {
                return;
            }
            var $card = $('<div class="fs-theme-card"/>')
                .hover(function () {
                    $(this).addClass('hover');
                }, function () {
                    $(this).removeClass('hover');
                }).click(function () {
                    FS.Async.setTheme(theme, function () {
                        $('.fs-theme-select', self.$themeContainer).hide();
                        $mask.show();
                    });
                }).data("THEME", theme);
            if (theme.cover) {
                cover = theme.cover;
            } else {
                cover = '/com/fr/fs/resources/images/theme/cover_default.png';
            }
            $('<img class="fs-theme-cover"/>').attr("src", FR.servletURL + '?op=resource&resource=' + cover).appendTo($card);
            var $mask = $('<div class="fs-theme-select"/>').appendTo($card);
            $('<div class="fs-theme-title"/>').attr("title", theme.text)
                .text(theme.text).appendTo($card);
            if (FS.config.theme.isCustom !== theme.isCustom || FS.config.theme.name !== theme.name) {
                $mask.hide();
            }
            $card.appendTo(this.$themeContainer);
            this.loadedThemes.push(theme.name);
        },

        /**
         * 样式配置标签页
         * 第四页
         */
        styleConfigTab: function () {
            var saveBtn = {
                type: 'quickbutton',
                style: 'blue',
                text: FR.i18nText("FS-Frame-Simple_Save"),
                handler: function () {
                    FSCS.Control.saveStyleConfigData();
                }
            };
            return {
                title: FR.i18nText("FS-Setting-Style_Config"),
                content: {
                    widgetName: FSCS._WD.styleConfigTablePaneWD,
                    type: 'tablepane',
                    colSize: [80, 131, 'fill'],
                    rowSize: [21, 21, 21, 50, 21, 21, 150, 'auto', 100, 'auto', 100, 'auto', 30, 10],
                    width: 920,
                    vgap: 20,
                    items: [
                        this._createPlatformTitleConfig(),
                        this._createLogoTypeConfig(),
                        this._createLogoImgUploadConfig(),
                        this._createBannerPreviewConfig(),
                        this._createBackgroundTypeConfig(),
                        this._createBackgroundImgUploadConfig(),
                        [null, {}, $('<img/>').addClass('fs_csview_background')],
                        this._createBackgroundColorConfig(),
                        this._createBackgroundColorPicker(),
                        this._createColorSchemeConfig(),
                        this._createColorSchemePicker(),
                        this._createEditIconConfig(),
                        [saveBtn, null, null],
                        [{}, null, null]
                    ]
                }
            };
        },

        /**
         * 创建平台标题配置部分
         * @private
         */
        _createPlatformTitleConfig: function () {
            return [
                null, {
                    type: 'llabel',
                    value: FR.i18nText("FS-Setting-Simple_Title")
                }, {
                    widgetName: FSCS._WD.configPlatformTitleTextWD,
                    type: 'text',
                    width: 186,
                    height: 21,
                    listeners: [{
                        eventName: FR.Events.AFTEREDIT,
                        action: function () {
                            $('.fs-banner-preview .fs-banner-preview-title').text(
                                this.getWidgetByName(FSCS._WD.configPlatformTitleTextWD).getValue()
                            );
                        }
                    }]
                }
            ]

        },

        /**
         * 平台 Logo 类型设置
         * @private
         */
        _createLogoTypeConfig: function () {
            var self = this;
            return [
                null,
                {
                    type: 'llabel',
                    value: FR.i18nText("FS-Setting-Logo_Style")
                }, {
                    widgetName: FSCS._WD.configLogoTypeRadioGroupWD,
                    type: 'radiogroup',
                    assureSelect: true,
                    width: FR.i18nTextWidth("FS-Setting-Image_With_Title") > 96 ?
                        (FR.i18nTextWidth("FS-Setting-Image_With_Title") + 30) * 3 : 360,
                    height: 21,
                    items: [
                        {
                            text: FR.i18nText("FS-Setting-Title_Only"),
                            value: 1
                        }, {
                            text: FR.i18nText("FS-Setting-Image_With_Title"),
                            value: 2
                        }, {
                            text: FR.i18nText("FS-Setting-Image_Only"),
                            value: 3
                        }
                    ],
                    listeners: [{
                        eventName: FR.Events.AFTEREDIT,
                        action: function () {
                            self._setBannerPreview(this.getValue());
                        }
                    }],
                    columnsInRow: 3
                }
            ]
        },

        /**
         * 创建登录页标签自定义图片上传配置部分
         * @private
         */
        _createLogoImgUploadConfig: function () {
            var self = this;
            return [
                null, {},
                {
                    type: 'multifile',
                    widgetName: FSCS._WD.configLogoImgUploadWD,
                    maxlength: 1,
                    accept: '.png.jpg.gif',
                    hideFileList: true,
                    height: 32,
                    width: 32,
                    tooltipText: FR.i18nText("FS-Setting-Logo_Upload_ToolTip"),
                    listeners: [{
                        eventName: "afteredit",
                        action: function () {
                            var widget = self.configPane.getWidgetByName(FSCS._WD.configLogoImgUploadWD);
                            if (widget) {
                                var attachid = widget.getValue().attach_id;
                                var url = FR.servletURL + ('?op=fr_attach&cmd=ah_image&id=' + attachid + '&isAdjust=false');
                                $('.fs-banner-preview-logo').attr('src', url);
                                $('td', widget.element).remove();
                            }
                        }
                    }]
                }
            ]
        },

        /**
         * 创建标题图片预览区
         * @private
         */
        _createBannerPreviewConfig: function () {
            var $preview = $('<div class="fs-banner-preview"/>');
            $('<img class="fs-banner-preview-logo"/>').appendTo($preview);
            $('<span class="fs-banner-preview-title"/>').text(FS.config.company).appendTo($preview);
            return [null, {}, $('<div class="fs-banner-preview-wrapper"/>').append($preview)]
        },

        _setBannerPreview: function (logoType) {
            var pane = FSCS.View.configPane;
            var $preview = $('.fs-banner-preview');
            switch (logoType) {
                case 1:
                    pane.getWidgetByName(FSCS._WD.styleConfigTablePaneWD).setRowVisible([2], false);
                    $('.fs-banner-preview-logo', $preview).hide();
                    $('.fs-banner-preview-title', $preview).show();
                    break;
                case 2:
                    pane.getWidgetByName(FSCS._WD.styleConfigTablePaneWD).setRowVisible([2], true);
                    $('.fs-banner-preview-logo', $preview).show();
                    $('.fs-banner-preview-title', $preview).show();
                    break;
                case 3:
                    pane.getWidgetByName(FSCS._WD.styleConfigTablePaneWD).setRowVisible([2], true);
                    $('.fs-banner-preview-logo', $preview).show();
                    $('.fs-banner-preview-title', $preview).hide();
                    break;
                default:
                    return false
            }
            return true;
        },

        /**
         * 背景类型设置类型
         * @private
         */
        _createBackgroundTypeConfig: function () {
            var self = this;
            return [
                null, {
                    type: 'llabel',
                    value: FR.i18nText("FS-Setting-Backgroung_Type")
                }, {
                    widgetName: FSCS._WD.configBackgroundTypeRadioGroupWD,
                    type: 'radiogroup',
                    assureSelect: true,
                    width: 180,
                    height: 21,
                    items: [
                        {
                            text: FR.i18nText("FS-Setting-Background_Image"),
                            value: 1
                        }, {
                            text: FR.i18nText("FS-Setting-Background_Color"),
                            value: 2
                        }
                    ],
                    listeners: [{
                        eventName: FR.Events.AFTEREDIT,
                        action: function () {
                            if (this.getValue() === 2) {
                                // 纯色
                                this.getWidgetByName(FSCS._WD.styleConfigTablePaneWD).setRowVisible([5, 6], false);
                                this.getWidgetByName(FSCS._WD.styleConfigTablePaneWD).setRowVisible([7], true);
                                if (self.selectedPureBg) {
                                    var c = self.selectedPureBg.data('COLOR');
                                    if (c.isCustom) {
                                        this.getWidgetByName(FSCS._WD.styleConfigTablePaneWD).setRowVisible([8], true);
                                    }
                                    self.selectedPureBg.click();
                                } else {
                                    self.pureBgs[0].click();
                                }
                                $('body').addClass('fs-style-pure');
                            } else {
                                // 图片
                                this.getWidgetByName(FSCS._WD.styleConfigTablePaneWD).setRowVisible([5, 6], true);
                                this.getWidgetByName(FSCS._WD.styleConfigTablePaneWD).setRowVisible([7, 8], false);
                                var background = $('.fs_csview_background').attr('src');
                                $('body').removeClass('fs-style-pure').css('background-image', 'url("' + background + '")');
                            }
                        }
                    }],
                    columnsInRow: 2
                }
            ]
        },

        /**
         * 自定义背景图片上传
         * @private
         */
        _createBackgroundImgUploadConfig: function () {
            var self = this;
            return [
                null, {}, {
                    type: 'multifile',
                    maxlength: 1,
                    widgetName: FSCS._WD.configBackgroundImgUploadWD,
                    accept: '.png.jpg',
                    height: 32,
                    width: 32,
                    tooltipText: FR.i18nText("FS-Setting-BG_Upload_ToolTip"),
                    hideFileList: true,
                    listeners: [{
                        eventName: "afteredit",
                        action: function () {
                            var widget = self.configPane.getWidgetByName(FSCS._WD.configBackgroundImgUploadWD);
                            if (widget) {
                                var value = widget.getValue(), attachid = value.attach_id;
                                var url = FR.servletURL + ('?op=fr_attach&cmd=ah_image&id=' + attachid + '&isAdjust=false');
                                if (value.filename.indexOf('.') != -1) {
                                    var type = value.filename.split('.').pop();
                                    var config = {
                                        url: FR.servletURL + '?op=fs_manager&cmd=blur_image',
                                        data: {
                                            type: type,
                                            attachId: attachid
                                        }
                                    }
                                    var completeFn = function () {
                                        $('.fs_csview_background').attr('src', url);
                                        $('body').css('background-image', 'url("' + url + '")');
                                        $('td', widget.element).remove();
                                    };
                                    FS.Async.ajax(config, completeFn());
                                } else {
                                    $('.fs_csview_background').attr('src', url);
                                    $('body').css('background-image', 'url("' + url + '")');
                                    $('td', widget.element).remove();
                                }
                            }
                        }
                    }]
                }
            ]
        },

        /**
         * 背景色配置
         * @private
         */
        _createBackgroundColorConfig: function () {
            var self = this;
            this.pureBgs = [];
            this.selectedPureBg = null;
            var $group = $('<div class="fs-color-bg-radio-group"/>');
            var bgs = [
                {
                    index: 0,
                    color: {r: 38, g: 77, b: 132},
                    schemeIndex: 0
                }, {
                    index: 1,
                    color: {r: 89, g: 98, b: 128},
                    schemeIndex: 1
                }, {
                    index: 2,
                    color: {r: 52, g: 68, b: 91},
                    schemeIndex: 2
                }, {
                    index: 3,
                    color: {r: 38, g: 167, b: 168},
                    schemeIndex: 3
                }, {
                    index: -1,
                    name: FR.i18nText('FS-Setting-Color_Custom'),
                    color: {r: 46, g: 46, b: 46},
                    isCustom: true
                }
            ];
            $.each(bgs, function (index, bg) {
                var color = FS.Tools.getCssColor(bg.color);
                var $item = $('<div class="fs-color-bg"/>')
                    .data('COLOR', bg)
                    .data('INDEX', bg.index)
                    .click(function () {
                        var c = $(this).data('COLOR');
                        var color = FS.Tools.getCssColor(c.color);
                        $('.fs-color-bg-select', $group).removeClass('fs-color-bg-select');
                        $(this).addClass('fs-color-bg-select');
                        self.selectedPureBg = $(this);
                        $('body').css('background', color);
                        if (c.isCustom) {
                            self.configPane.getWidgetByName(FSCS._WD.styleConfigTablePaneWD).setRowVisible([8], true);
                            self.configPane.getWidgetByName(FSCS._WD.colorPureBackgroundPicker).setValue(c.color);
                        } else {
                            self.configPane.getWidgetByName(FSCS._WD.styleConfigTablePaneWD).setRowVisible([8], false);
                        }
                        // 联动配色选取
                        if (!FR.isNull(bg.schemeIndex)) {
                            self.schemeRadios[bg.schemeIndex].setSelected(true);
                        }
                    })
                    .css('background-color', color)
                    .appendTo($group);
                if (bg.isCustom) {
                    $('<div class="fs-color-bg-custom-label"/>')
                        .append($('<span/>').text(bg.name))
                        .appendTo($item);
                    $item.addClass('custom');
                }
                self.pureBgs.push($item);
            });
            return [null, "&nbsp;", $group];
        },

        /**
         * 自定义背景色配置
         * @private
         */
        _createBackgroundColorPicker: function () {
            var self = this;
            return [null, {}, {
                widgetName: FSCS._WD.colorPureBackgroundPicker,
                type: 'fscolorpicker',
                width: 300,
                onColorPick: function () {
                    var color = this.getText();
                    if (self.selectedPureBg) {
                        self.selectedPureBg.css('background', color);
                        var bgc = self.selectedPureBg.data('COLOR');
                        bgc.color = this.getValue();
                        $('body').css('background', color);
                    }
                }
            }]
        },

        /**
         * 配色设置
         * @private
         */
        _createColorSchemeConfig: function () {
            var self = this;
            var $group = $('<div class="fs-color-scheme-radio-group"/>');
            this.schemeRadios = [];
            this.selectedSchemeRadio = null;
            //tint, highlight, background, font
            var schemes = [
                {
                    index: 0,
                    name: FR.i18nText('FS-Setting-Preset_Theme_1'),
                    colors: FSCS._Constants.colorSchemes[0]
                }, {
                    index: 1,
                    name: FR.i18nText('FS-Setting-Preset_Theme_2'),
                    colors: FSCS._Constants.colorSchemes[1]
                }, {
                    index: 2,
                    name: FR.i18nText('FS-Setting-Preset_Theme_3'),
                    colors: FSCS._Constants.colorSchemes[2]
                }, {
                    index: 3,
                    name: FR.i18nText('FS-Setting-Preset_Theme_4'),
                    colors: FSCS._Constants.colorSchemes[3]
                }, {
                    index: -1,
                    name: FR.i18nText('FS-Setting-Color_Custom'),
                    colors: FSCS._Constants.defaultCustomColors,
                    selectable: true,
                    onColorSelected: function (color) {
                        self.configPane.getWidgetByName(FSCS._WD.styleConfigTablePaneWD).setRowVisible([10], true);
                        self.configPane.getWidgetByName(FSCS._WD.colorSchemeColorPicker).setValue(color);
                    }
                }
            ];
            var beforeSelect = function (select) {
                var o = this.options;
                // 保持选中
                if (!select && self.selectedSchemeRadio === this) {
                    return true;
                }
                if (select === true) {
                    var prev = self.selectedSchemeRadio;
                    self.selectedSchemeRadio = this;
                    if (prev) {
                        prev.setSelected(false);
                    }
                }
                // 隐藏取色器
                if (!o.selectable) {
                    self.configPane.getWidgetByName(FSCS._WD.styleConfigTablePaneWD).setRowVisible([10], false);
                    if (select && !FR.isNull(o.bgIndex)) {
                        var $bg = self.pureBgs[o.bgIndex];
                        $bg && $bg.click();
                    }
                }
                self._applySelectedScheme();
                return false;
            };
            $.each(schemes, function (i, scheme) {
                self.schemeRadios.push(new FS.ColorSchemeRadio({
                    renderEl: $("<div/>").appendTo($group),
                    type: 'colorschemeradio',
                    index: scheme.index,
                    text: scheme.name,
                    selected: false,
                    height: 55,
                    width: 160,
                    left: i % 4 === 0 ? 0 : 20,
                    colorScheme: scheme.colors,
                    colorSelectable: scheme.selectable,
                    bgIndex: scheme.bgIndex,
                    beforeSelect: beforeSelect,
                    onColorSelected: scheme.onColorSelected
                }));
            });
            return [
                null, FR.i18nText("FS-Setting-Color_Scheme"), $group
            ]
        },

        _applySelectedScheme: function () {
            if (this.selectedSchemeRadio) {
                var colors = this.selectedSchemeRadio.getColorScheme();
                FS.importThemeStyle({
                    tint: colors[0],
                    highlight: colors[1],
                    background: colors[2],
                    font: colors[3]
                });
            }
        },

        /**
         * 自定义配色设置
         * @private
         */
        _createColorSchemePicker: function () {
            var self = this;
            return [null, {}, {
                widgetName: FSCS._WD.colorSchemeColorPicker,
                type: 'fscolorpicker',
                width: 300,
                onColorPick: function () {
                    var color = this.getValue();
                    self.selectedSchemeRadio.setSelectedColor(color);
                    self._applySelectedScheme();
                }
            }]
        },

        /**
         * 修改目录图标设置开关
         * @private
         */
        _createEditIconConfig: function () {
            var self = this;
            var $iconEditor = $('<div class="fs-icon-editor"/>');
            this.$icons = $('<div class="fs-icon-select-wrapper"/>').appendTo($iconEditor);
            var $folderWrapper = $('<div class="fs-icon-folder-wrapper"/>').insertBefore(this.$icons);
            this.$folders = $('<ul class="folder-group"/>').appendTo($folderWrapper);

            // 加上可选图标
            $.each(FSCS._Constants.folderIcons, function (i, icon) {
                self.addIconItem({
                    text: icon,
                    onSelect: function ($icon) {
                        $.each(FS.Plugin.CustomIcon, function (index, item) {
                            if($.isFunction(item.removePreCustomIconSelected)) {
                                item.removePreCustomIconSelected(self.$folders);
                            }
                        });
                        $('.fs-icon-folder-item.selected .folder-icon', self.$folders)
                            .html($('.icon-item', $icon).html())
                    }
                })
            });
            $.each(FS.Plugin.CustomIcon, function (index, item) {
                if($.isFunction(item.addCustomIconItem)) {
                    item.addCustomIconItem(self);
                }
            });
            return [
                null, FR.i18nText("FS-Setting-Edit_Directory_Icon"), $iconEditor
            ]
        },

        /**
         * 添加图标选择区的目录项
         */
        addFolderItem: function (folder) {
            var self = this;
            var $folder = $('<li class="fs-icon-folder-item"/>').click(function () {
                self.selectFolderItem($(this));
            });
            if (folder.value.length < 5) {
                $('<i class="folder-icon"/>').html(folder.value).appendTo($folder);
            }else{
                $.each(FS.Plugin.CustomIcon, function (index, item) {
                    if($.isFunction(item.addItem2FolderNodes)) {
                        item.addItem2FolderNodes(folder, $folder);
                    }
                });
            }
            $('<span class="folder-title"/>').text(folder.text).appendTo($folder);
            $folder.data('ENTRY', folder);
            $folder.appendTo(this.$folders);
        },

        selectFolderItem: function ($folder) {
            if ($folder.hasClass('selected')) {
                return;
            }
            if (this.$selectedFolder) {
                this.$selectedFolder.removeClass('selected');
            }
            this.$selectedFolder = $folder;
            $folder.addClass('selected');
            FR.applyFunc(this, $folder.data('ENTRY').onSelect, [$folder], false);
        },

        addIconItem: function (icon) {
            var self = this;
            var $icon = $('<div class="fs-icon-item"/>').hover(function () {
                $(this).addClass('icon-hover');
            }, function () {
                if (!$(this).hasClass('selected')) {
                    $(this).removeClass('icon-hover');
                }
            }).click(function () {
                self.selectIconItem($(this));
            });
            $('<i class="icon-item"/>').html(icon.text).appendTo($icon);
            $icon.data('ENTRY', icon);
            $icon.appendTo(this.$icons);
        },

        selectIconItem: function ($icon) {
            if ($icon.hasClass('selected')) {
                return;
            }
            if (this.$selectedIcon) {
                this.$selectedIcon.removeClass('icon-hover selected');
                this.$selectedIcon.children('.selected-mark').remove();
            }
            this.$selectedIcon = $icon;
            $('<div class="selected-mark"/>').appendTo(this.$selectedIcon);
            $icon.addClass('icon-hover selected');
            FR.applyFunc(this, $icon.data('ENTRY').onSelect, [$icon], false);
        }
    },

    /**
     * 缓存
     */
    Cache: {
        /**
         * 缓存首页部门角色数据
         */
        saveHomePageDepartmentCache: function () {
            var self = this;
            var homepageId = FSCS.View.configPane.getWidgetByName(FSCS._WD.configCustomHomePageListWD).getValue();
            if (!homepageId) {
                return;
            }
            if (homepageId) {
                self.setHomePageCache(homepageId, FSCS.View.configPane.getWidgetByName(FSCS._WD.configDepartmentTableTreeWD).getAllSelectedLeafNodes(), true);
            }
        },

        /**
         * 缓存首页自定义角色数据
         */
        saveHomePageCustomRoleCache: function () {
            var self = this;
            var homepageId = FSCS.View.configPane.getWidgetByName(FSCS._WD.configCustomHomePageListWD).getValue();
            if (!homepageId) {
                return;
            }
            if (homepageId) {
                var positionAndCustomRoleTab = FSCS.View.configPane.getWidgetByName(FSCS._WD.configHomePagePosAndCRoleInsideTabWD);
                var customRoleList = positionAndCustomRoleTab.getWidgetByName(FSCS._WD.configCustomRoleListWD);
                self.setHomePageCache(homepageId, customRoleList.getValue(), false);
            }
        },

        /**
         * 获取首页权限配置缓存
         */
        getHomePageCache: function () {
            var self = this;
            if (!self.homePageCache) {
                self.homePageCache = {};
            }
            return self.homePageCache;
        },

        /**
         * 获取首页原始权限配置缓存
         */
        getOriginalHomePageCache: function () {
            var self = this;
            if (!self.originalHomePageCache) {
                self.originalHomePageCache = {};
            }
            return self.originalHomePageCache;
        },

        /**
         * 删除首页缓存
         * @param homepageId    首页ID
         */
        deleteHomePageCache: function (homepageId) {
            var self = this;
            if (homepageId) {
                delete self.homePageCache[homepageId];
                delete self.originalHomePageCache[homepageId];
            }
        },

        /**
         * 清楚首页缓存
         */
        clearHomePageCache: function () {
            var self = this;
            self.homePageCache = {};
            self.originalHomePageCache = {};
        },

        /**
         * 处理首页配置缓存角色数据
         * @param roles 角色
         */
        processHomePageCache: function (roles) {
            var homePageCache = [];
            for (var i = 0, len = roles.length; i < len; i++) {
                var item = {};
                item.id = roles[i].id;
                item.view = roles[i].view;
                homePageCache.push(item);
            }
            return homePageCache;
        },

        /**
         * 设置首页配置缓存
         * @param homepageId    首页ID
         * @param roles         角色
         * @param isCompanyRole 是否为部门职位信息
         */
        setHomePageCache: function (homepageId, roles, isCompanyRole) {
            var self = this;
            homepageId = homepageId + "";
            if (!self.getHomePageCache()[homepageId]) {
                self.getHomePageCache()[homepageId] = {};
            }
            if (isCompanyRole) {
                //职位部门
                self.getHomePageCache()[homepageId]["companyRole"] = self.processHomePageCache(roles);
            } else {
                //自定义角色
                self.getHomePageCache()[homepageId]['customRole'] = self.processHomePageCache(roles);
            }
        },

        /**
         * 前台保存原始首页配置缓存
         * @param homepageId    首页ID
         * @param roles         角色
         * @param isCompanyRole 是否为部门职位信息
         */
        keepOriginalHomePageCache: function (homepageId, roles, isCompanyRole) {
            var self = this;
            if (!self.originalHomePageCache) {
                self.originalHomePageCache = {};
            }
            if (!self.originalHomePageCache[homepageId]) {
                self.originalHomePageCache[homepageId] = {};
            }
            if (isCompanyRole) {
                if (!self.originalHomePageCache[homepageId]["companyRole"]) {
                    self.setHomePageCache(homepageId, roles, true);
                    self.originalHomePageCache[homepageId]["companyRole"] = FR.clone(roles);
                }
            } else {
                if (!self.originalHomePageCache[homepageId]["customRole"]) {
                    self.setHomePageCache(homepageId, roles, false);
                    self.originalHomePageCache[homepageId]["customRole"] = FR.clone(roles);
                }
            }
        },

        /**
         * 更新原始首页权限缓存
         * @param homepageCache 首页权限缓存
         */
        refreshOriginalHomePageCache: function (homepageCache) {
            this.originalHomePageCache = homepageCache;
        },

        /**
         * 获取首页URL缓存
         */
        getHomePageUrlCache: function () {
            var self = this;
            if (!self.homePageUrlCache) {
                self.homePageUrlCache = {};
            }
            return self.homePageUrlCache;
        },

        /**
         * 删除首页的URL缓存
         * @param homepageId
         */
        deleteHomePageUrlCache: function (homepageId) {
            var self = this;
            if (homepageId) {
                delete self.homePageUrlCache[homepageId];
                delete self.originalHomePageUrlCache[homepageId];
            }
        },

        /**
         * 清空首页URL缓存
         */
        clearHomePageUrlCache: function () {
            var self = this;
            self.homePageUrlCache = {};
            self.originalHomePageUrlCache = {};
        },

        /**
         * 保存首页URL缓存
         * @param homepageId 首页ID
         * @param url        首页URL
         */
        setHomePageUrlCache: function (homepageId, url) {
            var self = this;
            self.getHomePageUrlCache()[homepageId] = url;
        },

        /**
         * 前台保存原始首页URL
         * @param homepageId 首页ID
         * @param url        首页URL
         */
        keepOriginalHomePageUrlCache: function (homepageId, url) {
            var self = this;
            if (!self.originalHomePageUrlCache) {
                self.originalHomePageUrlCache = {};
            }
            if (!self.originalHomePageUrlCache[homepageId]) {
                self.setHomePageUrlCache(homepageId, url);
                self.originalHomePageUrlCache[homepageId] = url;
            }
        },

        /**
         * 获取原始首页URL缓存
         * @returns {{}|*}
         */
        getOriginalHomePageUrlCache: function () {
            var self = this;
            if (!self.originalHomePageUrlCache) {
                self.originalHomePageUrlCache = {};
            }
            return self.originalHomePageUrlCache;
        },

        /**
         * 更新原始首页URL缓存
         * @param homepageURLCache 首页URL缓存
         */
        refreshOriginalHomePageUrlCache: function (homepageURLCache) {
            this.originalHomePageUrlCache = homepageURLCache;
        },

        /**
         * 清空缓存
         */
        clearCache: function () {
            var self = this;
            self.clearHomePageCache();
            self.clearHomePageUrlCache();
        }
    },

    /**
     * 控制
     */
    Control: {
        initData: function () {
            var self = this;
            self.data = FS.Sync.ajax({
                url: FR.servletURL + '?op=fs_manager&cmd=fs_get_titleinfo',
                type: 'POST'
            });
        },

        /**
         * 配置登录页设置标签数据
         */
        popLoginPageData: function (tabPane) {
            var attr = this.data;
            if (attr.isloginimg === true || attr.loginurl == null) {
                tabPane.getWidgetByName(FSCS._WD.configLoginPageTypeRadioGroupWD).setValue(1, true);
            } else {
                tabPane.getWidgetByName(FSCS._WD.configLoginPageTypeRadioGroupWD).setValue(2, true);
                tabPane.getWidgetByName(FSCS._WD.configLoginPageUrlTextWD).setValue(attr.loginurl, true);
            }
            // 登录页背景
            var url = FR.servletURL + (attr.loginimg && attr.loginimg != 'null' ?
                    '?op=fr_attach&cmd=ah_image&id=' + attr.loginimg + '&isAdjust=false' :
                        '?op=resource&resource=/com/fr/fs/resources/images/oem/signin.jpg'
                );
            $('.fs_csview_loginimg').attr('src', url);
        },

        /**
         * 创建登陆风格div
         */
        _createLoginStyleDiv: function (tabPane) {
            var $login_style_div = $('.fs_login_style');
            $('<span/>').text("123").appendTo($login_style_div);
            return $login_style_div;
        },

        /**
         * 配置首页设置标签数据
         */
        popHomePageData: function (tabPane) {
            //初始化缓存
            var cache = FSCS.Cache;
            cache.clearCache();
        },

        /**
         * 初始化主题选择页数据
         */
        popThemeConfigData: function (tabPane) {
            var themes = [
                {
                    isCustom: false,
                    name: 'default',
                    text: 'Classic',
                    cover: '/com/fr/fs/resources/images/theme/cover_fr.jpg'
                }, {
                    isCustom: false,
                    name: 'bi',
                    text: 'modern',
                    cover: '/com/fr/fs/resources/images/theme/cover_bi.jpg'
                }
            ];
            $.each(themes, function (index, theme) {
                FSCS.View.addThemeCard(theme);
            });
            FS.Async.getCustomThemeList(function (res, status) {
                if (status === 'success') {
                    var list = FR.jsonDecode(res.responseText);
                    $.each(list, function (index, theme) {
                        FSCS.View.addThemeCard(theme);
                    });
                }
            });

        },

        /**
         * 初始化样式配置标签页数据
         */
        popStyleConfigData: function (tabPane) {
            var attr = this.data;
            tabPane.getWidgetByName(FSCS._WD.configPlatformTitleTextWD).setValue(attr.logintitle, true);
            tabPane.getWidgetByName(FSCS._WD.configLogoTypeRadioGroupWD).setValue(attr.logoType, true);
            // Logo图片
            var url = FR.servletURL + (attr.logoImg ?
                    '?op=fr_attach&cmd=ah_image&id=' + attr.logoImg + '&isAdjust=false' :
                        '?op=resource&resource=/com/fr/fs/resources/images/logo.png'
                );
            $('.fs-banner-preview .fs-banner-preview-logo').attr('src', url);
            // 平台背景
            url = FR.servletURL + (attr.backgroundImg ?
                    '?op=fr_attach&cmd=ah_image&id=' + attr.backgroundImg + '&isAdjust=false' :
                        '?op=resource&resource=/com/fr/fs/resources/images/fsbg.jpg'
                );
            $('.fs_csview_background').attr('src', url).removeAttr('style');
            var bgs = FSCS.View.pureBgs;

            var $customBg = bgs[bgs.length - 1];
            if (attr.customBackgroundColor) {
                $customBg.css('background', attr.customBackgroundColor);
                $customBg.data('COLOR').color = FS.Tools.getColor(attr.customBackgroundColor);
            }
            if (attr.isBackgroundImg === true) {
                tabPane.getWidgetByName(FSCS._WD.configBackgroundTypeRadioGroupWD).setValue(1, false);
                tabPane.getWidgetByName(FSCS._WD.styleConfigTablePaneWD).setRowVisible([7, 8], false);
            } else {
                tabPane.getWidgetByName(FSCS._WD.configBackgroundTypeRadioGroupWD).setValue(2, true);
                var selectedBg = attr.backgroundColor < 0 ? bgs.length - 1 : attr.backgroundColor;
                bgs[selectedBg].click();
            }

            //配色
            var radios = FSCS.View.schemeRadios;
            if (attr.customColors.length !== 0) {
                var scheme = [];
                $.each(attr.customColors, function (i, cssColor) {
                    var color = FS.Tools.getColor(cssColor);
                    scheme.push(color);
                });
                radios[radios.length - 1].setColorScheme(scheme);
            }
            var selectedScheme = attr.colorScheme < 0 ? radios.length - 1 : attr.colorScheme;
            radios[selectedScheme].setSelected(true);

            //目录图标
            var iconWrapperHeight = attr.icons.length * 32 + 20;
            iconWrapperHeight = iconWrapperHeight > 400 ? iconWrapperHeight : 400;
            $(".fs-icon-folder-wrapper").height(iconWrapperHeight);
            var onFolderSelected = function ($folder) {
                var idx = $.inArray(
                    $('.folder-icon', $folder).html(), FSCS._Constants.folderIcons);
                if (idx >= 0) {
                    FSCS.View.selectIconItem(FSCS.View.$icons.children().eq(idx));
                }else{
                    if (FS.Plugin.CustomIcon.length > 0) {
                        $.each(FS.Plugin.CustomIcon, function (index, item) {
                            if($.isFunction(item.initSelectedCustomIcon)) {
                                item.initSelectedCustomIcon($folder);
                            }
                        });
                    }
                    else{
                        FSCS.View.selectIconItem(FSCS.View.$icons.children().eq(0));
                    }
                }
            };
            $.each(attr.icons, function (i, folderIcon) {
                // 后台如果直接传递unicode，前台解码会出现偏移
                if (folderIcon.value.length < 5){
                    //大于4说明不是unicode，自定义的图标
                    folderIcon.value = String.fromCharCode(parseInt(folderIcon.value, 16));
                }
                folderIcon.onSelect = onFolderSelected;
                FSCS.View.addFolderItem(folderIcon);
            });
            if (attr.icons && attr.icons.length > 0) {
                FSCS.View.selectFolderItem(FSCS.View.$folders.children().eq(0));
            }
        },

        /**
         * 判断部门职位项目是否重复
         * @param id     职位Id
         * @param result 当前部门职位列表集
         * @private
         */
        _alreadyExists: function (id, result) {
            for (var i = 0; i < result.length; i++) {
                if (result[i].id === id) {
                    return true;
                }
            }
            return false;
        },

        /**
         * 保存登录页配置数据
         */
        saveLoginPageData: function () {
            var view = FSCS.View;
            var configPane = view.configPane;
            var jo = {};
            if (view.inUseId !== view.changeUseId) {
                //相等表示不需要切换
                jo.inUseId = view.inUseId;
                jo.changeUseId = view.changeUseId;
            }
            var isLoginImg = (configPane.getWidgetByName(FSCS._WD.configLoginPageTypeRadioGroupWD).getValue() === 1);
            jo.isLoginImg = isLoginImg;
            if (isLoginImg) {
                var loginPageAttach = configPane.getWidgetByName(FSCS._WD.configLoginPageImgUploadWD).getValue();
                if (loginPageAttach && loginPageAttach.attach_id) {
                    jo.loginImgId = loginPageAttach.attach_id;
                }
            } else {
                var loginUrl = configPane.getWidgetByName(FSCS._WD.configLoginPageUrlTextWD).getValue();
                if (loginUrl) {
                    jo.loginUrl = loginUrl;
                }
            }
            var completeFn = function (res, status) {
                if (status === 'success') {
                    var info = FR.jsonDecode(res.responseText).info;
                    if(info == undefined) {
                        FR.Msg.toast(FR.i18nText("FS-Generic-Simple_Successfully"));
                    } else {
                        showRestartDialog(FR.i18nText("FS-CustomStyle_Toast_Prompt"), info);
                        view.inUseId = view.changeUseId;
                    }
                }
            };
            var config = {
                url: FR.servletURL + '?op=fs_manager&cmd=fs_set_login_page',
                type: 'POST',
                data: jo
            };
            FS.Async.ajax(config, completeFn);
        },

        /**
         * 保存首页数据
         * @param homepage
         */
        saveHomePage: function (homepage) {
            var result = null;
            var result = FS.Sync.ajax({
                url: FR.servletURL + '?op=fs_manager&cmd=fs_set_homepage',
                type: 'POST',
                data: {
                    homepage: homepage
                }
            })

            var success = result.success;
            if (success != null && success === false) {
                FR.Msg.toast(FR.i18nText("FS-Generic-Simple_Failed"));
            } else {
                FR.Msg.toast(FR.i18nText("FS-Generic-Simple_Successfully"));
            }
            return result;
        },

        /**
         * 首页权限比较方法
         * @param a
         * @param b
         * @returns {number}
         */
        compareHomePage: function (a, b) {
            var aid = a.id, bid = b.id;
            var r = aid - bid;
            if (r === 0) {
                var a_view = (a.view ? a.view : 0), b_view = (b.view ? b.view : 0);
                return a_view - b_view;
            } else {
                return r;
            }
        },

        /**
         * 检查权限数组
         * @param baseArray
         * @param newArray
         * @returns {{}}
         */
        checkPrivilegeArray: function (baseArray, newArray) {
            var self = this;
            var result = {};
            if (baseArray && newArray) {
                var add = result.add = [];
                var remove = result.remove = [];
                var comparatorFn = self.compareHomePage;
                baseArray = baseArray.sort(comparatorFn);
                newArray = newArray.sort(comparatorFn);

                var bi = 0, ni = 0;
                var cr = 0;
                for (; bi < baseArray.length && ni < newArray.length; bi++) {
                    cr = comparatorFn.call(this, baseArray[bi], newArray[ni]);
                    while (cr > 0) {
                        add[add.length] = newArray[ni];
                        ni++;
                        if (ni >= newArray.length) {
                            break;
                        }
                        cr = comparatorFn.call(this, baseArray[bi], newArray[ni]);
                    }
                    if (ni >= newArray.length) {
                        break;
                    }
                    if (cr === 0) {
                        ni++;
                    } else {
                        remove[remove.length] = baseArray[bi];
                    }
                }
                for (; bi < baseArray.length; bi++) {
                    remove[remove.length] = baseArray[bi];
                }
                for (; ni < newArray.length; ni++) {
                    add[add.length] = newArray[ni];
                }
                // 检验
                if ((add.length - remove.length) != (newArray.length - baseArray.length)) {
                    throw "checkPrivilegeArray error!";
                }
            }
            return result;
        },

        /**
         * 保存首页权限数据
         * @returns {boolean} 是否保存成功
         */
        saveHomePagePrivileges: function () {
            var self = this;
            var homepagePrivileges = FSCS.Cache.getHomePageCache();
            var originalHomepagePrivileges = FSCS.Cache.getOriginalHomePageCache();
            var homepagePrivilegeChanges = {
                "companyRole": [],
                "customRole": []
            };

            var getPrivilegeJSON = function (addEntry, removeEntry, roleId, isCompanyRole) {
                if (!addEntry && !removeEntry || !roleId) {
                    return null;
                }
                var result = {
                    homepages: {
                        add: addEntry ? [addEntry] : [],
                        remove: removeEntry ? [removeEntry] : []
                    }
                };
                if (isCompanyRole) {
                    if (roleId.indexOf(FSCS._Constants.configPostIdPrefix) >= 0) {
                        //部门角色
                        var departAndPostId = roleId.split(FSCS._Constants.configPostIdPrefix);
                        result.departmentId = departAndPostId[0];
                        if (departAndPostId[1]) {
                            result.postId = departAndPostId[1];
                        }
                    } else {
                        result.departmentId = roleId;
                    }
                } else {
                    result.roleId = roleId;
                }
                return result;
            };

            var dealWithRoleChanges = function (key, originalRoles, newRoles, roleType) {
                var role = self.checkPrivilegeArray(
                    originalRoles[roleType], newRoles[roleType]
                );
                var addHomePageDict = {};
                if (role.add && role.add.length > 0) {
                    for (var m = 0, len = role.add.length; m < len; m++) {
                        var addHomePage = {
                            "id": key.substr(0)
                        };
                        addHomePage.view = role.add[m].view;
                        addHomePageDict[role.add[m].id] = addHomePage;
                    }
                }
                var removeHomePageDict = {};
                if (role.remove && role.remove.length > 0) {
                    for (var m = 0, len = role.remove.length; m < len; m++) {
                        var removeHomePage = {
                            "id": key.substr(0)
                        };
                        removeHomePage.view = role.remove[m].view;
                        removeHomePageDict[role.remove[m].id] = removeHomePage;
                    }
                }
                var isCompanyRole = roleType == "companyRole";
                $.each(addHomePageDict, function (id, addHomePage) {
                    var removeHomePage = null;
                    if (addHomePageDict.hasOwnProperty(id)) {
                        removeHomePage = removeHomePageDict[id];
                        delete removeHomePageDict[id];
                    }
                    var RoleChange = getPrivilegeJSON(addHomePage, removeHomePage, id, isCompanyRole);
                    if (RoleChange) {
                        homepagePrivilegeChanges[roleType].push(RoleChange);
                    }
                });
                $.each(removeHomePageDict, function (id, removeHomePage) {
                    var RoleChange = getPrivilegeJSON(null, removeHomePage, id, isCompanyRole);
                    if (RoleChange) {
                        homepagePrivilegeChanges[roleType].push(RoleChange);
                    }
                });
            };

            $.each(originalHomepagePrivileges, function (key, value) {
                var originalRoles = value;
                var newRoles = homepagePrivileges[key];
                dealWithRoleChanges(key, originalRoles, newRoles, "companyRole");
                dealWithRoleChanges(key, originalRoles, newRoles, "customRole");
            });

            //保存首页权限数据
            var result = FR.jsonDecode(FS.Trans.ajax({
                returnString: true,
                url: FR.servletURL + '?op=fs_manager&cmd=fs_set_homepage_roles',
                data: homepagePrivilegeChanges
            }));
            if (result.success != null && result.success === false) {
                return false;
            } else {
                FSCS.Cache.refreshOriginalHomePageCache(FR.clone(homepagePrivileges));
                return true;
            }
        },

        /**
         * 保存首页URL
         * @returns {boolean} 是否保存成功
         */
        saveHomePageURLs: function () {
            //缓存下当前选中的首页URL
            if (FSCS.View.previousId != null) {
                var prevUrl = {
                    pcUrl: FSCS.View.configPane.getWidgetByName(FSCS._WD.configHomePageUrlTextWD4PC).getText(),
                    padUrl: FSCS.View.configPane.getWidgetByName(FSCS._WD.configHomePageUrlTextWD4Pad).getText(),
                    phoneUrl: FSCS.View.configPane.getWidgetByName(FSCS._WD.configHomePageUrlTextWD4Phone).getText()
                }
                FSCS.Cache.setHomePageUrlCache(FSCS.View.previousId, prevUrl)
            }

            var homePageURLs = FSCS.Cache.getHomePageUrlCache();
            var originalHomePageURLs = FSCS.Cache.getOriginalHomePageUrlCache();
            var homepageUrlChanges = {};

            //比较首页URL变更
            $.each(originalHomePageURLs, function (id, originalURL) {
                var newURL = homePageURLs[id];
                if (newURL !== originalURL) {
                    homepageUrlChanges[id] = newURL;
                }
            });

            //保存首页URL数据
            var result = FR.jsonDecode(FS.Trans.ajax({
                returnString: true,
                url: FR.servletURL + '?op=fs_manager&cmd=fs_set_homepage_url',
                data: {
                    UrlList: homepageUrlChanges
                }
            }));
            if (result.success != null && result.success === false) {
                return false;
            } else {
                FSCS.Cache.refreshOriginalHomePageUrlCache(FR.clone(homePageURLs));
                return true;
            }
        },

        /**
         * 保存首页数据
         */
        saveHomePageData: function () {
            var self = this;
            var privilegeResult = self.saveHomePagePrivileges();
            var urlResult = self.saveHomePageURLs();
            if (privilegeResult && urlResult) {
                FR.Msg.toast(FR.i18nText("FS-Generic-Simple_Successfully"));
            } else if (!privilegeResult) {
                FR.Msg.toast(FR.i18nText("FS-Privilege-Already_Set"));
            } else {
                FR.Msg.toast(FR.i18nText("FS-Generic-Simple_Failed"));
            }
        },

        /**
         * 保存样式配置数据
         */
        saveStyleConfigData: function () {
            var view = FSCS.View;
            var pane = view.configPane;
            var jo = {};
            // 标题
            jo.loginTitle = pane.getWidgetByName(FSCS._WD.configPlatformTitleTextWD).getValue();
            // Logo 设置
            jo.logoType = pane.getWidgetByName(FSCS._WD.configLogoTypeRadioGroupWD).getValue();
            if (jo.logoType > 1) {
                var logoAttach = pane.getWidgetByName(FSCS._WD.configLogoImgUploadWD).getValue();
                if (logoAttach && logoAttach.attach_id) {
                    jo.logoImgId = logoAttach.attach_id;
                }
            }
            // 背景
            jo.isBackgroundImg = pane.getWidgetByName(FSCS._WD.configBackgroundTypeRadioGroupWD).getValue() === 1;
            if (!jo.isBackgroundImg) {
                jo.backgroundColor = FSCS.View.selectedPureBg.data('INDEX');
            }
            var bgs = FSCS.View.pureBgs;
            jo.customBackgroundColor = FS.Tools.getCssColor(bgs[bgs.length - 1].data('COLOR').color);
            var backgroundAttach = pane.getWidgetByName(FSCS._WD.configBackgroundImgUploadWD).getValue();
            if (backgroundAttach && backgroundAttach.attach_id) {
                jo.backgroundImg = backgroundAttach.attach_id;
            }
            //配色
            jo.colorScheme = FSCS.View.selectedSchemeRadio.getIndex();
            var radios = FSCS.View.schemeRadios;
            jo.customColors = radios[radios.length - 1].getColorScheme();
            // 图标
            var folderIcons = {};
            $.each(FSCS.View.$folders.children(), function (i, folder) {
                var folderIcon = $(folder).data('ENTRY');
                // 取 unicode 十六进制
                var id = $('.folder-icon', $(folder)).html().charCodeAt(0).toString(16);
                if (id === "NaN"){
                    //为空的时候就找一下自定义的img
                    $.each(FS.Plugin.CustomIcon, function (index, item) {
                        if($.isFunction(item.getCustomIconAttachID)) {
                            id = item.getCustomIconAttachID(folder);
                        }
                    });
                }
                folderIcons[folderIcon.id] = id;
            });
            jo.folderIcons = folderIcons;
            var completeFn = function (res, status) {
                if (status === 'success') {
                    FR.Msg.toast(FR.i18nText("FS-Generic-Simple_Successfully"));
                }
            };
            var config = {
                url: FR.servletURL + '?op=fs_manager&cmd=fs_set_style',
                type: 'POST',
                data: jo
            };
            FS.Async.ajax(config, completeFn);
        }
    }
};

showRestartDialog = function (title, content2show) {
    var content;
    if (typeof content2show === 'string') {
        content = content2show;
    }
    var dlg = new FR.Dialog({
        title : title,
        height : 155,
        width: 320,
        widgetName: 'customdialog',
        contentWidget: {
            type: 'absolute',
            items: [
                {
                    el: $('<div>'+content+'</div>').css({
                        'width': '100%',
                        'top': 35,
                        'font-size': '14px',
                        'text-align': 'center',
                        'position': 'absolute'
                    })
                },
                {
                    type: 'quickbutton',
                    text: FR.i18nText("FS-CutomStyle_Toast_OK"),
                    width: 60,
                    height: 30,
                    x: 130,
                    y: 75,
                    handler : function () {
                        dlg.getWidgetByName('customdialog').doClose();
                    }
                }
            ]
        }
    });
    dlg.setVisible(true);
};