/*     */ package ideabank.sap;
/*     */ 
/*     */ import java.io.BufferedReader;
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.PrintStream;
/*     */ import java.io.PrintWriter;
/*     */ import java.net.HttpURLConnection;
/*     */ import java.net.URL;
/*     */ import javax.net.ssl.HostnameVerifier;
/*     */ import javax.net.ssl.HttpsURLConnection;
/*     */ import javax.net.ssl.SSLContext;
/*     */ import javax.net.ssl.SSLSession;
/*     */ import javax.net.ssl.TrustManager;
/*     */ import javax.servlet.http.Cookie;
/*     */ import javax.servlet.http.HttpServletRequest;
/*     */ import javax.servlet.http.HttpServletResponse;
/*     */ 
/*     */ public class IAccount
/*     */ {
/*     */   private UserBean userbean;
/*     */   private String AAAAServer;
/*     */   private String LoginServer;
/*     */   private String ApplyID;
/*     */   private String ApplyKey;
/*     */   private String WorkPath;
/*  32 */   private HostnameVerifier hv = new HostnameVerifier() {
/*     */     public boolean verify(String urlHostName, SSLSession session) {
/*  34 */       return true;
/*     */     }
/*  32 */   };
/*     */   private HttpServletRequest request;
/*     */   private HttpServletResponse response;
/*     */ 
/*     */   public IAccount(HttpServletRequest request, HttpServletResponse response)
/*     */   {
/*  47 */     this.request = request;
/*  48 */     this.response = response;
/*     */ 
/*  50 */     trustAllHttpsCertificates();
/*  51 */     HttpsURLConnection.setDefaultHostnameVerifier(this.hv);
/*     */   }
/*     */ 
/*     */   public void SetManager(String AAAAServer, String LoginServer, String ApplyID, String ApplyKey, String WorkPath)
/*     */   {
/*  66 */     this.AAAAServer = AAAAServer;
/*  67 */     this.ApplyID = ApplyID;
/*  68 */     this.ApplyKey = ApplyKey;
/*  69 */     this.LoginServer = LoginServer;
/*  70 */     this.WorkPath = WorkPath;
/*     */   }
/*     */ 
/*     */   public boolean CheckCertLogin()
/*     */     throws Exception
/*     */   {
/*  81 */     String TrusDataID = this.request.getParameter("TrusDataID");
/*  82 */     String TrusDataTicket = this.request.getParameter("TrusDataTicket");
/*     */ 
/*  84 */     if ((TrusDataID != null) && (TrusDataTicket != null))
/*     */     {
/*  86 */       Cookie cTrusDataID = new Cookie("TrusDataID", TrusDataID);
/*  87 */       Cookie cTrusDataTicket = new Cookie("TrusDataTicket", TrusDataTicket);
/*  88 */       this.response.addCookie(cTrusDataID);
/*  89 */       this.response.addCookie(cTrusDataTicket);
//String url =getUrlNow(false);

/*  91 */       this.response.sendRedirect(getUrlNow(false));
/*     */     }
/*     */     else
/*     */     {
/*  95 */       Cookie[] cookies = this.request.getCookies();
/*  96 */       if (cookies != null)
/*     */       {
/*  98 */         for (int i = 0; i < cookies.length; i++)
/*     */         {
/* 100 */           Cookie c = cookies[i];
/* 101 */           if ("TrusDataID".equals(c.getName()))
/*     */           {
/* 103 */             TrusDataID = c.getValue();
/* 104 */           } else if ("TrusDataTicket".equals(c.getName()))
/*     */           {
/* 106 */             TrusDataTicket = c.getValue();
/*     */           }
/*     */         }
/* 109 */         String temp = "https://" + this.AAAAServer + "/login.aaaauth?operation=sso&trusdataid=" + TrusDataID + "&appid=" + this.ApplyID + "&summary=" + Tools.EncoderByMd5(new StringBuffer(String.valueOf(TrusDataTicket)).append(this.ApplyKey).toString());
/* 110 */         URL url = new URL(temp);
/* 111 */         HttpURLConnection connection = (HttpURLConnection)url.openConnection();
/* 112 */         int statusCode = 0;
/* 113 */         statusCode = connection.getResponseCode();
/*     */ 
/* 115 */         if (statusCode == 200)
/*     */         {
/* 117 */           BufferedReader input = new BufferedReader(new InputStreamReader(connection.getInputStream()));
/* 118 */           String rs = input.readLine();
/* 119 */           setUserBean(rs);
/* 120 */           return true;
/*     */         }
/* 122 */         if (statusCode == 401)
/*     */         {
/* 124 */           String urls = "https://" + this.LoginServer + "/login.aaaauth?operation=ic_auth&appid=" + this.ApplyID + "&url=" + Tools.getBASE64(getUrlNow(true));
/* 125 */           this.response.sendRedirect(urls);
/*     */         } else {
/* 127 */           if (statusCode == 403)
/*     */           {
/* 129 */             this.response.getWriter().println("用户认证失败");
/* 130 */             System.out.println("用户认证失败");
/* 131 */             return false;
/*     */           }
/* 133 */           if (statusCode == 404)
/*     */           {
/* 135 */             this.response.getWriter().println("用户未授权");
/* 136 */             System.out.println("用户未授权");
/* 137 */             return false;
/*     */           }
/*     */ 
/* 141 */           this.response.getWriter().println("登陆失败");
/* 142 */           return false;
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 147 */         String url = "https://" + this.LoginServer + "/login.aaaauth?operation=ic_auth&appid=" + this.ApplyID + "&url=" + Tools.getBASE64(getUrlNow(true));
/* 148 */         this.response.sendRedirect(url);
/*     */       }
/*     */     }
/*     */ 
/* 152 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean CheckUserLogin()
/*     */     throws Exception
/*     */   {
/* 165 */     String TrusDataID = this.request.getParameter("TrusDataID");
/* 166 */     String TrusDataTicket = this.request.getParameter("TrusDataTicket");
/*     */ 
/* 168 */     if ((TrusDataID != null) && (TrusDataTicket != null))
/*     */     {
/* 170 */       Cookie cTrusDataID = new Cookie("TrusDataID", TrusDataID);
/* 171 */       Cookie cTrusDataTicket = new Cookie("TrusDataTicket", TrusDataTicket);
/* 172 */       this.response.addCookie(cTrusDataID);
/* 173 */       this.response.addCookie(cTrusDataTicket);
/*     */ System.out.println(getUrlNow(false));
/* 175 */       this.response.sendRedirect(getUrlNow(false));
/*     */     }
/*     */     else
/*     */     {
/* 179 */       Cookie[] cookies = this.request.getCookies();
/* 180 */       if (cookies != null)
/*     */       {
/* 182 */         for (int i = 0; i < cookies.length; i++)
/*     */         {
/* 184 */           Cookie c = cookies[i];
/* 185 */           if ("TrusDataID".equals(c.getName()))
/*     */           {
/* 187 */             TrusDataID = c.getValue();
/* 188 */           } else if ("TrusDataTicket".equals(c.getName()))
/*     */           {
/* 190 */             TrusDataTicket = c.getValue();
/*     */           }
/*     */         }
/* 193 */         String temp = "https://" + this.AAAAServer + "/login.aaaauth?operation=sso&trusdataid=" + TrusDataID + "&appid=" + this.ApplyID + "&summary=" + Tools.EncoderByMd5(new StringBuffer(String.valueOf(TrusDataTicket)).append(this.ApplyKey).toString());
/* 194 */         URL url = new URL(temp);
/* 195 */         HttpURLConnection connection = (HttpURLConnection)url.openConnection();
/* 196 */         int statusCode = 0;
/* 197 */         statusCode = connection.getResponseCode();
/*     */ 
/* 200 */         if (statusCode == 200)
/*     */         {
/* 202 */           BufferedReader input = new BufferedReader(new InputStreamReader(connection.getInputStream()));
/* 203 */           String rs = input.readLine();
/* 204 */           setUserBean(rs);
/* 205 */           return true;
/*     */         }
/* 207 */         if (statusCode == 401)
/*     */         {
/* 209 */           String urls = "https://" + this.LoginServer + "/login.aaaauth?operation=basic_auth&appid=" + this.ApplyID + "&url=" + Tools.getBASE64(getUrlNow(true));
/* 210 */           this.response.sendRedirect(urls);
/*     */         } else {
/* 212 */           if (statusCode == 403)
/*     */           {
/* 214 */             this.response.getWriter().println("用户认证失败");
/* 215 */             System.out.println("用户认证失败");
/* 216 */             return false;
/*     */           }
/* 218 */           if (statusCode == 404)
/*     */           {
/* 220 */             this.response.getWriter().println("用户未授权");
/* 221 */             System.out.println("用户未授权");
/* 222 */             return false;
/*     */           }
/*     */ 
/* 226 */           this.response.getWriter().println("登陆失败");
/* 227 */           return false;
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 233 */         String url = "https://" + this.LoginServer + "/login.aaaauth?operation=basic_auth&appid=" + this.ApplyID + "&url=" + Tools.getBASE64(getUrlNow(true));
/* 234 */         this.response.sendRedirect(url);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 239 */     return false;
/*     */   }
/*     */   private void trustAllHttpsCertificates() {
/*     */     try {
/* 243 */       TrustManager[] trustAllCerts = new TrustManager[1];
/* 244 */       TrustManager tm = new miTM();
/* 245 */       trustAllCerts[0] = tm;
/* 246 */       SSLContext sc = SSLContext.getInstance("SSL");
/* 247 */       sc.init(null, trustAllCerts, null);
/* 248 */       HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getUrlNow(boolean isQuery)
/*     */   {
/* 258 */     String url = this.request.getScheme() + "://";
/* 259 */     url = url + this.request.getHeader("host");
/* 260 */    // url = url + this.request.getRequestURI();
/*     */     url = url+"/njzsb/certlogin.action";
/* 262 */     if ((isQuery) && (this.request.getQueryString() != null)) {
/* 263 */       url = url + "?" + this.request.getQueryString();
/*     */     }
/* 265 */     return url;
/*     */   }
/*     */ 
/*     */   public void Logout()
/*     */     throws Exception
/*     */   {
/* 274 */     String TrusDataID = "";
/* 275 */     String TrusDataTicket = "";
/* 276 */     trustAllHttpsCertificates();
/* 277 */     Cookie[] cookies = this.request.getCookies();
/* 278 */     if (cookies != null)
/*     */     {
/* 280 */       for (int i = 0; i < cookies.length; i++)
/*     */       {
/* 282 */         Cookie c = cookies[i];
/* 283 */         if ("TrusDataID".equals(c.getName()))
/*     */         {
/* 285 */           TrusDataID = c.getValue();
/* 286 */         } else if ("TrusDataTicket".equals(c.getName()))
/*     */         {
/* 288 */           TrusDataTicket = c.getValue();
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 293 */     if ((TrusDataID.length() > 0) && (TrusDataTicket.length() > 0))
/*     */     {
/* 295 */       String urltemp = "https://" + this.LoginServer + "/login.aaaauth?operation=loginout";
/* 296 */       this.response.sendRedirect(urltemp);
/*     */     }
/*     */     else {
/* 299 */       this.response.sendRedirect("https://" + this.LoginServer + "/login.aaaauth?operation=login&url=Lw==");
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean Authorize(String FunctionID)
/*     */     throws Exception
/*     */   {
/* 309 */     String TrusDataID = "";
/* 310 */     String TrusDataTicket = "";
/* 311 */     trustAllHttpsCertificates();
/* 312 */     Cookie[] cookies = this.request.getCookies();
/* 313 */     if (cookies != null)
/*     */     {
/* 315 */       for (int i = 0; i < cookies.length; i++)
/*     */       {
/* 317 */         Cookie c = cookies[i];
/* 318 */         if ("TrusDataID".equals(c.getName()))
/*     */         {
/* 320 */           TrusDataID = c.getValue();
/* 321 */         } else if ("TrusDataTicket".equals(c.getName()))
/*     */         {
/* 323 */           TrusDataTicket = c.getValue();
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 328 */     if ((TrusDataID.length() > 0) && (TrusDataTicket.length() > 0))
/*     */     {
/* 330 */       String urltemp = "https://" + this.AAAAServer + "/login.aaaauth?" + 
/* 331 */         "operation=myauthorize&" + 
/* 332 */         "trusdataid=" + TrusDataID + "&" + 
/* 333 */         "appid=" + this.ApplyID + "&" + 
/* 334 */         "functionid=" + Tools.getBASE64(FunctionID);
/* 335 */       URL url = new URL(urltemp);
/* 336 */       HttpURLConnection connection = (HttpURLConnection)url.openConnection();
/* 337 */       int statusCode = 0;
/* 338 */       statusCode = connection.getResponseCode();
/*     */ 
/* 340 */       if (statusCode == 200)
/*     */       {
/* 342 */         return true;
/*     */       }
/*     */     }
/*     */     else {
/* 346 */       this.response.sendRedirect("https://" + this.AAAAServer + "/");
/*     */     }
/*     */ 
/* 349 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean Audit(String OperateType, String OperateInfo, String OperateStatus, String codeType)
/*     */     throws Exception
/*     */   {
/* 368 */     String TrusDataID = "";
/* 369 */     String TrusDataTicket = "";
/* 370 */     trustAllHttpsCertificates();
/* 371 */     Cookie[] cookies = this.request.getCookies();
/* 372 */     if (cookies != null)
/*     */     {
/* 374 */       for (int i = 0; i < cookies.length; i++)
/*     */       {
/* 376 */         Cookie c = cookies[i];
/* 377 */         if ("TrusDataID".equals(c.getName()))
/*     */         {
/* 379 */           TrusDataID = c.getValue();
/* 380 */         } else if ("TrusDataTicket".equals(c.getName()))
/*     */         {
/* 382 */           TrusDataTicket = c.getValue();
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 387 */     if ((TrusDataID.length() > 0) && (TrusDataTicket.length() > 0))
/*     */     {
/* 389 */       String urltemp = "https://" + this.AAAAServer + "/login.aaaauth?" + 
/* 390 */         "operation=myaudit&" + 
/* 391 */         "trusdataid=" + TrusDataID + "&" + 
/* 392 */         "operatetype=" + OperateType + "&" + 
/* 393 */         "operateinfo=" + OperateInfo + "&" + 
/* 394 */         "operatestaus=" + OperateStatus + "&" + 
/* 395 */         "appid=" + this.ApplyID + "&" + 
/* 396 */         "codetype=" + codeType;
/*     */ 
/* 400 */       URL url = new URL(urltemp);
/* 401 */       HttpURLConnection connection = (HttpURLConnection)url.openConnection();
/*     */ 
/* 403 */       int statusCode = 0;
/* 404 */       statusCode = connection.getResponseCode();
/*     */ 
/* 406 */       if (statusCode == 200)
/*     */       {
/* 408 */         return true;
/*     */       }
/*     */     }
/*     */     else {
/* 412 */       this.response.sendRedirect("https://" + this.LoginServer + "/");
/*     */     }
/*     */ 
/* 415 */     return false;
/*     */   }
/*     */ 
/*     */   private void setUserBean(String rs)
/*     */   {
/* 420 */     this.userbean = new UserBean();
/* 421 */     String[] sArray = rs.split("&");
/* 422 */     for (int i = 0; i < sArray.length; i++)
/*     */     {
/* 424 */       String oname = sArray[i].split("=")[0];
/* 425 */       String ovalue = sArray[i].split("=")[1];
/* 426 */       if (oname.equals("UserID"))
/* 427 */         this.userbean.setUserID(ovalue);
/* 428 */       else if (oname.equals("DefaultUserName"))
/* 429 */         this.userbean.setDefaultUserName(ovalue);
/* 430 */       else if (oname.equals("Mail"))
/* 431 */         this.userbean.setMail(ovalue);
/* 432 */       else if (oname.equals("Telephone"))
/* 433 */         this.userbean.setTelephone(ovalue);
/* 434 */       else if (oname.equals("Unit"))
/* 435 */         this.userbean.setUnit(ovalue);
/* 436 */       else if (oname.equals("Organize"))
/* 437 */         this.userbean.setOrganize(ovalue);
/* 438 */       else if (oname.equals("AppUserName"))
/* 439 */         this.userbean.setAppUserName(ovalue);
/* 440 */       else if (oname.equals("AppPassWord"))
/* 441 */         this.userbean.setAppPassWord(ovalue);
/*     */     }
/*     */   }
/*     */ 
/*     */   public UserBean getUserBean()
/*     */   {
/* 447 */     return this.userbean;
/*     */   }
/*     */ }

/* Location:           C:\Users\Administrator\Desktop\ideabank.jar
 * Qualified Name:     ideabank.sap.IAccount
 * JD-Core Version:    0.6.2
 */