package com.jshx.zzhxm.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhxm.dao.ZzhxmqfhtkDao;
import com.jshx.zzhxm.entity.Zzhxmqfhtk;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @Author: Danfoen
 * @Description:
 * @Date: Created in 14:17 2019/5/23
 * @Modifird by:
 */
@Component("zzhxmqfhtkDao")
public class ZzhxmqfhtkDaoImpl extends BaseDaoImpl implements ZzhxmqfhtkDao {

    /**
     * 分页查询
     * @param page 分页信息
     * @param paraMap 查询条件信息
     * @return 分页信息
     */
    public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
    {
        return this.findPageByHqlId("findZzhxmqfhtkByMap", paraMap, page);
    }


    /**
     * 查询所有记录
     * @param paraMap 查询条件信息
     * @return 分页信息
     */
    @Override
    public List findZzhxmqfhtk(Map<String, Object> paraMap) {
        return this.findListByHqlId("findZzhxmqfhtkByMap", paraMap);
    }

    /**
     * 根据主键ID查询信息
     * @param id 主键ID
     * @return 主键ID对应的信息
     */
    @Override
    public Zzhxmqfhtk getById(String id) {
        return (Zzhxmqfhtk) this.getObjectById(Zzhxmqfhtk.class, id);
    }

    /**
     * 保存信息
     * @param zzhxmqfhtk 信息
     */
    @Override
    public void save(Zzhxmqfhtk zzhxmqfhtk) {
        zzhxmqfhtk.setId(null);
        this.saveOrUpdateObject(zzhxmqfhtk);
    }

    /**
     * 修改信息
     * @param zzhxmqfhtk 信息
     */
    @Override
    public void update(Zzhxmqfhtk zzhxmqfhtk) {
        this.saveOrUpdateObject(zzhxmqfhtk);
    }

    /**
     * 物理删除信息
     * @param id 主键ID
     */
    @Override
    public void delete(String id) {
        this.removeObjectById(Zzhxmqfhtk.class, id);
    }

    /**
     * 逻辑删除信息
     * @param id 主键ID
     */
    @Override
    public void deleteWithFlag(String id) {
        Zzhxmqfhtk zzhxmqfhtk = (Zzhxmqfhtk)this.getObjectById(Zzhxmqfhtk.class, id);
        zzhxmqfhtk.setDelFlag(1);
        this.saveObject(zzhxmqfhtk);
    }
}
