package com.jshx.zzhxm.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhxm.dao.ZzhxmDao;
import com.jshx.zzhxm.entity.Zzhxm;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("zzhxmDao")
public class ZzhxmDaoImpl extends BaseDaoImpl implements ZzhxmDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findZzhxmByMap", paraMap, page);
	}

	@Override
	public Pagination findByPageReview(Pagination page, Map<String, Object> paraMap) {
		return this.findPageByHqlId("findZzhxmByMapReview", paraMap, page);
	}

	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findZzhxm(Map<String, Object> paraMap){
		return this.findListByHqlId("findZzhxmByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Zzhxm getById(String id)
	{
		return (Zzhxm)this.getObjectById(Zzhxm.class, id);
	}

	/**
	 * 保存信息
	 * @param zzhxm 信息
	 */
	public void save(Zzhxm zzhxm)
	{
		zzhxm.setId(null);
		this.saveOrUpdateObject(zzhxm);
	}

	/**
	 * 修改信息
	 * @param zzhxm 信息
	 */
	public void update(Zzhxm zzhxm)
	{
		this.saveOrUpdateObject(zzhxm);
	}
	/**
	 * 修改信息
	 * @param zzhxm 信息
	 */
	@Override
	public void updateNotSave(Zzhxm zzhxm)
	{
		this.update(zzhxm);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Zzhxm.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Zzhxm zzhxm = (Zzhxm)this.getObjectById(Zzhxm.class, id);
		zzhxm.setDelFlag(1);
		this.saveObject(zzhxm);
	}
}
