package com.jshx.zzhqftk.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzscw.yzscwjzpz.dao.YzscwjzpzDao;
import com.jshx.yzscw.yzscwjzpz.entity.Yzscwjzpz;
import com.jshx.zzhqfdz.dao.ZzhqfdzDao;
import com.jshx.zzhqfdz.entity.Zzhqfdz;
import com.jshx.zzhqfdz.service.ZzhqfdzService;
import com.jshx.zzhqftk.dao.ZzhqftkDao;
import com.jshx.zzhqftk.entity.Zzhqftk;
import com.jshx.zzhqftk.service.ZzhqftkService;
import com.jshx.zzhxm.dao.ZzhxmJktzsDao;
import com.jshx.zzhxm.entity.ZzhxmJktzs;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("zzhqftkService")
public class ZzhqftkServiceImpl extends BaseServiceImpl implements ZzhqftkService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("zzhqftkDao")
	private ZzhqftkDao zzhqftkDao;
	@Autowired()
	@Qualifier("zzhxmjktzsDao")
	private ZzhxmJktzsDao zzhxmJktzsDao;
	@Autowired()
	@Qualifier("yzscwjzpzDao")
	private YzscwjzpzDao yzscwjzpzDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return zzhqftkDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Zzhqftk getById(String id)
	{
		return zzhqftkDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param zzhqftk 信息
	 */
	@Transactional
	public void save(Zzhqftk zzhqftk)
	{
		zzhqftkDao.save(zzhqftk);
	}

	/**
	 * 修改信息
	 * @param zzhqftk 信息
	 */
	@Transactional
	public void update(Zzhqftk zzhqftk)
	{
		zzhqftkDao.update(zzhqftk);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=zzhqftkDao.findZzhqftk(paraMap);
		zzhqftkDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					zzhqftkDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Zzhqftk> findZzhqftk(Map<String, Object> paraMap) {

		return zzhqftkDao.findZzhqftk(paraMap);

	}

	/**
	 * 保存退款信息以及插入到一站式财务机制凭证
	 * @param flag
	 * @param zzhqftk
	 * @param yzscwjzpz
	 */
	@Transactional
	public void saveTkxx(String flag, Zzhqftk zzhqftk, Yzscwjzpz yzscwjzpz,ZzhxmJktzs zzhxmJktzs) {
		if ("add".equalsIgnoreCase(flag)){
			zzhqftkDao.save(zzhqftk);
		}else{
			zzhqftkDao.update(zzhqftk);
		}
		zzhxmJktzsDao.update(zzhxmJktzs);
		yzscwjzpzDao.save(yzscwjzpz);
	}
}
