package com.jshx.zzhqftk.service;

import com.jshx.core.base.service.BaseService;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzscw.yzscwjzpz.entity.Yzscwjzpz;
import com.jshx.zzhqfdz.entity.Zzhqfdz;
import com.jshx.zzhqftk.entity.Zzhqftk;
import com.jshx.zzhxm.entity.ZzhxmJktzs;

import java.util.List;
import java.util.Map;

public interface ZzhqftkService extends BaseService
{

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);
	public List<Zzhqftk> findZzhqftk(Map<String, Object> paraMap);

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Zzhqftk getById(String id);

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Zzhqftk model);

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Zzhqftk model);

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	public void delete(String[] ids);

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	public void deleteWithFlag(String ids);

	/**
	 * 保存退款信息
	 * @param model 信息
	 */
	public void saveTkxx(String flag, Zzhqftk zzhqftk, Yzscwjzpz yzscwjzpz,ZzhxmJktzs zzhxmJktzs);

}
