package com.jshx.zzhqfdz.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzscw.yzscwjzpz.dao.YzscwjzpzDao;
import com.jshx.yzscw.yzscwjzpz.entity.Yzscwjzpz;
import com.jshx.zzhqfdz.dao.ZzhqfdzDao;
import com.jshx.zzhqfdz.entity.Zzhqfdz;
import com.jshx.zzhqfdz.service.ZzhqfdzService;
import com.jshx.zzhxm.dao.ZzhxmJktzsDao;
import com.jshx.zzhxm.entity.ZzhxmJktzs;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("zzhqfdzService")
public class ZzhqfdzServiceImpl extends BaseServiceImpl implements ZzhqfdzService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("zzhqfdzDao")
	private ZzhqfdzDao zzhqfdzDao;
	@Autowired()
	@Qualifier("zzhxmjktzsDao")
	private ZzhxmJktzsDao zzhxmJktzsDao;
	@Autowired()
	@Qualifier("yzscwjzpzDao")
	private YzscwjzpzDao yzscwjzpzDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return zzhqfdzDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Zzhqfdz getById(String id)
	{
		return zzhqfdzDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param zzhqfdz 信息
	 */

	public void save(Zzhqfdz zzhqfdz)
	{
		zzhqfdzDao.save(zzhqfdz);
	}


	/**
	 * 保存子账户情分信息以及插入到一站式财务机制凭证
	 * @param flag
	 * @param zzhqfdz
	 * @param yzscwjzpz
	 */
	@Transactional
	public void saveQfdzxx(String flag, Zzhqfdz zzhqfdz, Yzscwjzpz yzscwjzpz) {
		if ("add".equalsIgnoreCase(flag)){
			zzhqfdzDao.save(zzhqfdz);
		}else{
			zzhqfdzDao.update(zzhqfdz);
		}
		yzscwjzpzDao.save(yzscwjzpz);
	}

	@Transactional
	public String saveQfdzxx(Zzhqfdz zzhqfdz, Yzscwjzpz yzscwjzpz,ZzhxmJktzs zzhxmJktzs) {
		zzhqfdzDao.save(zzhqfdz);
		yzscwjzpzDao.save(yzscwjzpz);
		zzhxmJktzsDao.update(zzhxmJktzs);
		return "true";
	}

	/**
	 * 修改信息
	 * @param zzhqfdz 信息
	 */
	@Transactional
	public void update(Zzhqfdz zzhqfdz)
	{
		zzhqfdzDao.update(zzhqfdz);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=zzhqfdzDao.findZzhqfdz(paraMap);
		zzhqfdzDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					zzhqfdzDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Zzhqfdz> findZzhqfdz(Map<String, Object> paraMap) {

		return zzhqfdzDao.findZzhqfdz(paraMap);

	}

	/**
	 * 保存清分确认到账
	 * @param zzhxmJktzs1
	 * @param zzhqfdzList
	 */
	@Transactional
	public void saveQfqrdz(ZzhxmJktzs zzhxmJktzs1, List<Zzhqfdz> zzhqfdzList){
		zzhxmJktzsDao.update(zzhxmJktzs1);
		if(CollectionUtils.isNotEmpty(zzhqfdzList)){
			for(Zzhqfdz zzhqfdz1 : zzhqfdzList){
				zzhqfdz1.setQrdzzt("1");
				zzhqfdzDao.update(zzhqfdz1);
			}
		}
	}
}
