package com.jshx.zzhqfdz.service;

import com.jshx.core.base.service.BaseService;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhqfdz.entity.Zzhqfhz;
import com.jshx.zzhqfdz.entity.Zzhqfhzlsh;
import com.jshx.zzhqfdz.entity.Zzhqfhzmx;

import java.util.List;
import java.util.Map;

public interface ZzhqfhzmxService extends BaseService
{

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);
	public List<Zzhqfhzmx> findZzhqfhzmx(Map<String, Object> paraMap);
	public List<Zzhqfhzlsh> findZzhqfhzlsh(Map<String, Object> paraMap);

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Zzhqfhzmx getById(String id);

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Zzhqfhzmx model);

	public void save(Zzhqfhzlsh model);

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Zzhqfhzmx model);

	public void update(Zzhqfhzlsh model);

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	public void delete(String[] ids);

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	public void deleteWithFlag(String ids);
}
