package com.jshx.zzhqfdz.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhqfdz.dao.ZzhqfdzDao;
import com.jshx.zzhqfdz.dao.ZzhqfhzDao;
import com.jshx.zzhqfdz.entity.Zzhqfdz;
import com.jshx.zzhqfdz.entity.Zzhqfhz;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("zzhqfhzDao")
public class ZzhqfhzDaoImpl extends BaseDaoImpl implements ZzhqfhzDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findZzhqfhzByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findZzhqfhz(Map<String, Object> paraMap){
		return this.findListByHqlId("findZzhqfhzByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Zzhqfhz getById(String id)
	{
		return (Zzhqfhz)this.getObjectById(Zzhqfhz.class, id);
	}

	/**
	 * 保存信息
	 * @param zzhqfhz 信息
	 */
	public void save(Zzhqfhz zzhqfhz)
	{
		zzhqfhz.setId(null);
		this.saveOrUpdateObject(zzhqfhz);
	}

	/**
	 * 修改信息
	 * @param zzhqfhz 信息
	 */
	public void update(Zzhqfhz zzhqfhz)
	{
		this.saveOrUpdateObject(zzhqfhz);
	}


	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Zzhqfhz.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Zzhqfhz zzhqfhz = (Zzhqfhz)this.getObjectById(Zzhqfhz.class, id);
		zzhqfhz.setDelFlag(1);
		this.saveObject(zzhqfhz);
	}
}
