package com.jshx.zzhkppj.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhkppj.dao.ZzhkppjDao;
import com.jshx.zzhkppj.entity.Zzhkppj;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("zzhkppjDao")
public class ZzhkppjDaoImpl extends BaseDaoImpl implements ZzhkppjDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findZzhkppjByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findZzhkppj(Map<String, Object> paraMap){
		return this.findListByHqlId("findZzhkppjByMap", paraMap);
	}

	public List findZzhkppjToZzhkp(Map<String, Object> paraMap){
		return this.findListByHqlId("findKppjToZzhkp", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Zzhkppj getById(String id)
	{
		return (Zzhkppj)this.getObjectById(Zzhkppj.class, id);
	}

	/**
	 * 保存信息
	 * @param zzhkppj 信息
	 */
	public void save(Zzhkppj zzhkppj)
	{
		zzhkppj.setId(null);
		this.saveOrUpdateObject(zzhkppj);
	}

	/**
	 * 修改信息
	 * @param zzhkppj 信息
	 */
	public void update(Zzhkppj zzhkppj)
	{
		this.saveOrUpdateObject(zzhkppj);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Zzhkppj.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Zzhkppj zzhkppj = (Zzhkppj)this.getObjectById(Zzhkppj.class, id);
		zzhkppj.setDelFlag(1);
		this.saveObject(zzhkppj);
	}
}
