package com.jshx.yzssfgl.web;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.core.utils.Struts2Util;
import com.jshx.mobile.utils.JsonUtil;
import com.jshx.yzssfgl.entity.Yzsdicgl;
import com.jshx.yzssfgl.service.YzsdicglService;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.io.FileInputStream;
import java.util.*;

public class YzsdicglAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Yzsdicgl yzsdicgl = new Yzsdicgl();
	List<Yzsdicgl> yzsdicglList = new ArrayList<>();
	List<String> yzssxlxList = new ArrayList<>();
	List<String> yzssxmcList = new ArrayList<>();

	/**
	 * 业务类
	 */
	@Autowired
	private YzsdicglService yzsdicglService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;



	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;

	/**
	 *
	 */
	public void modifyYzs(){
		String str = "{\"message\":\"调用失败\",\"code\":\"1000\"}";
		try {
			String messageParam = Struts2Util.getRequest().getParameter("message");
			if(StringUtils.isEmpty(messageParam)){
				getResponse().setStatus(301);
				str = "{ \"message\": \"调用失败，未接受到项目信息\",\"code\": \"1000\",\"子账户账号\":\"\"}";
				JsonUtil.printJsonString(getResponse(), str);
				return;
			}
			JSONObject yzsmc = JSONObject.fromObject(messageParam);
		}catch(Exception e){
			e.printStackTrace();
			logger.debug(e.getMessage());
		}
	}

	/**
	 * 进入list页面初始化下拉
	 */
	public String init(){
		Map<String,Object> paramMap = new HashMap<>();
		yzssxlxList = yzsdicglService.getYzssxlx(paramMap);
		yzssxmcList = yzsdicglService.getYzssxmc(paramMap);
		return SUCCESS;
	}

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		if("请选择".equals(yzsdicgl.getYzssflx())){
			yzsdicgl.setYzssflx("");
		}
		if("请选择".equals(yzsdicgl.getYzssfmc())){
			yzsdicgl.setYzssfmc("");
		}
		if(pagination==null)
		    pagination = new Pagination(this.getRequest());

		if(null != yzsdicgl){

		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != yzsdicgl.getYzssflx()) && (0 < yzsdicgl.getYzssflx().trim().length())){
				paraMap.put("yzssflx",yzsdicgl.getYzssflx().trim());
			}
			if ((null != yzsdicgl.getYzssfmc()) && (0 < yzsdicgl.getYzssfmc().trim().length())){
				paraMap.put("yzssfmc",yzsdicgl.getYzssfmc().trim());
			}
			if ((null != yzsdicgl.getSflxm()) && (0 < yzsdicgl.getSflxm().trim().length())){
				paraMap.put("sflxm",yzsdicgl.getSflxm().trim());
			}
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(Date.class,new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap));
		final String filter = "id|yzssflx|yzssfmc|sflxm|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = yzsdicglService.findByPage(pagination, paraMap);
		convObjectToJson(pagination, config);
	}

	/**
	 * 	添加字典信息
	 */
	public String initEditadd() throws Exception{
		view();
		return EDIT;
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != yzsdicgl)&&(null != yzsdicgl.getId()))
			yzsdicgl = yzsdicglService.getById(yzsdicgl.getId());
		return VIEW;
	}

	/**
	 * 获取收费区域信息
	 */
	public void getQyxx(){
		Map<String,Object> paramMap =  new HashMap<>();
		yzsdicglList =yzsdicglService.findYzsdicgl(paramMap);
		getRequest().setAttribute("yzsqyglList",yzsdicglList);
	}

	/**
	 * 	初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}

	/**
	 * 	保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		if ("add".equalsIgnoreCase(this.flag)){
			yzsdicgl.setDeptId(this.getLoginUserDepartmentId());
			yzsdicgl.setDelFlag(0);
			yzsdicglService.save(yzsdicgl);
		}else{
			yzsdicglService.update(yzsdicgl);
		}
		
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	*/
	private void setBlobField(FileInputStream in)
	{
		if (null != yzsdicgl)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到zsdw中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	*/
	public String delete() throws Exception{
	    try{
			yzsdicglService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Yzsdicgl getYzsdicgl(){
		return this.yzsdicgl;
	}

	public void setYzsdicgl(Yzsdicgl yzsdicgl){
		this.yzsdicgl = yzsdicgl;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

	public List<Yzsdicgl> getYzsdicglList() {
		return yzsdicglList;
	}

	public void setYzsdicglList(List<Yzsdicgl> yzsdicglList) {
		this.yzsdicglList = yzsdicglList;
	}

	public List<String> getYzssxlxList() {
		return yzssxlxList;
	}

	public void setYzssxlxList(List<String> yzssxlxList) {
		this.yzssxlxList = yzssxlxList;
	}

	public List<String> getYzssxmcList() {
		return yzssxmcList;
	}

	public void setYzssxmcList(List<String> yzssxmcList) {
		this.yzssxmcList = yzssxmcList;
	}
}
