package com.jshx.yzssfgl.service;

import com.jshx.core.base.service.BaseService;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzssfgl.entity.Yzsdicgl;

import java.util.List;
import java.util.Map;

public interface YzsdicglService extends BaseService
{

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);
	public List<Yzsdicgl> findYzsdicgl(Map<String, Object> paraMap);

	public Yzsdicgl getBySflxm(String sflxm);

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Yzsdicgl getById(String id);

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Yzsdicgl model);

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Yzsdicgl model);

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	public void delete(String[] ids);

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	public void deleteWithFlag(String ids);

    /**
     * 获取一站式事项类型
     */
    public List<String> getYzssxlx(Map<String,Object> paramMap);

    /**
     * 获取一站式事项名称
     */
    public List<String> getYzssxmc(Map<String,Object> paramMap);
}
